// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import{PlayerInfo}from"./player_info.js";import{objectForEach}from"./util.js";export class Manager{constructor(clientRenderer){this.players_={};this.audioInfo_={};this.audioComponents_=[];this.clientRenderer_=clientRenderer;const copyAllPlayerButton=$("copy-all-player-button");const copyAllAudioButton=$("copy-all-audio-button");const hidePlayersButton=$("hide-players-button");if(copyAllPlayerButton){copyAllPlayerButton.onclick=function(){this.clientRenderer_.renderClipboard(JSON.stringify(this.players_,null,2))}.bind(this)}if(copyAllAudioButton){copyAllAudioButton.onclick=function(){this.clientRenderer_.renderClipboard(JSON.stringify(this.audioInfo_,null,2)+"\n\n"+JSON.stringify(this.audioComponents_,null,2))}.bind(this)}if(hidePlayersButton){hidePlayersButton.onclick=this.hidePlayers_.bind(this)}}updateAudioFocusSessions(sessions){this.clientRenderer_.audioFocusSessionUpdated(sessions)}updateRegisteredCdms(cdms){this.clientRenderer_.updateRegisteredCdms(cdms)}updateGeneralAudioInformation(audioInfo){this.audioInfo_=audioInfo;this.clientRenderer_.generalAudioInformationSet(this.audioInfo_)}updateAudioComponent(componentType,componentId,componentData){if(!(componentType in this.audioComponents_)){this.audioComponents_[componentType]={}}if(!(componentId in this.audioComponents_[componentType])){this.audioComponents_[componentType][componentId]=componentData}else{for(const key in componentData){this.audioComponents_[componentType][componentId][key]=componentData[key]}}this.clientRenderer_.audioComponentAdded(componentType,this.audioComponents_[componentType])}removeAudioComponent(componentType,componentId){if(!(componentType in this.audioComponents_)||!(componentId in this.audioComponents_[componentType])){return}delete this.audioComponents_[componentType][componentId];this.clientRenderer_.audioComponentRemoved(componentType,this.audioComponents_[componentType])}addPlayer(id){if(this.players_[id]){return}this.players_[id]=new PlayerInfo(id);this.clientRenderer_.playerAdded(this.players_,this.players_[id])}removePlayer(id){const playerRemoved=this.players_[id];delete this.players_[id];this.clientRenderer_.playerRemoved(this.players_,playerRemoved)}hidePlayers_(){objectForEach(this.players_,(function(playerInfo,id){this.removePlayer(id)}),this)}updatePlayerInfoNoRecord(id,timestamp,key,value){if(!this.players_[id]){console.error("[updatePlayerInfo] Id "+id+" does not exist");return}this.players_[id].addPropertyNoRecord(timestamp,key,value);this.clientRenderer_.playerUpdated(this.players_,this.players_[id],key,value)}updatePlayerInfo(id,timestamp,key,value){if(!this.players_[id]){console.error("[updatePlayerInfo] Id "+id+" does not exist");return}this.players_[id].addProperty(timestamp,key,value);this.clientRenderer_.playerUpdated(this.players_,this.players_[id],key,value)}parseVideoCaptureFormat_(format){const parts=format.split(", ");const formatDict={};for(const i in parts){let kv=parts[i].split(": ");if(kv.length===2){if(kv[0]==="pixel format"){continue}formatDict[kv[0]]=kv[1]}else{kv=parts[i].split("@");if(kv.length===2){formatDict["resolution"]=kv[0].replace(/[)(]/g,"");formatDict["fps"]=parseFloat(kv[1].replace(/fps$/,"")).toFixed(2)}}}return formatDict}updateVideoCaptureCapabilities(videoCaptureCapabilities){for(const i in videoCaptureCapabilities){for(const j in videoCaptureCapabilities[i]["formats"]){videoCaptureCapabilities[i]["formats"][j]=this.parseVideoCaptureFormat_(videoCaptureCapabilities[i]["formats"][j])}videoCaptureCapabilities[i]["controlSupport"]=videoCaptureCapabilities[i]["controlSupport"].join(" ")||"N/A"}const videoCaptureDeviceKeys=["name","formats","captureApi","controlSupport","id"];this.clientRenderer_.redrawVideoCaptureCapabilities(videoCaptureCapabilities,videoCaptureDeviceKeys)}}window.Manager=Manager;