// content/browser/indexed_db/indexed_db_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BucketClientInfoSpec as storage_mojom_BucketClientInfoSpec } from './bucket_client_info.mojom-webui.js';
import { BucketIdSpec as storage_mojom_BucketIdSpec } from './bucket_id.mojom-webui.js';
import { IdbBucketMetadataSpec as storage_mojom_IdbBucketMetadataSpec, IdbOriginMetadataSpec as storage_mojom_IdbOriginMetadataSpec } from './indexed_db_internals_types.mojom-webui.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
export class IdbInternalsHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'storage.mojom.IdbInternalsHandler', scope);
    }
}
export class IdbInternalsHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(IdbInternalsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getAllBucketsAcrossAllStorageKeys() {
        return this.proxy.sendMessage(0, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$, [], false);
    }
    downloadBucketData(bucketId) {
        return this.proxy.sendMessage(1, IdbInternalsHandler_DownloadBucketData_ParamsSpec.$, IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$, [
            bucketId
        ], false);
    }
    forceClose(bucketId) {
        return this.proxy.sendMessage(2, IdbInternalsHandler_ForceClose_ParamsSpec.$, IdbInternalsHandler_ForceClose_ResponseParamsSpec.$, [
            bucketId
        ], false);
    }
    startMetadataRecording(bucketId) {
        return this.proxy.sendMessage(3, IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$, [
            bucketId
        ], false);
    }
    stopMetadataRecording(bucketId) {
        return this.proxy.sendMessage(4, IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$, [
            bucketId
        ], false);
    }
    inspectClient(clientInfo) {
        return this.proxy.sendMessage(5, IdbInternalsHandler_InspectClient_ParamsSpec.$, IdbInternalsHandler_InspectClient_ResponseParamsSpec.$, [
            clientInfo
        ], false);
    }
}
;
/**
 * An object which receives request messages for the IdbInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IdbInternalsHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(IdbInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$, impl.getAllBucketsAcrossAllStorageKeys.bind(impl), false);
        this.helper_internal_.registerHandler(1, IdbInternalsHandler_DownloadBucketData_ParamsSpec.$, IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$, impl.downloadBucketData.bind(impl), false);
        this.helper_internal_.registerHandler(2, IdbInternalsHandler_ForceClose_ParamsSpec.$, IdbInternalsHandler_ForceClose_ResponseParamsSpec.$, impl.forceClose.bind(impl), false);
        this.helper_internal_.registerHandler(3, IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$, impl.startMetadataRecording.bind(impl), false);
        this.helper_internal_.registerHandler(4, IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$, impl.stopMetadataRecording.bind(impl), false);
        this.helper_internal_.registerHandler(5, IdbInternalsHandler_InspectClient_ParamsSpec.$, IdbInternalsHandler_InspectClient_ResponseParamsSpec.$, impl.inspectClient.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class IdbInternalsHandler {
    static get $interfaceName() {
        return "storage.mojom.IdbInternalsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new IdbInternalsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the IdbInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IdbInternalsHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getAllBucketsAcrossAllStorageKeys;
    downloadBucketData;
    forceClose;
    startMetadataRecording;
    stopMetadataRecording;
    inspectClient;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(IdbInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getAllBucketsAcrossAllStorageKeys =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$, IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$, this.getAllBucketsAcrossAllStorageKeys.createReceiverHandler(true /* expectsResponse */), false);
        this.downloadBucketData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, IdbInternalsHandler_DownloadBucketData_ParamsSpec.$, IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$, this.downloadBucketData.createReceiverHandler(true /* expectsResponse */), false);
        this.forceClose =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, IdbInternalsHandler_ForceClose_ParamsSpec.$, IdbInternalsHandler_ForceClose_ResponseParamsSpec.$, this.forceClose.createReceiverHandler(true /* expectsResponse */), false);
        this.startMetadataRecording =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$, this.startMetadataRecording.createReceiverHandler(true /* expectsResponse */), false);
        this.stopMetadataRecording =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$, IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$, this.stopMetadataRecording.createReceiverHandler(true /* expectsResponse */), false);
        this.inspectClient =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, IdbInternalsHandler_InspectClient_ParamsSpec.$, IdbInternalsHandler_InspectClient_ResponseParamsSpec.$, this.inspectClient.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const IdbPartitionMetadataSpec = { $: {} };
export const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec = { $: {} };
export const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec = { $: {} };
export const IdbInternalsHandler_DownloadBucketData_ParamsSpec = { $: {} };
export const IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec = { $: {} };
export const IdbInternalsHandler_ForceClose_ParamsSpec = { $: {} };
export const IdbInternalsHandler_ForceClose_ResponseParamsSpec = { $: {} };
export const IdbInternalsHandler_StartMetadataRecording_ParamsSpec = { $: {} };
export const IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec = { $: {} };
export const IdbInternalsHandler_StopMetadataRecording_ParamsSpec = { $: {} };
export const IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec = { $: {} };
export const IdbInternalsHandler_InspectClient_ParamsSpec = { $: {} };
export const IdbInternalsHandler_InspectClient_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(IdbPartitionMetadataSpec.$, 'IdbPartitionMetadata', [
    mojo.internal.StructField('partitionPath', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('originList', 8, 0, mojo.internal.Array(storage_mojom_IdbOriginMetadataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$, 'IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params', [], [[0, 8],]);
mojo.internal.Struct(IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$, 'IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('partitions', 8, 0, mojo.internal.Array(IdbPartitionMetadataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(IdbInternalsHandler_DownloadBucketData_ParamsSpec.$, 'IdbInternalsHandler_DownloadBucketData_Params', [
    mojo.internal.StructField('bucketId', 0, 0, storage_mojom_BucketIdSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$, 'IdbInternalsHandler_DownloadBucketData_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_ForceClose_ParamsSpec.$, 'IdbInternalsHandler_ForceClose_Params', [
    mojo.internal.StructField('bucketId', 0, 0, storage_mojom_BucketIdSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_ForceClose_ResponseParamsSpec.$, 'IdbInternalsHandler_ForceClose_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$, 'IdbInternalsHandler_StartMetadataRecording_Params', [
    mojo.internal.StructField('bucketId', 0, 0, storage_mojom_BucketIdSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$, 'IdbInternalsHandler_StartMetadataRecording_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$, 'IdbInternalsHandler_StopMetadataRecording_Params', [
    mojo.internal.StructField('bucketId', 0, 0, storage_mojom_BucketIdSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$, 'IdbInternalsHandler_StopMetadataRecording_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metadata', 8, 0, mojo.internal.Array(storage_mojom_IdbBucketMetadataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(IdbInternalsHandler_InspectClient_ParamsSpec.$, 'IdbInternalsHandler_InspectClient_Params', [
    mojo.internal.StructField('clientInfo', 0, 0, storage_mojom_BucketClientInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(IdbInternalsHandler_InspectClient_ResponseParamsSpec.$, 'IdbInternalsHandler_InspectClient_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
