// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import"./attribution_detail_table.js";import"./attribution_internals_table.js";import{AggregatableResult}from"./aggregatable_result.mojom-webui.js";import{AttributionSupport}from"./attribution.mojom-webui.js";import{Factory,HandlerRemote,ObserverReceiver,WebUISource_Attributability}from"./attribution_internals.mojom-webui.js";import{OsRegistrationResult,RegistrationType}from"./attribution_reporting.mojom-webui.js";import{EventLevelResult}from"./event_level_result.mojom-webui.js";import{ProcessAggregatableDebugReportResult}from"./process_aggregatable_debug_report_result.mojom-webui.js";import{SourceType}from"./source_type.mojom-webui.js";import{StoreSourceResult}from"./store_source_result.mojom-webui.js";import{TriggerDataMatching}from"./trigger_data_matching.mojom-webui.js";const BUDGET_PER_SOURCE=65536;function compareDefault(a,b){if(a<b){return-1}if(a>b){return 1}return 0}function undefinedFirst(f){return(a,b)=>{if(a===undefined&&b===undefined){return 0}if(a===undefined){return-1}if(b===undefined){return 1}return f(a,b)}}function compareLexicographic(f){return(a,b)=>{for(let i=0;i<a.length&&i<b.length;++i){const r=f(a[i],b[i]);if(r!==0){return r}}return compareDefault(a.length,b.length)}}function bigintReplacer(_key,value){return typeof value==="bigint"?value.toString():value}function allowingUndefined({render:render,compare:compare}){return{compare:compare?undefinedFirst(compare):undefined,render:(td,v)=>{if(v!==undefined){render(td,v)}}}}function valueColumn(label,key,{render:render,compare:compare},defaultSort=false){return{label:label,render:(td,data)=>render(td,data[key]),compare:compare?(a,b)=>compare(a[key],b[key]):undefined,defaultSort:defaultSort}}const asDate={compare:compareDefault,render:(td,v)=>{const time=td.ownerDocument.createElement("time");time.dateTime=v.toISOString();time.innerText=v.toLocaleString();td.replaceChildren(time)}};const numberClass="number";const asNumber={compare:compareDefault,render:(td,v)=>{td.classList.add(numberClass);td.innerText=v.toString()}};function asCustomNumber(fmt){return{compare:compareDefault,render:(td,v)=>{td.classList.add(numberClass);td.innerText=fmt(v)}}}const asStringOrBool={compare:compareDefault,render:(td,v)=>td.innerText=v.toString()};const asCode={render:(td,v)=>{const code=td.ownerDocument.createElement("code");code.innerText=v;const pre=td.ownerDocument.createElement("pre");pre.append(code);td.replaceChildren(pre)}};function asList({render:render,compare:compare}){return{compare:compare?compareLexicographic(compare):undefined,render:(td,vs)=>{if(vs.length===0){td.replaceChildren();return}const ul=td.ownerDocument.createElement("ul");for(const v of vs){const li=td.ownerDocument.createElement("li");render(li,v);ul.append(li)}td.replaceChildren(ul)}}}function renderUrl(td,url){const a=td.ownerDocument.createElement("a");a.target="_blank";a.href=url;a.innerText=url;td.replaceChildren(a)}const asUrl={compare:compareDefault,render:renderUrl};function isAttributionSuccessDebugReport(url){return url.includes("/.well-known/attribution-reporting/debug/")}function newSource(mojo){return{id:mojo.id,sourceEventId:mojo.sourceEventId,sourceOrigin:originToText(mojo.sourceOrigin),destinations:mojo.destinations.destinations.map((d=>originToText(d.siteAsOrigin))).sort(compareDefault),reportingOrigin:originToText(mojo.reportingOrigin),sourceTime:new Date(mojo.sourceTime),expiryTime:new Date(mojo.expiryTime),triggerData:mojo.triggerData,eventReportWindowsStart:mojo.eventReportWindows.startTime.microseconds/1000000n,eventReportWindowsEnds:mojo.eventReportWindows.endTimes.map((t=>t.microseconds/1000000n)),maxEventLevelReports:mojo.maxEventLevelReports,aggregatableReportWindowTime:new Date(mojo.aggregatableReportWindowTime),sourceType:sourceTypeText[mojo.sourceType],priority:mojo.priority,filterData:JSON.stringify(mojo.filterData.filterValues,null," "),aggregationKeys:JSON.stringify(mojo.aggregationKeys,bigintReplacer," "),debugKey:mojo.debugKey??undefined,dedupKeys:mojo.dedupKeys.sort(compareDefault),remainingAggregatableAttributionBudget:mojo.remainingAggregatableAttributionBudget,aggregatableDedupKeys:mojo.aggregatableDedupKeys.sort(compareDefault),triggerDataMatching:triggerDataMatchingText[mojo.triggerDataMatching],eventLevelEpsilon:mojo.eventLevelEpsilon,status:attributabilityText[mojo.attributability],cookieBasedDebugAllowed:mojo.cookieBasedDebugAllowed,remainingAggregatableDebugBudget:mojo.remainingAggregatableDebugBudget,aggregatableDebugKeyPiece:mojo.aggregatableDebugKeyPiece,attributionScopesData:mojo.attributionScopesDataJson,aggregatableNamedBudgets:mojo.aggregatableNamedBudgets}}function initSourceTable(panel){return initPanel(panel,[valueColumn("Source Event ID","sourceEventId",asNumber),valueColumn("Status","status",asStringOrBool),valueColumn("Source Origin","sourceOrigin",asUrl),valueColumn("Destinations","destinations",asList(asUrl)),valueColumn("Reporting Origin","reportingOrigin",asUrl),valueColumn("Registration Time","sourceTime",asDate,true),valueColumn("Expiry","expiryTime",asDate),valueColumn("Source Type","sourceType",asStringOrBool),valueColumn("Debug Key","debugKey",allowingUndefined(asNumber))],{getId:source=>source.id,isSelectable:true},[valueColumn("Priority","priority",asNumber),valueColumn("Filter Data","filterData",asCode),valueColumn("Cookie-Based Debug Allowed","cookieBasedDebugAllowed",asStringOrBool),valueColumn("Attribution Scopes Data","attributionScopesData",asCode),valueColumn("Remaining Aggregatable Debug Budget","remainingAggregatableDebugBudget",asCustomNumber((v=>`${v} / ${BUDGET_PER_SOURCE}`))),valueColumn("Aggregatable Debug Key Piece","aggregatableDebugKeyPiece",asStringOrBool),"Event-Level Fields",valueColumn("Epsilon","eventLevelEpsilon",asCustomNumber((v=>v.toFixed(3)))),valueColumn("Trigger Data Matching","triggerDataMatching",asStringOrBool),valueColumn("Trigger Data","triggerData",asList(asNumber)),valueColumn("Report Start","eventReportWindowsStart",asNumber),valueColumn("Report Windows","eventReportWindowsEnds",asList(asNumber)),valueColumn("Max Reports","maxEventLevelReports",asNumber),valueColumn("Dedup Keys","dedupKeys",asList(asNumber)),"Aggregatable Fields",valueColumn("Report Window Time","aggregatableReportWindowTime",asDate),valueColumn("Remaining Aggregatable Attribution Budget","remainingAggregatableAttributionBudget",asCustomNumber((v=>`${v} / ${BUDGET_PER_SOURCE}`))),valueColumn("Named Budgets","aggregatableNamedBudgets",asCode),valueColumn("Aggregation Keys","aggregationKeys",asCode),valueColumn("Dedup Keys","aggregatableDedupKeys",asList(asNumber))])}class Registration{time;contextOrigin;reportingOrigin;registrationJson;clearedDebugKey;constructor(mojo){this.time=new Date(mojo.time);this.contextOrigin=originToText(mojo.contextOrigin);this.reportingOrigin=originToText(mojo.reportingOrigin);this.registrationJson=mojo.registrationJson;this.clearedDebugKey=mojo.clearedDebugKey??undefined}}function initRegistrationTableModel(panel,contextOriginTitle,cols){return initPanel(panel,[valueColumn("Time","time",asDate,true),valueColumn(contextOriginTitle,"contextOrigin",asUrl),valueColumn("Reporting Origin","reportingOrigin",asUrl),valueColumn("Cleared Debug Key","clearedDebugKey",allowingUndefined(asNumber)),...cols],{isSelectable:true},[valueColumn("Registration JSON","registrationJson",asCode)])}class Trigger extends Registration{eventLevelResult;aggregatableResult;constructor(mojo){super(mojo.registration);this.eventLevelResult=eventLevelResultText[mojo.eventLevelResult];this.aggregatableResult=aggregatableResultText[mojo.aggregatableResult]}}function initTriggerTable(panel){return initRegistrationTableModel(panel,"Destination",[valueColumn("Event-Level Result","eventLevelResult",asStringOrBool),valueColumn("Aggregatable Result","aggregatableResult",asStringOrBool)])}class SourceRegistration extends Registration{type;status;constructor(mojo){super(mojo.registration);this.type=sourceTypeText[mojo.type];this.status=sourceRegistrationStatusText[mojo.status]}}function initSourceRegistrationTable(panel){return initRegistrationTableModel(panel,"Source Origin",[valueColumn("Type","type",asStringOrBool),valueColumn("Status","status",asStringOrBool)])}function isHttpError(code){return code<200||code>=400}const reportStatusColumn={label:"Status",compare:(a,b)=>compareDefault(a.status,b.status),render:(td,report)=>{td.classList.toggle("send-error",report.sendFailed);td.innerText=report.status}};function networkStatusToString(status,sentPrefix){if(status.httpResponseCode!==undefined){return[`${sentPrefix}HTTP ${status.httpResponseCode}`,isHttpError(status.httpResponseCode)]}else if(status.networkError!==undefined){return[`Network error: ${status.networkError}`,true]}else{throw new Error("invalid NetworkStatus union")}}class Report{id;reportBody;reportUrl;triggerTime;reportTime;status;sendFailed;constructor(mojo){this.id=mojo.id;this.reportBody=mojo.reportBody;this.reportUrl=mojo.reportUrl.url;this.triggerTime=new Date(mojo.triggerTime);this.reportTime=new Date(mojo.reportTime);[this.status,this.sendFailed]=Report.statusToString(mojo.status,"Sent: ")}isPending(){return this.status==="Pending"}static statusToString(status,sentPrefix){if(status.networkStatus!==undefined){return networkStatusToString(status.networkStatus,sentPrefix)}else if(status.pending!==undefined){return["Pending",false]}else if(status.replacedByHigherPriorityReport!==undefined){return[`Replaced by higher-priority report: ${status.replacedByHigherPriorityReport}`,false]}else if(status.expired!==undefined){return["Expired",false]}else if(status.prohibitedByBrowserPolicy!==undefined){return["Prohibited by browser policy",false]}else if(status.failedToAssemble!==undefined){return["Dropped due to assembly failure",false]}else{throw new Error("invalid ReportStatus union")}}}class EventLevelReport extends Report{reportPriority;randomizedReport;constructor(mojo){super(mojo);this.reportPriority=mojo.data.eventLevelData.priority;this.randomizedReport=!mojo.data.eventLevelData.attributedTruthfully}}class AggregatableReport extends Report{contributions;aggregationCoordinator;isNullReport;constructor(mojo){super(mojo);this.contributions=JSON.stringify(mojo.data.aggregatableAttributionData.contributions,bigintReplacer," ");this.aggregationCoordinator=mojo.data.aggregatableAttributionData.aggregationCoordinator;this.isNullReport=mojo.data.aggregatableAttributionData.isNullReport}}function initPanel(panel,cols,initOpts,detailCols,onSelectionChange=()=>{}){const t=panel.querySelector("attribution-internals-table");t.init(cols,initOpts);const d=panel.querySelector("attribution-detail-table");d.init([...cols,...detailCols]);t.addEventListener("selection-change",(e=>{onSelectionChange(e.detail.data);d.update(e.detail.data)}));d.addEventListener("close",(()=>t.clearSelection()));return t}function initReportTable(panel,handler,cols){const sendReportButton=panel.querySelector("button");const t=initPanel(panel,[reportStatusColumn,valueColumn("URL","reportUrl",asUrl),valueColumn("Trigger Time","triggerTime",asDate),valueColumn("Report Time","reportTime",asDate,true),...cols],{getId:(report,updated)=>report.isPending()||updated?report.id.value:undefined,isSelectable:true},[valueColumn("Body","reportBody",asCode)],(report=>sendReportButton.disabled=!report?.isPending()));sendReportButton.addEventListener("click",(()=>sendReport(t,sendReportButton,handler)));return t}function sendReport(t,sendReportButton,handler){const id=t.selectedData()?.id;if(id===undefined){return}const previousText=sendReportButton.innerText;sendReportButton.disabled=true;sendReportButton.innerText="Sending...";handler.sendReport(id).then((()=>{sendReportButton.innerText=previousText}))}const registrationTypeText={[RegistrationType.kSource]:"Source",[RegistrationType.kTrigger]:"Trigger"};const osRegistrationResultText={[OsRegistrationResult.kPassedToOs]:"Passed to OS",[OsRegistrationResult.kInvalidRegistrationUrl]:"Invalid registration URL",[OsRegistrationResult.kProhibitedByBrowserPolicy]:"Prohibited by browser policy",[OsRegistrationResult.kRejectedByOs]:"Rejected by OS"};function newOsRegistration(mojo){return{time:new Date(mojo.time),registrationUrl:mojo.registrationUrl.url,topLevelOrigin:originToText(mojo.topLevelOrigin),debugKeyAllowed:mojo.isDebugKeyAllowed,debugReporting:mojo.debugReporting,registrationType:`OS ${registrationTypeText[mojo.type]}`,result:osRegistrationResultText[mojo.result]}}function initOsRegistrationTable(t){t.init([valueColumn("Time","time",asDate,true),valueColumn("Type","registrationType",asStringOrBool),valueColumn("URL","registrationUrl",asUrl),valueColumn("Top-Level Origin","topLevelOrigin",asUrl),valueColumn("Debug Key Allowed","debugKeyAllowed",asStringOrBool),valueColumn("Debug Reporting","debugReporting",asStringOrBool),valueColumn("Result","result",asStringOrBool)]);return t}function verboseDebugReport(mojo){const report={body:mojo.body,url:mojo.url.url,time:new Date(mojo.time),status:"",sendFailed:false};[report.status,report.sendFailed]=networkStatusToString(mojo.status,"");return report}function attributionSuccessDebugReport(mojo){const[status,sendFailed]=Report.statusToString(mojo.status,"");return{body:mojo.reportBody,url:mojo.reportUrl.url,time:new Date(mojo.reportTime),status:status,sendFailed:sendFailed}}const processAggregatableDebugReportResultText={[ProcessAggregatableDebugReportResult.kSuccess]:"Success",[ProcessAggregatableDebugReportResult.kNoDebugData]:"No debug data",[ProcessAggregatableDebugReportResult.kInsufficientBudget]:"Insufficient budget",[ProcessAggregatableDebugReportResult.kExcessiveReports]:"Excessive reports",[ProcessAggregatableDebugReportResult.kGlobalRateLimitReached]:"Global rate-limit reached",[ProcessAggregatableDebugReportResult.kReportingSiteRateLimitReached]:"Per reporting site rate-limit reached",[ProcessAggregatableDebugReportResult.kBothRateLimitsReached]:"Both rate-limits reached",[ProcessAggregatableDebugReportResult.kInternalError]:"Internal error"};function aggregatableDebugReport(mojo){const report={body:mojo.body,url:mojo.url.url,time:new Date(mojo.time),status:"",sendFailed:false};const processStatus=processAggregatableDebugReportResultText[mojo.processResult];let sendStatus;if(mojo.sendResult.networkStatus!==undefined){[sendStatus,report.sendFailed]=networkStatusToString(mojo.sendResult.networkStatus,"")}else if(mojo.sendResult.assemblyFailed!==undefined){sendStatus="Assembly failure"}else{throw new Error("invalid AggregatableDebugReportStatus union")}report.status=`${processStatus}, ${sendStatus}`;return report}function initDebugReportTable(panel){return initPanel(panel,[valueColumn("Time","time",asDate,true),valueColumn("URL","url",asUrl),reportStatusColumn],{isSelectable:true},[valueColumn("Body","body",asCode)])}function originToText(origin){if(origin.host.length===0){return"Null"}let result=origin.scheme+"://"+origin.host;if(origin.scheme==="https"&&origin.port!==443||origin.scheme==="http"&&origin.port!==80){result+=":"+origin.port}return result}const sourceTypeText={[SourceType.kNavigation]:"Navigation",[SourceType.kEvent]:"Event"};const triggerDataMatchingText={[TriggerDataMatching.kModulus]:"modulus",[TriggerDataMatching.kExact]:"exact"};const attributabilityText={[WebUISource_Attributability.kAttributable]:"Attributable",[WebUISource_Attributability.kNoisedNever]:"Unattributable: noised with no reports",[WebUISource_Attributability.kNoisedFalsely]:"Unattributable: noised with fake reports",[WebUISource_Attributability.kReachedEventLevelAttributionLimit]:"Attributable: reached event-level attribution limit"};const sourceRegistrationStatusText={[StoreSourceResult.kSuccess]:"Success",[StoreSourceResult.kSuccessNoised]:"Success",[StoreSourceResult.kInternalError]:"Rejected: internal error",[StoreSourceResult.kInsufficientSourceCapacity]:"Rejected: insufficient source capacity",[StoreSourceResult.kInsufficientUniqueDestinationCapacity]:"Rejected: insufficient unique destination capacity",[StoreSourceResult.kExcessiveReportingOrigins]:"Rejected: excessive reporting origins",[StoreSourceResult.kProhibitedByBrowserPolicy]:"Rejected: prohibited by browser policy",[StoreSourceResult.kDestinationReportingLimitReached]:"Rejected: destination reporting limit reached",[StoreSourceResult.kDestinationGlobalLimitReached]:"Rejected: destination global limit reached",[StoreSourceResult.kDestinationBothLimitsReached]:"Rejected: destination both limits reached",[StoreSourceResult.kExceedsMaxChannelCapacity]:"Rejected: channel capacity exceeds max allowed",[StoreSourceResult.kReportingOriginsPerSiteLimitReached]:"Rejected: reached reporting origins per site limit",[StoreSourceResult.kExceedsMaxTriggerStateCardinality]:"Rejected: trigger state cardinality exceeds limit",[StoreSourceResult.kDestinationPerDayReportingLimitReached]:"Rejected: destination per day reporting limit reached",[StoreSourceResult.kExceedsMaxScopesChannelCapacity]:"Rejected: scopes channel capacity exceeds max allowed",[StoreSourceResult.kExceedsMaxEventStatesLimit]:"Rejected: event states exceeds limit"};const commonResult={success:"Success: Report stored",internalError:"Failure: Internal error",noMatchingImpressions:"Failure: No matching sources",noMatchingSourceFilterData:"Failure: No matching source filter data",deduplicated:"Failure: Deduplicated against an earlier report",noCapacityForConversionDestination:"Failure: No report capacity for destination site",excessiveAttributions:"Failure: Excessive attributions",excessiveReportingOrigins:"Failure: Excessive reporting origins",reportWindowPassed:"Failure: Report window has passed",excessiveReports:"Failure: Excessive reports",prohibitedByBrowserPolicy:"Failure: Prohibited by browser policy"};const eventLevelResultText={[EventLevelResult.kSuccess]:commonResult.success,[EventLevelResult.kSuccessDroppedLowerPriority]:commonResult.success,[EventLevelResult.kInternalError]:commonResult.internalError,[EventLevelResult.kNoMatchingImpressions]:commonResult.noMatchingImpressions,[EventLevelResult.kNoMatchingSourceFilterData]:commonResult.noMatchingSourceFilterData,[EventLevelResult.kNoCapacityForConversionDestination]:commonResult.noCapacityForConversionDestination,[EventLevelResult.kExcessiveAttributions]:commonResult.excessiveAttributions,[EventLevelResult.kExcessiveReportingOrigins]:commonResult.excessiveReportingOrigins,[EventLevelResult.kDeduplicated]:commonResult.deduplicated,[EventLevelResult.kReportWindowNotStarted]:"Failure: Report window has not started",[EventLevelResult.kReportWindowPassed]:commonResult.reportWindowPassed,[EventLevelResult.kPriorityTooLow]:"Failure: Priority too low",[EventLevelResult.kNeverAttributedSource]:"Failure: Noised",[EventLevelResult.kFalselyAttributedSource]:"Failure: Noised",[EventLevelResult.kNotRegistered]:"Failure: No event-level data present",[EventLevelResult.kProhibitedByBrowserPolicy]:commonResult.prohibitedByBrowserPolicy,[EventLevelResult.kNoMatchingConfigurations]:"Failure: no matching event-level configurations",[EventLevelResult.kExcessiveReports]:commonResult.excessiveReports,[EventLevelResult.kNoMatchingTriggerData]:"Failure: no matching trigger data"};const aggregatableResultText={[AggregatableResult.kSuccess]:commonResult.success,[AggregatableResult.kInternalError]:commonResult.internalError,[AggregatableResult.kNoMatchingImpressions]:commonResult.noMatchingImpressions,[AggregatableResult.kNoMatchingSourceFilterData]:commonResult.noMatchingSourceFilterData,[AggregatableResult.kNoCapacityForConversionDestination]:commonResult.noCapacityForConversionDestination,[AggregatableResult.kExcessiveAttributions]:commonResult.excessiveAttributions,[AggregatableResult.kExcessiveReportingOrigins]:commonResult.excessiveReportingOrigins,[AggregatableResult.kDeduplicated]:commonResult.deduplicated,[AggregatableResult.kReportWindowPassed]:commonResult.reportWindowPassed,[AggregatableResult.kNoHistograms]:"Failure: No source histograms",[AggregatableResult.kInsufficientBudget]:"Failure: Insufficient budget",[AggregatableResult.kNotRegistered]:"Failure: No aggregatable data present",[AggregatableResult.kProhibitedByBrowserPolicy]:commonResult.prohibitedByBrowserPolicy,[AggregatableResult.kExcessiveReports]:commonResult.excessiveReports,[AggregatableResult.kInsufficientNamedBudget]:"Failure: Insufficient budget with selected name"};const attributionSupportText={[AttributionSupport.kWeb]:"web",[AttributionSupport.kWebAndOs]:"os, web",[AttributionSupport.kOs]:"os",[AttributionSupport.kNone]:"",[AttributionSupport.kUnset]:"unset"};class AttributionInternals{sources;sourceRegistrations;triggers;debugReports;osRegistrations;eventLevelReports;aggregatableReports;handler=new HandlerRemote;constructor(){this.eventLevelReports=initReportTable(document.querySelector("#event-level-report-panel"),this.handler,[valueColumn("Priority","reportPriority",asNumber),valueColumn("Randomized","randomizedReport",asStringOrBool)]);this.aggregatableReports=initReportTable(document.querySelector("#aggregatable-report-panel"),this.handler,[valueColumn("Histograms","contributions",asCode),valueColumn("Aggregation Coordinator","aggregationCoordinator",asUrl),valueColumn("Null","isNullReport",asStringOrBool)]);this.sources=initSourceTable(document.querySelector("#active-source-panel"));this.sourceRegistrations=initSourceRegistrationTable(document.querySelector("#source-registration-panel"));this.triggers=initTriggerTable(document.querySelector("#trigger-registration-panel"));this.debugReports=initDebugReportTable(document.querySelector("#debug-report-panel"));this.osRegistrations=initOsRegistrationTable(document.querySelector("#osRegistrationTable"));const tabs=document.querySelectorAll('div[slot="tab"]');const panels=document.querySelectorAll('div[slot="panel"]');for(let i=0;i<panels.length&&i<tabs.length;++i){const tab=tabs[i];panels[i].addEventListener("rows-change",(e=>tab.classList.toggle("unread",!tab.hasAttribute("selected")&&e.detail.rowCount>0)))}Factory.getRemote().create(new ObserverReceiver(this).$.bindNewPipeAndPassRemote(),this.handler.$.bindNewPipeAndPassReceiver())}onReportHandled(mojo){this.addSentOrDroppedReport(mojo)}onDebugReportSent(mojo){this.debugReports.addRow(verboseDebugReport(mojo))}onAggregatableDebugReportSent(mojo){this.debugReports.addRow(aggregatableDebugReport(mojo))}onSourceHandled(mojo){this.sourceRegistrations.addRow(new SourceRegistration(mojo))}onTriggerHandled(mojo){this.triggers.addRow(new Trigger(mojo))}onOsRegistration(mojo){this.osRegistrations.addRow(newOsRegistration(mojo))}addSentOrDroppedReport(mojo){if(isAttributionSuccessDebugReport(mojo.reportUrl.url)){this.debugReports.addRow(attributionSuccessDebugReport(mojo))}else if(mojo.data.eventLevelData!==undefined){this.eventLevelReports.addRow(new EventLevelReport(mojo))}else{this.aggregatableReports.addRow(new AggregatableReport(mojo))}}clearStorage(){this.sourceRegistrations.clearRows();this.triggers.clearRows();this.eventLevelReports.clearRows((report=>!report.isPending()));this.aggregatableReports.clearRows((report=>!report.isPending()));this.debugReports.clearRows();this.osRegistrations.clearRows();this.handler.clearStorage()}onDebugModeChanged(debugMode){const reportDelaysContent=document.querySelector("#report-delays");const noiseContent=document.querySelector("#noise");if(debugMode){reportDelaysContent.innerText="disabled";noiseContent.innerText="disabled"}else{reportDelaysContent.innerText="enabled";noiseContent.innerText="enabled"}}refresh(){this.handler.isAttributionReportingEnabled().then((response=>{const featureStatus=document.querySelector("#feature-status");featureStatus.innerText=response.enabled?"enabled":"disabled";const attributionSupport=document.querySelector("#attribution-support");attributionSupport.innerText=attributionSupportText[response.attributionSupport]}))}onSourcesChanged(sources){this.sources.updateRows(function*(){for(const source of sources){yield newSource(source)}}())}onReportsChanged(reports){this.eventLevelReports.updateRows(function*(){for(const report of reports){if(report.data.eventLevelData!==undefined){yield new EventLevelReport(report)}}}());this.aggregatableReports.updateRows(function*(){for(const report of reports){if(report.data.aggregatableAttributionData!==undefined){yield new AggregatableReport(report)}}}())}}document.addEventListener("DOMContentLoaded",(function(){const tabBox=document.querySelector("cr-tab-box");tabBox.addEventListener("selected-index-change",(e=>{const tabs=document.querySelectorAll('div[slot="tab"]');tabs[e.detail].classList.remove("unread")}));const internals=new AttributionInternals;document.querySelector("#refresh").addEventListener("click",(()=>internals.refresh()));document.querySelector("#clear-data").addEventListener("click",(()=>internals.clearStorage()));tabBox.hidden=false;internals.refresh()}));