// content/browser/process_internals/process_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_DATA_VIEW_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/browser/process_internals/process_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace mojom {
class ProcessCountInfoDataView;

class SiteInstanceInfoDataView;

class FrameInfoDataView;

class WebContentsInfoDataView;

class IsolatedOriginInfoDataView;



}  // mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::ProcessCountInfoDataView> {
  using Data = ::mojom::internal::ProcessCountInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::SiteInstanceInfoDataView> {
  using Data = ::mojom::internal::SiteInstanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::FrameInfoDataView> {
  using Data = ::mojom::internal::FrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::WebContentsInfoDataView> {
  using Data = ::mojom::internal::WebContentsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::IsolatedOriginInfoDataView> {
  using Data = ::mojom::internal::IsolatedOriginInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {


enum class FrameInfo_Type : int32_t {
  
  kActive = 0,
  
  kBackForwardCache = 1,
  
  kPrerender = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FrameInfo_Type value);
inline bool IsKnownEnumValue(FrameInfo_Type value) {
  return internal::FrameInfo_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProcessInternalsHandlerInterfaceBase {};

using ProcessInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;


class ProcessCountInfoDataView {
 public:
  ProcessCountInfoDataView() = default;

  ProcessCountInfoDataView(
      internal::ProcessCountInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t renderer_process_limit() const {
    return data_->renderer_process_limit;
  }
  uint64_t renderer_process_count_total() const {
    return data_->renderer_process_count_total;
  }
  uint64_t live_renderer_processes_count_total() const {
    return data_->live_renderer_processes_count_total;
  }
  uint64_t renderer_process_count_for_limit() const {
    return data_->renderer_process_count_for_limit;
  }
 private:
  internal::ProcessCountInfo_Data* data_ = nullptr;
};


class SiteInstanceInfoDataView {
 public:
  SiteInstanceInfoDataView() = default;

  SiteInstanceInfoDataView(
      internal::SiteInstanceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t site_instance_group_id() const {
    return data_->site_instance_group_id;
  }
  int32_t browsing_instance_id() const {
    return data_->browsing_instance_id;
  }
  bool locked() const {
    return data_->locked;
  }
  inline void GetSiteUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `site_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSiteUrl` instead "
    "of `ReadSiteUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->site_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetProcessLockUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessLockUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `process_lock_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProcessLockUrl` instead "
    "of `ReadProcessLockUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->process_lock_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool requires_origin_keyed_process() const {
    return data_->requires_origin_keyed_process;
  }
  bool is_sandbox_for_iframes() const {
    return data_->is_sandbox_for_iframes;
  }
  bool is_guest() const {
    return data_->is_guest;
  }
  bool is_pdf() const {
    return data_->is_pdf;
  }
  bool are_javascript_optimizers_enabled() const {
    return data_->are_javascript_optimizers_enabled;
  }
  inline void GetStoragePartitionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStoragePartition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `storage_partition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStoragePartition` instead "
    "of `ReadStoragePartition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->storage_partition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SiteInstanceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameInfoDataView {
 public:
  FrameInfoDataView() = default;

  FrameInfoDataView(
      internal::FrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  int32_t agent_scheduling_group_id() const {
    return data_->agent_scheduling_group_id;
  }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetSiteInstanceDataView(
      SiteInstanceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteInstance(UserType* output) {
    
    auto* pointer = data_->site_instance.Get();
    return mojo::internal::Deserialize<::mojom::SiteInstanceInfoDataView>(
        pointer, output, message_);
  }
  inline void GetLastCommittedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastCommittedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `last_committed_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastCommittedUrl` instead "
    "of `ReadLastCommittedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_committed_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::mojom::FrameInfo_Type>(
        data_value, output);
  }
  FrameInfo_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojom::FrameInfo_Type>(data_->type));
  }
 private:
  internal::FrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebContentsInfoDataView {
 public:
  WebContentsInfoDataView() = default;

  WebContentsInfoDataView(
      internal::WebContentsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRootFrameDataView(
      FrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootFrame(UserType* output) {
    
    auto* pointer = data_->root_frame.Get();
    return mojo::internal::Deserialize<::mojom::FrameInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBfcachedRootFramesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBfcachedRootFrames(UserType* output) {
    
    auto* pointer = data_->bfcached_root_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPrerenderRootFramesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrerenderRootFrames(UserType* output) {
    
    auto* pointer = data_->prerender_root_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebContentsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IsolatedOriginInfoDataView {
 public:
  IsolatedOriginInfoDataView() = default;

  IsolatedOriginInfoDataView(
      internal::IsolatedOriginInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IsolatedOriginInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojom

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_DATA_VIEW_H_