// content/browser/private_aggregation/private_aggregation_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/browser/private_aggregation/private_aggregation_internals.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::private_aggregation_internals::mojom::ReportStatus>
    : public mojo::internal::EnumHashImpl<::private_aggregation_internals::mojom::ReportStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::ReportStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::private_aggregation_internals::mojom::ReportStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::private_aggregation_internals::mojom::ReportStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bucket)::BaseType> bucket_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
      in_bucket,
      bucket_fragment);

    fragment->bucket.Set(
        bucket_fragment.is_null() ? nullptr : bucket_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bucket.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket in AggregatableHistogramContribution struct");

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    fragment->report_time = Traits::report_time(input);

    decltype(Traits::api_identifier(input)) in_api_identifier = Traits::api_identifier(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->api_identifier)::BaseType> api_identifier_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_api_identifier,
      api_identifier_fragment);

    fragment->api_identifier.Set(
        api_identifier_fragment.is_null() ? nullptr : api_identifier_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->api_identifier.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null api_identifier in WebUIAggregatableReport struct");

    decltype(Traits::api_version(input)) in_api_version = Traits::api_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->api_version)::BaseType> api_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_api_version,
      api_version_fragment);

    fragment->api_version.Set(
        api_version_fragment.is_null() ? nullptr : api_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->api_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null api_version in WebUIAggregatableReport struct");

    decltype(Traits::report_url(input)) in_report_url = Traits::report_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_url)::BaseType> report_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_url,
      report_url_fragment);

    fragment->report_url.Set(
        report_url_fragment.is_null() ? nullptr : report_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_url in WebUIAggregatableReport struct");

    decltype(Traits::contributions(input)) in_contributions = Traits::contributions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contributions)::BaseType>
        contributions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView>>(
      in_contributions,
      contributions_fragment,
      &contributions_validate_params);

    fragment->contributions.Set(
        contributions_fragment.is_null() ? nullptr : contributions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contributions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contributions in WebUIAggregatableReport struct");

    
    mojo::internal::Serialize<::private_aggregation_internals::mojom::ReportStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::report_body(input)) in_report_body = Traits::report_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_body)::BaseType> report_body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_report_body,
      report_body_fragment);

    fragment->report_body.Set(
        report_body_fragment.is_null() ? nullptr : report_body_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_body.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_body in WebUIAggregatableReport struct");
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::WebUIAggregatableReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace private_aggregation_internals::mojom {



inline void AggregatableHistogramContributionDataView::GetBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->bucket.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}


inline void WebUIAggregatableReportDataView::GetIdDataView(
    AggregatableReportRequestIDDataView* output) {
  auto pointer = data_->id.Get();
  *output = AggregatableReportRequestIDDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetApiIdentifierDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->api_identifier.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetApiVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->api_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetContributionsDataView(
    mojo::ArrayDataView<AggregatableHistogramContributionDataView>* output) {
  auto pointer = data_->contributions.Get();
  *output = mojo::ArrayDataView<AggregatableHistogramContributionDataView>(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetReportBodyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->report_body.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // private_aggregation_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::private_aggregation_internals::mojom::ReportStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::private_aggregation_internals::mojom::ReportStatus value);
};

} // namespace perfetto

#endif  // CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_