// content/browser/private_aggregation/private_aggregation_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_DATA_VIEW_H_
#define CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"


namespace private_aggregation_internals::mojom {
class AggregatableReportRequestIDDataView;

class AggregatableHistogramContributionDataView;

class WebUIAggregatableReportDataView;



}  // private_aggregation_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace private_aggregation_internals::mojom {


enum class ReportStatus : int32_t {
  
  kPending = 0,
  
  kSent = 1,
  
  kFailedToAssemble = 2,
  
  kFailedToSend = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReportStatus value);
inline bool IsKnownEnumValue(ReportStatus value) {
  return internal::ReportStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ObserverInterfaceBase {};

using ObserverPtrDataView =
    mojo::InterfacePtrDataView<ObserverInterfaceBase>;
using ObserverRequestDataView =
    mojo::InterfaceRequestDataView<ObserverInterfaceBase>;
using ObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ObserverInterfaceBase>;
using ObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ObserverInterfaceBase>;
class HandlerInterfaceBase {};

using HandlerPtrDataView =
    mojo::InterfacePtrDataView<HandlerInterfaceBase>;
using HandlerRequestDataView =
    mojo::InterfaceRequestDataView<HandlerInterfaceBase>;
using HandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HandlerInterfaceBase>;
using HandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HandlerInterfaceBase>;
class FactoryInterfaceBase {};

using FactoryPtrDataView =
    mojo::InterfacePtrDataView<FactoryInterfaceBase>;
using FactoryRequestDataView =
    mojo::InterfaceRequestDataView<FactoryInterfaceBase>;
using FactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FactoryInterfaceBase>;
using FactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FactoryInterfaceBase>;


class AggregatableReportRequestIDDataView {
 public:
  AggregatableReportRequestIDDataView() = default;

  AggregatableReportRequestIDDataView(
      internal::AggregatableReportRequestID_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t value() const {
    return data_->value;
  }
 private:
  internal::AggregatableReportRequestID_Data* data_ = nullptr;
};


class AggregatableHistogramContributionDataView {
 public:
  AggregatableHistogramContributionDataView() = default;

  AggregatableHistogramContributionDataView(
      internal::AggregatableHistogramContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = data_->bucket.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::AggregatableHistogramContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIAggregatableReportDataView {
 public:
  WebUIAggregatableReportDataView() = default;

  WebUIAggregatableReportDataView(
      internal::WebUIAggregatableReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      AggregatableReportRequestIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView>(
        pointer, output, message_);
  }
  double report_time() const {
    return data_->report_time;
  }
  inline void GetApiIdentifierDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApiIdentifier(UserType* output) {
    
    auto* pointer = data_->api_identifier.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetApiVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApiVersion(UserType* output) {
    
    auto* pointer = data_->api_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUrl(UserType* output) {
    
    auto* pointer = data_->report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetContributionsDataView(
      mojo::ArrayDataView<AggregatableHistogramContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContributions(UserType* output) {
    
    auto* pointer = data_->contributions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::private_aggregation_internals::mojom::ReportStatus>(
        data_value, output);
  }
  ReportStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::private_aggregation_internals::mojom::ReportStatus>(data_->status));
  }
  inline void GetReportBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportBody(UserType* output) {
    
    auto* pointer = data_->report_body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIAggregatableReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // private_aggregation_internals::mojom

#endif  // CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_DATA_VIEW_H_