// content/browser/indexed_db/indexed_db_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_id.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/browser/indexed_db/indexed_db_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbPartitionMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbPartitionMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbPartitionMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::partition_path(input)) in_partition_path = Traits::partition_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partition_path)::BaseType> partition_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_partition_path,
      partition_path_fragment);

    fragment->partition_path.Set(
        partition_path_fragment.is_null() ? nullptr : partition_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->partition_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_path in IdbPartitionMetadata struct");

    decltype(Traits::origin_list(input)) in_origin_list = Traits::origin_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_list)::BaseType>
        origin_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& origin_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>>(
      in_origin_list,
      origin_list_fragment,
      &origin_list_validate_params);

    fragment->origin_list.Set(
        origin_list_fragment.is_null() ? nullptr : origin_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_list in IdbPartitionMetadata struct");
  }

  static bool Deserialize(::storage::mojom::internal::IdbPartitionMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbPartitionMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void IdbPartitionMetadataDataView::GetPartitionPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->partition_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void IdbPartitionMetadataDataView::GetOriginListDataView(
    mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>* output) {
  auto pointer = data_->origin_list.Get();
  *output = mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SHARED_H_