// content/browser/indexed_db/indexed_db_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "content/browser/indexed_db/indexed_db_internals.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_id.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbPartitionMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbPartitionMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbPartitionMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::partition_path(input)) in_partition_path = Traits::partition_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->partition_path)::BaseType> partition_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_partition_path,
        partition_path_fragment);

      fragment->partition_path.Set(
          partition_path_fragment.is_null() ? nullptr : partition_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->partition_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null partition_path in IdbPartitionMetadata struct");

      decltype(Traits::origin_list(input)) in_origin_list = Traits::origin_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin_list)::BaseType>
          origin_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& origin_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>, send_validation>(
        in_origin_list,
        origin_list_fragment,
        &origin_list_validate_params);

      fragment->origin_list.Set(
          origin_list_fragment.is_null() ? nullptr : origin_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin_list in IdbPartitionMetadata struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_SEND_VALIDATION_H_