// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_SystemInfo_h
#define content_protocol_SystemInfo_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace SystemInfo {
class GPUDevice;
class Size;
class VideoDecodeAcceleratorCapability;
class VideoEncodeAcceleratorCapability;
class GPUInfo;
class ProcessInfo;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CONTENT_EXPORT GPUDevice : public ::crdtp::ProtocolObject<GPUDevice> {
public:
    ~GPUDevice() override;  // Defined below

    double GetVendorId() { return m_vendorId; }
    void SetVendorId(double value);  // Defined below

    double GetDeviceId() { return m_deviceId; }
    void SetDeviceId(double value);  // Defined below

    bool HasSubSysId() { return !!m_subSysId; }
    double GetSubSysId(double defaultValue) const {
       return m_subSysId.value_or(defaultValue);
    }
    const std::optional<double>& GetSubSysId() const {
       return m_subSysId;
    }
    void SetSubSysId(double value);  // Defined below

    bool HasRevision() { return !!m_revision; }
    double GetRevision(double defaultValue) const {
       return m_revision.value_or(defaultValue);
    }
    const std::optional<double>& GetRevision() const {
       return m_revision;
    }
    void SetRevision(double value);  // Defined below

    String GetVendorString() { return m_vendorString; }
    void SetVendorString(const String& value);  // Defined below

    String GetDeviceString() { return m_deviceString; }
    void SetDeviceString(const String& value);  // Defined below

    String GetDriverVendor() { return m_driverVendor; }
    void SetDriverVendor(const String& value);  // Defined below

    String GetDriverVersion() { return m_driverVersion; }
    void SetDriverVersion(const String& value);  // Defined below

    template<int STATE>
    class GPUDeviceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            VendorIdSet = 1 << 1,
            DeviceIdSet = 1 << 2,
            VendorStringSet = 1 << 3,
            DeviceStringSet = 1 << 4,
            DriverVendorSet = 1 << 5,
            DriverVersionSet = 1 << 6,
            AllFieldsSet = (VendorIdSet | DeviceIdSet | VendorStringSet | DeviceStringSet | DriverVendorSet | DriverVersionSet | 0)};


        GPUDeviceBuilder<STATE | VendorIdSet>& SetVendorId(double value);  // Defined below

        GPUDeviceBuilder<STATE | DeviceIdSet>& SetDeviceId(double value);  // Defined below

        GPUDeviceBuilder<STATE>& SetSubSysId(double value);  // Defined below

        GPUDeviceBuilder<STATE>& SetRevision(double value);  // Defined below

        GPUDeviceBuilder<STATE | VendorStringSet>& SetVendorString(const String& value);  // Defined below

        GPUDeviceBuilder<STATE | DeviceStringSet>& SetDeviceString(const String& value);  // Defined below

        GPUDeviceBuilder<STATE | DriverVendorSet>& SetDriverVendor(const String& value);  // Defined below

        GPUDeviceBuilder<STATE | DriverVersionSet>& SetDriverVersion(const String& value);  // Defined below

        std::unique_ptr<GPUDevice> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GPUDevice;
        GPUDeviceBuilder() : m_result(new GPUDevice()) { }

        template<int STEP> GPUDeviceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GPUDeviceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::GPUDevice> m_result;
    };

    static GPUDeviceBuilder<0> Create()
    {
        return GPUDeviceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GPUDevice();  // Defined below

    double m_vendorId;
    double m_deviceId;
    std::optional<double> m_subSysId;
    std::optional<double> m_revision;
    String m_vendorString;
    String m_deviceString;
    String m_driverVendor;
    String m_driverVersion;
};


class CONTENT_EXPORT Size : public ::crdtp::ProtocolObject<Size> {
public:
    ~Size() override;  // Defined below

    int GetWidth() { return m_width; }
    void SetWidth(int value);  // Defined below

    int GetHeight() { return m_height; }
    void SetHeight(int value);  // Defined below

    template<int STATE>
    class SizeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            WidthSet = 1 << 1,
            HeightSet = 1 << 2,
            AllFieldsSet = (WidthSet | HeightSet | 0)};


        SizeBuilder<STATE | WidthSet>& SetWidth(int value);  // Defined below

        SizeBuilder<STATE | HeightSet>& SetHeight(int value);  // Defined below

        std::unique_ptr<Size> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Size;
        SizeBuilder() : m_result(new Size()) { }

        template<int STEP> SizeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SizeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::Size> m_result;
    };

    static SizeBuilder<0> Create()
    {
        return SizeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Size();  // Defined below

    int m_width;
    int m_height;
};


class CONTENT_EXPORT VideoDecodeAcceleratorCapability : public ::crdtp::ProtocolObject<VideoDecodeAcceleratorCapability> {
public:
    ~VideoDecodeAcceleratorCapability() override;  // Defined below

    String GetProfile() { return m_profile; }
    void SetProfile(const String& value);  // Defined below

    protocol::SystemInfo::Size* GetMaxResolution() { return m_maxResolution.get(); }
    void SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

    protocol::SystemInfo::Size* GetMinResolution() { return m_minResolution.get(); }
    void SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

    template<int STATE>
    class VideoDecodeAcceleratorCapabilityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProfileSet = 1 << 1,
            MaxResolutionSet = 1 << 2,
            MinResolutionSet = 1 << 3,
            AllFieldsSet = (ProfileSet | MaxResolutionSet | MinResolutionSet | 0)};


        VideoDecodeAcceleratorCapabilityBuilder<STATE | ProfileSet>& SetProfile(const String& value);  // Defined below

        VideoDecodeAcceleratorCapabilityBuilder<STATE | MaxResolutionSet>& SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

        VideoDecodeAcceleratorCapabilityBuilder<STATE | MinResolutionSet>& SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

        std::unique_ptr<VideoDecodeAcceleratorCapability> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VideoDecodeAcceleratorCapability;
        VideoDecodeAcceleratorCapabilityBuilder() : m_result(new VideoDecodeAcceleratorCapability()) { }

        template<int STEP> VideoDecodeAcceleratorCapabilityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VideoDecodeAcceleratorCapabilityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::VideoDecodeAcceleratorCapability> m_result;
    };

    static VideoDecodeAcceleratorCapabilityBuilder<0> Create()
    {
        return VideoDecodeAcceleratorCapabilityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VideoDecodeAcceleratorCapability();  // Defined below

    String m_profile;
    std::unique_ptr<protocol::SystemInfo::Size> m_maxResolution;
    std::unique_ptr<protocol::SystemInfo::Size> m_minResolution;
};


class CONTENT_EXPORT VideoEncodeAcceleratorCapability : public ::crdtp::ProtocolObject<VideoEncodeAcceleratorCapability> {
public:
    ~VideoEncodeAcceleratorCapability() override;  // Defined below

    String GetProfile() { return m_profile; }
    void SetProfile(const String& value);  // Defined below

    protocol::SystemInfo::Size* GetMaxResolution() { return m_maxResolution.get(); }
    void SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

    int GetMaxFramerateNumerator() { return m_maxFramerateNumerator; }
    void SetMaxFramerateNumerator(int value);  // Defined below

    int GetMaxFramerateDenominator() { return m_maxFramerateDenominator; }
    void SetMaxFramerateDenominator(int value);  // Defined below

    template<int STATE>
    class VideoEncodeAcceleratorCapabilityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProfileSet = 1 << 1,
            MaxResolutionSet = 1 << 2,
            MaxFramerateNumeratorSet = 1 << 3,
            MaxFramerateDenominatorSet = 1 << 4,
            AllFieldsSet = (ProfileSet | MaxResolutionSet | MaxFramerateNumeratorSet | MaxFramerateDenominatorSet | 0)};


        VideoEncodeAcceleratorCapabilityBuilder<STATE | ProfileSet>& SetProfile(const String& value);  // Defined below

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxResolutionSet>& SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value);  // Defined below

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxFramerateNumeratorSet>& SetMaxFramerateNumerator(int value);  // Defined below

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxFramerateDenominatorSet>& SetMaxFramerateDenominator(int value);  // Defined below

        std::unique_ptr<VideoEncodeAcceleratorCapability> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VideoEncodeAcceleratorCapability;
        VideoEncodeAcceleratorCapabilityBuilder() : m_result(new VideoEncodeAcceleratorCapability()) { }

        template<int STEP> VideoEncodeAcceleratorCapabilityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VideoEncodeAcceleratorCapabilityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::VideoEncodeAcceleratorCapability> m_result;
    };

    static VideoEncodeAcceleratorCapabilityBuilder<0> Create()
    {
        return VideoEncodeAcceleratorCapabilityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VideoEncodeAcceleratorCapability();  // Defined below

    String m_profile;
    std::unique_ptr<protocol::SystemInfo::Size> m_maxResolution;
    int m_maxFramerateNumerator;
    int m_maxFramerateDenominator;
};


class CONTENT_EXPORT GPUInfo : public ::crdtp::ProtocolObject<GPUInfo> {
public:
    ~GPUInfo() override;  // Defined below

    protocol::Array<protocol::SystemInfo::GPUDevice>* GetDevices() { return m_devices.get(); }
    void SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value);  // Defined below

    bool HasAuxAttributes() { return !!m_auxAttributes; }
    protocol::DictionaryValue* GetAuxAttributes(protocol::DictionaryValue* defaultValue) {
       return m_auxAttributes ? m_auxAttributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& GetAuxAttributes() const {
       return m_auxAttributes;
    }
    void SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    bool HasFeatureStatus() { return !!m_featureStatus; }
    protocol::DictionaryValue* GetFeatureStatus(protocol::DictionaryValue* defaultValue) {
       return m_featureStatus ? m_featureStatus.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& GetFeatureStatus() const {
       return m_featureStatus;
    }
    void SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    protocol::Array<String>* GetDriverBugWorkarounds() { return m_driverBugWorkarounds.get(); }
    void SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>* GetVideoDecoding() { return m_videoDecoding.get(); }
    void SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value);  // Defined below

    protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>* GetVideoEncoding() { return m_videoEncoding.get(); }
    void SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value);  // Defined below

    template<int STATE>
    class GPUInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DevicesSet = 1 << 1,
            DriverBugWorkaroundsSet = 1 << 2,
            VideoDecodingSet = 1 << 3,
            VideoEncodingSet = 1 << 4,
            AllFieldsSet = (DevicesSet | DriverBugWorkaroundsSet | VideoDecodingSet | VideoEncodingSet | 0)};


        GPUInfoBuilder<STATE | DevicesSet>& SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value);  // Defined below

        GPUInfoBuilder<STATE>& SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        GPUInfoBuilder<STATE>& SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        GPUInfoBuilder<STATE | DriverBugWorkaroundsSet>& SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        GPUInfoBuilder<STATE | VideoDecodingSet>& SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value);  // Defined below

        GPUInfoBuilder<STATE | VideoEncodingSet>& SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value);  // Defined below

        std::unique_ptr<GPUInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GPUInfo;
        GPUInfoBuilder() : m_result(new GPUInfo()) { }

        template<int STEP> GPUInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GPUInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::GPUInfo> m_result;
    };

    static GPUInfoBuilder<0> Create()
    {
        return GPUInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GPUInfo();  // Defined below

    std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> m_devices;
    std::unique_ptr<protocol::DictionaryValue> m_auxAttributes;
    std::unique_ptr<protocol::DictionaryValue> m_featureStatus;
    std::unique_ptr<protocol::Array<String>> m_driverBugWorkarounds;
    std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> m_videoDecoding;
    std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> m_videoEncoding;
};


class CONTENT_EXPORT ProcessInfo : public ::crdtp::ProtocolObject<ProcessInfo> {
public:
    ~ProcessInfo() override;  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    int GetId() { return m_id; }
    void SetId(int value);  // Defined below

    double GetCpuTime() { return m_cpuTime; }
    void SetCpuTime(double value);  // Defined below

    template<int STATE>
    class ProcessInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            IdSet = 1 << 2,
            CpuTimeSet = 1 << 3,
            AllFieldsSet = (TypeSet | IdSet | CpuTimeSet | 0)};


        ProcessInfoBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        ProcessInfoBuilder<STATE | IdSet>& SetId(int value);  // Defined below

        ProcessInfoBuilder<STATE | CpuTimeSet>& SetCpuTime(double value);  // Defined below

        std::unique_ptr<ProcessInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ProcessInfo;
        ProcessInfoBuilder() : m_result(new ProcessInfo()) { }

        template<int STEP> ProcessInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ProcessInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::ProcessInfo> m_result;
    };

    static ProcessInfoBuilder<0> Create()
    {
        return ProcessInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ProcessInfo();  // Defined below

    String m_type;
    int m_id;
    double m_cpuTime;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline GPUDevice::~GPUDevice() = default;
inline void GPUDevice::SetVendorId(double value) { m_vendorId = value; }
inline void GPUDevice::SetDeviceId(double value) { m_deviceId = value; }
inline void GPUDevice::SetSubSysId(double value) { m_subSysId = value; }
inline void GPUDevice::SetRevision(double value) { m_revision = value; }
inline void GPUDevice::SetVendorString(const String& value) { m_vendorString = value; }
inline void GPUDevice::SetDeviceString(const String& value) { m_deviceString = value; }
inline void GPUDevice::SetDriverVendor(const String& value) { m_driverVendor = value; }
inline void GPUDevice::SetDriverVersion(const String& value) { m_driverVersion = value; }

template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::VendorIdSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetVendorId(double value) {
  static_assert(!(STATE & VendorIdSet), "property vendorId should not be set yet");
  m_result->SetVendorId(value);
  return castState<VendorIdSet>();
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::DeviceIdSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetDeviceId(double value) {
  static_assert(!(STATE & DeviceIdSet), "property deviceId should not be set yet");
  m_result->SetDeviceId(value);
  return castState<DeviceIdSet>();
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE>& GPUDevice::GPUDeviceBuilder<STATE>::SetSubSysId(double value) {
  m_result->SetSubSysId(value);
  return *this;
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE>& GPUDevice::GPUDeviceBuilder<STATE>::SetRevision(double value) {
  m_result->SetRevision(value);
  return *this;
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::VendorStringSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetVendorString(const String& value) {
  static_assert(!(STATE & VendorStringSet), "property vendorString should not be set yet");
  m_result->SetVendorString(value);
  return castState<VendorStringSet>();
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::DeviceStringSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetDeviceString(const String& value) {
  static_assert(!(STATE & DeviceStringSet), "property deviceString should not be set yet");
  m_result->SetDeviceString(value);
  return castState<DeviceStringSet>();
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::DriverVendorSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetDriverVendor(const String& value) {
  static_assert(!(STATE & DriverVendorSet), "property driverVendor should not be set yet");
  m_result->SetDriverVendor(value);
  return castState<DriverVendorSet>();
}
template<int STATE>
inline GPUDevice::GPUDeviceBuilder<STATE | GPUDevice::GPUDeviceBuilder<STATE>::DriverVersionSet>&
GPUDevice::GPUDeviceBuilder<STATE>::SetDriverVersion(const String& value) {
  static_assert(!(STATE & DriverVersionSet), "property driverVersion should not be set yet");
  m_result->SetDriverVersion(value);
  return castState<DriverVersionSet>();
}

inline GPUDevice::GPUDevice() {
  m_vendorId = 0;
  m_deviceId = 0;
}
inline Size::~Size() = default;
inline void Size::SetWidth(int value) { m_width = value; }
inline void Size::SetHeight(int value) { m_height = value; }

template<int STATE>
inline Size::SizeBuilder<STATE | Size::SizeBuilder<STATE>::WidthSet>&
Size::SizeBuilder<STATE>::SetWidth(int value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->SetWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline Size::SizeBuilder<STATE | Size::SizeBuilder<STATE>::HeightSet>&
Size::SizeBuilder<STATE>::SetHeight(int value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->SetHeight(value);
  return castState<HeightSet>();
}

inline Size::Size() {
  m_width = 0;
  m_height = 0;
}
inline VideoDecodeAcceleratorCapability::~VideoDecodeAcceleratorCapability() = default;
inline void VideoDecodeAcceleratorCapability::SetProfile(const String& value) { m_profile = value; }
inline void VideoDecodeAcceleratorCapability::SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_maxResolution = std::move(value); }
inline void VideoDecodeAcceleratorCapability::SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_minResolution = std::move(value); }

template<int STATE>
inline VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE | VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::ProfileSet>&
VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::SetProfile(const String& value) {
  static_assert(!(STATE & ProfileSet), "property profile should not be set yet");
  m_result->SetProfile(value);
  return castState<ProfileSet>();
}
template<int STATE>
inline VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE | VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::MaxResolutionSet>&
VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) {
  static_assert(!(STATE & MaxResolutionSet), "property maxResolution should not be set yet");
  m_result->SetMaxResolution(std::move(value));
  return castState<MaxResolutionSet>();
}
template<int STATE>
inline VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE | VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::MinResolutionSet>&
VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapabilityBuilder<STATE>::SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value) {
  static_assert(!(STATE & MinResolutionSet), "property minResolution should not be set yet");
  m_result->SetMinResolution(std::move(value));
  return castState<MinResolutionSet>();
}

inline VideoDecodeAcceleratorCapability::VideoDecodeAcceleratorCapability() {
}
inline VideoEncodeAcceleratorCapability::~VideoEncodeAcceleratorCapability() = default;
inline void VideoEncodeAcceleratorCapability::SetProfile(const String& value) { m_profile = value; }
inline void VideoEncodeAcceleratorCapability::SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_maxResolution = std::move(value); }
inline void VideoEncodeAcceleratorCapability::SetMaxFramerateNumerator(int value) { m_maxFramerateNumerator = value; }
inline void VideoEncodeAcceleratorCapability::SetMaxFramerateDenominator(int value) { m_maxFramerateDenominator = value; }

template<int STATE>
inline VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE | VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::ProfileSet>&
VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::SetProfile(const String& value) {
  static_assert(!(STATE & ProfileSet), "property profile should not be set yet");
  m_result->SetProfile(value);
  return castState<ProfileSet>();
}
template<int STATE>
inline VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE | VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::MaxResolutionSet>&
VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) {
  static_assert(!(STATE & MaxResolutionSet), "property maxResolution should not be set yet");
  m_result->SetMaxResolution(std::move(value));
  return castState<MaxResolutionSet>();
}
template<int STATE>
inline VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE | VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::MaxFramerateNumeratorSet>&
VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::SetMaxFramerateNumerator(int value) {
  static_assert(!(STATE & MaxFramerateNumeratorSet), "property maxFramerateNumerator should not be set yet");
  m_result->SetMaxFramerateNumerator(value);
  return castState<MaxFramerateNumeratorSet>();
}
template<int STATE>
inline VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE | VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::MaxFramerateDenominatorSet>&
VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapabilityBuilder<STATE>::SetMaxFramerateDenominator(int value) {
  static_assert(!(STATE & MaxFramerateDenominatorSet), "property maxFramerateDenominator should not be set yet");
  m_result->SetMaxFramerateDenominator(value);
  return castState<MaxFramerateDenominatorSet>();
}

inline VideoEncodeAcceleratorCapability::VideoEncodeAcceleratorCapability() {
  m_maxFramerateNumerator = 0;
  m_maxFramerateDenominator = 0;
}
inline GPUInfo::~GPUInfo() = default;
inline void GPUInfo::SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value) { m_devices = std::move(value); }
inline void GPUInfo::SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value) { m_auxAttributes = std::move(value); }
inline void GPUInfo::SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value) { m_featureStatus = std::move(value); }
inline void GPUInfo::SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value) { m_driverBugWorkarounds = std::move(value); }
inline void GPUInfo::SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value) { m_videoDecoding = std::move(value); }
inline void GPUInfo::SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value) { m_videoEncoding = std::move(value); }

template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE | GPUInfo::GPUInfoBuilder<STATE>::DevicesSet>&
GPUInfo::GPUInfoBuilder<STATE>::SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value) {
  static_assert(!(STATE & DevicesSet), "property devices should not be set yet");
  m_result->SetDevices(std::move(value));
  return castState<DevicesSet>();
}
template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE>& GPUInfo::GPUInfoBuilder<STATE>::SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value) {
  m_result->SetAuxAttributes(std::move(value));
  return *this;
}
template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE>& GPUInfo::GPUInfoBuilder<STATE>::SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value) {
  m_result->SetFeatureStatus(std::move(value));
  return *this;
}
template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE | GPUInfo::GPUInfoBuilder<STATE>::DriverBugWorkaroundsSet>&
GPUInfo::GPUInfoBuilder<STATE>::SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & DriverBugWorkaroundsSet), "property driverBugWorkarounds should not be set yet");
  m_result->SetDriverBugWorkarounds(std::move(value));
  return castState<DriverBugWorkaroundsSet>();
}
template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE | GPUInfo::GPUInfoBuilder<STATE>::VideoDecodingSet>&
GPUInfo::GPUInfoBuilder<STATE>::SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value) {
  static_assert(!(STATE & VideoDecodingSet), "property videoDecoding should not be set yet");
  m_result->SetVideoDecoding(std::move(value));
  return castState<VideoDecodingSet>();
}
template<int STATE>
inline GPUInfo::GPUInfoBuilder<STATE | GPUInfo::GPUInfoBuilder<STATE>::VideoEncodingSet>&
GPUInfo::GPUInfoBuilder<STATE>::SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value) {
  static_assert(!(STATE & VideoEncodingSet), "property videoEncoding should not be set yet");
  m_result->SetVideoEncoding(std::move(value));
  return castState<VideoEncodingSet>();
}

inline GPUInfo::GPUInfo() {
}
inline ProcessInfo::~ProcessInfo() = default;
inline void ProcessInfo::SetType(const String& value) { m_type = value; }
inline void ProcessInfo::SetId(int value) { m_id = value; }
inline void ProcessInfo::SetCpuTime(double value) { m_cpuTime = value; }

template<int STATE>
inline ProcessInfo::ProcessInfoBuilder<STATE | ProcessInfo::ProcessInfoBuilder<STATE>::TypeSet>&
ProcessInfo::ProcessInfoBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline ProcessInfo::ProcessInfoBuilder<STATE | ProcessInfo::ProcessInfoBuilder<STATE>::IdSet>&
ProcessInfo::ProcessInfoBuilder<STATE>::SetId(int value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}
template<int STATE>
inline ProcessInfo::ProcessInfoBuilder<STATE | ProcessInfo::ProcessInfoBuilder<STATE>::CpuTimeSet>&
ProcessInfo::ProcessInfoBuilder<STATE>::SetCpuTime(double value) {
  static_assert(!(STATE & CpuTimeSet), "property cpuTime should not be set yet");
  m_result->SetCpuTime(value);
  return castState<CpuTimeSet>();
}

inline ProcessInfo::ProcessInfo() {
  m_id = 0;
  m_cpuTime = 0;
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT GetInfoCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::SystemInfo::GPUInfo> gpu, const String& modelName, const String& modelVersion, const String& commandLine) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInfoCallback() { }
    };
    virtual void GetInfo(std::unique_ptr<GetInfoCallback> callback) = 0;
    virtual DispatchResponse GetFeatureState(const String& in_featureState, bool* out_featureEnabled) = 0;
    class CONTENT_EXPORT GetProcessInfoCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::SystemInfo::ProcessInfo>> processInfo) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetProcessInfoCallback() { }
    };
    virtual void GetProcessInfo(std::unique_ptr<GetProcessInfoCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace SystemInfo
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_SystemInfo_h)
