// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Page_h
#define content_protocol_Page_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/io.h"
#include "content/browser/devtools/protocol/network.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Page {
using FrameId = String;
using TransitionType = String;
class NavigationEntry;
class ScreencastFrameMetadata;
using DialogType = String;
class AppManifestError;
class AppManifestParsedProperties;
class Viewport;
class InstallabilityErrorArgument;
class InstallabilityError;
using ReferrerPolicy = String;
class FileFilter;
class FileHandler;
class ImageResource;
class LaunchHandler;
class ProtocolHandler;
class RelatedApplication;
class ScopeExtension;
class Screenshot;
class ShareTarget;
class Shortcut;
class WebAppManifest;
using BackForwardCacheNotRestoredReason = String;
using BackForwardCacheNotRestoredReasonType = String;
class BackForwardCacheBlockingDetails;
class BackForwardCacheNotRestoredExplanation;
class BackForwardCacheNotRestoredExplanationTree;

// ------------- Forward and enum declarations.

namespace TransitionTypeEnum {
CONTENT_EXPORT extern const char Link[];
CONTENT_EXPORT extern const char Typed[];
CONTENT_EXPORT extern const char Address_bar[];
CONTENT_EXPORT extern const char Auto_bookmark[];
CONTENT_EXPORT extern const char Auto_subframe[];
CONTENT_EXPORT extern const char Manual_subframe[];
CONTENT_EXPORT extern const char Generated[];
CONTENT_EXPORT extern const char Auto_toplevel[];
CONTENT_EXPORT extern const char Form_submit[];
CONTENT_EXPORT extern const char Reload[];
CONTENT_EXPORT extern const char Keyword[];
CONTENT_EXPORT extern const char Keyword_generated[];
CONTENT_EXPORT extern const char Other[];
} // namespace TransitionTypeEnum

namespace DialogTypeEnum {
CONTENT_EXPORT extern const char Alert[];
CONTENT_EXPORT extern const char Confirm[];
CONTENT_EXPORT extern const char Prompt[];
CONTENT_EXPORT extern const char Beforeunload[];
} // namespace DialogTypeEnum

namespace ReferrerPolicyEnum {
CONTENT_EXPORT extern const char NoReferrer[];
CONTENT_EXPORT extern const char NoReferrerWhenDowngrade[];
CONTENT_EXPORT extern const char Origin[];
CONTENT_EXPORT extern const char OriginWhenCrossOrigin[];
CONTENT_EXPORT extern const char SameOrigin[];
CONTENT_EXPORT extern const char StrictOrigin[];
CONTENT_EXPORT extern const char StrictOriginWhenCrossOrigin[];
CONTENT_EXPORT extern const char UnsafeUrl[];
} // namespace ReferrerPolicyEnum

namespace BackForwardCacheNotRestoredReasonEnum {
CONTENT_EXPORT extern const char NotPrimaryMainFrame[];
CONTENT_EXPORT extern const char BackForwardCacheDisabled[];
CONTENT_EXPORT extern const char RelatedActiveContentsExist[];
CONTENT_EXPORT extern const char HTTPStatusNotOK[];
CONTENT_EXPORT extern const char SchemeNotHTTPOrHTTPS[];
CONTENT_EXPORT extern const char Loading[];
CONTENT_EXPORT extern const char WasGrantedMediaAccess[];
CONTENT_EXPORT extern const char DisableForRenderFrameHostCalled[];
CONTENT_EXPORT extern const char DomainNotAllowed[];
CONTENT_EXPORT extern const char HTTPMethodNotGET[];
CONTENT_EXPORT extern const char SubframeIsNavigating[];
CONTENT_EXPORT extern const char Timeout[];
CONTENT_EXPORT extern const char CacheLimit[];
CONTENT_EXPORT extern const char JavaScriptExecution[];
CONTENT_EXPORT extern const char RendererProcessKilled[];
CONTENT_EXPORT extern const char RendererProcessCrashed[];
CONTENT_EXPORT extern const char SchedulerTrackedFeatureUsed[];
CONTENT_EXPORT extern const char ConflictingBrowsingInstance[];
CONTENT_EXPORT extern const char CacheFlushed[];
CONTENT_EXPORT extern const char ServiceWorkerVersionActivation[];
CONTENT_EXPORT extern const char SessionRestored[];
CONTENT_EXPORT extern const char ServiceWorkerPostMessage[];
CONTENT_EXPORT extern const char EnteredBackForwardCacheBeforeServiceWorkerHostAdded[];
CONTENT_EXPORT extern const char RenderFrameHostReused_SameSite[];
CONTENT_EXPORT extern const char RenderFrameHostReused_CrossSite[];
CONTENT_EXPORT extern const char ServiceWorkerClaim[];
CONTENT_EXPORT extern const char IgnoreEventAndEvict[];
CONTENT_EXPORT extern const char HaveInnerContents[];
CONTENT_EXPORT extern const char TimeoutPuttingInCache[];
CONTENT_EXPORT extern const char BackForwardCacheDisabledByLowMemory[];
CONTENT_EXPORT extern const char BackForwardCacheDisabledByCommandLine[];
CONTENT_EXPORT extern const char NetworkRequestDatapipeDrainedAsBytesConsumer[];
CONTENT_EXPORT extern const char NetworkRequestRedirected[];
CONTENT_EXPORT extern const char NetworkRequestTimeout[];
CONTENT_EXPORT extern const char NetworkExceedsBufferLimit[];
CONTENT_EXPORT extern const char NavigationCancelledWhileRestoring[];
CONTENT_EXPORT extern const char NotMostRecentNavigationEntry[];
CONTENT_EXPORT extern const char BackForwardCacheDisabledForPrerender[];
CONTENT_EXPORT extern const char UserAgentOverrideDiffers[];
CONTENT_EXPORT extern const char ForegroundCacheLimit[];
CONTENT_EXPORT extern const char BrowsingInstanceNotSwapped[];
CONTENT_EXPORT extern const char BackForwardCacheDisabledForDelegate[];
CONTENT_EXPORT extern const char UnloadHandlerExistsInMainFrame[];
CONTENT_EXPORT extern const char UnloadHandlerExistsInSubFrame[];
CONTENT_EXPORT extern const char ServiceWorkerUnregistration[];
CONTENT_EXPORT extern const char CacheControlNoStore[];
CONTENT_EXPORT extern const char CacheControlNoStoreCookieModified[];
CONTENT_EXPORT extern const char CacheControlNoStoreHTTPOnlyCookieModified[];
CONTENT_EXPORT extern const char NoResponseHead[];
CONTENT_EXPORT extern const char Unknown[];
CONTENT_EXPORT extern const char ActivationNavigationsDisallowedForBug1234857[];
CONTENT_EXPORT extern const char ErrorDocument[];
CONTENT_EXPORT extern const char FencedFramesEmbedder[];
CONTENT_EXPORT extern const char CookieDisabled[];
CONTENT_EXPORT extern const char HTTPAuthRequired[];
CONTENT_EXPORT extern const char CookieFlushed[];
CONTENT_EXPORT extern const char BroadcastChannelOnMessage[];
CONTENT_EXPORT extern const char WebViewSettingsChanged[];
CONTENT_EXPORT extern const char WebViewJavaScriptObjectChanged[];
CONTENT_EXPORT extern const char WebViewMessageListenerInjected[];
CONTENT_EXPORT extern const char WebViewSafeBrowsingAllowlistChanged[];
CONTENT_EXPORT extern const char WebViewDocumentStartJavascriptChanged[];
CONTENT_EXPORT extern const char WebSocket[];
CONTENT_EXPORT extern const char WebTransport[];
CONTENT_EXPORT extern const char WebRTC[];
CONTENT_EXPORT extern const char MainResourceHasCacheControlNoStore[];
CONTENT_EXPORT extern const char MainResourceHasCacheControlNoCache[];
CONTENT_EXPORT extern const char SubresourceHasCacheControlNoStore[];
CONTENT_EXPORT extern const char SubresourceHasCacheControlNoCache[];
CONTENT_EXPORT extern const char ContainsPlugins[];
CONTENT_EXPORT extern const char DocumentLoaded[];
CONTENT_EXPORT extern const char OutstandingNetworkRequestOthers[];
CONTENT_EXPORT extern const char RequestedMIDIPermission[];
CONTENT_EXPORT extern const char RequestedAudioCapturePermission[];
CONTENT_EXPORT extern const char RequestedVideoCapturePermission[];
CONTENT_EXPORT extern const char RequestedBackForwardCacheBlockedSensors[];
CONTENT_EXPORT extern const char RequestedBackgroundWorkPermission[];
CONTENT_EXPORT extern const char BroadcastChannel[];
CONTENT_EXPORT extern const char WebXR[];
CONTENT_EXPORT extern const char SharedWorker[];
CONTENT_EXPORT extern const char SharedWorkerMessage[];
CONTENT_EXPORT extern const char SharedWorkerWithNoActiveClient[];
CONTENT_EXPORT extern const char WebLocks[];
CONTENT_EXPORT extern const char WebHID[];
CONTENT_EXPORT extern const char WebBluetooth[];
CONTENT_EXPORT extern const char WebShare[];
CONTENT_EXPORT extern const char RequestedStorageAccessGrant[];
CONTENT_EXPORT extern const char WebNfc[];
CONTENT_EXPORT extern const char OutstandingNetworkRequestFetch[];
CONTENT_EXPORT extern const char OutstandingNetworkRequestXHR[];
CONTENT_EXPORT extern const char AppBanner[];
CONTENT_EXPORT extern const char Printing[];
CONTENT_EXPORT extern const char WebDatabase[];
CONTENT_EXPORT extern const char PictureInPicture[];
CONTENT_EXPORT extern const char SpeechRecognizer[];
CONTENT_EXPORT extern const char IdleManager[];
CONTENT_EXPORT extern const char PaymentManager[];
CONTENT_EXPORT extern const char SpeechSynthesis[];
CONTENT_EXPORT extern const char KeyboardLock[];
CONTENT_EXPORT extern const char WebOTPService[];
CONTENT_EXPORT extern const char OutstandingNetworkRequestDirectSocket[];
CONTENT_EXPORT extern const char InjectedJavascript[];
CONTENT_EXPORT extern const char InjectedStyleSheet[];
CONTENT_EXPORT extern const char KeepaliveRequest[];
CONTENT_EXPORT extern const char IndexedDBEvent[];
CONTENT_EXPORT extern const char Dummy[];
CONTENT_EXPORT extern const char JsNetworkRequestReceivedCacheControlNoStoreResource[];
CONTENT_EXPORT extern const char WebRTCUsedWithCCNS[];
CONTENT_EXPORT extern const char WebTransportUsedWithCCNS[];
CONTENT_EXPORT extern const char WebSocketUsedWithCCNS[];
CONTENT_EXPORT extern const char SmartCard[];
CONTENT_EXPORT extern const char LiveMediaStreamTrack[];
CONTENT_EXPORT extern const char UnloadHandler[];
CONTENT_EXPORT extern const char ParserAborted[];
CONTENT_EXPORT extern const char ContentSecurityHandler[];
CONTENT_EXPORT extern const char ContentWebAuthenticationAPI[];
CONTENT_EXPORT extern const char ContentFileChooser[];
CONTENT_EXPORT extern const char ContentSerial[];
CONTENT_EXPORT extern const char ContentFileSystemAccess[];
CONTENT_EXPORT extern const char ContentMediaDevicesDispatcherHost[];
CONTENT_EXPORT extern const char ContentWebBluetooth[];
CONTENT_EXPORT extern const char ContentWebUSB[];
CONTENT_EXPORT extern const char ContentMediaSessionService[];
CONTENT_EXPORT extern const char ContentScreenReader[];
CONTENT_EXPORT extern const char ContentDiscarded[];
CONTENT_EXPORT extern const char EmbedderPopupBlockerTabHelper[];
CONTENT_EXPORT extern const char EmbedderSafeBrowsingTriggeredPopupBlocker[];
CONTENT_EXPORT extern const char EmbedderSafeBrowsingThreatDetails[];
CONTENT_EXPORT extern const char EmbedderAppBannerManager[];
CONTENT_EXPORT extern const char EmbedderDomDistillerViewerSource[];
CONTENT_EXPORT extern const char EmbedderDomDistillerSelfDeletingRequestDelegate[];
CONTENT_EXPORT extern const char EmbedderOomInterventionTabHelper[];
CONTENT_EXPORT extern const char EmbedderOfflinePage[];
CONTENT_EXPORT extern const char EmbedderChromePasswordManagerClientBindCredentialManager[];
CONTENT_EXPORT extern const char EmbedderPermissionRequestManager[];
CONTENT_EXPORT extern const char EmbedderModalDialog[];
CONTENT_EXPORT extern const char EmbedderExtensions[];
CONTENT_EXPORT extern const char EmbedderExtensionMessaging[];
CONTENT_EXPORT extern const char EmbedderExtensionMessagingForOpenPort[];
CONTENT_EXPORT extern const char EmbedderExtensionSentMessageToCachedFrame[];
CONTENT_EXPORT extern const char RequestedByWebViewClient[];
CONTENT_EXPORT extern const char PostMessageByWebViewClient[];
CONTENT_EXPORT extern const char CacheControlNoStoreDeviceBoundSessionTerminated[];
CONTENT_EXPORT extern const char CacheLimitPrunedOnModerateMemoryPressure[];
CONTENT_EXPORT extern const char CacheLimitPrunedOnCriticalMemoryPressure[];
} // namespace BackForwardCacheNotRestoredReasonEnum

namespace BackForwardCacheNotRestoredReasonTypeEnum {
CONTENT_EXPORT extern const char SupportPending[];
CONTENT_EXPORT extern const char PageSupportNeeded[];
CONTENT_EXPORT extern const char Circumstantial[];
} // namespace BackForwardCacheNotRestoredReasonTypeEnum

namespace CaptureScreenshot {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
CONTENT_EXPORT extern const char* Webp;
} // FormatEnum
} // CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Mhtml;
} // FormatEnum
} // CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
CONTENT_EXPORT extern const char* ReturnAsBase64;
CONTENT_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
CONTENT_EXPORT extern const char* Deny;
CONTENT_EXPORT extern const char* Allow;
CONTENT_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
CONTENT_EXPORT extern const char* Mobile;
CONTENT_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // FormatEnum
} // StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
CONTENT_EXPORT extern const char* Frozen;
CONTENT_EXPORT extern const char* Active;
} // StateEnum
} // SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
CONTENT_EXPORT extern const char* None;
CONTENT_EXPORT extern const char* AutoAccept;
CONTENT_EXPORT extern const char* AutoChooseToAuthAnotherWay;
CONTENT_EXPORT extern const char* AutoReject;
CONTENT_EXPORT extern const char* AutoOptOut;
} // ModeEnum
} // SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
CONTENT_EXPORT extern const char* None;
CONTENT_EXPORT extern const char* AutoAccept;
CONTENT_EXPORT extern const char* AutoReject;
} // ModeEnum
} // SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
CONTENT_EXPORT extern const char* SelectSingle;
CONTENT_EXPORT extern const char* SelectMultiple;
} // ModeEnum
} // FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
CONTENT_EXPORT extern const char* Remove;
CONTENT_EXPORT extern const char* Swap;
} // ReasonEnum
} // FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
CONTENT_EXPORT extern const char* Reload;
CONTENT_EXPORT extern const char* ReloadBypassingCache;
CONTENT_EXPORT extern const char* Restore;
CONTENT_EXPORT extern const char* RestoreWithPost;
CONTENT_EXPORT extern const char* HistorySameDocument;
CONTENT_EXPORT extern const char* HistoryDifferentDocument;
CONTENT_EXPORT extern const char* SameDocument;
CONTENT_EXPORT extern const char* DifferentDocument;
} // NavigationTypeEnum
} // FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
CONTENT_EXPORT extern const char* InProgress;
CONTENT_EXPORT extern const char* Completed;
CONTENT_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
CONTENT_EXPORT extern const char* Fragment;
CONTENT_EXPORT extern const char* HistoryApi;
CONTENT_EXPORT extern const char* Other;
} // NavigationTypeEnum
} // NavigatedWithinDocument

// ------------- Type and builder declarations.

class CONTENT_EXPORT NavigationEntry : public ::crdtp::ProtocolObject<NavigationEntry> {
public:
    ~NavigationEntry() override;  // Defined below

    int GetId() { return m_id; }
    void SetId(int value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    String GetUserTypedURL() { return m_userTypedURL; }
    void SetUserTypedURL(const String& value);  // Defined below

    String GetTitle() { return m_title; }
    void SetTitle(const String& value);  // Defined below

    String GetTransitionType() { return m_transitionType; }
    void SetTransitionType(const String& value);  // Defined below

    template<int STATE>
    class NavigationEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            UrlSet = 1 << 2,
            UserTypedURLSet = 1 << 3,
            TitleSet = 1 << 4,
            TransitionTypeSet = 1 << 5,
            AllFieldsSet = (IdSet | UrlSet | UserTypedURLSet | TitleSet | TransitionTypeSet | 0)};


        NavigationEntryBuilder<STATE | IdSet>& SetId(int value);  // Defined below

        NavigationEntryBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        NavigationEntryBuilder<STATE | UserTypedURLSet>& SetUserTypedURL(const String& value);  // Defined below

        NavigationEntryBuilder<STATE | TitleSet>& SetTitle(const String& value);  // Defined below

        NavigationEntryBuilder<STATE | TransitionTypeSet>& SetTransitionType(const String& value);  // Defined below

        std::unique_ptr<NavigationEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigationEntry;
        NavigationEntryBuilder() : m_result(new NavigationEntry()) { }

        template<int STEP> NavigationEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigationEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::NavigationEntry> m_result;
    };

    static NavigationEntryBuilder<0> Create()
    {
        return NavigationEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigationEntry();  // Defined below

    int m_id;
    String m_url;
    String m_userTypedURL;
    String m_title;
    String m_transitionType;
};


class CONTENT_EXPORT ScreencastFrameMetadata : public ::crdtp::ProtocolObject<ScreencastFrameMetadata> {
public:
    ~ScreencastFrameMetadata() override;  // Defined below

    double GetOffsetTop() { return m_offsetTop; }
    void SetOffsetTop(double value);  // Defined below

    double GetPageScaleFactor() { return m_pageScaleFactor; }
    void SetPageScaleFactor(double value);  // Defined below

    double GetDeviceWidth() { return m_deviceWidth; }
    void SetDeviceWidth(double value);  // Defined below

    double GetDeviceHeight() { return m_deviceHeight; }
    void SetDeviceHeight(double value);  // Defined below

    double GetScrollOffsetX() { return m_scrollOffsetX; }
    void SetScrollOffsetX(double value);  // Defined below

    double GetScrollOffsetY() { return m_scrollOffsetY; }
    void SetScrollOffsetY(double value);  // Defined below

    bool HasTimestamp() { return !!m_timestamp; }
    double GetTimestamp(double defaultValue) const {
       return m_timestamp.value_or(defaultValue);
    }
    const std::optional<double>& GetTimestamp() const {
       return m_timestamp;
    }
    void SetTimestamp(double value);  // Defined below

    template<int STATE>
    class ScreencastFrameMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OffsetTopSet = 1 << 1,
            PageScaleFactorSet = 1 << 2,
            DeviceWidthSet = 1 << 3,
            DeviceHeightSet = 1 << 4,
            ScrollOffsetXSet = 1 << 5,
            ScrollOffsetYSet = 1 << 6,
            AllFieldsSet = (OffsetTopSet | PageScaleFactorSet | DeviceWidthSet | DeviceHeightSet | ScrollOffsetXSet | ScrollOffsetYSet | 0)};


        ScreencastFrameMetadataBuilder<STATE | OffsetTopSet>& SetOffsetTop(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE | PageScaleFactorSet>& SetPageScaleFactor(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE | DeviceWidthSet>& SetDeviceWidth(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE | DeviceHeightSet>& SetDeviceHeight(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE | ScrollOffsetXSet>& SetScrollOffsetX(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE | ScrollOffsetYSet>& SetScrollOffsetY(double value);  // Defined below

        ScreencastFrameMetadataBuilder<STATE>& SetTimestamp(double value);  // Defined below

        std::unique_ptr<ScreencastFrameMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreencastFrameMetadata;
        ScreencastFrameMetadataBuilder() : m_result(new ScreencastFrameMetadata()) { }

        template<int STEP> ScreencastFrameMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreencastFrameMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ScreencastFrameMetadata> m_result;
    };

    static ScreencastFrameMetadataBuilder<0> Create()
    {
        return ScreencastFrameMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreencastFrameMetadata();  // Defined below

    double m_offsetTop;
    double m_pageScaleFactor;
    double m_deviceWidth;
    double m_deviceHeight;
    double m_scrollOffsetX;
    double m_scrollOffsetY;
    std::optional<double> m_timestamp;
};


class CONTENT_EXPORT AppManifestError : public ::crdtp::ProtocolObject<AppManifestError> {
public:
    ~AppManifestError() override;  // Defined below

    String GetMessage() { return m_message; }
    void SetMessage(const String& value);  // Defined below

    int GetCritical() { return m_critical; }
    void SetCritical(int value);  // Defined below

    int GetLine() { return m_line; }
    void SetLine(int value);  // Defined below

    int GetColumn() { return m_column; }
    void SetColumn(int value);  // Defined below

    template<int STATE>
    class AppManifestErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MessageSet = 1 << 1,
            CriticalSet = 1 << 2,
            LineSet = 1 << 3,
            ColumnSet = 1 << 4,
            AllFieldsSet = (MessageSet | CriticalSet | LineSet | ColumnSet | 0)};


        AppManifestErrorBuilder<STATE | MessageSet>& SetMessage(const String& value);  // Defined below

        AppManifestErrorBuilder<STATE | CriticalSet>& SetCritical(int value);  // Defined below

        AppManifestErrorBuilder<STATE | LineSet>& SetLine(int value);  // Defined below

        AppManifestErrorBuilder<STATE | ColumnSet>& SetColumn(int value);  // Defined below

        std::unique_ptr<AppManifestError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AppManifestError;
        AppManifestErrorBuilder() : m_result(new AppManifestError()) { }

        template<int STEP> AppManifestErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AppManifestErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AppManifestError> m_result;
    };

    static AppManifestErrorBuilder<0> Create()
    {
        return AppManifestErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AppManifestError();  // Defined below

    String m_message;
    int m_critical;
    int m_line;
    int m_column;
};


class CONTENT_EXPORT AppManifestParsedProperties : public ::crdtp::ProtocolObject<AppManifestParsedProperties> {
public:
    ~AppManifestParsedProperties() override;  // Defined below

    String GetScope() { return m_scope; }
    void SetScope(const String& value);  // Defined below

    template<int STATE>
    class AppManifestParsedPropertiesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScopeSet = 1 << 1,
            AllFieldsSet = (ScopeSet | 0)};


        AppManifestParsedPropertiesBuilder<STATE | ScopeSet>& SetScope(const String& value);  // Defined below

        std::unique_ptr<AppManifestParsedProperties> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AppManifestParsedProperties;
        AppManifestParsedPropertiesBuilder() : m_result(new AppManifestParsedProperties()) { }

        template<int STEP> AppManifestParsedPropertiesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AppManifestParsedPropertiesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AppManifestParsedProperties> m_result;
    };

    static AppManifestParsedPropertiesBuilder<0> Create()
    {
        return AppManifestParsedPropertiesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AppManifestParsedProperties();  // Defined below

    String m_scope;
};


class CONTENT_EXPORT Viewport : public ::crdtp::ProtocolObject<Viewport> {
public:
    ~Viewport() override;  // Defined below

    double GetX() { return m_x; }
    void SetX(double value);  // Defined below

    double GetY() { return m_y; }
    void SetY(double value);  // Defined below

    double GetWidth() { return m_width; }
    void SetWidth(double value);  // Defined below

    double GetHeight() { return m_height; }
    void SetHeight(double value);  // Defined below

    double GetScale() { return m_scale; }
    void SetScale(double value);  // Defined below

    template<int STATE>
    class ViewportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            ScaleSet = 1 << 5,
            AllFieldsSet = (XSet | YSet | WidthSet | HeightSet | ScaleSet | 0)};


        ViewportBuilder<STATE | XSet>& SetX(double value);  // Defined below

        ViewportBuilder<STATE | YSet>& SetY(double value);  // Defined below

        ViewportBuilder<STATE | WidthSet>& SetWidth(double value);  // Defined below

        ViewportBuilder<STATE | HeightSet>& SetHeight(double value);  // Defined below

        ViewportBuilder<STATE | ScaleSet>& SetScale(double value);  // Defined below

        std::unique_ptr<Viewport> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Viewport;
        ViewportBuilder() : m_result(new Viewport()) { }

        template<int STEP> ViewportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ViewportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Viewport> m_result;
    };

    static ViewportBuilder<0> Create()
    {
        return ViewportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Viewport();  // Defined below

    double m_x;
    double m_y;
    double m_width;
    double m_height;
    double m_scale;
};


class CONTENT_EXPORT InstallabilityErrorArgument : public ::crdtp::ProtocolObject<InstallabilityErrorArgument> {
public:
    ~InstallabilityErrorArgument() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetValue() { return m_value; }
    void SetValue(const String& value);  // Defined below

    template<int STATE>
    class InstallabilityErrorArgumentBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        InstallabilityErrorArgumentBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        InstallabilityErrorArgumentBuilder<STATE | ValueSet>& SetValue(const String& value);  // Defined below

        std::unique_ptr<InstallabilityErrorArgument> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityErrorArgument;
        InstallabilityErrorArgumentBuilder() : m_result(new InstallabilityErrorArgument()) { }

        template<int STEP> InstallabilityErrorArgumentBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorArgumentBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityErrorArgument> m_result;
    };

    static InstallabilityErrorArgumentBuilder<0> Create()
    {
        return InstallabilityErrorArgumentBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityErrorArgument();  // Defined below

    String m_name;
    String m_value;
};


class CONTENT_EXPORT InstallabilityError : public ::crdtp::ProtocolObject<InstallabilityError> {
public:
    ~InstallabilityError() override;  // Defined below

    String GetErrorId() { return m_errorId; }
    void SetErrorId(const String& value);  // Defined below

    protocol::Array<protocol::Page::InstallabilityErrorArgument>* GetErrorArguments() { return m_errorArguments.get(); }
    void SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value);  // Defined below

    template<int STATE>
    class InstallabilityErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorIdSet = 1 << 1,
            ErrorArgumentsSet = 1 << 2,
            AllFieldsSet = (ErrorIdSet | ErrorArgumentsSet | 0)};


        InstallabilityErrorBuilder<STATE | ErrorIdSet>& SetErrorId(const String& value);  // Defined below

        InstallabilityErrorBuilder<STATE | ErrorArgumentsSet>& SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value);  // Defined below

        std::unique_ptr<InstallabilityError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityError;
        InstallabilityErrorBuilder() : m_result(new InstallabilityError()) { }

        template<int STEP> InstallabilityErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityError> m_result;
    };

    static InstallabilityErrorBuilder<0> Create()
    {
        return InstallabilityErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityError();  // Defined below

    String m_errorId;
    std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> m_errorArguments;
};


class CONTENT_EXPORT FileFilter : public ::crdtp::ProtocolObject<FileFilter> {
public:
    ~FileFilter() override;  // Defined below

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value);  // Defined below

    bool HasAccepts() { return !!m_accepts; }
    protocol::Array<String>* GetAccepts(protocol::Array<String>* defaultValue) {
       return m_accepts ? m_accepts.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetAccepts() const {
       return m_accepts;
    }
    void SetAccepts(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class FileFilterBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FileFilterBuilder<STATE>& SetName(const String& value);  // Defined below

        FileFilterBuilder<STATE>& SetAccepts(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<FileFilter> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FileFilter;
        FileFilterBuilder() : m_result(new FileFilter()) { }

        template<int STEP> FileFilterBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FileFilterBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FileFilter> m_result;
    };

    static FileFilterBuilder<0> Create()
    {
        return FileFilterBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FileFilter();  // Defined below

    std::optional<String> m_name;
    std::unique_ptr<protocol::Array<String>> m_accepts;
};


class CONTENT_EXPORT FileHandler : public ::crdtp::ProtocolObject<FileHandler> {
public:
    ~FileHandler() override;  // Defined below

    String GetAction() { return m_action; }
    void SetAction(const String& value);  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    bool HasIcons() { return !!m_icons; }
    protocol::Array<protocol::Page::ImageResource>* GetIcons(protocol::Array<protocol::Page::ImageResource>* defaultValue) {
       return m_icons ? m_icons.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::ImageResource>>& GetIcons() const {
       return m_icons;
    }
    void SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value);  // Defined below

    bool HasAccepts() { return !!m_accepts; }
    protocol::Array<protocol::Page::FileFilter>* GetAccepts(protocol::Array<protocol::Page::FileFilter>* defaultValue) {
       return m_accepts ? m_accepts.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::FileFilter>>& GetAccepts() const {
       return m_accepts;
    }
    void SetAccepts(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value);  // Defined below

    String GetLaunchType() { return m_launchType; }
    void SetLaunchType(const String& value);  // Defined below

    template<int STATE>
    class FileHandlerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ActionSet = 1 << 1,
            NameSet = 1 << 2,
            LaunchTypeSet = 1 << 3,
            AllFieldsSet = (ActionSet | NameSet | LaunchTypeSet | 0)};


        FileHandlerBuilder<STATE | ActionSet>& SetAction(const String& value);  // Defined below

        FileHandlerBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        FileHandlerBuilder<STATE>& SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value);  // Defined below

        FileHandlerBuilder<STATE>& SetAccepts(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value);  // Defined below

        FileHandlerBuilder<STATE | LaunchTypeSet>& SetLaunchType(const String& value);  // Defined below

        std::unique_ptr<FileHandler> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FileHandler;
        FileHandlerBuilder() : m_result(new FileHandler()) { }

        template<int STEP> FileHandlerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FileHandlerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FileHandler> m_result;
    };

    static FileHandlerBuilder<0> Create()
    {
        return FileHandlerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FileHandler();  // Defined below

    String m_action;
    String m_name;
    std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> m_icons;
    std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> m_accepts;
    String m_launchType;
};


class CONTENT_EXPORT ImageResource : public ::crdtp::ProtocolObject<ImageResource> {
public:
    ~ImageResource() override;  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    bool HasSizes() { return !!m_sizes; }
    String GetSizes(const String& defaultValue) const {
       return m_sizes.value_or(defaultValue);
    }
    const std::optional<String>& GetSizes() const {
       return m_sizes;
    }
    void SetSizes(const String& value);  // Defined below

    bool HasType() { return !!m_type; }
    String GetType(const String& defaultValue) const {
       return m_type.value_or(defaultValue);
    }
    const std::optional<String>& GetType() const {
       return m_type;
    }
    void SetType(const String& value);  // Defined below

    template<int STATE>
    class ImageResourceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        ImageResourceBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        ImageResourceBuilder<STATE>& SetSizes(const String& value);  // Defined below

        ImageResourceBuilder<STATE>& SetType(const String& value);  // Defined below

        std::unique_ptr<ImageResource> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ImageResource;
        ImageResourceBuilder() : m_result(new ImageResource()) { }

        template<int STEP> ImageResourceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ImageResourceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ImageResource> m_result;
    };

    static ImageResourceBuilder<0> Create()
    {
        return ImageResourceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ImageResource();  // Defined below

    String m_url;
    std::optional<String> m_sizes;
    std::optional<String> m_type;
};


class CONTENT_EXPORT LaunchHandler : public ::crdtp::ProtocolObject<LaunchHandler> {
public:
    ~LaunchHandler() override;  // Defined below

    String GetClientMode() { return m_clientMode; }
    void SetClientMode(const String& value);  // Defined below

    template<int STATE>
    class LaunchHandlerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ClientModeSet = 1 << 1,
            AllFieldsSet = (ClientModeSet | 0)};


        LaunchHandlerBuilder<STATE | ClientModeSet>& SetClientMode(const String& value);  // Defined below

        std::unique_ptr<LaunchHandler> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LaunchHandler;
        LaunchHandlerBuilder() : m_result(new LaunchHandler()) { }

        template<int STEP> LaunchHandlerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LaunchHandlerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::LaunchHandler> m_result;
    };

    static LaunchHandlerBuilder<0> Create()
    {
        return LaunchHandlerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LaunchHandler();  // Defined below

    String m_clientMode;
};


class CONTENT_EXPORT ProtocolHandler : public ::crdtp::ProtocolObject<ProtocolHandler> {
public:
    ~ProtocolHandler() override;  // Defined below

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    template<int STATE>
    class ProtocolHandlerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            UrlSet = 1 << 2,
            AllFieldsSet = (ProtocolSet | UrlSet | 0)};


        ProtocolHandlerBuilder<STATE | ProtocolSet>& SetProtocol(const String& value);  // Defined below

        ProtocolHandlerBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        std::unique_ptr<ProtocolHandler> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ProtocolHandler;
        ProtocolHandlerBuilder() : m_result(new ProtocolHandler()) { }

        template<int STEP> ProtocolHandlerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ProtocolHandlerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ProtocolHandler> m_result;
    };

    static ProtocolHandlerBuilder<0> Create()
    {
        return ProtocolHandlerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ProtocolHandler();  // Defined below

    String m_protocol;
    String m_url;
};


class CONTENT_EXPORT RelatedApplication : public ::crdtp::ProtocolObject<RelatedApplication> {
public:
    ~RelatedApplication() override;  // Defined below

    bool HasId() { return !!m_id; }
    String GetId(const String& defaultValue) const {
       return m_id.value_or(defaultValue);
    }
    const std::optional<String>& GetId() const {
       return m_id;
    }
    void SetId(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    template<int STATE>
    class RelatedApplicationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        RelatedApplicationBuilder<STATE>& SetId(const String& value);  // Defined below

        RelatedApplicationBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        std::unique_ptr<RelatedApplication> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RelatedApplication;
        RelatedApplicationBuilder() : m_result(new RelatedApplication()) { }

        template<int STEP> RelatedApplicationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RelatedApplicationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::RelatedApplication> m_result;
    };

    static RelatedApplicationBuilder<0> Create()
    {
        return RelatedApplicationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RelatedApplication();  // Defined below

    std::optional<String> m_id;
    String m_url;
};


class CONTENT_EXPORT ScopeExtension : public ::crdtp::ProtocolObject<ScopeExtension> {
public:
    ~ScopeExtension() override;  // Defined below

    String GetOrigin() { return m_origin; }
    void SetOrigin(const String& value);  // Defined below

    bool GetHasOriginWildcard() { return m_hasOriginWildcard; }
    void SetHasOriginWildcard(bool value);  // Defined below

    template<int STATE>
    class ScopeExtensionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            HasOriginWildcardSet = 1 << 2,
            AllFieldsSet = (OriginSet | HasOriginWildcardSet | 0)};


        ScopeExtensionBuilder<STATE | OriginSet>& SetOrigin(const String& value);  // Defined below

        ScopeExtensionBuilder<STATE | HasOriginWildcardSet>& SetHasOriginWildcard(bool value);  // Defined below

        std::unique_ptr<ScopeExtension> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScopeExtension;
        ScopeExtensionBuilder() : m_result(new ScopeExtension()) { }

        template<int STEP> ScopeExtensionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScopeExtensionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ScopeExtension> m_result;
    };

    static ScopeExtensionBuilder<0> Create()
    {
        return ScopeExtensionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScopeExtension();  // Defined below

    String m_origin;
    bool m_hasOriginWildcard;
};


class CONTENT_EXPORT Screenshot : public ::crdtp::ProtocolObject<Screenshot> {
public:
    ~Screenshot() override;  // Defined below

    protocol::Page::ImageResource* GetImage() { return m_image.get(); }
    void SetImage(std::unique_ptr<protocol::Page::ImageResource> value);  // Defined below

    String GetFormFactor() { return m_formFactor; }
    void SetFormFactor(const String& value);  // Defined below

    bool HasLabel() { return !!m_label; }
    String GetLabel(const String& defaultValue) const {
       return m_label.value_or(defaultValue);
    }
    const std::optional<String>& GetLabel() const {
       return m_label;
    }
    void SetLabel(const String& value);  // Defined below

    template<int STATE>
    class ScreenshotBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ImageSet = 1 << 1,
            FormFactorSet = 1 << 2,
            AllFieldsSet = (ImageSet | FormFactorSet | 0)};


        ScreenshotBuilder<STATE | ImageSet>& SetImage(std::unique_ptr<protocol::Page::ImageResource> value);  // Defined below

        ScreenshotBuilder<STATE | FormFactorSet>& SetFormFactor(const String& value);  // Defined below

        ScreenshotBuilder<STATE>& SetLabel(const String& value);  // Defined below

        std::unique_ptr<Screenshot> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Screenshot;
        ScreenshotBuilder() : m_result(new Screenshot()) { }

        template<int STEP> ScreenshotBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenshotBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Screenshot> m_result;
    };

    static ScreenshotBuilder<0> Create()
    {
        return ScreenshotBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Screenshot();  // Defined below

    std::unique_ptr<protocol::Page::ImageResource> m_image;
    String m_formFactor;
    std::optional<String> m_label;
};


class CONTENT_EXPORT ShareTarget : public ::crdtp::ProtocolObject<ShareTarget> {
public:
    ~ShareTarget() override;  // Defined below

    String GetAction() { return m_action; }
    void SetAction(const String& value);  // Defined below

    String GetMethod() { return m_method; }
    void SetMethod(const String& value);  // Defined below

    String GetEnctype() { return m_enctype; }
    void SetEnctype(const String& value);  // Defined below

    bool HasTitle() { return !!m_title; }
    String GetTitle(const String& defaultValue) const {
       return m_title.value_or(defaultValue);
    }
    const std::optional<String>& GetTitle() const {
       return m_title;
    }
    void SetTitle(const String& value);  // Defined below

    bool HasText() { return !!m_text; }
    String GetText(const String& defaultValue) const {
       return m_text.value_or(defaultValue);
    }
    const std::optional<String>& GetText() const {
       return m_text;
    }
    void SetText(const String& value);  // Defined below

    bool HasUrl() { return !!m_url; }
    String GetUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& GetUrl() const {
       return m_url;
    }
    void SetUrl(const String& value);  // Defined below

    bool HasFiles() { return !!m_files; }
    protocol::Array<protocol::Page::FileFilter>* GetFiles(protocol::Array<protocol::Page::FileFilter>* defaultValue) {
       return m_files ? m_files.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::FileFilter>>& GetFiles() const {
       return m_files;
    }
    void SetFiles(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value);  // Defined below

    template<int STATE>
    class ShareTargetBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ActionSet = 1 << 1,
            MethodSet = 1 << 2,
            EnctypeSet = 1 << 3,
            AllFieldsSet = (ActionSet | MethodSet | EnctypeSet | 0)};


        ShareTargetBuilder<STATE | ActionSet>& SetAction(const String& value);  // Defined below

        ShareTargetBuilder<STATE | MethodSet>& SetMethod(const String& value);  // Defined below

        ShareTargetBuilder<STATE | EnctypeSet>& SetEnctype(const String& value);  // Defined below

        ShareTargetBuilder<STATE>& SetTitle(const String& value);  // Defined below

        ShareTargetBuilder<STATE>& SetText(const String& value);  // Defined below

        ShareTargetBuilder<STATE>& SetUrl(const String& value);  // Defined below

        ShareTargetBuilder<STATE>& SetFiles(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value);  // Defined below

        std::unique_ptr<ShareTarget> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ShareTarget;
        ShareTargetBuilder() : m_result(new ShareTarget()) { }

        template<int STEP> ShareTargetBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ShareTargetBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ShareTarget> m_result;
    };

    static ShareTargetBuilder<0> Create()
    {
        return ShareTargetBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ShareTarget();  // Defined below

    String m_action;
    String m_method;
    String m_enctype;
    std::optional<String> m_title;
    std::optional<String> m_text;
    std::optional<String> m_url;
    std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> m_files;
};


class CONTENT_EXPORT Shortcut : public ::crdtp::ProtocolObject<Shortcut> {
public:
    ~Shortcut() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    template<int STATE>
    class ShortcutBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            UrlSet = 1 << 2,
            AllFieldsSet = (NameSet | UrlSet | 0)};


        ShortcutBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        ShortcutBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        std::unique_ptr<Shortcut> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Shortcut;
        ShortcutBuilder() : m_result(new Shortcut()) { }

        template<int STEP> ShortcutBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ShortcutBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Shortcut> m_result;
    };

    static ShortcutBuilder<0> Create()
    {
        return ShortcutBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Shortcut();  // Defined below

    String m_name;
    String m_url;
};


class CONTENT_EXPORT WebAppManifest : public ::crdtp::ProtocolObject<WebAppManifest> {
public:
    ~WebAppManifest() override;  // Defined below

    bool HasBackgroundColor() { return !!m_backgroundColor; }
    String GetBackgroundColor(const String& defaultValue) const {
       return m_backgroundColor.value_or(defaultValue);
    }
    const std::optional<String>& GetBackgroundColor() const {
       return m_backgroundColor;
    }
    void SetBackgroundColor(const String& value);  // Defined below

    bool HasDescription() { return !!m_description; }
    String GetDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& GetDescription() const {
       return m_description;
    }
    void SetDescription(const String& value);  // Defined below

    bool HasDir() { return !!m_dir; }
    String GetDir(const String& defaultValue) const {
       return m_dir.value_or(defaultValue);
    }
    const std::optional<String>& GetDir() const {
       return m_dir;
    }
    void SetDir(const String& value);  // Defined below

    bool HasDisplay() { return !!m_display; }
    String GetDisplay(const String& defaultValue) const {
       return m_display.value_or(defaultValue);
    }
    const std::optional<String>& GetDisplay() const {
       return m_display;
    }
    void SetDisplay(const String& value);  // Defined below

    bool HasDisplayOverrides() { return !!m_displayOverrides; }
    protocol::Array<String>* GetDisplayOverrides(protocol::Array<String>* defaultValue) {
       return m_displayOverrides ? m_displayOverrides.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetDisplayOverrides() const {
       return m_displayOverrides;
    }
    void SetDisplayOverrides(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    bool HasFileHandlers() { return !!m_fileHandlers; }
    protocol::Array<protocol::Page::FileHandler>* GetFileHandlers(protocol::Array<protocol::Page::FileHandler>* defaultValue) {
       return m_fileHandlers ? m_fileHandlers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::FileHandler>>& GetFileHandlers() const {
       return m_fileHandlers;
    }
    void SetFileHandlers(std::unique_ptr<protocol::Array<protocol::Page::FileHandler>> value);  // Defined below

    bool HasIcons() { return !!m_icons; }
    protocol::Array<protocol::Page::ImageResource>* GetIcons(protocol::Array<protocol::Page::ImageResource>* defaultValue) {
       return m_icons ? m_icons.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::ImageResource>>& GetIcons() const {
       return m_icons;
    }
    void SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value);  // Defined below

    bool HasId() { return !!m_id; }
    String GetId(const String& defaultValue) const {
       return m_id.value_or(defaultValue);
    }
    const std::optional<String>& GetId() const {
       return m_id;
    }
    void SetId(const String& value);  // Defined below

    bool HasLang() { return !!m_lang; }
    String GetLang(const String& defaultValue) const {
       return m_lang.value_or(defaultValue);
    }
    const std::optional<String>& GetLang() const {
       return m_lang;
    }
    void SetLang(const String& value);  // Defined below

    bool HasLaunchHandler() { return !!m_launchHandler; }
    protocol::Page::LaunchHandler* GetLaunchHandler(protocol::Page::LaunchHandler* defaultValue) {
       return m_launchHandler ? m_launchHandler.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::LaunchHandler>& GetLaunchHandler() const {
       return m_launchHandler;
    }
    void SetLaunchHandler(std::unique_ptr<protocol::Page::LaunchHandler> value);  // Defined below

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value);  // Defined below

    bool HasOrientation() { return !!m_orientation; }
    String GetOrientation(const String& defaultValue) const {
       return m_orientation.value_or(defaultValue);
    }
    const std::optional<String>& GetOrientation() const {
       return m_orientation;
    }
    void SetOrientation(const String& value);  // Defined below

    bool HasPreferRelatedApplications() { return !!m_preferRelatedApplications; }
    bool GetPreferRelatedApplications(bool defaultValue) const {
       return m_preferRelatedApplications.value_or(defaultValue);
    }
    const std::optional<bool>& GetPreferRelatedApplications() const {
       return m_preferRelatedApplications;
    }
    void SetPreferRelatedApplications(bool value);  // Defined below

    bool HasProtocolHandlers() { return !!m_protocolHandlers; }
    protocol::Array<protocol::Page::ProtocolHandler>* GetProtocolHandlers(protocol::Array<protocol::Page::ProtocolHandler>* defaultValue) {
       return m_protocolHandlers ? m_protocolHandlers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>>& GetProtocolHandlers() const {
       return m_protocolHandlers;
    }
    void SetProtocolHandlers(std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>> value);  // Defined below

    bool HasRelatedApplications() { return !!m_relatedApplications; }
    protocol::Array<protocol::Page::RelatedApplication>* GetRelatedApplications(protocol::Array<protocol::Page::RelatedApplication>* defaultValue) {
       return m_relatedApplications ? m_relatedApplications.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>>& GetRelatedApplications() const {
       return m_relatedApplications;
    }
    void SetRelatedApplications(std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>> value);  // Defined below

    bool HasScope() { return !!m_scope; }
    String GetScope(const String& defaultValue) const {
       return m_scope.value_or(defaultValue);
    }
    const std::optional<String>& GetScope() const {
       return m_scope;
    }
    void SetScope(const String& value);  // Defined below

    bool HasScopeExtensions() { return !!m_scopeExtensions; }
    protocol::Array<protocol::Page::ScopeExtension>* GetScopeExtensions(protocol::Array<protocol::Page::ScopeExtension>* defaultValue) {
       return m_scopeExtensions ? m_scopeExtensions.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>>& GetScopeExtensions() const {
       return m_scopeExtensions;
    }
    void SetScopeExtensions(std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>> value);  // Defined below

    bool HasScreenshots() { return !!m_screenshots; }
    protocol::Array<protocol::Page::Screenshot>* GetScreenshots(protocol::Array<protocol::Page::Screenshot>* defaultValue) {
       return m_screenshots ? m_screenshots.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::Screenshot>>& GetScreenshots() const {
       return m_screenshots;
    }
    void SetScreenshots(std::unique_ptr<protocol::Array<protocol::Page::Screenshot>> value);  // Defined below

    bool HasShareTarget() { return !!m_shareTarget; }
    protocol::Page::ShareTarget* GetShareTarget(protocol::Page::ShareTarget* defaultValue) {
       return m_shareTarget ? m_shareTarget.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::ShareTarget>& GetShareTarget() const {
       return m_shareTarget;
    }
    void SetShareTarget(std::unique_ptr<protocol::Page::ShareTarget> value);  // Defined below

    bool HasShortName() { return !!m_shortName; }
    String GetShortName(const String& defaultValue) const {
       return m_shortName.value_or(defaultValue);
    }
    const std::optional<String>& GetShortName() const {
       return m_shortName;
    }
    void SetShortName(const String& value);  // Defined below

    bool HasShortcuts() { return !!m_shortcuts; }
    protocol::Array<protocol::Page::Shortcut>* GetShortcuts(protocol::Array<protocol::Page::Shortcut>* defaultValue) {
       return m_shortcuts ? m_shortcuts.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::Shortcut>>& GetShortcuts() const {
       return m_shortcuts;
    }
    void SetShortcuts(std::unique_ptr<protocol::Array<protocol::Page::Shortcut>> value);  // Defined below

    bool HasStartUrl() { return !!m_startUrl; }
    String GetStartUrl(const String& defaultValue) const {
       return m_startUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetStartUrl() const {
       return m_startUrl;
    }
    void SetStartUrl(const String& value);  // Defined below

    bool HasThemeColor() { return !!m_themeColor; }
    String GetThemeColor(const String& defaultValue) const {
       return m_themeColor.value_or(defaultValue);
    }
    const std::optional<String>& GetThemeColor() const {
       return m_themeColor;
    }
    void SetThemeColor(const String& value);  // Defined below

    template<int STATE>
    class WebAppManifestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        WebAppManifestBuilder<STATE>& SetBackgroundColor(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetDescription(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetDir(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetDisplay(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetDisplayOverrides(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetFileHandlers(std::unique_ptr<protocol::Array<protocol::Page::FileHandler>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetId(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetLang(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetLaunchHandler(std::unique_ptr<protocol::Page::LaunchHandler> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetName(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetOrientation(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetPreferRelatedApplications(bool value);  // Defined below

        WebAppManifestBuilder<STATE>& SetProtocolHandlers(std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetRelatedApplications(std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetScope(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetScopeExtensions(std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetScreenshots(std::unique_ptr<protocol::Array<protocol::Page::Screenshot>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetShareTarget(std::unique_ptr<protocol::Page::ShareTarget> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetShortName(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetShortcuts(std::unique_ptr<protocol::Array<protocol::Page::Shortcut>> value);  // Defined below

        WebAppManifestBuilder<STATE>& SetStartUrl(const String& value);  // Defined below

        WebAppManifestBuilder<STATE>& SetThemeColor(const String& value);  // Defined below

        std::unique_ptr<WebAppManifest> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WebAppManifest;
        WebAppManifestBuilder() : m_result(new WebAppManifest()) { }

        template<int STEP> WebAppManifestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WebAppManifestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::WebAppManifest> m_result;
    };

    static WebAppManifestBuilder<0> Create()
    {
        return WebAppManifestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WebAppManifest();  // Defined below

    std::optional<String> m_backgroundColor;
    std::optional<String> m_description;
    std::optional<String> m_dir;
    std::optional<String> m_display;
    std::unique_ptr<protocol::Array<String>> m_displayOverrides;
    std::unique_ptr<protocol::Array<protocol::Page::FileHandler>> m_fileHandlers;
    std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> m_icons;
    std::optional<String> m_id;
    std::optional<String> m_lang;
    std::unique_ptr<protocol::Page::LaunchHandler> m_launchHandler;
    std::optional<String> m_name;
    std::optional<String> m_orientation;
    std::optional<bool> m_preferRelatedApplications;
    std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>> m_protocolHandlers;
    std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>> m_relatedApplications;
    std::optional<String> m_scope;
    std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>> m_scopeExtensions;
    std::unique_ptr<protocol::Array<protocol::Page::Screenshot>> m_screenshots;
    std::unique_ptr<protocol::Page::ShareTarget> m_shareTarget;
    std::optional<String> m_shortName;
    std::unique_ptr<protocol::Array<protocol::Page::Shortcut>> m_shortcuts;
    std::optional<String> m_startUrl;
    std::optional<String> m_themeColor;
};


class CONTENT_EXPORT BackForwardCacheBlockingDetails : public ::crdtp::ProtocolObject<BackForwardCacheBlockingDetails> {
public:
    ~BackForwardCacheBlockingDetails() override;  // Defined below

    bool HasUrl() { return !!m_url; }
    String GetUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& GetUrl() const {
       return m_url;
    }
    void SetUrl(const String& value);  // Defined below

    bool HasFunction() { return !!m_function; }
    String GetFunction(const String& defaultValue) const {
       return m_function.value_or(defaultValue);
    }
    const std::optional<String>& GetFunction() const {
       return m_function;
    }
    void SetFunction(const String& value);  // Defined below

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value);  // Defined below

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value);  // Defined below

    template<int STATE>
    class BackForwardCacheBlockingDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LineNumberSet = 1 << 1,
            ColumnNumberSet = 1 << 2,
            AllFieldsSet = (LineNumberSet | ColumnNumberSet | 0)};


        BackForwardCacheBlockingDetailsBuilder<STATE>& SetUrl(const String& value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE>& SetFunction(const String& value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE | LineNumberSet>& SetLineNumber(int value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value);  // Defined below

        std::unique_ptr<BackForwardCacheBlockingDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheBlockingDetails;
        BackForwardCacheBlockingDetailsBuilder() : m_result(new BackForwardCacheBlockingDetails()) { }

        template<int STEP> BackForwardCacheBlockingDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheBlockingDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheBlockingDetails> m_result;
    };

    static BackForwardCacheBlockingDetailsBuilder<0> Create()
    {
        return BackForwardCacheBlockingDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheBlockingDetails();  // Defined below

    std::optional<String> m_url;
    std::optional<String> m_function;
    int m_lineNumber;
    int m_columnNumber;
};


class CONTENT_EXPORT BackForwardCacheNotRestoredExplanation : public ::crdtp::ProtocolObject<BackForwardCacheNotRestoredExplanation> {
public:
    ~BackForwardCacheNotRestoredExplanation() override;  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    String GetReason() { return m_reason; }
    void SetReason(const String& value);  // Defined below

    bool HasContext() { return !!m_context; }
    String GetContext(const String& defaultValue) const {
       return m_context.value_or(defaultValue);
    }
    const std::optional<String>& GetContext() const {
       return m_context;
    }
    void SetContext(const String& value);  // Defined below

    bool HasDetails() { return !!m_details; }
    protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>* GetDetails(protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>* defaultValue) {
       return m_details ? m_details.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>>& GetDetails() const {
       return m_details;
    }
    void SetDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value);  // Defined below

    template<int STATE>
    class BackForwardCacheNotRestoredExplanationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (TypeSet | ReasonSet | 0)};


        BackForwardCacheNotRestoredExplanationBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE | ReasonSet>& SetReason(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE>& SetContext(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE>& SetDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value);  // Defined below

        std::unique_ptr<BackForwardCacheNotRestoredExplanation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheNotRestoredExplanation;
        BackForwardCacheNotRestoredExplanationBuilder() : m_result(new BackForwardCacheNotRestoredExplanation()) { }

        template<int STEP> BackForwardCacheNotRestoredExplanationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheNotRestoredExplanationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanation> m_result;
    };

    static BackForwardCacheNotRestoredExplanationBuilder<0> Create()
    {
        return BackForwardCacheNotRestoredExplanationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheNotRestoredExplanation();  // Defined below

    String m_type;
    String m_reason;
    std::optional<String> m_context;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> m_details;
};


class CONTENT_EXPORT BackForwardCacheNotRestoredExplanationTree : public ::crdtp::ProtocolObject<BackForwardCacheNotRestoredExplanationTree> {
public:
    ~BackForwardCacheNotRestoredExplanationTree() override;  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>* GetExplanations() { return m_explanations.get(); }
    void SetExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value);  // Defined below

    protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>* GetChildren() { return m_children.get(); }
    void SetChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value);  // Defined below

    template<int STATE>
    class BackForwardCacheNotRestoredExplanationTreeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            ExplanationsSet = 1 << 2,
            ChildrenSet = 1 << 3,
            AllFieldsSet = (UrlSet | ExplanationsSet | ChildrenSet | 0)};


        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | ExplanationsSet>& SetExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value);  // Defined below

        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | ChildrenSet>& SetChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value);  // Defined below

        std::unique_ptr<BackForwardCacheNotRestoredExplanationTree> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheNotRestoredExplanationTree;
        BackForwardCacheNotRestoredExplanationTreeBuilder() : m_result(new BackForwardCacheNotRestoredExplanationTree()) { }

        template<int STEP> BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> m_result;
    };

    static BackForwardCacheNotRestoredExplanationTreeBuilder<0> Create()
    {
        return BackForwardCacheNotRestoredExplanationTreeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheNotRestoredExplanationTree();  // Defined below

    String m_url;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> m_explanations;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> m_children;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline NavigationEntry::~NavigationEntry() = default;
inline void NavigationEntry::SetId(int value) { m_id = value; }
inline void NavigationEntry::SetUrl(const String& value) { m_url = value; }
inline void NavigationEntry::SetUserTypedURL(const String& value) { m_userTypedURL = value; }
inline void NavigationEntry::SetTitle(const String& value) { m_title = value; }
inline void NavigationEntry::SetTransitionType(const String& value) { m_transitionType = value; }

template<int STATE>
inline NavigationEntry::NavigationEntryBuilder<STATE | NavigationEntry::NavigationEntryBuilder<STATE>::IdSet>&
NavigationEntry::NavigationEntryBuilder<STATE>::SetId(int value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}
template<int STATE>
inline NavigationEntry::NavigationEntryBuilder<STATE | NavigationEntry::NavigationEntryBuilder<STATE>::UrlSet>&
NavigationEntry::NavigationEntryBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline NavigationEntry::NavigationEntryBuilder<STATE | NavigationEntry::NavigationEntryBuilder<STATE>::UserTypedURLSet>&
NavigationEntry::NavigationEntryBuilder<STATE>::SetUserTypedURL(const String& value) {
  static_assert(!(STATE & UserTypedURLSet), "property userTypedURL should not be set yet");
  m_result->SetUserTypedURL(value);
  return castState<UserTypedURLSet>();
}
template<int STATE>
inline NavigationEntry::NavigationEntryBuilder<STATE | NavigationEntry::NavigationEntryBuilder<STATE>::TitleSet>&
NavigationEntry::NavigationEntryBuilder<STATE>::SetTitle(const String& value) {
  static_assert(!(STATE & TitleSet), "property title should not be set yet");
  m_result->SetTitle(value);
  return castState<TitleSet>();
}
template<int STATE>
inline NavigationEntry::NavigationEntryBuilder<STATE | NavigationEntry::NavigationEntryBuilder<STATE>::TransitionTypeSet>&
NavigationEntry::NavigationEntryBuilder<STATE>::SetTransitionType(const String& value) {
  static_assert(!(STATE & TransitionTypeSet), "property transitionType should not be set yet");
  m_result->SetTransitionType(value);
  return castState<TransitionTypeSet>();
}

inline NavigationEntry::NavigationEntry() {
  m_id = 0;
}
inline ScreencastFrameMetadata::~ScreencastFrameMetadata() = default;
inline void ScreencastFrameMetadata::SetOffsetTop(double value) { m_offsetTop = value; }
inline void ScreencastFrameMetadata::SetPageScaleFactor(double value) { m_pageScaleFactor = value; }
inline void ScreencastFrameMetadata::SetDeviceWidth(double value) { m_deviceWidth = value; }
inline void ScreencastFrameMetadata::SetDeviceHeight(double value) { m_deviceHeight = value; }
inline void ScreencastFrameMetadata::SetScrollOffsetX(double value) { m_scrollOffsetX = value; }
inline void ScreencastFrameMetadata::SetScrollOffsetY(double value) { m_scrollOffsetY = value; }
inline void ScreencastFrameMetadata::SetTimestamp(double value) { m_timestamp = value; }

template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::OffsetTopSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetOffsetTop(double value) {
  static_assert(!(STATE & OffsetTopSet), "property offsetTop should not be set yet");
  m_result->SetOffsetTop(value);
  return castState<OffsetTopSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::PageScaleFactorSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetPageScaleFactor(double value) {
  static_assert(!(STATE & PageScaleFactorSet), "property pageScaleFactor should not be set yet");
  m_result->SetPageScaleFactor(value);
  return castState<PageScaleFactorSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::DeviceWidthSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetDeviceWidth(double value) {
  static_assert(!(STATE & DeviceWidthSet), "property deviceWidth should not be set yet");
  m_result->SetDeviceWidth(value);
  return castState<DeviceWidthSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::DeviceHeightSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetDeviceHeight(double value) {
  static_assert(!(STATE & DeviceHeightSet), "property deviceHeight should not be set yet");
  m_result->SetDeviceHeight(value);
  return castState<DeviceHeightSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::ScrollOffsetXSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetScrollOffsetX(double value) {
  static_assert(!(STATE & ScrollOffsetXSet), "property scrollOffsetX should not be set yet");
  m_result->SetScrollOffsetX(value);
  return castState<ScrollOffsetXSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE | ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::ScrollOffsetYSet>&
ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetScrollOffsetY(double value) {
  static_assert(!(STATE & ScrollOffsetYSet), "property scrollOffsetY should not be set yet");
  m_result->SetScrollOffsetY(value);
  return castState<ScrollOffsetYSet>();
}
template<int STATE>
inline ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>& ScreencastFrameMetadata::ScreencastFrameMetadataBuilder<STATE>::SetTimestamp(double value) {
  m_result->SetTimestamp(value);
  return *this;
}

inline ScreencastFrameMetadata::ScreencastFrameMetadata() {
  m_offsetTop = 0;
  m_pageScaleFactor = 0;
  m_deviceWidth = 0;
  m_deviceHeight = 0;
  m_scrollOffsetX = 0;
  m_scrollOffsetY = 0;
}
inline AppManifestError::~AppManifestError() = default;
inline void AppManifestError::SetMessage(const String& value) { m_message = value; }
inline void AppManifestError::SetCritical(int value) { m_critical = value; }
inline void AppManifestError::SetLine(int value) { m_line = value; }
inline void AppManifestError::SetColumn(int value) { m_column = value; }

template<int STATE>
inline AppManifestError::AppManifestErrorBuilder<STATE | AppManifestError::AppManifestErrorBuilder<STATE>::MessageSet>&
AppManifestError::AppManifestErrorBuilder<STATE>::SetMessage(const String& value) {
  static_assert(!(STATE & MessageSet), "property message should not be set yet");
  m_result->SetMessage(value);
  return castState<MessageSet>();
}
template<int STATE>
inline AppManifestError::AppManifestErrorBuilder<STATE | AppManifestError::AppManifestErrorBuilder<STATE>::CriticalSet>&
AppManifestError::AppManifestErrorBuilder<STATE>::SetCritical(int value) {
  static_assert(!(STATE & CriticalSet), "property critical should not be set yet");
  m_result->SetCritical(value);
  return castState<CriticalSet>();
}
template<int STATE>
inline AppManifestError::AppManifestErrorBuilder<STATE | AppManifestError::AppManifestErrorBuilder<STATE>::LineSet>&
AppManifestError::AppManifestErrorBuilder<STATE>::SetLine(int value) {
  static_assert(!(STATE & LineSet), "property line should not be set yet");
  m_result->SetLine(value);
  return castState<LineSet>();
}
template<int STATE>
inline AppManifestError::AppManifestErrorBuilder<STATE | AppManifestError::AppManifestErrorBuilder<STATE>::ColumnSet>&
AppManifestError::AppManifestErrorBuilder<STATE>::SetColumn(int value) {
  static_assert(!(STATE & ColumnSet), "property column should not be set yet");
  m_result->SetColumn(value);
  return castState<ColumnSet>();
}

inline AppManifestError::AppManifestError() {
  m_critical = 0;
  m_line = 0;
  m_column = 0;
}
inline AppManifestParsedProperties::~AppManifestParsedProperties() = default;
inline void AppManifestParsedProperties::SetScope(const String& value) { m_scope = value; }

template<int STATE>
inline AppManifestParsedProperties::AppManifestParsedPropertiesBuilder<STATE | AppManifestParsedProperties::AppManifestParsedPropertiesBuilder<STATE>::ScopeSet>&
AppManifestParsedProperties::AppManifestParsedPropertiesBuilder<STATE>::SetScope(const String& value) {
  static_assert(!(STATE & ScopeSet), "property scope should not be set yet");
  m_result->SetScope(value);
  return castState<ScopeSet>();
}

inline AppManifestParsedProperties::AppManifestParsedProperties() {
}
inline Viewport::~Viewport() = default;
inline void Viewport::SetX(double value) { m_x = value; }
inline void Viewport::SetY(double value) { m_y = value; }
inline void Viewport::SetWidth(double value) { m_width = value; }
inline void Viewport::SetHeight(double value) { m_height = value; }
inline void Viewport::SetScale(double value) { m_scale = value; }

template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::XSet>&
Viewport::ViewportBuilder<STATE>::SetX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->SetX(value);
  return castState<XSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::YSet>&
Viewport::ViewportBuilder<STATE>::SetY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->SetY(value);
  return castState<YSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::WidthSet>&
Viewport::ViewportBuilder<STATE>::SetWidth(double value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->SetWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::HeightSet>&
Viewport::ViewportBuilder<STATE>::SetHeight(double value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->SetHeight(value);
  return castState<HeightSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::ScaleSet>&
Viewport::ViewportBuilder<STATE>::SetScale(double value) {
  static_assert(!(STATE & ScaleSet), "property scale should not be set yet");
  m_result->SetScale(value);
  return castState<ScaleSet>();
}

inline Viewport::Viewport() {
  m_x = 0;
  m_y = 0;
  m_width = 0;
  m_height = 0;
  m_scale = 0;
}
inline InstallabilityErrorArgument::~InstallabilityErrorArgument() = default;
inline void InstallabilityErrorArgument::SetName(const String& value) { m_name = value; }
inline void InstallabilityErrorArgument::SetValue(const String& value) { m_value = value; }

template<int STATE>
inline InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE | InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE>::NameSet>&
InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE | InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE>::ValueSet>&
InstallabilityErrorArgument::InstallabilityErrorArgumentBuilder<STATE>::SetValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(value);
  return castState<ValueSet>();
}

inline InstallabilityErrorArgument::InstallabilityErrorArgument() {
}
inline InstallabilityError::~InstallabilityError() = default;
inline void InstallabilityError::SetErrorId(const String& value) { m_errorId = value; }
inline void InstallabilityError::SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value) { m_errorArguments = std::move(value); }

template<int STATE>
inline InstallabilityError::InstallabilityErrorBuilder<STATE | InstallabilityError::InstallabilityErrorBuilder<STATE>::ErrorIdSet>&
InstallabilityError::InstallabilityErrorBuilder<STATE>::SetErrorId(const String& value) {
  static_assert(!(STATE & ErrorIdSet), "property errorId should not be set yet");
  m_result->SetErrorId(value);
  return castState<ErrorIdSet>();
}
template<int STATE>
inline InstallabilityError::InstallabilityErrorBuilder<STATE | InstallabilityError::InstallabilityErrorBuilder<STATE>::ErrorArgumentsSet>&
InstallabilityError::InstallabilityErrorBuilder<STATE>::SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value) {
  static_assert(!(STATE & ErrorArgumentsSet), "property errorArguments should not be set yet");
  m_result->SetErrorArguments(std::move(value));
  return castState<ErrorArgumentsSet>();
}

inline InstallabilityError::InstallabilityError() {
}
inline FileFilter::~FileFilter() = default;
inline void FileFilter::SetName(const String& value) { m_name = value; }
inline void FileFilter::SetAccepts(std::unique_ptr<protocol::Array<String>> value) { m_accepts = std::move(value); }

template<int STATE>
inline FileFilter::FileFilterBuilder<STATE>& FileFilter::FileFilterBuilder<STATE>::SetName(const String& value) {
  m_result->SetName(value);
  return *this;
}
template<int STATE>
inline FileFilter::FileFilterBuilder<STATE>& FileFilter::FileFilterBuilder<STATE>::SetAccepts(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetAccepts(std::move(value));
  return *this;
}

inline FileFilter::FileFilter() {
}
inline FileHandler::~FileHandler() = default;
inline void FileHandler::SetAction(const String& value) { m_action = value; }
inline void FileHandler::SetName(const String& value) { m_name = value; }
inline void FileHandler::SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value) { m_icons = std::move(value); }
inline void FileHandler::SetAccepts(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value) { m_accepts = std::move(value); }
inline void FileHandler::SetLaunchType(const String& value) { m_launchType = value; }

template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::ActionSet>&
FileHandler::FileHandlerBuilder<STATE>::SetAction(const String& value) {
  static_assert(!(STATE & ActionSet), "property action should not be set yet");
  m_result->SetAction(value);
  return castState<ActionSet>();
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::NameSet>&
FileHandler::FileHandlerBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE>& FileHandler::FileHandlerBuilder<STATE>::SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value) {
  m_result->SetIcons(std::move(value));
  return *this;
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE>& FileHandler::FileHandlerBuilder<STATE>::SetAccepts(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value) {
  m_result->SetAccepts(std::move(value));
  return *this;
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::LaunchTypeSet>&
FileHandler::FileHandlerBuilder<STATE>::SetLaunchType(const String& value) {
  static_assert(!(STATE & LaunchTypeSet), "property launchType should not be set yet");
  m_result->SetLaunchType(value);
  return castState<LaunchTypeSet>();
}

inline FileHandler::FileHandler() {
}
inline ImageResource::~ImageResource() = default;
inline void ImageResource::SetUrl(const String& value) { m_url = value; }
inline void ImageResource::SetSizes(const String& value) { m_sizes = value; }
inline void ImageResource::SetType(const String& value) { m_type = value; }

template<int STATE>
inline ImageResource::ImageResourceBuilder<STATE | ImageResource::ImageResourceBuilder<STATE>::UrlSet>&
ImageResource::ImageResourceBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline ImageResource::ImageResourceBuilder<STATE>& ImageResource::ImageResourceBuilder<STATE>::SetSizes(const String& value) {
  m_result->SetSizes(value);
  return *this;
}
template<int STATE>
inline ImageResource::ImageResourceBuilder<STATE>& ImageResource::ImageResourceBuilder<STATE>::SetType(const String& value) {
  m_result->SetType(value);
  return *this;
}

inline ImageResource::ImageResource() {
}
inline LaunchHandler::~LaunchHandler() = default;
inline void LaunchHandler::SetClientMode(const String& value) { m_clientMode = value; }

template<int STATE>
inline LaunchHandler::LaunchHandlerBuilder<STATE | LaunchHandler::LaunchHandlerBuilder<STATE>::ClientModeSet>&
LaunchHandler::LaunchHandlerBuilder<STATE>::SetClientMode(const String& value) {
  static_assert(!(STATE & ClientModeSet), "property clientMode should not be set yet");
  m_result->SetClientMode(value);
  return castState<ClientModeSet>();
}

inline LaunchHandler::LaunchHandler() {
}
inline ProtocolHandler::~ProtocolHandler() = default;
inline void ProtocolHandler::SetProtocol(const String& value) { m_protocol = value; }
inline void ProtocolHandler::SetUrl(const String& value) { m_url = value; }

template<int STATE>
inline ProtocolHandler::ProtocolHandlerBuilder<STATE | ProtocolHandler::ProtocolHandlerBuilder<STATE>::ProtocolSet>&
ProtocolHandler::ProtocolHandlerBuilder<STATE>::SetProtocol(const String& value) {
  static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
  m_result->SetProtocol(value);
  return castState<ProtocolSet>();
}
template<int STATE>
inline ProtocolHandler::ProtocolHandlerBuilder<STATE | ProtocolHandler::ProtocolHandlerBuilder<STATE>::UrlSet>&
ProtocolHandler::ProtocolHandlerBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}

inline ProtocolHandler::ProtocolHandler() {
}
inline RelatedApplication::~RelatedApplication() = default;
inline void RelatedApplication::SetId(const String& value) { m_id = value; }
inline void RelatedApplication::SetUrl(const String& value) { m_url = value; }

template<int STATE>
inline RelatedApplication::RelatedApplicationBuilder<STATE>& RelatedApplication::RelatedApplicationBuilder<STATE>::SetId(const String& value) {
  m_result->SetId(value);
  return *this;
}
template<int STATE>
inline RelatedApplication::RelatedApplicationBuilder<STATE | RelatedApplication::RelatedApplicationBuilder<STATE>::UrlSet>&
RelatedApplication::RelatedApplicationBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}

inline RelatedApplication::RelatedApplication() {
}
inline ScopeExtension::~ScopeExtension() = default;
inline void ScopeExtension::SetOrigin(const String& value) { m_origin = value; }
inline void ScopeExtension::SetHasOriginWildcard(bool value) { m_hasOriginWildcard = value; }

template<int STATE>
inline ScopeExtension::ScopeExtensionBuilder<STATE | ScopeExtension::ScopeExtensionBuilder<STATE>::OriginSet>&
ScopeExtension::ScopeExtensionBuilder<STATE>::SetOrigin(const String& value) {
  static_assert(!(STATE & OriginSet), "property origin should not be set yet");
  m_result->SetOrigin(value);
  return castState<OriginSet>();
}
template<int STATE>
inline ScopeExtension::ScopeExtensionBuilder<STATE | ScopeExtension::ScopeExtensionBuilder<STATE>::HasOriginWildcardSet>&
ScopeExtension::ScopeExtensionBuilder<STATE>::SetHasOriginWildcard(bool value) {
  static_assert(!(STATE & HasOriginWildcardSet), "property hasOriginWildcard should not be set yet");
  m_result->SetHasOriginWildcard(value);
  return castState<HasOriginWildcardSet>();
}

inline ScopeExtension::ScopeExtension() {
  m_hasOriginWildcard = false;
}
inline Screenshot::~Screenshot() = default;
inline void Screenshot::SetImage(std::unique_ptr<protocol::Page::ImageResource> value) { m_image = std::move(value); }
inline void Screenshot::SetFormFactor(const String& value) { m_formFactor = value; }
inline void Screenshot::SetLabel(const String& value) { m_label = value; }

template<int STATE>
inline Screenshot::ScreenshotBuilder<STATE | Screenshot::ScreenshotBuilder<STATE>::ImageSet>&
Screenshot::ScreenshotBuilder<STATE>::SetImage(std::unique_ptr<protocol::Page::ImageResource> value) {
  static_assert(!(STATE & ImageSet), "property image should not be set yet");
  m_result->SetImage(std::move(value));
  return castState<ImageSet>();
}
template<int STATE>
inline Screenshot::ScreenshotBuilder<STATE | Screenshot::ScreenshotBuilder<STATE>::FormFactorSet>&
Screenshot::ScreenshotBuilder<STATE>::SetFormFactor(const String& value) {
  static_assert(!(STATE & FormFactorSet), "property formFactor should not be set yet");
  m_result->SetFormFactor(value);
  return castState<FormFactorSet>();
}
template<int STATE>
inline Screenshot::ScreenshotBuilder<STATE>& Screenshot::ScreenshotBuilder<STATE>::SetLabel(const String& value) {
  m_result->SetLabel(value);
  return *this;
}

inline Screenshot::Screenshot() {
}
inline ShareTarget::~ShareTarget() = default;
inline void ShareTarget::SetAction(const String& value) { m_action = value; }
inline void ShareTarget::SetMethod(const String& value) { m_method = value; }
inline void ShareTarget::SetEnctype(const String& value) { m_enctype = value; }
inline void ShareTarget::SetTitle(const String& value) { m_title = value; }
inline void ShareTarget::SetText(const String& value) { m_text = value; }
inline void ShareTarget::SetUrl(const String& value) { m_url = value; }
inline void ShareTarget::SetFiles(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value) { m_files = std::move(value); }

template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE | ShareTarget::ShareTargetBuilder<STATE>::ActionSet>&
ShareTarget::ShareTargetBuilder<STATE>::SetAction(const String& value) {
  static_assert(!(STATE & ActionSet), "property action should not be set yet");
  m_result->SetAction(value);
  return castState<ActionSet>();
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE | ShareTarget::ShareTargetBuilder<STATE>::MethodSet>&
ShareTarget::ShareTargetBuilder<STATE>::SetMethod(const String& value) {
  static_assert(!(STATE & MethodSet), "property method should not be set yet");
  m_result->SetMethod(value);
  return castState<MethodSet>();
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE | ShareTarget::ShareTargetBuilder<STATE>::EnctypeSet>&
ShareTarget::ShareTargetBuilder<STATE>::SetEnctype(const String& value) {
  static_assert(!(STATE & EnctypeSet), "property enctype should not be set yet");
  m_result->SetEnctype(value);
  return castState<EnctypeSet>();
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE>& ShareTarget::ShareTargetBuilder<STATE>::SetTitle(const String& value) {
  m_result->SetTitle(value);
  return *this;
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE>& ShareTarget::ShareTargetBuilder<STATE>::SetText(const String& value) {
  m_result->SetText(value);
  return *this;
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE>& ShareTarget::ShareTargetBuilder<STATE>::SetUrl(const String& value) {
  m_result->SetUrl(value);
  return *this;
}
template<int STATE>
inline ShareTarget::ShareTargetBuilder<STATE>& ShareTarget::ShareTargetBuilder<STATE>::SetFiles(std::unique_ptr<protocol::Array<protocol::Page::FileFilter>> value) {
  m_result->SetFiles(std::move(value));
  return *this;
}

inline ShareTarget::ShareTarget() {
}
inline Shortcut::~Shortcut() = default;
inline void Shortcut::SetName(const String& value) { m_name = value; }
inline void Shortcut::SetUrl(const String& value) { m_url = value; }

template<int STATE>
inline Shortcut::ShortcutBuilder<STATE | Shortcut::ShortcutBuilder<STATE>::NameSet>&
Shortcut::ShortcutBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Shortcut::ShortcutBuilder<STATE | Shortcut::ShortcutBuilder<STATE>::UrlSet>&
Shortcut::ShortcutBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}

inline Shortcut::Shortcut() {
}
inline WebAppManifest::~WebAppManifest() = default;
inline void WebAppManifest::SetBackgroundColor(const String& value) { m_backgroundColor = value; }
inline void WebAppManifest::SetDescription(const String& value) { m_description = value; }
inline void WebAppManifest::SetDir(const String& value) { m_dir = value; }
inline void WebAppManifest::SetDisplay(const String& value) { m_display = value; }
inline void WebAppManifest::SetDisplayOverrides(std::unique_ptr<protocol::Array<String>> value) { m_displayOverrides = std::move(value); }
inline void WebAppManifest::SetFileHandlers(std::unique_ptr<protocol::Array<protocol::Page::FileHandler>> value) { m_fileHandlers = std::move(value); }
inline void WebAppManifest::SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value) { m_icons = std::move(value); }
inline void WebAppManifest::SetId(const String& value) { m_id = value; }
inline void WebAppManifest::SetLang(const String& value) { m_lang = value; }
inline void WebAppManifest::SetLaunchHandler(std::unique_ptr<protocol::Page::LaunchHandler> value) { m_launchHandler = std::move(value); }
inline void WebAppManifest::SetName(const String& value) { m_name = value; }
inline void WebAppManifest::SetOrientation(const String& value) { m_orientation = value; }
inline void WebAppManifest::SetPreferRelatedApplications(bool value) { m_preferRelatedApplications = value; }
inline void WebAppManifest::SetProtocolHandlers(std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>> value) { m_protocolHandlers = std::move(value); }
inline void WebAppManifest::SetRelatedApplications(std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>> value) { m_relatedApplications = std::move(value); }
inline void WebAppManifest::SetScope(const String& value) { m_scope = value; }
inline void WebAppManifest::SetScopeExtensions(std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>> value) { m_scopeExtensions = std::move(value); }
inline void WebAppManifest::SetScreenshots(std::unique_ptr<protocol::Array<protocol::Page::Screenshot>> value) { m_screenshots = std::move(value); }
inline void WebAppManifest::SetShareTarget(std::unique_ptr<protocol::Page::ShareTarget> value) { m_shareTarget = std::move(value); }
inline void WebAppManifest::SetShortName(const String& value) { m_shortName = value; }
inline void WebAppManifest::SetShortcuts(std::unique_ptr<protocol::Array<protocol::Page::Shortcut>> value) { m_shortcuts = std::move(value); }
inline void WebAppManifest::SetStartUrl(const String& value) { m_startUrl = value; }
inline void WebAppManifest::SetThemeColor(const String& value) { m_themeColor = value; }

template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetBackgroundColor(const String& value) {
  m_result->SetBackgroundColor(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetDescription(const String& value) {
  m_result->SetDescription(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetDir(const String& value) {
  m_result->SetDir(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetDisplay(const String& value) {
  m_result->SetDisplay(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetDisplayOverrides(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetDisplayOverrides(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetFileHandlers(std::unique_ptr<protocol::Array<protocol::Page::FileHandler>> value) {
  m_result->SetFileHandlers(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetIcons(std::unique_ptr<protocol::Array<protocol::Page::ImageResource>> value) {
  m_result->SetIcons(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetId(const String& value) {
  m_result->SetId(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetLang(const String& value) {
  m_result->SetLang(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetLaunchHandler(std::unique_ptr<protocol::Page::LaunchHandler> value) {
  m_result->SetLaunchHandler(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetName(const String& value) {
  m_result->SetName(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetOrientation(const String& value) {
  m_result->SetOrientation(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetPreferRelatedApplications(bool value) {
  m_result->SetPreferRelatedApplications(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetProtocolHandlers(std::unique_ptr<protocol::Array<protocol::Page::ProtocolHandler>> value) {
  m_result->SetProtocolHandlers(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetRelatedApplications(std::unique_ptr<protocol::Array<protocol::Page::RelatedApplication>> value) {
  m_result->SetRelatedApplications(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetScope(const String& value) {
  m_result->SetScope(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetScopeExtensions(std::unique_ptr<protocol::Array<protocol::Page::ScopeExtension>> value) {
  m_result->SetScopeExtensions(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetScreenshots(std::unique_ptr<protocol::Array<protocol::Page::Screenshot>> value) {
  m_result->SetScreenshots(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetShareTarget(std::unique_ptr<protocol::Page::ShareTarget> value) {
  m_result->SetShareTarget(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetShortName(const String& value) {
  m_result->SetShortName(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetShortcuts(std::unique_ptr<protocol::Array<protocol::Page::Shortcut>> value) {
  m_result->SetShortcuts(std::move(value));
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetStartUrl(const String& value) {
  m_result->SetStartUrl(value);
  return *this;
}
template<int STATE>
inline WebAppManifest::WebAppManifestBuilder<STATE>& WebAppManifest::WebAppManifestBuilder<STATE>::SetThemeColor(const String& value) {
  m_result->SetThemeColor(value);
  return *this;
}

inline WebAppManifest::WebAppManifest() {
}
inline BackForwardCacheBlockingDetails::~BackForwardCacheBlockingDetails() = default;
inline void BackForwardCacheBlockingDetails::SetUrl(const String& value) { m_url = value; }
inline void BackForwardCacheBlockingDetails::SetFunction(const String& value) { m_function = value; }
inline void BackForwardCacheBlockingDetails::SetLineNumber(int value) { m_lineNumber = value; }
inline void BackForwardCacheBlockingDetails::SetColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>& BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::SetUrl(const String& value) {
  m_result->SetUrl(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>& BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::SetFunction(const String& value) {
  m_result->SetFunction(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE | BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::LineNumberSet>&
BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::SetLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->SetLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE | BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::ColumnNumberSet>&
BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::SetColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->SetColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetails() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline BackForwardCacheNotRestoredExplanation::~BackForwardCacheNotRestoredExplanation() = default;
inline void BackForwardCacheNotRestoredExplanation::SetType(const String& value) { m_type = value; }
inline void BackForwardCacheNotRestoredExplanation::SetReason(const String& value) { m_reason = value; }
inline void BackForwardCacheNotRestoredExplanation::SetContext(const String& value) { m_context = value; }
inline void BackForwardCacheNotRestoredExplanation::SetDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value) { m_details = std::move(value); }

template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE | BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::TypeSet>&
BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE | BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::ReasonSet>&
BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::SetReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->SetReason(value);
  return castState<ReasonSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>& BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::SetContext(const String& value) {
  m_result->SetContext(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>& BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::SetDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value) {
  m_result->SetDetails(std::move(value));
  return *this;
}

inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanation() {
}
inline BackForwardCacheNotRestoredExplanationTree::~BackForwardCacheNotRestoredExplanationTree() = default;
inline void BackForwardCacheNotRestoredExplanationTree::SetUrl(const String& value) { m_url = value; }
inline void BackForwardCacheNotRestoredExplanationTree::SetExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value) { m_explanations = std::move(value); }
inline void BackForwardCacheNotRestoredExplanationTree::SetChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value) { m_children = std::move(value); }

template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::UrlSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::ExplanationsSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::SetExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value) {
  static_assert(!(STATE & ExplanationsSet), "property explanations should not be set yet");
  m_result->SetExplanations(std::move(value));
  return castState<ExplanationsSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::ChildrenSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::SetChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value) {
  static_assert(!(STATE & ChildrenSet), "property children should not be set yet");
  m_result->SetChildren(std::move(value));
  return castState<ChildrenSet>();
}

inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTree() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse BringToFront() = 0;
    class CONTENT_EXPORT CaptureScreenshotCallback {
    public:
        virtual void sendSuccess(const Binary& data) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CaptureScreenshotCallback() { }
    };
    virtual void CaptureScreenshot(std::optional<String> in_format, std::optional<int> in_quality, std::unique_ptr<protocol::Page::Viewport> in_clip, std::optional<bool> in_fromSurface, std::optional<bool> in_captureBeyondViewport, std::optional<bool> in_optimizeForSpeed, std::unique_ptr<CaptureScreenshotCallback> callback) = 0;
    class CONTENT_EXPORT CaptureSnapshotCallback {
    public:
        virtual void sendSuccess(const String& data) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CaptureSnapshotCallback() { }
    };
    virtual void CaptureSnapshot(std::optional<String> in_format, std::unique_ptr<CaptureSnapshotCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable(std::optional<bool> in_enableFileChooserOpenedEvent) = 0;
    class CONTENT_EXPORT GetAppManifestCallback {
    public:
        virtual void sendSuccess(const String& url, std::unique_ptr<protocol::Array<protocol::Page::AppManifestError>> errors, std::optional<String> data, std::unique_ptr<protocol::Page::AppManifestParsedProperties> parsed, std::unique_ptr<protocol::Page::WebAppManifest> manifest) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAppManifestCallback() { }
    };
    virtual void GetAppManifest(std::optional<String> in_manifestId, std::unique_ptr<GetAppManifestCallback> callback) = 0;
    class CONTENT_EXPORT GetInstallabilityErrorsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityError>> installabilityErrors) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInstallabilityErrorsCallback() { }
    };
    virtual void GetInstallabilityErrors(std::unique_ptr<GetInstallabilityErrorsCallback> callback) = 0;
    class CONTENT_EXPORT GetManifestIconsCallback {
    public:
        virtual void sendSuccess(std::optional<Binary> primaryIcon) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetManifestIconsCallback() { }
    };
    virtual void GetManifestIcons(std::unique_ptr<GetManifestIconsCallback> callback) = 0;
    class CONTENT_EXPORT GetAppIdCallback {
    public:
        virtual void sendSuccess(std::optional<String> appId, std::optional<String> recommendedId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAppIdCallback() { }
    };
    virtual void GetAppId(std::unique_ptr<GetAppIdCallback> callback) = 0;
    virtual DispatchResponse GetNavigationHistory(int* out_currentIndex, std::unique_ptr<protocol::Array<protocol::Page::NavigationEntry>>* out_entries) = 0;
    virtual DispatchResponse ResetNavigationHistory() = 0;
    virtual DispatchResponse HandleJavaScriptDialog(bool in_accept, std::optional<String> in_promptText) = 0;
    class CONTENT_EXPORT NavigateCallback {
    public:
        virtual void sendSuccess(const String& frameId, std::optional<String> loaderId, std::optional<String> errorText, std::optional<bool> isDownload) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~NavigateCallback() { }
    };
    virtual void Navigate(const String& in_url, std::optional<String> in_referrer, std::optional<String> in_transitionType, std::optional<String> in_frameId, std::optional<String> in_referrerPolicy, std::unique_ptr<NavigateCallback> callback) = 0;
    virtual DispatchResponse NavigateToHistoryEntry(int in_entryId) = 0;
    class CONTENT_EXPORT ReloadCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ReloadCallback() { }
    };
    virtual void Reload(std::optional<bool> in_ignoreCache, std::optional<String> in_scriptToEvaluateOnLoad, std::optional<String> in_loaderId, std::unique_ptr<ReloadCallback> callback) = 0;
    virtual DispatchResponse ScreencastFrameAck(int in_sessionId) = 0;
    virtual DispatchResponse SetBypassCSP(bool in_enabled) = 0;
    virtual DispatchResponse SetDownloadBehavior(const String& in_behavior, std::optional<String> in_downloadPath) = 0;
    virtual DispatchResponse StartScreencast(std::optional<String> in_format, std::optional<int> in_quality, std::optional<int> in_maxWidth, std::optional<int> in_maxHeight, std::optional<int> in_everyNthFrame) = 0;
    virtual DispatchResponse StopLoading() = 0;
    virtual DispatchResponse Crash() = 0;
    virtual DispatchResponse Close() = 0;
    virtual DispatchResponse SetWebLifecycleState(const String& in_state) = 0;
    virtual DispatchResponse StopScreencast() = 0;
    virtual DispatchResponse AddCompilationCache(const String& in_url, const Binary& in_data) = 0;
    virtual DispatchResponse SetPrerenderingAllowed(bool in_isAllowed) = 0;
    class CONTENT_EXPORT GetAnnotatedPageContentCallback {
    public:
        virtual void sendSuccess(const Binary& content) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAnnotatedPageContentCallback() { }
    };
    virtual void GetAnnotatedPageContent(std::optional<bool> in_includeActionableInformation, std::unique_ptr<GetAnnotatedPageContentCallback> callback) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void FrameDetached(const String& frameId, const String& reason);
    void FrameStartedNavigating(const String& frameId, const String& url, const String& loaderId, const String& navigationType);
    void FrameStartedLoading(const String& frameId);
    void FrameStoppedLoading(const String& frameId);
    void DownloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename);
    void DownloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state);
    void InterstitialHidden();
    void InterstitialShown();
    void JavascriptDialogClosed(const String& frameId, bool result, const String& userInput);
    void JavascriptDialogOpening(const String& url, const String& frameId, const String& message, const String& type, bool hasBrowserHandler, std::optional<String> defaultPrompt = {});
    void BackForwardCacheNotUsed(const String& loaderId, const String& frameId, std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> notRestoredExplanations, std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree = {});
    void ScreencastFrame(const Binary& data, std::unique_ptr<protocol::Page::ScreencastFrameMetadata> metadata, int sessionId);
    void ScreencastVisibilityChanged(bool visible);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Page
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Page_h)
