// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_DeviceAccess_h
#define content_protocol_DeviceAccess_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace DeviceAccess {
using RequestId = String;
using DeviceId = String;
class PromptDevice;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CONTENT_EXPORT PromptDevice : public ::crdtp::ProtocolObject<PromptDevice> {
public:
    ~PromptDevice() override;  // Defined below

    String GetId() { return m_id; }
    void SetId(const String& value);  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    template<int STATE>
    class PromptDeviceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            NameSet = 1 << 2,
            AllFieldsSet = (IdSet | NameSet | 0)};


        PromptDeviceBuilder<STATE | IdSet>& SetId(const String& value);  // Defined below

        PromptDeviceBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        std::unique_ptr<PromptDevice> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PromptDevice;
        PromptDeviceBuilder() : m_result(new PromptDevice()) { }

        template<int STEP> PromptDeviceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PromptDeviceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DeviceAccess::PromptDevice> m_result;
    };

    static PromptDeviceBuilder<0> Create()
    {
        return PromptDeviceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PromptDevice();  // Defined below

    String m_id;
    String m_name;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline PromptDevice::~PromptDevice() = default;
inline void PromptDevice::SetId(const String& value) { m_id = value; }
inline void PromptDevice::SetName(const String& value) { m_name = value; }

template<int STATE>
inline PromptDevice::PromptDeviceBuilder<STATE | PromptDevice::PromptDeviceBuilder<STATE>::IdSet>&
PromptDevice::PromptDeviceBuilder<STATE>::SetId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}
template<int STATE>
inline PromptDevice::PromptDeviceBuilder<STATE | PromptDevice::PromptDeviceBuilder<STATE>::NameSet>&
PromptDevice::PromptDeviceBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}

inline PromptDevice::PromptDevice() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse SelectPrompt(const String& in_id, const String& in_deviceId) = 0;
    virtual DispatchResponse CancelPrompt(const String& in_id) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void DeviceRequestPrompted(const String& id, std::unique_ptr<protocol::Array<protocol::DeviceAccess::PromptDevice>> devices);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DeviceAccess
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_DeviceAccess_h)
