// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Browser_h
#define content_protocol_Browser_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Browser {
using BrowserContextID = String;
using PermissionType = String;
using PermissionSetting = String;
class PermissionDescriptor;
class Bucket;
class Histogram;
using PrivacySandboxAPI = String;

// ------------- Forward and enum declarations.

namespace PermissionTypeEnum {
CONTENT_EXPORT extern const char Ar[];
CONTENT_EXPORT extern const char AudioCapture[];
CONTENT_EXPORT extern const char AutomaticFullscreen[];
CONTENT_EXPORT extern const char BackgroundFetch[];
CONTENT_EXPORT extern const char BackgroundSync[];
CONTENT_EXPORT extern const char CameraPanTiltZoom[];
CONTENT_EXPORT extern const char CapturedSurfaceControl[];
CONTENT_EXPORT extern const char ClipboardReadWrite[];
CONTENT_EXPORT extern const char ClipboardSanitizedWrite[];
CONTENT_EXPORT extern const char DisplayCapture[];
CONTENT_EXPORT extern const char DurableStorage[];
CONTENT_EXPORT extern const char Geolocation[];
CONTENT_EXPORT extern const char HandTracking[];
CONTENT_EXPORT extern const char IdleDetection[];
CONTENT_EXPORT extern const char KeyboardLock[];
CONTENT_EXPORT extern const char LocalFonts[];
CONTENT_EXPORT extern const char LocalNetworkAccess[];
CONTENT_EXPORT extern const char Midi[];
CONTENT_EXPORT extern const char MidiSysex[];
CONTENT_EXPORT extern const char Nfc[];
CONTENT_EXPORT extern const char Notifications[];
CONTENT_EXPORT extern const char PaymentHandler[];
CONTENT_EXPORT extern const char PeriodicBackgroundSync[];
CONTENT_EXPORT extern const char PointerLock[];
CONTENT_EXPORT extern const char ProtectedMediaIdentifier[];
CONTENT_EXPORT extern const char Sensors[];
CONTENT_EXPORT extern const char SmartCard[];
CONTENT_EXPORT extern const char SpeakerSelection[];
CONTENT_EXPORT extern const char StorageAccess[];
CONTENT_EXPORT extern const char TopLevelStorageAccess[];
CONTENT_EXPORT extern const char VideoCapture[];
CONTENT_EXPORT extern const char Vr[];
CONTENT_EXPORT extern const char WakeLockScreen[];
CONTENT_EXPORT extern const char WakeLockSystem[];
CONTENT_EXPORT extern const char WebAppInstallation[];
CONTENT_EXPORT extern const char WebPrinting[];
CONTENT_EXPORT extern const char WindowManagement[];
} // namespace PermissionTypeEnum

namespace PermissionSettingEnum {
CONTENT_EXPORT extern const char Granted[];
CONTENT_EXPORT extern const char Denied[];
CONTENT_EXPORT extern const char Prompt[];
} // namespace PermissionSettingEnum

namespace PrivacySandboxAPIEnum {
CONTENT_EXPORT extern const char BiddingAndAuctionServices[];
CONTENT_EXPORT extern const char TrustedKeyValue[];
} // namespace PrivacySandboxAPIEnum

namespace SetDownloadBehavior {
namespace BehaviorEnum {
CONTENT_EXPORT extern const char* Deny;
CONTENT_EXPORT extern const char* Allow;
CONTENT_EXPORT extern const char* AllowAndName;
CONTENT_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace DownloadProgress {
namespace StateEnum {
CONTENT_EXPORT extern const char* InProgress;
CONTENT_EXPORT extern const char* Completed;
CONTENT_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

// ------------- Type and builder declarations.

class CONTENT_EXPORT PermissionDescriptor : public ::crdtp::ProtocolObject<PermissionDescriptor> {
public:
    ~PermissionDescriptor() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    bool HasSysex() { return !!m_sysex; }
    bool GetSysex(bool defaultValue) const {
       return m_sysex.value_or(defaultValue);
    }
    const std::optional<bool>& GetSysex() const {
       return m_sysex;
    }
    void SetSysex(bool value);  // Defined below

    bool HasUserVisibleOnly() { return !!m_userVisibleOnly; }
    bool GetUserVisibleOnly(bool defaultValue) const {
       return m_userVisibleOnly.value_or(defaultValue);
    }
    const std::optional<bool>& GetUserVisibleOnly() const {
       return m_userVisibleOnly;
    }
    void SetUserVisibleOnly(bool value);  // Defined below

    bool HasAllowWithoutSanitization() { return !!m_allowWithoutSanitization; }
    bool GetAllowWithoutSanitization(bool defaultValue) const {
       return m_allowWithoutSanitization.value_or(defaultValue);
    }
    const std::optional<bool>& GetAllowWithoutSanitization() const {
       return m_allowWithoutSanitization;
    }
    void SetAllowWithoutSanitization(bool value);  // Defined below

    bool HasAllowWithoutGesture() { return !!m_allowWithoutGesture; }
    bool GetAllowWithoutGesture(bool defaultValue) const {
       return m_allowWithoutGesture.value_or(defaultValue);
    }
    const std::optional<bool>& GetAllowWithoutGesture() const {
       return m_allowWithoutGesture;
    }
    void SetAllowWithoutGesture(bool value);  // Defined below

    bool HasPanTiltZoom() { return !!m_panTiltZoom; }
    bool GetPanTiltZoom(bool defaultValue) const {
       return m_panTiltZoom.value_or(defaultValue);
    }
    const std::optional<bool>& GetPanTiltZoom() const {
       return m_panTiltZoom;
    }
    void SetPanTiltZoom(bool value);  // Defined below

    template<int STATE>
    class PermissionDescriptorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            AllFieldsSet = (NameSet | 0)};


        PermissionDescriptorBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        PermissionDescriptorBuilder<STATE>& SetSysex(bool value);  // Defined below

        PermissionDescriptorBuilder<STATE>& SetUserVisibleOnly(bool value);  // Defined below

        PermissionDescriptorBuilder<STATE>& SetAllowWithoutSanitization(bool value);  // Defined below

        PermissionDescriptorBuilder<STATE>& SetAllowWithoutGesture(bool value);  // Defined below

        PermissionDescriptorBuilder<STATE>& SetPanTiltZoom(bool value);  // Defined below

        std::unique_ptr<PermissionDescriptor> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PermissionDescriptor;
        PermissionDescriptorBuilder() : m_result(new PermissionDescriptor()) { }

        template<int STEP> PermissionDescriptorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PermissionDescriptorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::PermissionDescriptor> m_result;
    };

    static PermissionDescriptorBuilder<0> Create()
    {
        return PermissionDescriptorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PermissionDescriptor();  // Defined below

    String m_name;
    std::optional<bool> m_sysex;
    std::optional<bool> m_userVisibleOnly;
    std::optional<bool> m_allowWithoutSanitization;
    std::optional<bool> m_allowWithoutGesture;
    std::optional<bool> m_panTiltZoom;
};


class CONTENT_EXPORT Bucket : public ::crdtp::ProtocolObject<Bucket> {
public:
    ~Bucket() override;  // Defined below

    int GetLow() { return m_low; }
    void SetLow(int value);  // Defined below

    int GetHigh() { return m_high; }
    void SetHigh(int value);  // Defined below

    int GetCount() { return m_count; }
    void SetCount(int value);  // Defined below

    template<int STATE>
    class BucketBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LowSet = 1 << 1,
            HighSet = 1 << 2,
            CountSet = 1 << 3,
            AllFieldsSet = (LowSet | HighSet | CountSet | 0)};


        BucketBuilder<STATE | LowSet>& SetLow(int value);  // Defined below

        BucketBuilder<STATE | HighSet>& SetHigh(int value);  // Defined below

        BucketBuilder<STATE | CountSet>& SetCount(int value);  // Defined below

        std::unique_ptr<Bucket> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Bucket;
        BucketBuilder() : m_result(new Bucket()) { }

        template<int STEP> BucketBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BucketBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::Bucket> m_result;
    };

    static BucketBuilder<0> Create()
    {
        return BucketBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Bucket();  // Defined below

    int m_low;
    int m_high;
    int m_count;
};


class CONTENT_EXPORT Histogram : public ::crdtp::ProtocolObject<Histogram> {
public:
    ~Histogram() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    int GetSum() { return m_sum; }
    void SetSum(int value);  // Defined below

    int GetCount() { return m_count; }
    void SetCount(int value);  // Defined below

    protocol::Array<protocol::Browser::Bucket>* GetBuckets() { return m_buckets.get(); }
    void SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value);  // Defined below

    template<int STATE>
    class HistogramBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            SumSet = 1 << 2,
            CountSet = 1 << 3,
            BucketsSet = 1 << 4,
            AllFieldsSet = (NameSet | SumSet | CountSet | BucketsSet | 0)};


        HistogramBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        HistogramBuilder<STATE | SumSet>& SetSum(int value);  // Defined below

        HistogramBuilder<STATE | CountSet>& SetCount(int value);  // Defined below

        HistogramBuilder<STATE | BucketsSet>& SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value);  // Defined below

        std::unique_ptr<Histogram> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Histogram;
        HistogramBuilder() : m_result(new Histogram()) { }

        template<int STEP> HistogramBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HistogramBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::Histogram> m_result;
    };

    static HistogramBuilder<0> Create()
    {
        return HistogramBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Histogram();  // Defined below

    String m_name;
    int m_sum;
    int m_count;
    std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> m_buckets;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline PermissionDescriptor::~PermissionDescriptor() = default;
inline void PermissionDescriptor::SetName(const String& value) { m_name = value; }
inline void PermissionDescriptor::SetSysex(bool value) { m_sysex = value; }
inline void PermissionDescriptor::SetUserVisibleOnly(bool value) { m_userVisibleOnly = value; }
inline void PermissionDescriptor::SetAllowWithoutSanitization(bool value) { m_allowWithoutSanitization = value; }
inline void PermissionDescriptor::SetAllowWithoutGesture(bool value) { m_allowWithoutGesture = value; }
inline void PermissionDescriptor::SetPanTiltZoom(bool value) { m_panTiltZoom = value; }

template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE | PermissionDescriptor::PermissionDescriptorBuilder<STATE>::NameSet>&
PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE>& PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetSysex(bool value) {
  m_result->SetSysex(value);
  return *this;
}
template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE>& PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetUserVisibleOnly(bool value) {
  m_result->SetUserVisibleOnly(value);
  return *this;
}
template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE>& PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetAllowWithoutSanitization(bool value) {
  m_result->SetAllowWithoutSanitization(value);
  return *this;
}
template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE>& PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetAllowWithoutGesture(bool value) {
  m_result->SetAllowWithoutGesture(value);
  return *this;
}
template<int STATE>
inline PermissionDescriptor::PermissionDescriptorBuilder<STATE>& PermissionDescriptor::PermissionDescriptorBuilder<STATE>::SetPanTiltZoom(bool value) {
  m_result->SetPanTiltZoom(value);
  return *this;
}

inline PermissionDescriptor::PermissionDescriptor() {
}
inline Bucket::~Bucket() = default;
inline void Bucket::SetLow(int value) { m_low = value; }
inline void Bucket::SetHigh(int value) { m_high = value; }
inline void Bucket::SetCount(int value) { m_count = value; }

template<int STATE>
inline Bucket::BucketBuilder<STATE | Bucket::BucketBuilder<STATE>::LowSet>&
Bucket::BucketBuilder<STATE>::SetLow(int value) {
  static_assert(!(STATE & LowSet), "property low should not be set yet");
  m_result->SetLow(value);
  return castState<LowSet>();
}
template<int STATE>
inline Bucket::BucketBuilder<STATE | Bucket::BucketBuilder<STATE>::HighSet>&
Bucket::BucketBuilder<STATE>::SetHigh(int value) {
  static_assert(!(STATE & HighSet), "property high should not be set yet");
  m_result->SetHigh(value);
  return castState<HighSet>();
}
template<int STATE>
inline Bucket::BucketBuilder<STATE | Bucket::BucketBuilder<STATE>::CountSet>&
Bucket::BucketBuilder<STATE>::SetCount(int value) {
  static_assert(!(STATE & CountSet), "property count should not be set yet");
  m_result->SetCount(value);
  return castState<CountSet>();
}

inline Bucket::Bucket() {
  m_low = 0;
  m_high = 0;
  m_count = 0;
}
inline Histogram::~Histogram() = default;
inline void Histogram::SetName(const String& value) { m_name = value; }
inline void Histogram::SetSum(int value) { m_sum = value; }
inline void Histogram::SetCount(int value) { m_count = value; }
inline void Histogram::SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value) { m_buckets = std::move(value); }

template<int STATE>
inline Histogram::HistogramBuilder<STATE | Histogram::HistogramBuilder<STATE>::NameSet>&
Histogram::HistogramBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Histogram::HistogramBuilder<STATE | Histogram::HistogramBuilder<STATE>::SumSet>&
Histogram::HistogramBuilder<STATE>::SetSum(int value) {
  static_assert(!(STATE & SumSet), "property sum should not be set yet");
  m_result->SetSum(value);
  return castState<SumSet>();
}
template<int STATE>
inline Histogram::HistogramBuilder<STATE | Histogram::HistogramBuilder<STATE>::CountSet>&
Histogram::HistogramBuilder<STATE>::SetCount(int value) {
  static_assert(!(STATE & CountSet), "property count should not be set yet");
  m_result->SetCount(value);
  return castState<CountSet>();
}
template<int STATE>
inline Histogram::HistogramBuilder<STATE | Histogram::HistogramBuilder<STATE>::BucketsSet>&
Histogram::HistogramBuilder<STATE>::SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value) {
  static_assert(!(STATE & BucketsSet), "property buckets should not be set yet");
  m_result->SetBuckets(std::move(value));
  return castState<BucketsSet>();
}

inline Histogram::Histogram() {
  m_sum = 0;
  m_count = 0;
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT SetPermissionCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetPermissionCallback() { }
    };
    virtual void SetPermission(std::unique_ptr<protocol::Browser::PermissionDescriptor> in_permission, const String& in_setting, std::optional<String> in_origin, std::optional<String> in_embeddedOrigin, std::optional<String> in_browserContextId, std::unique_ptr<SetPermissionCallback> callback) = 0;
    class CONTENT_EXPORT GrantPermissionsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GrantPermissionsCallback() { }
    };
    virtual void GrantPermissions(std::unique_ptr<protocol::Array<String>> in_permissions, std::optional<String> in_origin, std::optional<String> in_browserContextId, std::unique_ptr<GrantPermissionsCallback> callback) = 0;
    class CONTENT_EXPORT ResetPermissionsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ResetPermissionsCallback() { }
    };
    virtual void ResetPermissions(std::optional<String> in_browserContextId, std::unique_ptr<ResetPermissionsCallback> callback) = 0;
    virtual DispatchResponse SetDownloadBehavior(const String& in_behavior, std::optional<String> in_browserContextId, std::optional<String> in_downloadPath, std::optional<bool> in_eventsEnabled) = 0;
    virtual DispatchResponse CancelDownload(const String& in_guid, std::optional<String> in_browserContextId) = 0;
    virtual DispatchResponse Crash() = 0;
    virtual DispatchResponse CrashGpuProcess() = 0;
    virtual DispatchResponse GetVersion(String* out_protocolVersion, String* out_product, String* out_revision, String* out_userAgent, String* out_jsVersion) = 0;
    virtual DispatchResponse GetBrowserCommandLine(std::unique_ptr<protocol::Array<String>>* out_arguments) = 0;
    virtual DispatchResponse GetHistograms(std::optional<String> in_query, std::optional<bool> in_delta, std::unique_ptr<protocol::Array<protocol::Browser::Histogram>>* out_histograms) = 0;
    virtual DispatchResponse GetHistogram(const String& in_name, std::optional<bool> in_delta, std::unique_ptr<protocol::Browser::Histogram>* out_histogram) = 0;
    class CONTENT_EXPORT AddPrivacySandboxCoordinatorKeyConfigCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AddPrivacySandboxCoordinatorKeyConfigCallback() { }
    };
    virtual void AddPrivacySandboxCoordinatorKeyConfig(const String& in_api, const String& in_coordinatorOrigin, const String& in_keyConfig, std::optional<String> in_browserContextId, std::unique_ptr<AddPrivacySandboxCoordinatorKeyConfigCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void DownloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename);
    void DownloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state, std::optional<String> filePath = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Browser
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Browser_h)
