// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_BackgroundService_h
#define content_protocol_BackgroundService_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace BackgroundService {
using ServiceName = String;
class EventMetadata;
class BackgroundServiceEvent;

// ------------- Forward and enum declarations.

namespace ServiceNameEnum {
CONTENT_EXPORT extern const char BackgroundFetch[];
CONTENT_EXPORT extern const char BackgroundSync[];
CONTENT_EXPORT extern const char PushMessaging[];
CONTENT_EXPORT extern const char Notifications[];
CONTENT_EXPORT extern const char PaymentHandler[];
CONTENT_EXPORT extern const char PeriodicBackgroundSync[];
} // namespace ServiceNameEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT EventMetadata : public ::crdtp::ProtocolObject<EventMetadata> {
public:
    ~EventMetadata() override;  // Defined below

    String GetKey() { return m_key; }
    void SetKey(const String& value);  // Defined below

    String GetValue() { return m_value; }
    void SetValue(const String& value);  // Defined below

    template<int STATE>
    class EventMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        EventMetadataBuilder<STATE | KeySet>& SetKey(const String& value);  // Defined below

        EventMetadataBuilder<STATE | ValueSet>& SetValue(const String& value);  // Defined below

        std::unique_ptr<EventMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class EventMetadata;
        EventMetadataBuilder() : m_result(new EventMetadata()) { }

        template<int STEP> EventMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<EventMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BackgroundService::EventMetadata> m_result;
    };

    static EventMetadataBuilder<0> Create()
    {
        return EventMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    EventMetadata();  // Defined below

    String m_key;
    String m_value;
};


class CONTENT_EXPORT BackgroundServiceEvent : public ::crdtp::ProtocolObject<BackgroundServiceEvent> {
public:
    ~BackgroundServiceEvent() override;  // Defined below

    double GetTimestamp() { return m_timestamp; }
    void SetTimestamp(double value);  // Defined below

    String GetOrigin() { return m_origin; }
    void SetOrigin(const String& value);  // Defined below

    String GetServiceWorkerRegistrationId() { return m_serviceWorkerRegistrationId; }
    void SetServiceWorkerRegistrationId(const String& value);  // Defined below

    String GetService() { return m_service; }
    void SetService(const String& value);  // Defined below

    String GetEventName() { return m_eventName; }
    void SetEventName(const String& value);  // Defined below

    String GetInstanceId() { return m_instanceId; }
    void SetInstanceId(const String& value);  // Defined below

    protocol::Array<protocol::BackgroundService::EventMetadata>* GetEventMetadata() { return m_eventMetadata.get(); }
    void SetEventMetadata(std::unique_ptr<protocol::Array<protocol::BackgroundService::EventMetadata>> value);  // Defined below

    String GetStorageKey() { return m_storageKey; }
    void SetStorageKey(const String& value);  // Defined below

    template<int STATE>
    class BackgroundServiceEventBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TimestampSet = 1 << 1,
            OriginSet = 1 << 2,
            ServiceWorkerRegistrationIdSet = 1 << 3,
            ServiceSet = 1 << 4,
            EventNameSet = 1 << 5,
            InstanceIdSet = 1 << 6,
            EventMetadataSet = 1 << 7,
            StorageKeySet = 1 << 8,
            AllFieldsSet = (TimestampSet | OriginSet | ServiceWorkerRegistrationIdSet | ServiceSet | EventNameSet | InstanceIdSet | EventMetadataSet | StorageKeySet | 0)};


        BackgroundServiceEventBuilder<STATE | TimestampSet>& SetTimestamp(double value);  // Defined below

        BackgroundServiceEventBuilder<STATE | OriginSet>& SetOrigin(const String& value);  // Defined below

        BackgroundServiceEventBuilder<STATE | ServiceWorkerRegistrationIdSet>& SetServiceWorkerRegistrationId(const String& value);  // Defined below

        BackgroundServiceEventBuilder<STATE | ServiceSet>& SetService(const String& value);  // Defined below

        BackgroundServiceEventBuilder<STATE | EventNameSet>& SetEventName(const String& value);  // Defined below

        BackgroundServiceEventBuilder<STATE | InstanceIdSet>& SetInstanceId(const String& value);  // Defined below

        BackgroundServiceEventBuilder<STATE | EventMetadataSet>& SetEventMetadata(std::unique_ptr<protocol::Array<protocol::BackgroundService::EventMetadata>> value);  // Defined below

        BackgroundServiceEventBuilder<STATE | StorageKeySet>& SetStorageKey(const String& value);  // Defined below

        std::unique_ptr<BackgroundServiceEvent> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackgroundServiceEvent;
        BackgroundServiceEventBuilder() : m_result(new BackgroundServiceEvent()) { }

        template<int STEP> BackgroundServiceEventBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackgroundServiceEventBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BackgroundService::BackgroundServiceEvent> m_result;
    };

    static BackgroundServiceEventBuilder<0> Create()
    {
        return BackgroundServiceEventBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackgroundServiceEvent();  // Defined below

    double m_timestamp;
    String m_origin;
    String m_serviceWorkerRegistrationId;
    String m_service;
    String m_eventName;
    String m_instanceId;
    std::unique_ptr<protocol::Array<protocol::BackgroundService::EventMetadata>> m_eventMetadata;
    String m_storageKey;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline EventMetadata::~EventMetadata() = default;
inline void EventMetadata::SetKey(const String& value) { m_key = value; }
inline void EventMetadata::SetValue(const String& value) { m_value = value; }

template<int STATE>
inline EventMetadata::EventMetadataBuilder<STATE | EventMetadata::EventMetadataBuilder<STATE>::KeySet>&
EventMetadata::EventMetadataBuilder<STATE>::SetKey(const String& value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->SetKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline EventMetadata::EventMetadataBuilder<STATE | EventMetadata::EventMetadataBuilder<STATE>::ValueSet>&
EventMetadata::EventMetadataBuilder<STATE>::SetValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(value);
  return castState<ValueSet>();
}

inline EventMetadata::EventMetadata() {
}
inline BackgroundServiceEvent::~BackgroundServiceEvent() = default;
inline void BackgroundServiceEvent::SetTimestamp(double value) { m_timestamp = value; }
inline void BackgroundServiceEvent::SetOrigin(const String& value) { m_origin = value; }
inline void BackgroundServiceEvent::SetServiceWorkerRegistrationId(const String& value) { m_serviceWorkerRegistrationId = value; }
inline void BackgroundServiceEvent::SetService(const String& value) { m_service = value; }
inline void BackgroundServiceEvent::SetEventName(const String& value) { m_eventName = value; }
inline void BackgroundServiceEvent::SetInstanceId(const String& value) { m_instanceId = value; }
inline void BackgroundServiceEvent::SetEventMetadata(std::unique_ptr<protocol::Array<protocol::BackgroundService::EventMetadata>> value) { m_eventMetadata = std::move(value); }
inline void BackgroundServiceEvent::SetStorageKey(const String& value) { m_storageKey = value; }

template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::TimestampSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetTimestamp(double value) {
  static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
  m_result->SetTimestamp(value);
  return castState<TimestampSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::OriginSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetOrigin(const String& value) {
  static_assert(!(STATE & OriginSet), "property origin should not be set yet");
  m_result->SetOrigin(value);
  return castState<OriginSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::ServiceWorkerRegistrationIdSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetServiceWorkerRegistrationId(const String& value) {
  static_assert(!(STATE & ServiceWorkerRegistrationIdSet), "property serviceWorkerRegistrationId should not be set yet");
  m_result->SetServiceWorkerRegistrationId(value);
  return castState<ServiceWorkerRegistrationIdSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::ServiceSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetService(const String& value) {
  static_assert(!(STATE & ServiceSet), "property service should not be set yet");
  m_result->SetService(value);
  return castState<ServiceSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::EventNameSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetEventName(const String& value) {
  static_assert(!(STATE & EventNameSet), "property eventName should not be set yet");
  m_result->SetEventName(value);
  return castState<EventNameSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::InstanceIdSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetInstanceId(const String& value) {
  static_assert(!(STATE & InstanceIdSet), "property instanceId should not be set yet");
  m_result->SetInstanceId(value);
  return castState<InstanceIdSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::EventMetadataSet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetEventMetadata(std::unique_ptr<protocol::Array<protocol::BackgroundService::EventMetadata>> value) {
  static_assert(!(STATE & EventMetadataSet), "property eventMetadata should not be set yet");
  m_result->SetEventMetadata(std::move(value));
  return castState<EventMetadataSet>();
}
template<int STATE>
inline BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE | BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::StorageKeySet>&
BackgroundServiceEvent::BackgroundServiceEventBuilder<STATE>::SetStorageKey(const String& value) {
  static_assert(!(STATE & StorageKeySet), "property storageKey should not be set yet");
  m_result->SetStorageKey(value);
  return castState<StorageKeySet>();
}

inline BackgroundServiceEvent::BackgroundServiceEvent() {
  m_timestamp = 0;
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT StartObservingCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartObservingCallback() { }
    };
    virtual void StartObserving(const String& in_service, std::unique_ptr<StartObservingCallback> callback) = 0;
    virtual DispatchResponse StopObserving(const String& in_service) = 0;
    virtual DispatchResponse SetRecording(bool in_shouldRecord, const String& in_service) = 0;
    virtual DispatchResponse ClearEvents(const String& in_service) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void RecordingStateChanged(bool isRecording, const String& service);
    void BackgroundServiceEventReceived(std::unique_ptr<protocol::BackgroundService::BackgroundServiceEvent> backgroundServiceEvent);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace BackgroundService
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_BackgroundService_h)
