// content/browser/attribution_reporting/attribution_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  AggregatableResultSpec as attributionReporting_mojom_AggregatableResultSpec,
  AggregatableResult as attributionReporting_mojom_AggregatableResult
} from './aggregatable_result.mojom-webui.js';
import {
  AttributionSupportSpec as network_mojom_AttributionSupportSpec,
  AttributionSupport as network_mojom_AttributionSupport
} from './attribution.mojom-webui.js';
import {
  OsRegistrationResultSpec as attributionReporting_mojom_OsRegistrationResultSpec,
  OsRegistrationResult as attributionReporting_mojom_OsRegistrationResult,
  RegistrationTypeSpec as attributionReporting_mojom_RegistrationTypeSpec,
  RegistrationType as attributionReporting_mojom_RegistrationType
} from './attribution_reporting.mojom-webui.js';
import {
  EventLevelResultSpec as attributionReporting_mojom_EventLevelResultSpec,
  EventLevelResult as attributionReporting_mojom_EventLevelResult
} from './event_level_result.mojom-webui.js';
import {
  ProcessAggregatableDebugReportResultSpec as attributionReporting_mojom_ProcessAggregatableDebugReportResultSpec,
  ProcessAggregatableDebugReportResult as attributionReporting_mojom_ProcessAggregatableDebugReportResult
} from './process_aggregatable_debug_report_result.mojom-webui.js';
import {
  DestinationSetSpec as attributionReporting_mojom_DestinationSetSpec,
  DestinationSet as attributionReporting_mojom_DestinationSet,
  EventReportWindowsSpec as attributionReporting_mojom_EventReportWindowsSpec,
  EventReportWindows as attributionReporting_mojom_EventReportWindows,
  FilterDataSpec as attributionReporting_mojom_FilterDataSpec,
  FilterData as attributionReporting_mojom_FilterData
} from './registration.mojom-webui.js';
import {
  SourceTypeSpec as attributionReporting_mojom_SourceTypeSpec,
  SourceType as attributionReporting_mojom_SourceType
} from './source_type.mojom-webui.js';
import {
  StoreSourceResultSpec as attributionReporting_mojom_StoreSourceResultSpec,
  StoreSourceResult as attributionReporting_mojom_StoreSourceResult
} from './store_source_result.mojom-webui.js';
import {
  TriggerDataMatchingSpec as attributionReporting_mojom_TriggerDataMatchingSpec,
  TriggerDataMatching as attributionReporting_mojom_TriggerDataMatching
} from './trigger_data_matching.mojom-webui.js';
import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type ObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ObserverPendingReceiver>;

export class ObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Observer> {

  handle: mojo.internal.interfaceSupport.Endpoint<ObserverPendingReceiver>;
  constructor(handle: MojoHandle|ObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'attribution_internals.mojom.Observer',
        scope);
  }
}

export interface ObserverInterface {
  onSourcesChanged(sources: WebUISource[]): void;
  onReportsChanged(reports: WebUIReport[]): void;
  onSourceHandled(source: WebUISourceRegistration): void;
  onReportHandled(report: WebUIReport): void;
  onDebugReportSent(report: WebUIDebugReport): void;
  onAggregatableDebugReportSent(report: WebUIAggregatableDebugReport): void;
  onTriggerHandled(trigger: WebUITrigger): void;
  onOsRegistration(registration: WebUIOsRegistration): void;
  onDebugModeChanged(debugMode: boolean): void;
}

export class ObserverRemote implements ObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onSourcesChanged(
      sources: WebUISource[]): void {
    this.proxy.sendMessage(
        0,
        Observer_OnSourcesChanged_ParamsSpec.$,
        null,
        [
          sources
        ],
        false);
  }

  onReportsChanged(
      reports: WebUIReport[]): void {
    this.proxy.sendMessage(
        1,
        Observer_OnReportsChanged_ParamsSpec.$,
        null,
        [
          reports
        ],
        false);
  }

  onSourceHandled(
      source: WebUISourceRegistration): void {
    this.proxy.sendMessage(
        2,
        Observer_OnSourceHandled_ParamsSpec.$,
        null,
        [
          source
        ],
        false);
  }

  onReportHandled(
      report: WebUIReport): void {
    this.proxy.sendMessage(
        3,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }

  onDebugReportSent(
      report: WebUIDebugReport): void {
    this.proxy.sendMessage(
        4,
        Observer_OnDebugReportSent_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }

  onAggregatableDebugReportSent(
      report: WebUIAggregatableDebugReport): void {
    this.proxy.sendMessage(
        5,
        Observer_OnAggregatableDebugReportSent_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }

  onTriggerHandled(
      trigger: WebUITrigger): void {
    this.proxy.sendMessage(
        6,
        Observer_OnTriggerHandled_ParamsSpec.$,
        null,
        [
          trigger
        ],
        false);
  }

  onOsRegistration(
      registration: WebUIOsRegistration): void {
    this.proxy.sendMessage(
        7,
        Observer_OnOsRegistration_ParamsSpec.$,
        null,
        [
          registration
        ],
        false);
  }

  onDebugModeChanged(
      debugMode: boolean): void {
    this.proxy.sendMessage(
        8,
        Observer_OnDebugModeChanged_ParamsSpec.$,
        null,
        [
          debugMode
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Observer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ObserverRemote, ObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ObserverRemote, ObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Observer_OnSourcesChanged_ParamsSpec.$,
        null,
        impl.onSourcesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Observer_OnReportsChanged_ParamsSpec.$,
        null,
        impl.onReportsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Observer_OnSourceHandled_ParamsSpec.$,
        null,
        impl.onSourceHandled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        impl.onReportHandled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Observer_OnDebugReportSent_ParamsSpec.$,
        null,
        impl.onDebugReportSent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Observer_OnAggregatableDebugReportSent_ParamsSpec.$,
        null,
        impl.onAggregatableDebugReportSent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Observer_OnTriggerHandled_ParamsSpec.$,
        null,
        impl.onTriggerHandled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Observer_OnOsRegistration_ParamsSpec.$,
        null,
        impl.onOsRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Observer_OnDebugModeChanged_ParamsSpec.$,
        null,
        impl.onDebugModeChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Observer {
  static get $interfaceName(): string {
    return "attribution_internals.mojom.Observer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ObserverRemote {
    let remote = new ObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Observer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ObserverRemote, ObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ObserverRemote, ObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onSourcesChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onReportsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onSourceHandled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onReportHandled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDebugReportSent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAggregatableDebugReportSent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onTriggerHandled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onOsRegistration: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDebugModeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onSourcesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Observer_OnSourcesChanged_ParamsSpec.$,
        null,
        this.onSourcesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onReportsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Observer_OnReportsChanged_ParamsSpec.$,
        null,
        this.onReportsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onSourceHandled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Observer_OnSourceHandled_ParamsSpec.$,
        null,
        this.onSourceHandled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onReportHandled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        this.onReportHandled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDebugReportSent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Observer_OnDebugReportSent_ParamsSpec.$,
        null,
        this.onDebugReportSent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAggregatableDebugReportSent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Observer_OnAggregatableDebugReportSent_ParamsSpec.$,
        null,
        this.onAggregatableDebugReportSent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onTriggerHandled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Observer_OnTriggerHandled_ParamsSpec.$,
        null,
        this.onTriggerHandled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onOsRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Observer_OnOsRegistration_ParamsSpec.$,
        null,
        this.onOsRegistration.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDebugModeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Observer_OnDebugModeChanged_ParamsSpec.$,
        null,
        this.onDebugModeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type HandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<HandlerPendingReceiver>;

export class HandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Handler> {

  handle: mojo.internal.interfaceSupport.Endpoint<HandlerPendingReceiver>;
  constructor(handle: MojoHandle|HandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'attribution_internals.mojom.Handler',
        scope);
  }
}

export interface HandlerInterface {
  isAttributionReportingEnabled(): Promise<{
        enabled: boolean,
        attributionSupport: network_mojom_AttributionSupport, }>;
  sendReport(id: ReportID): Promise<void>;
  clearStorage(): Promise<void>;
}

export class HandlerRemote implements HandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<HandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<HandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|HandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  isAttributionReportingEnabled(): Promise<{
        enabled: boolean,
        attributionSupport: network_mojom_AttributionSupport, }> {
    return this.proxy.sendMessage(
        0,
        Handler_IsAttributionReportingEnabled_ParamsSpec.$,
        Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  sendReport(
      id: ReportID): Promise<void> {
    return this.proxy.sendMessage(
        1,
        Handler_SendReport_ParamsSpec.$,
        Handler_SendReport_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  clearStorage(): Promise<void> {
    return this.proxy.sendMessage(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Handler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HandlerRemote, HandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HandlerRemote, HandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: HandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Handler_IsAttributionReportingEnabled_ParamsSpec.$,
        Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,
        impl.isAttributionReportingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Handler_SendReport_ParamsSpec.$,
        Handler_SendReport_ResponseParamsSpec.$,
        impl.sendReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        impl.clearStorage.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Handler {
  static get $interfaceName(): string {
    return "attribution_internals.mojom.Handler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): HandlerRemote {
    let remote = new HandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Handler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HandlerRemote, HandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HandlerRemote, HandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  isAttributionReportingEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendReport: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearStorage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.isAttributionReportingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Handler_IsAttributionReportingEnabled_ParamsSpec.$,
        Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,
        this.isAttributionReportingEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    this.sendReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Handler_SendReport_ParamsSpec.$,
        Handler_SendReport_ResponseParamsSpec.$,
        this.sendReport.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        this.clearStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type FactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<FactoryPendingReceiver>;

export class FactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Factory> {

  handle: mojo.internal.interfaceSupport.Endpoint<FactoryPendingReceiver>;
  constructor(handle: MojoHandle|FactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'attribution_internals.mojom.Factory',
        scope);
  }
}

export interface FactoryInterface {
  create(observer: ObserverRemote, handler: HandlerPendingReceiver): void;
}

export class FactoryRemote implements FactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<FactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|FactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  create(
      observer: ObserverRemote,
      handler: HandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        [
          observer,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Factory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FactoryRemote, FactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FactoryRemote, FactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: FactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        impl.create.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Factory {
  static get $interfaceName(): string {
    return "attribution_internals.mojom.Factory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): FactoryRemote {
    let remote = new FactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Factory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FactoryRemote, FactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FactoryRemote, FactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  create: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        this.create.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ReportIDSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIReportEventLevelDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AggregatableHistogramContributionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIReportAggregatableAttributionDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const EmptySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIReportSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIDebugReportSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIAggregatableDebugReportSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUISourceSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIRegistrationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUITriggerSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUISourceRegistrationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIOsRegistrationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnSourcesChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnReportsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnSourceHandled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnReportHandled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnDebugReportSent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnAggregatableDebugReportSent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnTriggerHandled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnOsRegistration_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnDebugModeChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_IsAttributionReportingEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_IsAttributionReportingEnabled_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_SendReport_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_SendReport_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_ClearStorage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_ClearStorage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Factory_Create_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIReportDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NetworkStatusSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReportStatusSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SendAggregatableDebugReportResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ReportIDMojoType {
  value: bigint;
}


export type ReportID = ReportIDMojoType;
mojo.internal.Struct<ReportIDMojoType>(
    ReportIDSpec.$,
    'ReportID',
    [
      mojo.internal.StructField<ReportIDMojoType, bigint>(
        'value', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebUIReportEventLevelDataMojoType {
  priority: bigint;
  attributedTruthfully: boolean;
}


export type WebUIReportEventLevelData = WebUIReportEventLevelDataMojoType;
mojo.internal.Struct<WebUIReportEventLevelDataMojoType>(
    WebUIReportEventLevelDataSpec.$,
    'WebUIReportEventLevelData',
    [
      mojo.internal.StructField<WebUIReportEventLevelDataMojoType, bigint>(
        'priority', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportEventLevelDataMojoType, boolean>(
        'attributedTruthfully', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AggregatableHistogramContributionMojoType {
  key: string;
  value: number;
  filteringId: bigint;
}


export type AggregatableHistogramContribution = AggregatableHistogramContributionMojoType;
mojo.internal.Struct<AggregatableHistogramContributionMojoType>(
    AggregatableHistogramContributionSpec.$,
    'AggregatableHistogramContribution',
    [
      mojo.internal.StructField<AggregatableHistogramContributionMojoType, string>(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AggregatableHistogramContributionMojoType, number>(
        'value', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AggregatableHistogramContributionMojoType, bigint>(
        'filteringId', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface WebUIReportAggregatableAttributionDataMojoType {
  contributions: AggregatableHistogramContribution[];
  aggregationCoordinator: string;
  isNullReport: boolean;
}


export type WebUIReportAggregatableAttributionData = WebUIReportAggregatableAttributionDataMojoType;
mojo.internal.Struct<WebUIReportAggregatableAttributionDataMojoType>(
    WebUIReportAggregatableAttributionDataSpec.$,
    'WebUIReportAggregatableAttributionData',
    [
      mojo.internal.StructField<WebUIReportAggregatableAttributionDataMojoType, AggregatableHistogramContribution[]>(
        'contributions', 0,
        0,
        mojo.internal.Array(AggregatableHistogramContributionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportAggregatableAttributionDataMojoType, string>(
        'aggregationCoordinator', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportAggregatableAttributionDataMojoType, boolean>(
        'isNullReport', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface EmptyMojoType {
}


export type Empty = EmptyMojoType;
mojo.internal.Struct<EmptyMojoType>(
    EmptySpec.$,
    'Empty',
    [
    ],
    [[0, 8],]);





export interface WebUIReportMojoType {
  id: ReportID;
  reportUrl: url_mojom_Url;
  triggerTime: number;
  reportTime: number;
  reportBody: string;
  status: ReportStatus;
  data: WebUIReportData;
}


export type WebUIReport = WebUIReportMojoType;
mojo.internal.Struct<WebUIReportMojoType>(
    WebUIReportSpec.$,
    'WebUIReport',
    [
      mojo.internal.StructField<WebUIReportMojoType, ReportID>(
        'id', 0,
        0,
        ReportIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, url_mojom_Url>(
        'reportUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, number>(
        'triggerTime', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, number>(
        'reportTime', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, string>(
        'reportBody', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, ReportStatus>(
        'status', 40,
        0,
        ReportStatusSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIReportMojoType, WebUIReportData>(
        'data', 56,
        0,
        WebUIReportDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);





export interface WebUIDebugReportMojoType {
  url: url_mojom_Url;
  time: number;
  body: string;
  status: NetworkStatus;
}


export type WebUIDebugReport = WebUIDebugReportMojoType;
mojo.internal.Struct<WebUIDebugReportMojoType>(
    WebUIDebugReportSpec.$,
    'WebUIDebugReport',
    [
      mojo.internal.StructField<WebUIDebugReportMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIDebugReportMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIDebugReportMojoType, string>(
        'body', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIDebugReportMojoType, NetworkStatus>(
        'status', 24,
        0,
        NetworkStatusSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface WebUIAggregatableDebugReportMojoType {
  url: url_mojom_Url;
  time: number;
  body: string;
  processResult: attributionReporting_mojom_ProcessAggregatableDebugReportResult;
  sendResult: SendAggregatableDebugReportResult;
}


export type WebUIAggregatableDebugReport = WebUIAggregatableDebugReportMojoType;
mojo.internal.Struct<WebUIAggregatableDebugReportMojoType>(
    WebUIAggregatableDebugReportSpec.$,
    'WebUIAggregatableDebugReport',
    [
      mojo.internal.StructField<WebUIAggregatableDebugReportMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableDebugReportMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableDebugReportMojoType, string>(
        'body', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableDebugReportMojoType, attributionReporting_mojom_ProcessAggregatableDebugReportResult>(
        'processResult', 24,
        0,
        attributionReporting_mojom_ProcessAggregatableDebugReportResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableDebugReportMojoType, SendAggregatableDebugReportResult>(
        'sendResult', 32,
        0,
        SendAggregatableDebugReportResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);




export const WebUISource_AttributabilitySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WebUISource_Attributability {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kAttributable = 0,
  kNoisedNever = 1,
  kNoisedFalsely = 2,
  kReachedEventLevelAttributionLimit = 3,
}


export interface WebUISourceMojoType {
  id: bigint;
  sourceEventId: bigint;
  sourceOrigin: url_mojom_Origin;
  destinations: attributionReporting_mojom_DestinationSet;
  reportingOrigin: url_mojom_Origin;
  sourceTime: number;
  expiryTime: number;
  eventReportWindows: attributionReporting_mojom_EventReportWindows;
  triggerData: number[];
  maxEventLevelReports: number;
  sourceType: attributionReporting_mojom_SourceType;
  aggregatableReportWindowTime: number;
  priority: bigint;
  debugKey: (bigint | null);
  cookieBasedDebugAllowed: boolean;
  remainingAggregatableAttributionBudget: number;
  dedupKeys: bigint[];
  filterData: attributionReporting_mojom_FilterData;
  aggregationKeys: {[key: string]: string};
  aggregatableDedupKeys: bigint[];
  triggerDataMatching: attributionReporting_mojom_TriggerDataMatching;
  remainingAggregatableDebugBudget: number;
  eventLevelEpsilon: number;
  aggregatableDebugKeyPiece: string;
  attributionScopesDataJson: string;
  aggregatableNamedBudgets: string;
  attributability: WebUISource_Attributability;
}


export type WebUISource = WebUISourceMojoType;
mojo.internal.Struct<WebUISourceMojoType>(
    WebUISourceSpec.$,
    'WebUISource',
    [
      mojo.internal.StructField<WebUISourceMojoType, bigint>(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, bigint>(
        'sourceEventId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, url_mojom_Origin>(
        'sourceOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, attributionReporting_mojom_DestinationSet>(
        'destinations', 24,
        0,
        attributionReporting_mojom_DestinationSetSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, url_mojom_Origin>(
        'reportingOrigin', 32,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'sourceTime', 40,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'expiryTime', 48,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, attributionReporting_mojom_EventReportWindows>(
        'eventReportWindows', 56,
        0,
        attributionReporting_mojom_EventReportWindowsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number[]>(
        'triggerData', 64,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'maxEventLevelReports', 72,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'aggregatableReportWindowTime', 80,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, attributionReporting_mojom_SourceType>(
        'sourceType', 76,
        0,
        attributionReporting_mojom_SourceTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, bigint>(
        'priority', 88,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, boolean>(
        'debug_key_$flag', 96,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "debug_key_$value",
          originalFieldName: "debugKey",
        },
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, bigint>(
        'debug_key_$value', 104,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "debugKey",
        },
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, bigint[]>(
        'dedupKeys', 112,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, attributionReporting_mojom_FilterData>(
        'filterData', 120,
        0,
        attributionReporting_mojom_FilterDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, {[key: string]: string}>(
        'aggregationKeys', 128,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'remainingAggregatableAttributionBudget', 100,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, bigint[]>(
        'aggregatableDedupKeys', 136,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, attributionReporting_mojom_TriggerDataMatching>(
        'triggerDataMatching', 144,
        0,
        attributionReporting_mojom_TriggerDataMatchingSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'eventLevelEpsilon', 152,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, boolean>(
        'cookieBasedDebugAllowed', 96,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, number>(
        'remainingAggregatableDebugBudget', 148,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, string>(
        'aggregatableDebugKeyPiece', 160,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, string>(
        'attributionScopesDataJson', 168,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, string>(
        'aggregatableNamedBudgets', 176,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceMojoType, WebUISource_Attributability>(
        'attributability', 184,
        0,
        WebUISource_AttributabilitySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 200],]);





export interface WebUIRegistrationMojoType {
  time: number;
  contextOrigin: url_mojom_Origin;
  reportingOrigin: url_mojom_Origin;
  registrationJson: string;
  clearedDebugKey: (bigint | null);
}


export type WebUIRegistration = WebUIRegistrationMojoType;
mojo.internal.Struct<WebUIRegistrationMojoType>(
    WebUIRegistrationSpec.$,
    'WebUIRegistration',
    [
      mojo.internal.StructField<WebUIRegistrationMojoType, number>(
        'time', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIRegistrationMojoType, url_mojom_Origin>(
        'contextOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIRegistrationMojoType, url_mojom_Origin>(
        'reportingOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIRegistrationMojoType, string>(
        'registrationJson', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIRegistrationMojoType, boolean>(
        'cleared_debug_key_$flag', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "cleared_debug_key_$value",
          originalFieldName: "clearedDebugKey",
        },
        undefined,
    ),
      mojo.internal.StructField<WebUIRegistrationMojoType, bigint>(
        'cleared_debug_key_$value', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "clearedDebugKey",
        },
        undefined,
    ),
    ],
    [[0, 56],]);





export interface WebUITriggerMojoType {
  registration: WebUIRegistration;
  eventLevelResult: attributionReporting_mojom_EventLevelResult;
  aggregatableResult: attributionReporting_mojom_AggregatableResult;
}


export type WebUITrigger = WebUITriggerMojoType;
mojo.internal.Struct<WebUITriggerMojoType>(
    WebUITriggerSpec.$,
    'WebUITrigger',
    [
      mojo.internal.StructField<WebUITriggerMojoType, WebUIRegistration>(
        'registration', 0,
        0,
        WebUIRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUITriggerMojoType, attributionReporting_mojom_EventLevelResult>(
        'eventLevelResult', 8,
        0,
        attributionReporting_mojom_EventLevelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUITriggerMojoType, attributionReporting_mojom_AggregatableResult>(
        'aggregatableResult', 12,
        0,
        attributionReporting_mojom_AggregatableResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebUISourceRegistrationMojoType {
  registration: WebUIRegistration;
  type: attributionReporting_mojom_SourceType;
  status: attributionReporting_mojom_StoreSourceResult;
}


export type WebUISourceRegistration = WebUISourceRegistrationMojoType;
mojo.internal.Struct<WebUISourceRegistrationMojoType>(
    WebUISourceRegistrationSpec.$,
    'WebUISourceRegistration',
    [
      mojo.internal.StructField<WebUISourceRegistrationMojoType, WebUIRegistration>(
        'registration', 0,
        0,
        WebUIRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceRegistrationMojoType, attributionReporting_mojom_SourceType>(
        'type', 8,
        0,
        attributionReporting_mojom_SourceTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUISourceRegistrationMojoType, attributionReporting_mojom_StoreSourceResult>(
        'status', 12,
        0,
        attributionReporting_mojom_StoreSourceResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebUIOsRegistrationMojoType {
  time: number;
  registrationUrl: url_mojom_Url;
  topLevelOrigin: url_mojom_Origin;
  isDebugKeyAllowed: boolean;
  debugReporting: boolean;
  type: attributionReporting_mojom_RegistrationType;
  result: attributionReporting_mojom_OsRegistrationResult;
}


export type WebUIOsRegistration = WebUIOsRegistrationMojoType;
mojo.internal.Struct<WebUIOsRegistrationMojoType>(
    WebUIOsRegistrationSpec.$,
    'WebUIOsRegistration',
    [
      mojo.internal.StructField<WebUIOsRegistrationMojoType, number>(
        'time', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, url_mojom_Url>(
        'registrationUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, url_mojom_Origin>(
        'topLevelOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, boolean>(
        'isDebugKeyAllowed', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, boolean>(
        'debugReporting', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, attributionReporting_mojom_RegistrationType>(
        'type', 28,
        0,
        attributionReporting_mojom_RegistrationTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIOsRegistrationMojoType, attributionReporting_mojom_OsRegistrationResult>(
        'result', 32,
        0,
        attributionReporting_mojom_OsRegistrationResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface Observer_OnSourcesChanged_ParamsMojoType {
  sources: WebUISource[];
}


export type Observer_OnSourcesChanged_Params = Observer_OnSourcesChanged_ParamsMojoType;
mojo.internal.Struct<Observer_OnSourcesChanged_ParamsMojoType>(
    Observer_OnSourcesChanged_ParamsSpec.$,
    'Observer_OnSourcesChanged_Params',
    [
      mojo.internal.StructField<Observer_OnSourcesChanged_ParamsMojoType, WebUISource[]>(
        'sources', 0,
        0,
        mojo.internal.Array(WebUISourceSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnReportsChanged_ParamsMojoType {
  reports: WebUIReport[];
}


export type Observer_OnReportsChanged_Params = Observer_OnReportsChanged_ParamsMojoType;
mojo.internal.Struct<Observer_OnReportsChanged_ParamsMojoType>(
    Observer_OnReportsChanged_ParamsSpec.$,
    'Observer_OnReportsChanged_Params',
    [
      mojo.internal.StructField<Observer_OnReportsChanged_ParamsMojoType, WebUIReport[]>(
        'reports', 0,
        0,
        mojo.internal.Array(WebUIReportSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnSourceHandled_ParamsMojoType {
  source: WebUISourceRegistration;
}


export type Observer_OnSourceHandled_Params = Observer_OnSourceHandled_ParamsMojoType;
mojo.internal.Struct<Observer_OnSourceHandled_ParamsMojoType>(
    Observer_OnSourceHandled_ParamsSpec.$,
    'Observer_OnSourceHandled_Params',
    [
      mojo.internal.StructField<Observer_OnSourceHandled_ParamsMojoType, WebUISourceRegistration>(
        'source', 0,
        0,
        WebUISourceRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnReportHandled_ParamsMojoType {
  report: WebUIReport;
}


export type Observer_OnReportHandled_Params = Observer_OnReportHandled_ParamsMojoType;
mojo.internal.Struct<Observer_OnReportHandled_ParamsMojoType>(
    Observer_OnReportHandled_ParamsSpec.$,
    'Observer_OnReportHandled_Params',
    [
      mojo.internal.StructField<Observer_OnReportHandled_ParamsMojoType, WebUIReport>(
        'report', 0,
        0,
        WebUIReportSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnDebugReportSent_ParamsMojoType {
  report: WebUIDebugReport;
}


export type Observer_OnDebugReportSent_Params = Observer_OnDebugReportSent_ParamsMojoType;
mojo.internal.Struct<Observer_OnDebugReportSent_ParamsMojoType>(
    Observer_OnDebugReportSent_ParamsSpec.$,
    'Observer_OnDebugReportSent_Params',
    [
      mojo.internal.StructField<Observer_OnDebugReportSent_ParamsMojoType, WebUIDebugReport>(
        'report', 0,
        0,
        WebUIDebugReportSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnAggregatableDebugReportSent_ParamsMojoType {
  report: WebUIAggregatableDebugReport;
}


export type Observer_OnAggregatableDebugReportSent_Params = Observer_OnAggregatableDebugReportSent_ParamsMojoType;
mojo.internal.Struct<Observer_OnAggregatableDebugReportSent_ParamsMojoType>(
    Observer_OnAggregatableDebugReportSent_ParamsSpec.$,
    'Observer_OnAggregatableDebugReportSent_Params',
    [
      mojo.internal.StructField<Observer_OnAggregatableDebugReportSent_ParamsMojoType, WebUIAggregatableDebugReport>(
        'report', 0,
        0,
        WebUIAggregatableDebugReportSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnTriggerHandled_ParamsMojoType {
  trigger: WebUITrigger;
}


export type Observer_OnTriggerHandled_Params = Observer_OnTriggerHandled_ParamsMojoType;
mojo.internal.Struct<Observer_OnTriggerHandled_ParamsMojoType>(
    Observer_OnTriggerHandled_ParamsSpec.$,
    'Observer_OnTriggerHandled_Params',
    [
      mojo.internal.StructField<Observer_OnTriggerHandled_ParamsMojoType, WebUITrigger>(
        'trigger', 0,
        0,
        WebUITriggerSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnOsRegistration_ParamsMojoType {
  registration: WebUIOsRegistration;
}


export type Observer_OnOsRegistration_Params = Observer_OnOsRegistration_ParamsMojoType;
mojo.internal.Struct<Observer_OnOsRegistration_ParamsMojoType>(
    Observer_OnOsRegistration_ParamsSpec.$,
    'Observer_OnOsRegistration_Params',
    [
      mojo.internal.StructField<Observer_OnOsRegistration_ParamsMojoType, WebUIOsRegistration>(
        'registration', 0,
        0,
        WebUIOsRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Observer_OnDebugModeChanged_ParamsMojoType {
  debugMode: boolean;
}


export type Observer_OnDebugModeChanged_Params = Observer_OnDebugModeChanged_ParamsMojoType;
mojo.internal.Struct<Observer_OnDebugModeChanged_ParamsMojoType>(
    Observer_OnDebugModeChanged_ParamsSpec.$,
    'Observer_OnDebugModeChanged_Params',
    [
      mojo.internal.StructField<Observer_OnDebugModeChanged_ParamsMojoType, boolean>(
        'debugMode', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_IsAttributionReportingEnabled_ParamsMojoType {
}


export type Handler_IsAttributionReportingEnabled_Params = Handler_IsAttributionReportingEnabled_ParamsMojoType;
mojo.internal.Struct<Handler_IsAttributionReportingEnabled_ParamsMojoType>(
    Handler_IsAttributionReportingEnabled_ParamsSpec.$,
    'Handler_IsAttributionReportingEnabled_Params',
    [
    ],
    [[0, 8],]);





export interface Handler_IsAttributionReportingEnabled_ResponseParamsMojoType {
  enabled: boolean;
  attributionSupport: network_mojom_AttributionSupport;
}


export type Handler_IsAttributionReportingEnabled_ResponseParams = Handler_IsAttributionReportingEnabled_ResponseParamsMojoType;
mojo.internal.Struct<Handler_IsAttributionReportingEnabled_ResponseParamsMojoType>(
    Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,
    'Handler_IsAttributionReportingEnabled_ResponseParams',
    [
      mojo.internal.StructField<Handler_IsAttributionReportingEnabled_ResponseParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Handler_IsAttributionReportingEnabled_ResponseParamsMojoType, network_mojom_AttributionSupport>(
        'attributionSupport', 4,
        0,
        network_mojom_AttributionSupportSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_SendReport_ParamsMojoType {
  id: ReportID;
}


export type Handler_SendReport_Params = Handler_SendReport_ParamsMojoType;
mojo.internal.Struct<Handler_SendReport_ParamsMojoType>(
    Handler_SendReport_ParamsSpec.$,
    'Handler_SendReport_Params',
    [
      mojo.internal.StructField<Handler_SendReport_ParamsMojoType, ReportID>(
        'id', 0,
        0,
        ReportIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_SendReport_ResponseParamsMojoType {
}


export type Handler_SendReport_ResponseParams = Handler_SendReport_ResponseParamsMojoType;
mojo.internal.Struct<Handler_SendReport_ResponseParamsMojoType>(
    Handler_SendReport_ResponseParamsSpec.$,
    'Handler_SendReport_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface Handler_ClearStorage_ParamsMojoType {
}


export type Handler_ClearStorage_Params = Handler_ClearStorage_ParamsMojoType;
mojo.internal.Struct<Handler_ClearStorage_ParamsMojoType>(
    Handler_ClearStorage_ParamsSpec.$,
    'Handler_ClearStorage_Params',
    [
    ],
    [[0, 8],]);





export interface Handler_ClearStorage_ResponseParamsMojoType {
}


export type Handler_ClearStorage_ResponseParams = Handler_ClearStorage_ResponseParamsMojoType;
mojo.internal.Struct<Handler_ClearStorage_ResponseParamsMojoType>(
    Handler_ClearStorage_ResponseParamsSpec.$,
    'Handler_ClearStorage_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface Factory_Create_ParamsMojoType {
  observer: ObserverRemote;
  handler: HandlerPendingReceiver;
}


export type Factory_Create_Params = Factory_Create_ParamsMojoType;
mojo.internal.Struct<Factory_Create_ParamsMojoType>(
    Factory_Create_ParamsSpec.$,
    'Factory_Create_Params',
    [
      mojo.internal.StructField<Factory_Create_ParamsMojoType, ObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Factory_Create_ParamsMojoType, HandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(HandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



mojo.internal.Union(
    WebUIReportDataSpec.$, 'WebUIReportData',
    {
      'eventLevelData': {
        'ordinal': 0,
        'type': WebUIReportEventLevelDataSpec.$,
      },
      'aggregatableAttributionData': {
        'ordinal': 1,
        'type': WebUIReportAggregatableAttributionDataSpec.$,
      },
    });

export interface WebUIReportData {
  eventLevelData?: WebUIReportEventLevelData,
  aggregatableAttributionData?: WebUIReportAggregatableAttributionData,
}

export enum WebUIReportDataFieldTags {
  EVENT_LEVEL_DATA,
  AGGREGATABLE_ATTRIBUTION_DATA,
}

export function whichWebUIReportData(u: WebUIReportData): WebUIReportDataFieldTags {
  if (u.eventLevelData !== null && u.eventLevelData !== undefined) {
    return WebUIReportDataFieldTags.EVENT_LEVEL_DATA;
  }
  if (u.aggregatableAttributionData !== null && u.aggregatableAttributionData !== undefined) {
    return WebUIReportDataFieldTags.AGGREGATABLE_ATTRIBUTION_DATA;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    NetworkStatusSpec.$, 'NetworkStatus',
    {
      'httpResponseCode': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
      },
      'networkError': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

export interface NetworkStatus {
  httpResponseCode?: number,
  networkError?: string,
}

export enum NetworkStatusFieldTags {
  HTTP_RESPONSE_CODE,
  NETWORK_ERROR,
}

export function whichNetworkStatus(u: NetworkStatus): NetworkStatusFieldTags {
  if (u.httpResponseCode !== null && u.httpResponseCode !== undefined) {
    return NetworkStatusFieldTags.HTTP_RESPONSE_CODE;
  }
  if (u.networkError !== null && u.networkError !== undefined) {
    return NetworkStatusFieldTags.NETWORK_ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    ReportStatusSpec.$, 'ReportStatus',
    {
      'pending': {
        'ordinal': 0,
        'type': EmptySpec.$,
      },
      'replacedByHigherPriorityReport': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'prohibitedByBrowserPolicy': {
        'ordinal': 2,
        'type': EmptySpec.$,
      },
      'expired': {
        'ordinal': 3,
        'type': EmptySpec.$,
      },
      'networkStatus': {
        'ordinal': 4,
        'type': NetworkStatusSpec.$,
      },
      'failedToAssemble': {
        'ordinal': 5,
        'type': EmptySpec.$,
      },
    });

export interface ReportStatus {
  pending?: Empty,
  replacedByHigherPriorityReport?: string,
  prohibitedByBrowserPolicy?: Empty,
  expired?: Empty,
  networkStatus?: NetworkStatus,
  failedToAssemble?: Empty,
}

export enum ReportStatusFieldTags {
  PENDING,
  REPLACED_BY_HIGHER_PRIORITY_REPORT,
  PROHIBITED_BY_BROWSER_POLICY,
  EXPIRED,
  NETWORK_STATUS,
  FAILED_TO_ASSEMBLE,
}

export function whichReportStatus(u: ReportStatus): ReportStatusFieldTags {
  if (u.pending !== null && u.pending !== undefined) {
    return ReportStatusFieldTags.PENDING;
  }
  if (u.replacedByHigherPriorityReport !== null && u.replacedByHigherPriorityReport !== undefined) {
    return ReportStatusFieldTags.REPLACED_BY_HIGHER_PRIORITY_REPORT;
  }
  if (u.prohibitedByBrowserPolicy !== null && u.prohibitedByBrowserPolicy !== undefined) {
    return ReportStatusFieldTags.PROHIBITED_BY_BROWSER_POLICY;
  }
  if (u.expired !== null && u.expired !== undefined) {
    return ReportStatusFieldTags.EXPIRED;
  }
  if (u.networkStatus !== null && u.networkStatus !== undefined) {
    return ReportStatusFieldTags.NETWORK_STATUS;
  }
  if (u.failedToAssemble !== null && u.failedToAssemble !== undefined) {
    return ReportStatusFieldTags.FAILED_TO_ASSEMBLE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    SendAggregatableDebugReportResultSpec.$, 'SendAggregatableDebugReportResult',
    {
      'assemblyFailed': {
        'ordinal': 0,
        'type': EmptySpec.$,
      },
      'networkStatus': {
        'ordinal': 1,
        'type': NetworkStatusSpec.$,
      },
    });

export interface SendAggregatableDebugReportResult {
  assemblyFailed?: Empty,
  networkStatus?: NetworkStatus,
}

export enum SendAggregatableDebugReportResultFieldTags {
  ASSEMBLY_FAILED,
  NETWORK_STATUS,
}

export function whichSendAggregatableDebugReportResult(u: SendAggregatableDebugReportResult): SendAggregatableDebugReportResultFieldTags {
  if (u.assemblyFailed !== null && u.assemblyFailed !== undefined) {
    return SendAggregatableDebugReportResultFieldTags.ASSEMBLY_FAILED;
  }
  if (u.networkStatus !== null && u.networkStatus !== undefined) {
    return SendAggregatableDebugReportResultFieldTags.NETWORK_STATUS;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
