// content/browser/attribution_reporting/attribution_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "content/browser/attribution_reporting/attribution_internals.mojom-shared-internal.h"
#include "components/attribution_reporting/registration.mojom-shared.h"
#include "components/attribution_reporting/source_type.mojom-shared.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-shared.h"
#include "content/browser/attribution_reporting/aggregatable_result.mojom-shared.h"
#include "content/browser/attribution_reporting/process_aggregatable_debug_report_result.mojom-shared.h"
#include "content/browser/attribution_reporting/attribution_reporting.mojom-shared.h"
#include "content/browser/attribution_reporting/event_level_result.mojom-shared.h"
#include "content/browser/attribution_reporting/store_source_result.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::ReportIDDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::ReportIDDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::ReportID_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIReportEventLevelDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIReportEventLevelDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIReportEventLevelData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->priority = Traits::priority(input);

      fragment->attributed_truthfully = Traits::attributed_truthfully(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::AggregatableHistogramContributionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::AggregatableHistogramContributionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::AggregatableHistogramContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in AggregatableHistogramContribution struct");

      fragment->value = Traits::value(input);

      fragment->filtering_id = Traits::filtering_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIReportAggregatableAttributionDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIReportAggregatableAttributionDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIReportAggregatableAttributionData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::contributions(input)) in_contributions = Traits::contributions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contributions)::BaseType>
          contributions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_internals::mojom::AggregatableHistogramContributionDataView>, send_validation>(
        in_contributions,
        contributions_fragment,
        &contributions_validate_params);

      fragment->contributions.Set(
          contributions_fragment.is_null() ? nullptr : contributions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contributions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contributions in WebUIReportAggregatableAttributionData struct");

      decltype(Traits::aggregation_coordinator(input)) in_aggregation_coordinator = Traits::aggregation_coordinator(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_coordinator)::BaseType> aggregation_coordinator_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_aggregation_coordinator,
        aggregation_coordinator_fragment);

      fragment->aggregation_coordinator.Set(
          aggregation_coordinator_fragment.is_null() ? nullptr : aggregation_coordinator_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregation_coordinator.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregation_coordinator in WebUIReportAggregatableAttributionData struct");

      fragment->is_null_report = Traits::is_null_report(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::EmptyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::EmptyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::Empty_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_internals::mojom::ReportIDDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in WebUIReport struct");

      decltype(Traits::report_url(input)) in_report_url = Traits::report_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_url)::BaseType> report_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_report_url,
        report_url_fragment);

      fragment->report_url.Set(
          report_url_fragment.is_null() ? nullptr : report_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_url in WebUIReport struct");

      fragment->trigger_time = Traits::trigger_time(input);

      fragment->report_time = Traits::report_time(input);

      decltype(Traits::report_body(input)) in_report_body = Traits::report_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_body)::BaseType> report_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_report_body,
        report_body_fragment);

      fragment->report_body.Set(
          report_body_fragment.is_null() ? nullptr : report_body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_body in WebUIReport struct");

      decltype(Traits::status(input)) in_status = Traits::status(input);
      mojo::internal::MessageFragment<decltype(fragment->status)>
          status_fragment(fragment.message());
      status_fragment.Claim(&fragment->status);
      
      mojo::internal::Serialize<::attribution_internals::mojom::ReportStatusDataView, send_validation>(
        in_status,
        status_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->status.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in WebUIReport struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::attribution_internals::mojom::WebUIReportDataDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in WebUIReport struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIDebugReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIDebugReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIDebugReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebUIDebugReport struct");

      fragment->time = Traits::time(input);

      decltype(Traits::body(input)) in_body = Traits::body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->body)::BaseType> body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_body,
        body_fragment);

      fragment->body.Set(
          body_fragment.is_null() ? nullptr : body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in WebUIDebugReport struct");

      decltype(Traits::status(input)) in_status = Traits::status(input);
      mojo::internal::MessageFragment<decltype(fragment->status)>
          status_fragment(fragment.message());
      status_fragment.Claim(&fragment->status);
      
      mojo::internal::Serialize<::attribution_internals::mojom::NetworkStatusDataView, send_validation>(
        in_status,
        status_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->status.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in WebUIDebugReport struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIAggregatableDebugReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIAggregatableDebugReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIAggregatableDebugReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebUIAggregatableDebugReport struct");

      fragment->time = Traits::time(input);

      decltype(Traits::body(input)) in_body = Traits::body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->body)::BaseType> body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_body,
        body_fragment);

      fragment->body.Set(
          body_fragment.is_null() ? nullptr : body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in WebUIAggregatableDebugReport struct");

      
      mojo::internal::Serialize<::attribution_reporting::mojom::ProcessAggregatableDebugReportResult>(
        Traits::process_result(input),
        &fragment->process_result);

      decltype(Traits::send_result(input)) in_send_result = Traits::send_result(input);
      mojo::internal::MessageFragment<decltype(fragment->send_result)>
          send_result_fragment(fragment.message());
      send_result_fragment.Claim(&fragment->send_result);
      
      mojo::internal::Serialize<::attribution_internals::mojom::SendAggregatableDebugReportResultDataView, send_validation>(
        in_send_result,
        send_result_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->send_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null send_result in WebUIAggregatableDebugReport struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUISourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUISourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUISource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->source_event_id = Traits::source_event_id(input);

      decltype(Traits::source_origin(input)) in_source_origin = Traits::source_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_origin)::BaseType> source_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_source_origin,
        source_origin_fragment);

      fragment->source_origin.Set(
          source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_origin in WebUISource struct");

      decltype(Traits::destinations(input)) in_destinations = Traits::destinations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destinations)::BaseType> destinations_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::DestinationSetDataView, send_validation>(
        in_destinations,
        destinations_fragment);

      fragment->destinations.Set(
          destinations_fragment.is_null() ? nullptr : destinations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destinations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destinations in WebUISource struct");

      decltype(Traits::reporting_origin(input)) in_reporting_origin = Traits::reporting_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_origin)::BaseType> reporting_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_reporting_origin,
        reporting_origin_fragment);

      fragment->reporting_origin.Set(
          reporting_origin_fragment.is_null() ? nullptr : reporting_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reporting_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_origin in WebUISource struct");

      fragment->source_time = Traits::source_time(input);

      fragment->expiry_time = Traits::expiry_time(input);

      decltype(Traits::event_report_windows(input)) in_event_report_windows = Traits::event_report_windows(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_report_windows)::BaseType> event_report_windows_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::EventReportWindowsDataView, send_validation>(
        in_event_report_windows,
        event_report_windows_fragment);

      fragment->event_report_windows.Set(
          event_report_windows_fragment.is_null() ? nullptr : event_report_windows_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_report_windows.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_report_windows in WebUISource struct");

      decltype(Traits::trigger_data(input)) in_trigger_data = Traits::trigger_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trigger_data)::BaseType>
          trigger_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trigger_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_trigger_data,
        trigger_data_fragment,
        &trigger_data_validate_params);

      fragment->trigger_data.Set(
          trigger_data_fragment.is_null() ? nullptr : trigger_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trigger_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trigger_data in WebUISource struct");

      fragment->max_event_level_reports = Traits::max_event_level_reports(input);

      fragment->aggregatable_report_window_time = Traits::aggregatable_report_window_time(input);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::SourceType>(
        Traits::source_type(input),
        &fragment->source_type);

      fragment->priority = Traits::priority(input);
      fragment->debug_key_$flag = Traits::debug_key(input).has_value();
      if (Traits::debug_key(input).has_value()) {
        fragment->debug_key_$value = Traits::debug_key(input).value();
      }

      decltype(Traits::dedup_keys(input)) in_dedup_keys = Traits::dedup_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dedup_keys)::BaseType>
          dedup_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& dedup_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>, send_validation>(
        in_dedup_keys,
        dedup_keys_fragment,
        &dedup_keys_validate_params);

      fragment->dedup_keys.Set(
          dedup_keys_fragment.is_null() ? nullptr : dedup_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dedup_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dedup_keys in WebUISource struct");

      decltype(Traits::filter_data(input)) in_filter_data = Traits::filter_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filter_data)::BaseType> filter_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterDataDataView, send_validation>(
        in_filter_data,
        filter_data_fragment);

      fragment->filter_data.Set(
          filter_data_fragment.is_null() ? nullptr : filter_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filter_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filter_data in WebUISource struct");

      decltype(Traits::aggregation_keys(input)) in_aggregation_keys = Traits::aggregation_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_keys)::BaseType>
          aggregation_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregation_keys_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_aggregation_keys,
        aggregation_keys_fragment,
        &aggregation_keys_validate_params);

      fragment->aggregation_keys.Set(
          aggregation_keys_fragment.is_null() ? nullptr : aggregation_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregation_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregation_keys in WebUISource struct");

      fragment->remaining_aggregatable_attribution_budget = Traits::remaining_aggregatable_attribution_budget(input);

      decltype(Traits::aggregatable_dedup_keys(input)) in_aggregatable_dedup_keys = Traits::aggregatable_dedup_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_dedup_keys)::BaseType>
          aggregatable_dedup_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregatable_dedup_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>, send_validation>(
        in_aggregatable_dedup_keys,
        aggregatable_dedup_keys_fragment,
        &aggregatable_dedup_keys_validate_params);

      fragment->aggregatable_dedup_keys.Set(
          aggregatable_dedup_keys_fragment.is_null() ? nullptr : aggregatable_dedup_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_dedup_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_dedup_keys in WebUISource struct");

      
      mojo::internal::Serialize<::attribution_reporting::mojom::TriggerDataMatching>(
        Traits::trigger_data_matching(input),
        &fragment->trigger_data_matching);

      fragment->event_level_epsilon = Traits::event_level_epsilon(input);

      fragment->cookie_based_debug_allowed = Traits::cookie_based_debug_allowed(input);

      fragment->remaining_aggregatable_debug_budget = Traits::remaining_aggregatable_debug_budget(input);

      decltype(Traits::aggregatable_debug_key_piece(input)) in_aggregatable_debug_key_piece = Traits::aggregatable_debug_key_piece(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_debug_key_piece)::BaseType> aggregatable_debug_key_piece_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_aggregatable_debug_key_piece,
        aggregatable_debug_key_piece_fragment);

      fragment->aggregatable_debug_key_piece.Set(
          aggregatable_debug_key_piece_fragment.is_null() ? nullptr : aggregatable_debug_key_piece_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_debug_key_piece.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_debug_key_piece in WebUISource struct");

      decltype(Traits::attribution_scopes_data_json(input)) in_attribution_scopes_data_json = Traits::attribution_scopes_data_json(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attribution_scopes_data_json)::BaseType> attribution_scopes_data_json_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_attribution_scopes_data_json,
        attribution_scopes_data_json_fragment);

      fragment->attribution_scopes_data_json.Set(
          attribution_scopes_data_json_fragment.is_null() ? nullptr : attribution_scopes_data_json_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attribution_scopes_data_json.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribution_scopes_data_json in WebUISource struct");

      decltype(Traits::aggregatable_named_budgets(input)) in_aggregatable_named_budgets = Traits::aggregatable_named_budgets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_named_budgets)::BaseType> aggregatable_named_budgets_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_aggregatable_named_budgets,
        aggregatable_named_budgets_fragment);

      fragment->aggregatable_named_budgets.Set(
          aggregatable_named_budgets_fragment.is_null() ? nullptr : aggregatable_named_budgets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_named_budgets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_named_budgets in WebUISource struct");

      
      mojo::internal::Serialize<::attribution_internals::mojom::WebUISource_Attributability>(
        Traits::attributability(input),
        &fragment->attributability);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->time = Traits::time(input);

      decltype(Traits::context_origin(input)) in_context_origin = Traits::context_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->context_origin)::BaseType> context_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_context_origin,
        context_origin_fragment);

      fragment->context_origin.Set(
          context_origin_fragment.is_null() ? nullptr : context_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->context_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null context_origin in WebUIRegistration struct");

      decltype(Traits::reporting_origin(input)) in_reporting_origin = Traits::reporting_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_origin)::BaseType> reporting_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_reporting_origin,
        reporting_origin_fragment);

      fragment->reporting_origin.Set(
          reporting_origin_fragment.is_null() ? nullptr : reporting_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reporting_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_origin in WebUIRegistration struct");

      decltype(Traits::registration_json(input)) in_registration_json = Traits::registration_json(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->registration_json)::BaseType> registration_json_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_registration_json,
        registration_json_fragment);

      fragment->registration_json.Set(
          registration_json_fragment.is_null() ? nullptr : registration_json_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->registration_json.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration_json in WebUIRegistration struct");
      fragment->cleared_debug_key_$flag = Traits::cleared_debug_key(input).has_value();
      if (Traits::cleared_debug_key(input).has_value()) {
        fragment->cleared_debug_key_$value = Traits::cleared_debug_key(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUITriggerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUITriggerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUITrigger_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::registration(input)) in_registration = Traits::registration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->registration)::BaseType> registration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_internals::mojom::WebUIRegistrationDataView, send_validation>(
        in_registration,
        registration_fragment);

      fragment->registration.Set(
          registration_fragment.is_null() ? nullptr : registration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->registration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration in WebUITrigger struct");

      
      mojo::internal::Serialize<::attribution_reporting::mojom::EventLevelResult>(
        Traits::event_level_result(input),
        &fragment->event_level_result);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::AggregatableResult>(
        Traits::aggregatable_result(input),
        &fragment->aggregatable_result);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUISourceRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUISourceRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUISourceRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::registration(input)) in_registration = Traits::registration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->registration)::BaseType> registration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_internals::mojom::WebUIRegistrationDataView, send_validation>(
        in_registration,
        registration_fragment);

      fragment->registration.Set(
          registration_fragment.is_null() ? nullptr : registration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->registration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration in WebUISourceRegistration struct");

      
      mojo::internal::Serialize<::attribution_reporting::mojom::SourceType>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::StoreSourceResult>(
        Traits::status(input),
        &fragment->status);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIOsRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_internals::mojom::WebUIOsRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_internals::mojom::internal::WebUIOsRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->time = Traits::time(input);

      decltype(Traits::registration_url(input)) in_registration_url = Traits::registration_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->registration_url)::BaseType> registration_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_registration_url,
        registration_url_fragment);

      fragment->registration_url.Set(
          registration_url_fragment.is_null() ? nullptr : registration_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->registration_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration_url in WebUIOsRegistration struct");

      decltype(Traits::top_level_origin(input)) in_top_level_origin = Traits::top_level_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_level_origin)::BaseType> top_level_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_top_level_origin,
        top_level_origin_fragment);

      fragment->top_level_origin.Set(
          top_level_origin_fragment.is_null() ? nullptr : top_level_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_level_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_level_origin in WebUIOsRegistration struct");

      fragment->is_debug_key_allowed = Traits::is_debug_key_allowed(input);

      fragment->debug_reporting = Traits::debug_reporting(input);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationType>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationResult>(
        Traits::result(input),
        &fragment->result);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::WebUIReportDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_internals::mojom::WebUIReportDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_internals::mojom::internal::WebUIReportData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_internals::mojom::WebUIReportDataDataView::Tag::kEventLevelData: {
    decltype(Traits::event_level_data(input))
    in_event_level_data = Traits::event_level_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_event_level_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::WebUIReportEventLevelDataDataView, send_validation>(
  in_event_level_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null event_level_data in WebUIReportData union");
    fragment->data.f_event_level_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::WebUIReportDataDataView::Tag::kAggregatableAttributionData: {
    decltype(Traits::aggregatable_attribution_data(input))
    in_aggregatable_attribution_data = Traits::aggregatable_attribution_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_aggregatable_attribution_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::WebUIReportAggregatableAttributionDataDataView, send_validation>(
  in_aggregatable_attribution_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null aggregatable_attribution_data in WebUIReportData union");
    fragment->data.f_aggregatable_attribution_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::NetworkStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_internals::mojom::NetworkStatusDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_internals::mojom::internal::NetworkStatus_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_internals::mojom::NetworkStatusDataView::Tag::kHttpResponseCode: {
    decltype(Traits::http_response_code(input))
    in_http_response_code = Traits::http_response_code(input);
    fragment->data.f_http_response_code = in_http_response_code;
    break;
  }
  case ::attribution_internals::mojom::NetworkStatusDataView::Tag::kNetworkError: {
    decltype(Traits::network_error(input))
    in_network_error = Traits::network_error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_network_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_network_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null network_error in NetworkStatus union");
    fragment->data.f_network_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::ReportStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_internals::mojom::ReportStatusDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_internals::mojom::internal::ReportStatus_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kPending: {
    decltype(Traits::pending(input))
    in_pending = Traits::pending(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pending)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::EmptyDataView, send_validation>(
  in_pending,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pending in ReportStatus union");
    fragment->data.f_pending.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kReplacedByHigherPriorityReport: {
    decltype(Traits::replaced_by_higher_priority_report(input))
    in_replaced_by_higher_priority_report = Traits::replaced_by_higher_priority_report(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_replaced_by_higher_priority_report)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_replaced_by_higher_priority_report,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null replaced_by_higher_priority_report in ReportStatus union");
    fragment->data.f_replaced_by_higher_priority_report.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kProhibitedByBrowserPolicy: {
    decltype(Traits::prohibited_by_browser_policy(input))
    in_prohibited_by_browser_policy = Traits::prohibited_by_browser_policy(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_prohibited_by_browser_policy)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::EmptyDataView, send_validation>(
  in_prohibited_by_browser_policy,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null prohibited_by_browser_policy in ReportStatus union");
    fragment->data.f_prohibited_by_browser_policy.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kExpired: {
    decltype(Traits::expired(input))
    in_expired = Traits::expired(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_expired)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::EmptyDataView, send_validation>(
  in_expired,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null expired in ReportStatus union");
    fragment->data.f_expired.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kNetworkStatus: {
    decltype(Traits::network_status(input))
    in_network_status = Traits::network_status(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_network_status)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::attribution_internals::mojom::NetworkStatusDataView, send_validation>(
  in_network_status,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null network_status in ReportStatus union");
    fragment->data.f_network_status.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::ReportStatusDataView::Tag::kFailedToAssemble: {
    decltype(Traits::failed_to_assemble(input))
    in_failed_to_assemble = Traits::failed_to_assemble(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failed_to_assemble)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::EmptyDataView, send_validation>(
  in_failed_to_assemble,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failed_to_assemble in ReportStatus union");
    fragment->data.f_failed_to_assemble.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::attribution_internals::mojom::SendAggregatableDebugReportResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_internals::mojom::SendAggregatableDebugReportResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_internals::mojom::internal::SendAggregatableDebugReportResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_internals::mojom::SendAggregatableDebugReportResultDataView::Tag::kAssemblyFailed: {
    decltype(Traits::assembly_failed(input))
    in_assembly_failed = Traits::assembly_failed(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_assembly_failed)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::attribution_internals::mojom::EmptyDataView, send_validation>(
  in_assembly_failed,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null assembly_failed in SendAggregatableDebugReportResult union");
    fragment->data.f_assembly_failed.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::attribution_internals::mojom::SendAggregatableDebugReportResultDataView::Tag::kNetworkStatus: {
    decltype(Traits::network_status(input))
    in_network_status = Traits::network_status(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_network_status)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::attribution_internals::mojom::NetworkStatusDataView, send_validation>(
  in_network_status,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null network_status in SendAggregatableDebugReportResult union");
    fragment->data.f_network_status.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SEND_VALIDATION_H_