/**
 * `enabled` is only set if the feature is single valued.
 * `enabled` is true if the feature is currently enabled.
 * `is_default` is true if the feature is in its default state.
 * `options` is only set if the entry has multiple values.
 */
export interface Feature {
    internal_name: string;
    name: string;
    description: string;
    enabled: boolean;
    is_default: boolean;
    supported_platforms: string[];
    origin_list_value?: string;
    string_value?: string;
    options?: Array<{
        internal_name: string;
        description: string;
        selected: boolean;
    }>;
    links?: string[];
}
export interface ExperimentalFeaturesData {
    supportedFeatures: Feature[];
    unsupportedFeatures: Feature[];
    needsRestart: boolean;
    showBetaChannelPromotion: boolean;
    showDevChannelPromotion: boolean;
}
export interface FlagsBrowserProxy {
    restartBrowser(): void;
    requestDeprecatedFeatures(): Promise<ExperimentalFeaturesData>;
    resetAllFlags(): void;
    requestExperimentalFeatures(): Promise<ExperimentalFeaturesData>;
    enableExperimentalFeature(internalName: string, enable: boolean): void;
    selectExperimentalFeature(internalName: string, index: number): void;
    setOriginListFlag(internalName: string, value: string): void;
    setStringFlag(internalName: string, value: string): void;
}
export declare class FlagsBrowserProxyImpl implements FlagsBrowserProxy {
    restartBrowser(): void;
    requestDeprecatedFeatures(): Promise<any>;
    resetAllFlags(): void;
    requestExperimentalFeatures(): Promise<any>;
    enableExperimentalFeature(internalName: string, enable: boolean): void;
    selectExperimentalFeature(internalName: string, index: number): void;
    setOriginListFlag(internalName: string, value: string): void;
    setStringFlag(internalName: string, value: string): void;
    static getInstance(): FlagsBrowserProxy;
    static setInstance(obj: FlagsBrowserProxy): void;
}
