// components/webui/chrome_urls/mojom/chrome_urls.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_H_
#define COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-features.h"  // IWYU pragma: export
#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-shared.h"  // IWYU pragma: export
#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome_urls::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome_urls.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome_urls.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetUrlsMinVersion = 0,
    kSetDebugPagesEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDebugPagesEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetUrlsCallback = base::OnceCallback<void(ChromeUrlsDataPtr)>;
  using GetUrlsMojoCallback = base::OnceCallback<void(ChromeUrlsDataPtr)>;

  virtual void GetUrls(GetUrlsCallback callback) = 0;

  using SetDebugPagesEnabledCallback = base::OnceCallback<void()>;
  using SetDebugPagesEnabledMojoCallback = base::OnceCallback<void()>;

  virtual void SetDebugPagesEnabled(bool enabled, SetDebugPagesEnabledCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome_urls.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetUrls(GetUrlsCallback callback) final;
  
  void SetDebugPagesEnabled(bool enabled, SetDebugPagesEnabledCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  WebuiUrlInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebuiUrlInfo, T>::value>;
  using DataView = WebuiUrlInfoDataView;
  using Data_ = internal::WebuiUrlInfo_Data;

  template <typename... Args>
  static WebuiUrlInfoPtr New(Args&&... args) {
    return WebuiUrlInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebuiUrlInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebuiUrlInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebuiUrlInfo>::Convert(*this);
  }


  WebuiUrlInfo();

  WebuiUrlInfo(
      const ::GURL& url,
      bool enabled,
      bool internal);


  ~WebuiUrlInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebuiUrlInfoPtr>
  WebuiUrlInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebuiUrlInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebuiUrlInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebuiUrlInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebuiUrlInfo_UnserializedMessageContext<
            UserType, WebuiUrlInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebuiUrlInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebuiUrlInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebuiUrlInfo_UnserializedMessageContext<
            UserType, WebuiUrlInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebuiUrlInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  bool enabled;
  
  bool internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebuiUrlInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ChromeUrlsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeUrlsData, T>::value>;
  using DataView = ChromeUrlsDataDataView;
  using Data_ = internal::ChromeUrlsData_Data;

  template <typename... Args>
  static ChromeUrlsDataPtr New(Args&&... args) {
    return ChromeUrlsDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeUrlsDataPtr From(const U& u) {
    return mojo::TypeConverter<ChromeUrlsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeUrlsData>::Convert(*this);
  }


  ChromeUrlsData();

  ChromeUrlsData(
      std::vector<WebuiUrlInfoPtr> webui_urls,
      std::vector<::GURL> command_urls,
      bool internal_debugging_uis_enabled);

ChromeUrlsData(const ChromeUrlsData&) = delete;
ChromeUrlsData& operator=(const ChromeUrlsData&) = delete;

  ~ChromeUrlsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeUrlsDataPtr>
  ChromeUrlsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeUrlsData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeUrlsData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeUrlsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeUrlsData_UnserializedMessageContext<
            UserType, ChromeUrlsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChromeUrlsData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChromeUrlsData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeUrlsData_UnserializedMessageContext<
            UserType, ChromeUrlsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeUrlsData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WebuiUrlInfoPtr> webui_urls;
  
  std::vector<::GURL> command_urls;
  
  bool internal_debugging_uis_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeUrlsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebuiUrlInfoPtr WebuiUrlInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(enabled),
      mojo::Clone(internal)
  );
}

template <typename T, WebuiUrlInfo::EnableIfSame<T>*>
bool WebuiUrlInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->enabled, other_struct.enabled))
    return false;
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, WebuiUrlInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.enabled < rhs.enabled)
    return true;
  if (rhs.enabled < lhs.enabled)
    return false;
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
ChromeUrlsDataPtr ChromeUrlsData::Clone() const {
  return New(
      mojo::Clone(webui_urls),
      mojo::Clone(command_urls),
      mojo::Clone(internal_debugging_uis_enabled)
  );
}

template <typename T, ChromeUrlsData::EnableIfSame<T>*>
bool ChromeUrlsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->webui_urls, other_struct.webui_urls))
    return false;
  if (!mojo::Equals(this->command_urls, other_struct.command_urls))
    return false;
  if (!mojo::Equals(this->internal_debugging_uis_enabled, other_struct.internal_debugging_uis_enabled))
    return false;
  return true;
}

template <typename T, ChromeUrlsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.webui_urls < rhs.webui_urls)
    return true;
  if (rhs.webui_urls < lhs.webui_urls)
    return false;
  if (lhs.command_urls < rhs.command_urls)
    return true;
  if (rhs.command_urls < lhs.command_urls)
    return false;
  if (lhs.internal_debugging_uis_enabled < rhs.internal_debugging_uis_enabled)
    return true;
  if (rhs.internal_debugging_uis_enabled < lhs.internal_debugging_uis_enabled)
    return false;
  return false;
}


}  // chrome_urls::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome_urls::mojom::WebuiUrlInfo::DataView,
                                         ::chrome_urls::mojom::WebuiUrlInfoPtr> {
  static bool IsNull(const ::chrome_urls::mojom::WebuiUrlInfoPtr& input) { return !input; }
  static void SetToNull(::chrome_urls::mojom::WebuiUrlInfoPtr* output) { output->reset(); }

  static const decltype(::chrome_urls::mojom::WebuiUrlInfo::url)& url(
      const ::chrome_urls::mojom::WebuiUrlInfoPtr& input) {
    return input->url;
  }

  static decltype(::chrome_urls::mojom::WebuiUrlInfo::enabled) enabled(
      const ::chrome_urls::mojom::WebuiUrlInfoPtr& input) {
    return input->enabled;
  }

  static decltype(::chrome_urls::mojom::WebuiUrlInfo::internal) internal(
      const ::chrome_urls::mojom::WebuiUrlInfoPtr& input) {
    return input->internal;
  }

  static bool Read(::chrome_urls::mojom::WebuiUrlInfo::DataView input, ::chrome_urls::mojom::WebuiUrlInfoPtr* output);
};


template <>
struct  StructTraits<::chrome_urls::mojom::ChromeUrlsData::DataView,
                                         ::chrome_urls::mojom::ChromeUrlsDataPtr> {
  static bool IsNull(const ::chrome_urls::mojom::ChromeUrlsDataPtr& input) { return !input; }
  static void SetToNull(::chrome_urls::mojom::ChromeUrlsDataPtr* output) { output->reset(); }

  static const decltype(::chrome_urls::mojom::ChromeUrlsData::webui_urls)& webui_urls(
      const ::chrome_urls::mojom::ChromeUrlsDataPtr& input) {
    return input->webui_urls;
  }

  static const decltype(::chrome_urls::mojom::ChromeUrlsData::command_urls)& command_urls(
      const ::chrome_urls::mojom::ChromeUrlsDataPtr& input) {
    return input->command_urls;
  }

  static decltype(::chrome_urls::mojom::ChromeUrlsData::internal_debugging_uis_enabled) internal_debugging_uis_enabled(
      const ::chrome_urls::mojom::ChromeUrlsDataPtr& input) {
    return input->internal_debugging_uis_enabled;
  }

  static bool Read(::chrome_urls::mojom::ChromeUrlsData::DataView input, ::chrome_urls::mojom::ChromeUrlsDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_H_