// components/webui/chrome_urls/mojom/chrome_urls.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SHARED_H_
#define COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome_urls::mojom::WebuiUrlInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome_urls::mojom::WebuiUrlInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome_urls::mojom::internal::WebuiUrlInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WebuiUrlInfo struct");

    fragment->enabled = Traits::enabled(input);

    fragment->internal = Traits::internal(input);
  }

  static bool Deserialize(::chrome_urls::mojom::internal::WebuiUrlInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome_urls::mojom::WebuiUrlInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome_urls::mojom::ChromeUrlsDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome_urls::mojom::ChromeUrlsDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome_urls::mojom::internal::ChromeUrlsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::webui_urls(input)) in_webui_urls = Traits::webui_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webui_urls)::BaseType>
        webui_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& webui_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::chrome_urls::mojom::WebuiUrlInfoDataView>>(
      in_webui_urls,
      webui_urls_fragment,
      &webui_urls_validate_params);

    fragment->webui_urls.Set(
        webui_urls_fragment.is_null() ? nullptr : webui_urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->webui_urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null webui_urls in ChromeUrlsData struct");

    decltype(Traits::command_urls(input)) in_command_urls = Traits::command_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->command_urls)::BaseType>
        command_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& command_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_command_urls,
      command_urls_fragment,
      &command_urls_validate_params);

    fragment->command_urls.Set(
        command_urls_fragment.is_null() ? nullptr : command_urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->command_urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null command_urls in ChromeUrlsData struct");

    fragment->internal_debugging_uis_enabled = Traits::internal_debugging_uis_enabled(input);
  }

  static bool Deserialize(::chrome_urls::mojom::internal::ChromeUrlsData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome_urls::mojom::ChromeUrlsDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome_urls::mojom {

inline void WebuiUrlInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ChromeUrlsDataDataView::GetWebuiUrlsDataView(
    mojo::ArrayDataView<WebuiUrlInfoDataView>* output) {
  auto pointer = data_->webui_urls.Get();
  *output = mojo::ArrayDataView<WebuiUrlInfoDataView>(pointer, message_);
}
inline void ChromeUrlsDataDataView::GetCommandUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->command_urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}



}  // chrome_urls::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SHARED_H_