// components/webui/chrome_urls/mojom/chrome_urls.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-params-data.h"
namespace chrome_urls {
namespace mojom {

namespace internal {


// static
bool WebuiUrlInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebuiUrlInfo_Data* object =
      static_cast<const WebuiUrlInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebuiUrlInfo_Data::WebuiUrlInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeUrlsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeUrlsData_Data* object =
      static_cast<const ChromeUrlsData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->webui_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& webui_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->webui_urls, validation_context,
                                         &webui_urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->command_urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& command_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->command_urls, validation_context,
                                         &command_urls_validate_params)) {
    return false;
  }

  return true;
}

ChromeUrlsData_Data::ChromeUrlsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUrls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUrls_Params_Data* object =
      static_cast<const PageHandler_GetUrls_Params_Data*>(data);

  return true;
}

PageHandler_GetUrls_Params_Data::PageHandler_GetUrls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUrls_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUrls_ResponseParams_Data* object =
      static_cast<const PageHandler_GetUrls_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->urls_data, validation_context))
    return false;

  return true;
}

PageHandler_GetUrls_ResponseParams_Data::PageHandler_GetUrls_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetDebugPagesEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetDebugPagesEnabled_Params_Data* object =
      static_cast<const PageHandler_SetDebugPagesEnabled_Params_Data*>(data);

  return true;
}

PageHandler_SetDebugPagesEnabled_Params_Data::PageHandler_SetDebugPagesEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetDebugPagesEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetDebugPagesEnabled_ResponseParams_Data* object =
      static_cast<const PageHandler_SetDebugPagesEnabled_ResponseParams_Data*>(data);

  return true;
}

PageHandler_SetDebugPagesEnabled_ResponseParams_Data::PageHandler_SetDebugPagesEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome_urls