// components/webui/chrome_urls/mojom/chrome_urls.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace chrome_urls::mojom {
class WebuiUrlInfoDataView;

class ChromeUrlsDataDataView;



}  // chrome_urls::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome_urls::mojom::WebuiUrlInfoDataView> {
  using Data = ::chrome_urls::mojom::internal::WebuiUrlInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome_urls::mojom::ChromeUrlsDataDataView> {
  using Data = ::chrome_urls::mojom::internal::ChromeUrlsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome_urls::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class WebuiUrlInfoDataView {
 public:
  WebuiUrlInfoDataView() = default;

  WebuiUrlInfoDataView(
      internal::WebuiUrlInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool internal() const {
    return data_->internal;
  }
 private:
  internal::WebuiUrlInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeUrlsDataDataView {
 public:
  ChromeUrlsDataDataView() = default;

  ChromeUrlsDataDataView(
      internal::ChromeUrlsData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebuiUrlsDataView(
      mojo::ArrayDataView<WebuiUrlInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebuiUrls(UserType* output) {
    
    auto* pointer = data_->webui_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome_urls::mojom::WebuiUrlInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetCommandUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommandUrls(UserType* output) {
    
    auto* pointer = data_->command_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  bool internal_debugging_uis_enabled() const {
    return data_->internal_debugging_uis_enabled;
  }
 private:
  internal::ChromeUrlsData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // chrome_urls::mojom

#endif  // COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_DATA_VIEW_H_