// components/webapps/common/web_page_metadata_agent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_AGENT_MOJOM_H_
#define COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_AGENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webapps/common/web_page_metadata_agent.mojom-features.h"  // IWYU pragma: export
#include "components/webapps/common/web_page_metadata_agent.mojom-shared.h"  // IWYU pragma: export
#include "components/webapps/common/web_page_metadata_agent.mojom-forward.h"  // IWYU pragma: export
#include "components/webapps/common/web_page_metadata.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace webapps::mojom {

class WebPageMetadataAgentProxy;

template <typename ImplRefTraits>
class WebPageMetadataAgentStub;

class WebPageMetadataAgentRequestValidator;
class WebPageMetadataAgentResponseValidator;


class WebPageMetadataAgent
    : public WebPageMetadataAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webapps.mojom.WebPageMetadataAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPageMetadataAgentInterfaceBase;
  using Proxy_ = WebPageMetadataAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPageMetadataAgentStub<ImplRefTraits>;

  using RequestValidator_ = WebPageMetadataAgentRequestValidator;
  using ResponseValidator_ = WebPageMetadataAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetWebPageMetadataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetWebPageMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPageMetadataAgent() = default;

  using GetWebPageMetadataCallback = base::OnceCallback<void(::webapps::mojom::WebPageMetadataPtr)>;
  using GetWebPageMetadataMojoCallback = base::OnceCallback<void(::webapps::mojom::WebPageMetadataPtr)>;

  virtual void GetWebPageMetadata(GetWebPageMetadataCallback callback) = 0;
};



class  WebPageMetadataAgentProxy
    : public WebPageMetadataAgent {
 public:
  using InterfaceType = WebPageMetadataAgent;

  explicit WebPageMetadataAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetWebPageMetadata(GetWebPageMetadataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebPageMetadataAgentStubDispatch {
 public:
  static bool Accept(WebPageMetadataAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPageMetadataAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPageMetadataAgent>>
class WebPageMetadataAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPageMetadataAgentStub() = default;
  ~WebPageMetadataAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPageMetadataAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPageMetadataAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebPageMetadataAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebPageMetadataAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // webapps::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_AGENT_MOJOM_H_