// components/webapps/common/web_page_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/webapps/common/web_page_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/webapps/common/web_page_metadata.mojom-params-data.h"
#include "components/webapps/common/web_page_metadata.mojom-shared-message-ids.h"

#include "components/webapps/common/web_page_metadata.mojom-import-headers.h"
#include "components/webapps/common/web_page_metadata.mojom-test-utils.h"


namespace webapps::mojom {
WebPageIconInfo::WebPageIconInfo()
    : url(),
      square_size_px() {}

WebPageIconInfo::WebPageIconInfo(
    const ::GURL& url_in,
    int32_t square_size_px_in)
    : url(std::move(url_in)),
      square_size_px(std::move(square_size_px_in)) {}

WebPageIconInfo::~WebPageIconInfo() = default;

void WebPageIconInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "square_size_px"), this->square_size_px,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPageIconInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPageMetadata::WebPageMetadata()
    : application_name(),
      description(),
      application_url(),
      title(),
      icons(),
      mobile_capable(WebPageMobileCapable::UNSPECIFIED) {}

WebPageMetadata::WebPageMetadata(
    const ::std::u16string& application_name_in,
    const ::std::u16string& description_in,
    const ::GURL& application_url_in,
    const ::std::u16string& title_in,
    std::vector<WebPageIconInfoPtr> icons_in,
    WebPageMobileCapable mobile_capable_in)
    : application_name(std::move(application_name_in)),
      description(std::move(description_in)),
      application_url(std::move(application_url_in)),
      title(std::move(title_in)),
      icons(std::move(icons_in)),
      mobile_capable(std::move(mobile_capable_in)) {}

WebPageMetadata::~WebPageMetadata() = default;

void WebPageMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "application_name"), this->application_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "application_url"), this->application_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WebPageIconInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mobile_capable"), this->mobile_capable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPageMobileCapable>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPageMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // webapps::mojom


namespace mojo {


// static
bool StructTraits<::webapps::mojom::WebPageIconInfo::DataView, ::webapps::mojom::WebPageIconInfoPtr>::Read(
    ::webapps::mojom::WebPageIconInfo::DataView input,
    ::webapps::mojom::WebPageIconInfoPtr* output) {
  bool success = true;
  ::webapps::mojom::WebPageIconInfoPtr result(::webapps::mojom::WebPageIconInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->square_size_px = input.square_size_px();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webapps::mojom::WebPageMetadata::DataView, ::webapps::mojom::WebPageMetadataPtr>::Read(
    ::webapps::mojom::WebPageMetadata::DataView input,
    ::webapps::mojom::WebPageMetadataPtr* output) {
  bool success = true;
  ::webapps::mojom::WebPageMetadataPtr result(::webapps::mojom::WebPageMetadata::New());
  
      if (success && !input.ReadApplicationName(&result->application_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadApplicationUrl(&result->application_url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadMobileCapable(&result->mobile_capable))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webapps::mojom {




}  // webapps::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif