// components/webapps/common/web_page_metadata.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SEND_VALIDATION_H_

#include "components/webapps/common/web_page_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/webapps/common/web_page_metadata.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::webapps::mojom::WebPageMobileCapable, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webapps::mojom::WebPageIconInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webapps::mojom::WebPageIconInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webapps::mojom::internal::WebPageIconInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebPageIconInfo struct");

      fragment->square_size_px = Traits::square_size_px(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webapps::mojom::WebPageMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webapps::mojom::WebPageMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webapps::mojom::internal::WebPageMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::application_name(input)) in_application_name = Traits::application_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->application_name)::BaseType> application_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_application_name,
        application_name_fragment);

      fragment->application_name.Set(
          application_name_fragment.is_null() ? nullptr : application_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->application_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null application_name in WebPageMetadata struct");

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in WebPageMetadata struct");

      decltype(Traits::application_url(input)) in_application_url = Traits::application_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->application_url)::BaseType> application_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_application_url,
        application_url_fragment);

      fragment->application_url.Set(
          application_url_fragment.is_null() ? nullptr : application_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->application_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null application_url in WebPageMetadata struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in WebPageMetadata struct");

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::webapps::mojom::WebPageIconInfoDataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in WebPageMetadata struct");

      
      mojo::internal::Serialize<::webapps::mojom::WebPageMobileCapable>(
        Traits::mobile_capable(input),
        &fragment->mobile_capable);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SEND_VALIDATION_H_