// components/webapps/common/web_page_metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_DATA_VIEW_H_
#define COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/webapps/common/web_page_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace webapps::mojom {
class WebPageIconInfoDataView;

class WebPageMetadataDataView;



}  // webapps::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webapps::mojom::WebPageIconInfoDataView> {
  using Data = ::webapps::mojom::internal::WebPageIconInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webapps::mojom::WebPageMetadataDataView> {
  using Data = ::webapps::mojom::internal::WebPageMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace webapps::mojom {


enum class WebPageMobileCapable : int32_t {
  
  UNSPECIFIED = 0,
  
  ENABLED = 1,
  
  ENABLED_APPLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WebPageMobileCapable value);
inline bool IsKnownEnumValue(WebPageMobileCapable value) {
  return internal::WebPageMobileCapable_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebPageIconInfoDataView {
 public:
  WebPageIconInfoDataView() = default;

  WebPageIconInfoDataView(
      internal::WebPageIconInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t square_size_px() const {
    return data_->square_size_px;
  }
 private:
  internal::WebPageIconInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPageMetadataDataView {
 public:
  WebPageMetadataDataView() = default;

  WebPageMetadataDataView(
      internal::WebPageMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetApplicationNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApplicationName(UserType* output) {
    
    auto* pointer = data_->application_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetApplicationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApplicationUrl(UserType* output) {
    
    auto* pointer = data_->application_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<WebPageIconInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webapps::mojom::WebPageIconInfoDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMobileCapable(UserType* output) const {
    auto data_value = data_->mobile_capable;
    return mojo::internal::Deserialize<::webapps::mojom::WebPageMobileCapable>(
        data_value, output);
  }
  WebPageMobileCapable mobile_capable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webapps::mojom::WebPageMobileCapable>(data_->mobile_capable));
  }
 private:
  internal::WebPageMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // webapps::mojom

#endif  // COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_DATA_VIEW_H_