// components/web_package/mojom/web_bundle_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-features.h"  // IWYU pragma: export
#include "components/web_package/mojom/web_bundle_parser.mojom-shared.h"  // IWYU pragma: export
#include "components/web_package/mojom/web_bundle_parser.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/web_package/mojom/web_bundle_parser_mojom_traits.h"




namespace web_package::mojom {

class WebBundleParserFactoryProxy;

template <typename ImplRefTraits>
class WebBundleParserFactoryStub;

class WebBundleParserFactoryRequestValidator;


class WebBundleParserFactory
    : public WebBundleParserFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "web_package.mojom.WebBundleParserFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBundleParserFactoryInterfaceBase;
  using Proxy_ = WebBundleParserFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBundleParserFactoryStub<ImplRefTraits>;

  using RequestValidator_ = WebBundleParserFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetParserForDataSourceMinVersion = 0,
    kBindFileDataSourceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetParserForDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindFileDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBundleParserFactory() = default;

  virtual void GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, const std::optional<::GURL>& base_url, ::mojo::PendingRemote<BundleDataSource> data_source) = 0;

  virtual void BindFileDataSource(::mojo::PendingReceiver<BundleDataSource> data_source, ::base::File file) = 0;
};

class WebBundleParserProxy;

template <typename ImplRefTraits>
class WebBundleParserStub;

class WebBundleParserRequestValidator;
class WebBundleParserResponseValidator;


class WebBundleParser
    : public WebBundleParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "web_package.mojom.WebBundleParser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBundleParserInterfaceBase;
  using Proxy_ = WebBundleParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBundleParserStub<ImplRefTraits>;

  using RequestValidator_ = WebBundleParserRequestValidator;
  using ResponseValidator_ = WebBundleParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseIntegrityBlockMinVersion = 0,
    kParseMetadataMinVersion = 0,
    kParseResponseMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ParseIntegrityBlock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBundleParser() = default;

  using ParseIntegrityBlockCallback = base::OnceCallback<void(BundleIntegrityBlockPtr, BundleIntegrityBlockParseErrorPtr)>;
  using ParseIntegrityBlockMojoCallback = base::OnceCallback<void(BundleIntegrityBlockPtr, BundleIntegrityBlockParseErrorPtr)>;

  virtual void ParseIntegrityBlock(ParseIntegrityBlockCallback callback) = 0;

  using ParseMetadataCallback = base::OnceCallback<void(BundleMetadataPtr, BundleMetadataParseErrorPtr)>;
  using ParseMetadataMojoCallback = base::OnceCallback<void(BundleMetadataPtr, BundleMetadataParseErrorPtr)>;

  virtual void ParseMetadata(std::optional<uint64_t> offset, ParseMetadataCallback callback) = 0;

  using ParseResponseCallback = base::OnceCallback<void(BundleResponsePtr, BundleResponseParseErrorPtr)>;
  using ParseResponseMojoCallback = base::OnceCallback<void(BundleResponsePtr, BundleResponseParseErrorPtr)>;

  virtual void ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;
};

class BundleDataSourceProxy;

template <typename ImplRefTraits>
class BundleDataSourceStub;

class BundleDataSourceRequestValidator;
class BundleDataSourceResponseValidator;


class BundleDataSource
    : public BundleDataSourceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "web_package.mojom.BundleDataSource";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BundleDataSourceInterfaceBase;
  using Proxy_ = BundleDataSourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BundleDataSourceStub<ImplRefTraits>;

  using RequestValidator_ = BundleDataSourceRequestValidator;
  using ResponseValidator_ = BundleDataSourceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kLengthMinVersion = 0,
    kIsRandomAccessContextMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Length_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsRandomAccessContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BundleDataSource() = default;

  using ReadCallback = base::OnceCallback<void(const std::optional<std::vector<uint8_t>>&)>;
  using ReadMojoCallback = base::OnceCallback<void(const std::optional<std::vector<uint8_t>>&)>;

  virtual void Read(uint64_t offset, uint64_t length, ReadCallback callback) = 0;

  using LengthCallback = base::OnceCallback<void(int64_t)>;
  using LengthMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void Length(LengthCallback callback) = 0;

  using IsRandomAccessContextCallback = base::OnceCallback<void(bool)>;
  using IsRandomAccessContextMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsRandomAccessContext(IsRandomAccessContextCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;
};



class  WebBundleParserFactoryProxy
    : public WebBundleParserFactory {
 public:
  using InterfaceType = WebBundleParserFactory;

  explicit WebBundleParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, const std::optional<::GURL>& base_url, ::mojo::PendingRemote<BundleDataSource> data_source) final;
  
  void BindFileDataSource(::mojo::PendingReceiver<BundleDataSource> data_source, ::base::File file) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebBundleParserProxy
    : public WebBundleParser {
 public:
  using InterfaceType = WebBundleParser;

  explicit WebBundleParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ParseIntegrityBlock(ParseIntegrityBlockCallback callback) final;
  
  void ParseMetadata(std::optional<uint64_t> offset, ParseMetadataCallback callback) final;
  
  void ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BundleDataSourceProxy
    : public BundleDataSource {
 public:
  using InterfaceType = BundleDataSource;

  explicit BundleDataSourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(uint64_t offset, uint64_t length, ReadCallback callback) final;
  
  void Length(LengthCallback callback) final;
  
  void IsRandomAccessContext(IsRandomAccessContextCallback callback) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebBundleParserFactoryStubDispatch {
 public:
  static bool Accept(WebBundleParserFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBundleParserFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBundleParserFactory>>
class WebBundleParserFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBundleParserFactoryStub() = default;
  ~WebBundleParserFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebBundleParserStubDispatch {
 public:
  static bool Accept(WebBundleParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBundleParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBundleParser>>
class WebBundleParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBundleParserStub() = default;
  ~WebBundleParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BundleDataSourceStubDispatch {
 public:
  static bool Accept(BundleDataSource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BundleDataSource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BundleDataSource>>
class BundleDataSourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BundleDataSourceStub() = default;
  ~BundleDataSourceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BundleDataSourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BundleDataSourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebBundleParserFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebBundleParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BundleDataSourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebBundleParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BundleDataSourceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  BundleIntegrityBlockParseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleIntegrityBlockParseError, T>::value>;
  using DataView = BundleIntegrityBlockParseErrorDataView;
  using Data_ = internal::BundleIntegrityBlockParseError_Data;

  template <typename... Args>
  static BundleIntegrityBlockParseErrorPtr New(Args&&... args) {
    return BundleIntegrityBlockParseErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleIntegrityBlockParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<BundleIntegrityBlockParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleIntegrityBlockParseError>::Convert(*this);
  }


  BundleIntegrityBlockParseError();

  BundleIntegrityBlockParseError(
      BundleParseErrorType type,
      const std::string& message);


  ~BundleIntegrityBlockParseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleIntegrityBlockParseErrorPtr>
  BundleIntegrityBlockParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockParseError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockParseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleIntegrityBlockParseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleIntegrityBlockParseError_UnserializedMessageContext<
            UserType, BundleIntegrityBlockParseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockParseError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleIntegrityBlockParseError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleIntegrityBlockParseError_UnserializedMessageContext<
            UserType, BundleIntegrityBlockParseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockParseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BundleParseErrorType type;
  
  std::string message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleMetadataParseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleMetadataParseError, T>::value>;
  using DataView = BundleMetadataParseErrorDataView;
  using Data_ = internal::BundleMetadataParseError_Data;

  template <typename... Args>
  static BundleMetadataParseErrorPtr New(Args&&... args) {
    return BundleMetadataParseErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleMetadataParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<BundleMetadataParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleMetadataParseError>::Convert(*this);
  }


  BundleMetadataParseError();

  BundleMetadataParseError(
      BundleParseErrorType type,
      const std::string& message);


  ~BundleMetadataParseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleMetadataParseErrorPtr>
  BundleMetadataParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadataParseError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadataParseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleMetadataParseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleMetadataParseError_UnserializedMessageContext<
            UserType, BundleMetadataParseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleMetadataParseError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleMetadataParseError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleMetadataParseError_UnserializedMessageContext<
            UserType, BundleMetadataParseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleMetadataParseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BundleParseErrorType type;
  
  std::string message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleResponseParseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponseParseError, T>::value>;
  using DataView = BundleResponseParseErrorDataView;
  using Data_ = internal::BundleResponseParseError_Data;

  template <typename... Args>
  static BundleResponseParseErrorPtr New(Args&&... args) {
    return BundleResponseParseErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponseParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<BundleResponseParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponseParseError>::Convert(*this);
  }


  BundleResponseParseError();

  BundleResponseParseError(
      BundleParseErrorType type,
      const std::string& message);


  ~BundleResponseParseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponseParseErrorPtr>
  BundleResponseParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseParseError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseParseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponseParseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponseParseError_UnserializedMessageContext<
            UserType, BundleResponseParseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleResponseParseError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleResponseParseError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponseParseError_UnserializedMessageContext<
            UserType, BundleResponseParseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponseParseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BundleParseErrorType type;
  
  std::string message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  SignatureInfoUnknown {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignatureInfoUnknown, T>::value>;
  using DataView = SignatureInfoUnknownDataView;
  using Data_ = internal::SignatureInfoUnknown_Data;

  template <typename... Args>
  static SignatureInfoUnknownPtr New(Args&&... args) {
    return SignatureInfoUnknownPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignatureInfoUnknownPtr From(const U& u) {
    return mojo::TypeConverter<SignatureInfoUnknownPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignatureInfoUnknown>::Convert(*this);
  }


  SignatureInfoUnknown();


  ~SignatureInfoUnknown();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignatureInfoUnknownPtr>
  SignatureInfoUnknownPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoUnknown::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoUnknown::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignatureInfoUnknown::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignatureInfoUnknown_UnserializedMessageContext<
            UserType, SignatureInfoUnknown::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignatureInfoUnknown::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignatureInfoUnknown::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignatureInfoUnknown_UnserializedMessageContext<
            UserType, SignatureInfoUnknown::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignatureInfoUnknown::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignatureInfoUnknown::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  BundleResponseLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponseLocation, T>::value>;
  using DataView = BundleResponseLocationDataView;
  using Data_ = internal::BundleResponseLocation_Data;

  template <typename... Args>
  static BundleResponseLocationPtr New(Args&&... args) {
    return BundleResponseLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponseLocationPtr From(const U& u) {
    return mojo::TypeConverter<BundleResponseLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponseLocation>::Convert(*this);
  }


  BundleResponseLocation();

  BundleResponseLocation(
      uint64_t offset,
      uint64_t length);


  ~BundleResponseLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponseLocationPtr>
  BundleResponseLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseLocation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseLocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponseLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponseLocation_UnserializedMessageContext<
            UserType, BundleResponseLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleResponseLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleResponseLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponseLocation_UnserializedMessageContext<
            UserType, BundleResponseLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponseLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t offset;
  
  uint64_t length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SignatureInfo {
 public:
  using DataView = SignatureInfoDataView;
  using Data_ = internal::SignatureInfo_Data;
  using Tag = Data_::SignatureInfo_Tag;

  template <typename... Args>
  static SignatureInfoPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |unknown|.
  static SignatureInfoPtr NewUnknown(
      SignatureInfoUnknownPtr value);
  // Construct an instance holding |ed25519|.
  static SignatureInfoPtr NewEd25519(
      SignatureInfoEd25519Ptr value);
  // Construct an instance holding |ecdsa_p256_sha256|.
  static SignatureInfoPtr NewEcdsaP256Sha256(
      SignatureInfoEcdsaP256SHA256Ptr value);

  template <typename U>
  static SignatureInfoPtr From(const U& u) {
    return mojo::TypeConverter<SignatureInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignatureInfo>::Convert(*this);
  }
  ~SignatureInfo();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SignatureInfo(const SignatureInfo& other) = delete;
  SignatureInfo& operator=(const SignatureInfo& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SignatureInfoPtr>
  SignatureInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SignatureInfo>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SignatureInfo>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_unknown() const { return tag_ == Tag::kUnknown; }
  const SignatureInfoUnknownPtr& get_unknown() const {
    CHECK(tag_ == Tag::kUnknown);
    return data_.unknown;
  }
  SignatureInfoUnknownPtr& get_unknown() {
    CHECK(tag_ == Tag::kUnknown);
    return data_.unknown;
  }
  void set_unknown(SignatureInfoUnknownPtr unknown);

  bool is_ed25519() const { return tag_ == Tag::kEd25519; }
  const SignatureInfoEd25519Ptr& get_ed25519() const {
    CHECK(tag_ == Tag::kEd25519);
    return data_.ed25519;
  }
  SignatureInfoEd25519Ptr& get_ed25519() {
    CHECK(tag_ == Tag::kEd25519);
    return data_.ed25519;
  }
  void set_ed25519(SignatureInfoEd25519Ptr ed25519);

  bool is_ecdsa_p256_sha256() const { return tag_ == Tag::kEcdsaP256Sha256; }
  const SignatureInfoEcdsaP256SHA256Ptr& get_ecdsa_p256_sha256() const {
    CHECK(tag_ == Tag::kEcdsaP256Sha256);
    return data_.ecdsa_p256_sha256;
  }
  SignatureInfoEcdsaP256SHA256Ptr& get_ecdsa_p256_sha256() {
    CHECK(tag_ == Tag::kEcdsaP256Sha256);
    return data_.ecdsa_p256_sha256;
  }
  void set_ecdsa_p256_sha256(SignatureInfoEcdsaP256SHA256Ptr ecdsa_p256_sha256);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignatureInfo::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SignatureInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
        SignatureInfoUnknownPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEd25519)>,
        SignatureInfoEd25519Ptr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
        SignatureInfoEcdsaP256SHA256Ptr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SignatureInfoUnknownPtr unknown;
    SignatureInfoEd25519Ptr ed25519;
    SignatureInfoEcdsaP256SHA256Ptr ecdsa_p256_sha256;
  };

  SignatureInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
      SignatureInfoUnknownPtr value);
  SignatureInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kEd25519)>,
      SignatureInfoEd25519Ptr value);
  SignatureInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kEcdsaP256Sha256)>,
      SignatureInfoEcdsaP256SHA256Ptr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};








class  BundleIntegrityBlockAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleIntegrityBlockAttributes, T>::value>;
  using DataView = BundleIntegrityBlockAttributesDataView;
  using Data_ = internal::BundleIntegrityBlockAttributes_Data;

  template <typename... Args>
  static BundleIntegrityBlockAttributesPtr New(Args&&... args) {
    return BundleIntegrityBlockAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleIntegrityBlockAttributesPtr From(const U& u) {
    return mojo::TypeConverter<BundleIntegrityBlockAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleIntegrityBlockAttributes>::Convert(*this);
  }


  BundleIntegrityBlockAttributes();

  BundleIntegrityBlockAttributes(
      const std::string& web_bundle_id,
      std::vector<uint8_t> cbor);


  ~BundleIntegrityBlockAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleIntegrityBlockAttributesPtr>
  BundleIntegrityBlockAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockAttributes::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockAttributes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleIntegrityBlockAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleIntegrityBlockAttributes_UnserializedMessageContext<
            UserType, BundleIntegrityBlockAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleIntegrityBlockAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleIntegrityBlockAttributes_UnserializedMessageContext<
            UserType, BundleIntegrityBlockAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string web_bundle_id;
  
  std::vector<uint8_t> cbor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleIntegrityBlock {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleIntegrityBlock, T>::value>;
  using DataView = BundleIntegrityBlockDataView;
  using Data_ = internal::BundleIntegrityBlock_Data;

  template <typename... Args>
  static BundleIntegrityBlockPtr New(Args&&... args) {
    return BundleIntegrityBlockPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleIntegrityBlockPtr From(const U& u) {
    return mojo::TypeConverter<BundleIntegrityBlockPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleIntegrityBlock>::Convert(*this);
  }


  BundleIntegrityBlock();

  BundleIntegrityBlock(
      uint64_t size,
      std::vector<BundleIntegrityBlockSignatureStackEntryPtr> signature_stack,
      const ::web_package::IntegrityBlockAttributes& attributes);

BundleIntegrityBlock(const BundleIntegrityBlock&) = delete;
BundleIntegrityBlock& operator=(const BundleIntegrityBlock&) = delete;

  ~BundleIntegrityBlock();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleIntegrityBlockPtr>
  BundleIntegrityBlockPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlock::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlock::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleIntegrityBlock::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleIntegrityBlock_UnserializedMessageContext<
            UserType, BundleIntegrityBlock::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleIntegrityBlock::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleIntegrityBlock::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleIntegrityBlock_UnserializedMessageContext<
            UserType, BundleIntegrityBlock::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleIntegrityBlock::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t size;
  
  std::vector<BundleIntegrityBlockSignatureStackEntryPtr> signature_stack;
  
  ::web_package::IntegrityBlockAttributes attributes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleIntegrityBlock::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Ed25519PublicKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Ed25519PublicKey, T>::value>;
  using DataView = Ed25519PublicKeyDataView;
  using Data_ = internal::Ed25519PublicKey_Data;

  template <typename... Args>
  static Ed25519PublicKeyPtr New(Args&&... args) {
    return Ed25519PublicKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Ed25519PublicKeyPtr From(const U& u) {
    return mojo::TypeConverter<Ed25519PublicKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Ed25519PublicKey>::Convert(*this);
  }


  Ed25519PublicKey();

  explicit Ed25519PublicKey(
      std::vector<uint8_t> bytes);


  ~Ed25519PublicKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Ed25519PublicKeyPtr>
  Ed25519PublicKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Ed25519PublicKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Ed25519PublicKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Ed25519PublicKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Ed25519PublicKey_UnserializedMessageContext<
            UserType, Ed25519PublicKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Ed25519PublicKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Ed25519PublicKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Ed25519PublicKey_UnserializedMessageContext<
            UserType, Ed25519PublicKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Ed25519PublicKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Ed25519PublicKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Ed25519Signature {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Ed25519Signature, T>::value>;
  using DataView = Ed25519SignatureDataView;
  using Data_ = internal::Ed25519Signature_Data;

  template <typename... Args>
  static Ed25519SignaturePtr New(Args&&... args) {
    return Ed25519SignaturePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Ed25519SignaturePtr From(const U& u) {
    return mojo::TypeConverter<Ed25519SignaturePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Ed25519Signature>::Convert(*this);
  }


  Ed25519Signature();

  explicit Ed25519Signature(
      std::vector<uint8_t> bytes);


  ~Ed25519Signature();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Ed25519SignaturePtr>
  Ed25519SignaturePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Ed25519Signature::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Ed25519Signature::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Ed25519Signature::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Ed25519Signature_UnserializedMessageContext<
            UserType, Ed25519Signature::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Ed25519Signature::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Ed25519Signature::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Ed25519Signature_UnserializedMessageContext<
            UserType, Ed25519Signature::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Ed25519Signature::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Ed25519Signature::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SignatureInfoEd25519 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignatureInfoEd25519, T>::value>;
  using DataView = SignatureInfoEd25519DataView;
  using Data_ = internal::SignatureInfoEd25519_Data;

  template <typename... Args>
  static SignatureInfoEd25519Ptr New(Args&&... args) {
    return SignatureInfoEd25519Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignatureInfoEd25519Ptr From(const U& u) {
    return mojo::TypeConverter<SignatureInfoEd25519Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignatureInfoEd25519>::Convert(*this);
  }


  SignatureInfoEd25519();

  SignatureInfoEd25519(
      const ::web_package::Ed25519PublicKey& public_key,
      const ::web_package::Ed25519Signature& signature);


  ~SignatureInfoEd25519();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignatureInfoEd25519Ptr>
  SignatureInfoEd25519Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoEd25519::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoEd25519::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignatureInfoEd25519::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignatureInfoEd25519_UnserializedMessageContext<
            UserType, SignatureInfoEd25519::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignatureInfoEd25519::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignatureInfoEd25519::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignatureInfoEd25519_UnserializedMessageContext<
            UserType, SignatureInfoEd25519::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignatureInfoEd25519::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::web_package::Ed25519PublicKey public_key;
  
  ::web_package::Ed25519Signature signature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignatureInfoEd25519::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EcdsaP256PublicKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EcdsaP256PublicKey, T>::value>;
  using DataView = EcdsaP256PublicKeyDataView;
  using Data_ = internal::EcdsaP256PublicKey_Data;

  template <typename... Args>
  static EcdsaP256PublicKeyPtr New(Args&&... args) {
    return EcdsaP256PublicKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EcdsaP256PublicKeyPtr From(const U& u) {
    return mojo::TypeConverter<EcdsaP256PublicKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EcdsaP256PublicKey>::Convert(*this);
  }


  EcdsaP256PublicKey();

  explicit EcdsaP256PublicKey(
      std::vector<uint8_t> bytes);


  ~EcdsaP256PublicKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EcdsaP256PublicKeyPtr>
  EcdsaP256PublicKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EcdsaP256PublicKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EcdsaP256PublicKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EcdsaP256PublicKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EcdsaP256PublicKey_UnserializedMessageContext<
            UserType, EcdsaP256PublicKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EcdsaP256PublicKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EcdsaP256PublicKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EcdsaP256PublicKey_UnserializedMessageContext<
            UserType, EcdsaP256PublicKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EcdsaP256PublicKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EcdsaP256PublicKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EcdsaP256SHA256Signature {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EcdsaP256SHA256Signature, T>::value>;
  using DataView = EcdsaP256SHA256SignatureDataView;
  using Data_ = internal::EcdsaP256SHA256Signature_Data;

  template <typename... Args>
  static EcdsaP256SHA256SignaturePtr New(Args&&... args) {
    return EcdsaP256SHA256SignaturePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EcdsaP256SHA256SignaturePtr From(const U& u) {
    return mojo::TypeConverter<EcdsaP256SHA256SignaturePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EcdsaP256SHA256Signature>::Convert(*this);
  }


  EcdsaP256SHA256Signature();

  explicit EcdsaP256SHA256Signature(
      std::vector<uint8_t> bytes);


  ~EcdsaP256SHA256Signature();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EcdsaP256SHA256SignaturePtr>
  EcdsaP256SHA256SignaturePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EcdsaP256SHA256Signature::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EcdsaP256SHA256Signature::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EcdsaP256SHA256Signature::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EcdsaP256SHA256Signature_UnserializedMessageContext<
            UserType, EcdsaP256SHA256Signature::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EcdsaP256SHA256Signature::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EcdsaP256SHA256Signature::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EcdsaP256SHA256Signature_UnserializedMessageContext<
            UserType, EcdsaP256SHA256Signature::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EcdsaP256SHA256Signature::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SignatureInfoEcdsaP256SHA256 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignatureInfoEcdsaP256SHA256, T>::value>;
  using DataView = SignatureInfoEcdsaP256SHA256DataView;
  using Data_ = internal::SignatureInfoEcdsaP256SHA256_Data;

  template <typename... Args>
  static SignatureInfoEcdsaP256SHA256Ptr New(Args&&... args) {
    return SignatureInfoEcdsaP256SHA256Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignatureInfoEcdsaP256SHA256Ptr From(const U& u) {
    return mojo::TypeConverter<SignatureInfoEcdsaP256SHA256Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignatureInfoEcdsaP256SHA256>::Convert(*this);
  }


  SignatureInfoEcdsaP256SHA256();

  SignatureInfoEcdsaP256SHA256(
      const ::web_package::EcdsaP256PublicKey& public_key,
      const ::web_package::EcdsaP256SHA256Signature& signature);


  ~SignatureInfoEcdsaP256SHA256();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignatureInfoEcdsaP256SHA256Ptr>
  SignatureInfoEcdsaP256SHA256Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoEcdsaP256SHA256::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignatureInfoEcdsaP256SHA256::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignatureInfoEcdsaP256SHA256::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignatureInfoEcdsaP256SHA256_UnserializedMessageContext<
            UserType, SignatureInfoEcdsaP256SHA256::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignatureInfoEcdsaP256SHA256::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignatureInfoEcdsaP256SHA256::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignatureInfoEcdsaP256SHA256_UnserializedMessageContext<
            UserType, SignatureInfoEcdsaP256SHA256::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignatureInfoEcdsaP256SHA256::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::web_package::EcdsaP256PublicKey public_key;
  
  ::web_package::EcdsaP256SHA256Signature signature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  BundleIntegrityBlockSignatureStackEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleIntegrityBlockSignatureStackEntry, T>::value>;
  using DataView = BundleIntegrityBlockSignatureStackEntryDataView;
  using Data_ = internal::BundleIntegrityBlockSignatureStackEntry_Data;

  template <typename... Args>
  static BundleIntegrityBlockSignatureStackEntryPtr New(Args&&... args) {
    return BundleIntegrityBlockSignatureStackEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleIntegrityBlockSignatureStackEntryPtr From(const U& u) {
    return mojo::TypeConverter<BundleIntegrityBlockSignatureStackEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleIntegrityBlockSignatureStackEntry>::Convert(*this);
  }


  BundleIntegrityBlockSignatureStackEntry();

  BundleIntegrityBlockSignatureStackEntry(
      std::vector<uint8_t> attributes_cbor,
      SignatureInfoPtr signature_info);

BundleIntegrityBlockSignatureStackEntry(const BundleIntegrityBlockSignatureStackEntry&) = delete;
BundleIntegrityBlockSignatureStackEntry& operator=(const BundleIntegrityBlockSignatureStackEntry&) = delete;

  ~BundleIntegrityBlockSignatureStackEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleIntegrityBlockSignatureStackEntryPtr>
  BundleIntegrityBlockSignatureStackEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockSignatureStackEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIntegrityBlockSignatureStackEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleIntegrityBlockSignatureStackEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext<
            UserType, BundleIntegrityBlockSignatureStackEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockSignatureStackEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleIntegrityBlockSignatureStackEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext<
            UserType, BundleIntegrityBlockSignatureStackEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleIntegrityBlockSignatureStackEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> attributes_cbor;
  
  SignatureInfoPtr signature_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleMetadata, T>::value>;
  using DataView = BundleMetadataDataView;
  using Data_ = internal::BundleMetadata_Data;

  template <typename... Args>
  static BundleMetadataPtr New(Args&&... args) {
    return BundleMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleMetadataPtr From(const U& u) {
    return mojo::TypeConverter<BundleMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleMetadata>::Convert(*this);
  }


  BundleMetadata();

  BundleMetadata(
      BundleFormatVersion version,
      const std::optional<::GURL>& primary_url,
      base::flat_map<::GURL, BundleResponseLocationPtr> requests);

BundleMetadata(const BundleMetadata&) = delete;
BundleMetadata& operator=(const BundleMetadata&) = delete;

  ~BundleMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleMetadataPtr>
  BundleMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleMetadata_UnserializedMessageContext<
            UserType, BundleMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleMetadata_UnserializedMessageContext<
            UserType, BundleMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BundleFormatVersion version;
  
  std::optional<::GURL> primary_url;
  
  base::flat_map<::GURL, BundleResponseLocationPtr> requests;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  BundleResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponse, T>::value>;
  using DataView = BundleResponseDataView;
  using Data_ = internal::BundleResponse_Data;

  template <typename... Args>
  static BundleResponsePtr New(Args&&... args) {
    return BundleResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponsePtr From(const U& u) {
    return mojo::TypeConverter<BundleResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponse>::Convert(*this);
  }


  BundleResponse();

  BundleResponse(
      int32_t response_code,
      const base::flat_map<std::string, std::string>& response_headers,
      uint64_t payload_offset,
      uint64_t payload_length);


  ~BundleResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponsePtr>
  BundleResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponse_UnserializedMessageContext<
            UserType, BundleResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundleResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundleResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponse_UnserializedMessageContext<
            UserType, BundleResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t response_code;
  
  base::flat_map<std::string, std::string> response_headers;
  
  uint64_t payload_offset;
  
  uint64_t payload_length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SignatureInfoPtr SignatureInfo::Clone() const {
  switch (tag_) {
    case Tag::kUnknown:
      return NewUnknown(
          mojo::Clone(data_.unknown));
    case Tag::kEd25519:
      return NewEd25519(
          mojo::Clone(data_.ed25519));
    case Tag::kEcdsaP256Sha256:
      return NewEcdsaP256Sha256(
          mojo::Clone(data_.ecdsa_p256_sha256));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SignatureInfo>::value>::type*>
bool SignatureInfo::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kUnknown:
      return mojo::Equals(data_.unknown, other.data_.unknown);
    case Tag::kEd25519:
      return mojo::Equals(data_.ed25519, other.data_.ed25519);
    case Tag::kEcdsaP256Sha256:
      return mojo::Equals(data_.ecdsa_p256_sha256, other.data_.ecdsa_p256_sha256);
  }

  return false;
}
template <typename StructPtrType>
BundleIntegrityBlockParseErrorPtr BundleIntegrityBlockParseError::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(message)
  );
}

template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>*>
bool BundleIntegrityBlockParseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, BundleIntegrityBlockParseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
BundleMetadataParseErrorPtr BundleMetadataParseError::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(message)
  );
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>*>
bool BundleMetadataParseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponseParseErrorPtr BundleResponseParseError::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(message)
  );
}

template <typename T, BundleResponseParseError::EnableIfSame<T>*>
bool BundleResponseParseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, BundleResponseParseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
BundleIntegrityBlockAttributesPtr BundleIntegrityBlockAttributes::Clone() const {
  return New(
      mojo::Clone(web_bundle_id),
      mojo::Clone(cbor)
  );
}

template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>*>
bool BundleIntegrityBlockAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_bundle_id, other_struct.web_bundle_id))
    return false;
  if (!mojo::Equals(this->cbor, other_struct.cbor))
    return false;
  return true;
}

template <typename T, BundleIntegrityBlockAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_bundle_id < rhs.web_bundle_id)
    return true;
  if (rhs.web_bundle_id < lhs.web_bundle_id)
    return false;
  if (lhs.cbor < rhs.cbor)
    return true;
  if (rhs.cbor < lhs.cbor)
    return false;
  return false;
}
template <typename StructPtrType>
BundleIntegrityBlockPtr BundleIntegrityBlock::Clone() const {
  return New(
      mojo::Clone(size),
      mojo::Clone(signature_stack),
      mojo::Clone(attributes)
  );
}

template <typename T, BundleIntegrityBlock::EnableIfSame<T>*>
bool BundleIntegrityBlock::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->signature_stack, other_struct.signature_stack))
    return false;
  if (!mojo::Equals(this->attributes, other_struct.attributes))
    return false;
  return true;
}

template <typename T, BundleIntegrityBlock::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.signature_stack < rhs.signature_stack)
    return true;
  if (rhs.signature_stack < lhs.signature_stack)
    return false;
  if (lhs.attributes < rhs.attributes)
    return true;
  if (rhs.attributes < lhs.attributes)
    return false;
  return false;
}
template <typename StructPtrType>
Ed25519PublicKeyPtr Ed25519PublicKey::Clone() const {
  return New(
      mojo::Clone(bytes)
  );
}

template <typename T, Ed25519PublicKey::EnableIfSame<T>*>
bool Ed25519PublicKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, Ed25519PublicKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}
template <typename StructPtrType>
Ed25519SignaturePtr Ed25519Signature::Clone() const {
  return New(
      mojo::Clone(bytes)
  );
}

template <typename T, Ed25519Signature::EnableIfSame<T>*>
bool Ed25519Signature::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, Ed25519Signature::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}
template <typename StructPtrType>
SignatureInfoEd25519Ptr SignatureInfoEd25519::Clone() const {
  return New(
      mojo::Clone(public_key),
      mojo::Clone(signature)
  );
}

template <typename T, SignatureInfoEd25519::EnableIfSame<T>*>
bool SignatureInfoEd25519::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->public_key, other_struct.public_key))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  return true;
}

template <typename T, SignatureInfoEd25519::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.public_key < rhs.public_key)
    return true;
  if (rhs.public_key < lhs.public_key)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  return false;
}
template <typename StructPtrType>
EcdsaP256PublicKeyPtr EcdsaP256PublicKey::Clone() const {
  return New(
      mojo::Clone(bytes)
  );
}

template <typename T, EcdsaP256PublicKey::EnableIfSame<T>*>
bool EcdsaP256PublicKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, EcdsaP256PublicKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}
template <typename StructPtrType>
EcdsaP256SHA256SignaturePtr EcdsaP256SHA256Signature::Clone() const {
  return New(
      mojo::Clone(bytes)
  );
}

template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>*>
bool EcdsaP256SHA256Signature::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, EcdsaP256SHA256Signature::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}
template <typename StructPtrType>
SignatureInfoEcdsaP256SHA256Ptr SignatureInfoEcdsaP256SHA256::Clone() const {
  return New(
      mojo::Clone(public_key),
      mojo::Clone(signature)
  );
}

template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>*>
bool SignatureInfoEcdsaP256SHA256::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->public_key, other_struct.public_key))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  return true;
}

template <typename T, SignatureInfoEcdsaP256SHA256::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.public_key < rhs.public_key)
    return true;
  if (rhs.public_key < lhs.public_key)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  return false;
}
template <typename StructPtrType>
SignatureInfoUnknownPtr SignatureInfoUnknown::Clone() const {
  return New(
  );
}

template <typename T, SignatureInfoUnknown::EnableIfSame<T>*>
bool SignatureInfoUnknown::Equals(const T& other_struct) const {
  return true;
}

template <typename T, SignatureInfoUnknown::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
BundleIntegrityBlockSignatureStackEntryPtr BundleIntegrityBlockSignatureStackEntry::Clone() const {
  return New(
      mojo::Clone(attributes_cbor),
      mojo::Clone(signature_info)
  );
}

template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>*>
bool BundleIntegrityBlockSignatureStackEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->attributes_cbor, other_struct.attributes_cbor))
    return false;
  if (!mojo::Equals(this->signature_info, other_struct.signature_info))
    return false;
  return true;
}

template <typename T, BundleIntegrityBlockSignatureStackEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.attributes_cbor < rhs.attributes_cbor)
    return true;
  if (rhs.attributes_cbor < lhs.attributes_cbor)
    return false;
  if (lhs.signature_info < rhs.signature_info)
    return true;
  if (rhs.signature_info < lhs.signature_info)
    return false;
  return false;
}
template <typename StructPtrType>
BundleMetadataPtr BundleMetadata::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(primary_url),
      mojo::Clone(requests)
  );
}

template <typename T, BundleMetadata::EnableIfSame<T>*>
bool BundleMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->primary_url, other_struct.primary_url))
    return false;
  if (!mojo::Equals(this->requests, other_struct.requests))
    return false;
  return true;
}

template <typename T, BundleMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.primary_url < rhs.primary_url)
    return true;
  if (rhs.primary_url < lhs.primary_url)
    return false;
  if (lhs.requests < rhs.requests)
    return true;
  if (rhs.requests < lhs.requests)
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponseLocationPtr BundleResponseLocation::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(length)
  );
}

template <typename T, BundleResponseLocation::EnableIfSame<T>*>
bool BundleResponseLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  return true;
}

template <typename T, BundleResponseLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponsePtr BundleResponse::Clone() const {
  return New(
      mojo::Clone(response_code),
      mojo::Clone(response_headers),
      mojo::Clone(payload_offset),
      mojo::Clone(payload_length)
  );
}

template <typename T, BundleResponse::EnableIfSame<T>*>
bool BundleResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_code, other_struct.response_code))
    return false;
  if (!mojo::Equals(this->response_headers, other_struct.response_headers))
    return false;
  if (!mojo::Equals(this->payload_offset, other_struct.payload_offset))
    return false;
  if (!mojo::Equals(this->payload_length, other_struct.payload_length))
    return false;
  return true;
}

template <typename T, BundleResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response_code < rhs.response_code)
    return true;
  if (rhs.response_code < lhs.response_code)
    return false;
  if (lhs.response_headers < rhs.response_headers)
    return true;
  if (rhs.response_headers < lhs.response_headers)
    return false;
  if (lhs.payload_offset < rhs.payload_offset)
    return true;
  if (rhs.payload_offset < lhs.payload_offset)
    return false;
  if (lhs.payload_length < rhs.payload_length)
    return true;
  if (rhs.payload_length < lhs.payload_length)
    return false;
  return false;
}


}  // web_package::mojom

namespace mojo {


template <>
struct  StructTraits<::web_package::mojom::BundleIntegrityBlockParseError::DataView,
                                         ::web_package::mojom::BundleIntegrityBlockParseErrorPtr> {
  static bool IsNull(const ::web_package::mojom::BundleIntegrityBlockParseErrorPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleIntegrityBlockParseErrorPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleIntegrityBlockParseError::type) type(
      const ::web_package::mojom::BundleIntegrityBlockParseErrorPtr& input) {
    return input->type;
  }

  static const decltype(::web_package::mojom::BundleIntegrityBlockParseError::message)& message(
      const ::web_package::mojom::BundleIntegrityBlockParseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::web_package::mojom::BundleIntegrityBlockParseError::DataView input, ::web_package::mojom::BundleIntegrityBlockParseErrorPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleMetadataParseError::DataView,
                                         ::web_package::mojom::BundleMetadataParseErrorPtr> {
  static bool IsNull(const ::web_package::mojom::BundleMetadataParseErrorPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleMetadataParseErrorPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleMetadataParseError::type) type(
      const ::web_package::mojom::BundleMetadataParseErrorPtr& input) {
    return input->type;
  }

  static const decltype(::web_package::mojom::BundleMetadataParseError::message)& message(
      const ::web_package::mojom::BundleMetadataParseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::web_package::mojom::BundleMetadataParseError::DataView input, ::web_package::mojom::BundleMetadataParseErrorPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponseParseError::DataView,
                                         ::web_package::mojom::BundleResponseParseErrorPtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponseParseErrorPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponseParseErrorPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponseParseError::type) type(
      const ::web_package::mojom::BundleResponseParseErrorPtr& input) {
    return input->type;
  }

  static const decltype(::web_package::mojom::BundleResponseParseError::message)& message(
      const ::web_package::mojom::BundleResponseParseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::web_package::mojom::BundleResponseParseError::DataView input, ::web_package::mojom::BundleResponseParseErrorPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleIntegrityBlockAttributes::DataView,
                                         ::web_package::mojom::BundleIntegrityBlockAttributesPtr> {
  static bool IsNull(const ::web_package::mojom::BundleIntegrityBlockAttributesPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleIntegrityBlockAttributesPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::BundleIntegrityBlockAttributes::web_bundle_id)& web_bundle_id(
      const ::web_package::mojom::BundleIntegrityBlockAttributesPtr& input) {
    return input->web_bundle_id;
  }

  static const decltype(::web_package::mojom::BundleIntegrityBlockAttributes::cbor)& cbor(
      const ::web_package::mojom::BundleIntegrityBlockAttributesPtr& input) {
    return input->cbor;
  }

  static bool Read(::web_package::mojom::BundleIntegrityBlockAttributes::DataView input, ::web_package::mojom::BundleIntegrityBlockAttributesPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleIntegrityBlock::DataView,
                                         ::web_package::mojom::BundleIntegrityBlockPtr> {
  static bool IsNull(const ::web_package::mojom::BundleIntegrityBlockPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleIntegrityBlockPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleIntegrityBlock::size) size(
      const ::web_package::mojom::BundleIntegrityBlockPtr& input) {
    return input->size;
  }

  static const decltype(::web_package::mojom::BundleIntegrityBlock::signature_stack)& signature_stack(
      const ::web_package::mojom::BundleIntegrityBlockPtr& input) {
    return input->signature_stack;
  }

  static const decltype(::web_package::mojom::BundleIntegrityBlock::attributes)& attributes(
      const ::web_package::mojom::BundleIntegrityBlockPtr& input) {
    return input->attributes;
  }

  static bool Read(::web_package::mojom::BundleIntegrityBlock::DataView input, ::web_package::mojom::BundleIntegrityBlockPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::Ed25519PublicKey::DataView,
                                         ::web_package::mojom::Ed25519PublicKeyPtr> {
  static bool IsNull(const ::web_package::mojom::Ed25519PublicKeyPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::Ed25519PublicKeyPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::Ed25519PublicKey::bytes)& bytes(
      const ::web_package::mojom::Ed25519PublicKeyPtr& input) {
    return input->bytes;
  }

  static bool Read(::web_package::mojom::Ed25519PublicKey::DataView input, ::web_package::mojom::Ed25519PublicKeyPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::Ed25519Signature::DataView,
                                         ::web_package::mojom::Ed25519SignaturePtr> {
  static bool IsNull(const ::web_package::mojom::Ed25519SignaturePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::Ed25519SignaturePtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::Ed25519Signature::bytes)& bytes(
      const ::web_package::mojom::Ed25519SignaturePtr& input) {
    return input->bytes;
  }

  static bool Read(::web_package::mojom::Ed25519Signature::DataView input, ::web_package::mojom::Ed25519SignaturePtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::SignatureInfoEd25519::DataView,
                                         ::web_package::mojom::SignatureInfoEd25519Ptr> {
  static bool IsNull(const ::web_package::mojom::SignatureInfoEd25519Ptr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SignatureInfoEd25519Ptr* output) { output->reset(); }

  static const decltype(::web_package::mojom::SignatureInfoEd25519::public_key)& public_key(
      const ::web_package::mojom::SignatureInfoEd25519Ptr& input) {
    return input->public_key;
  }

  static const decltype(::web_package::mojom::SignatureInfoEd25519::signature)& signature(
      const ::web_package::mojom::SignatureInfoEd25519Ptr& input) {
    return input->signature;
  }

  static bool Read(::web_package::mojom::SignatureInfoEd25519::DataView input, ::web_package::mojom::SignatureInfoEd25519Ptr* output);
};


template <>
struct  StructTraits<::web_package::mojom::EcdsaP256PublicKey::DataView,
                                         ::web_package::mojom::EcdsaP256PublicKeyPtr> {
  static bool IsNull(const ::web_package::mojom::EcdsaP256PublicKeyPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::EcdsaP256PublicKeyPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::EcdsaP256PublicKey::bytes)& bytes(
      const ::web_package::mojom::EcdsaP256PublicKeyPtr& input) {
    return input->bytes;
  }

  static bool Read(::web_package::mojom::EcdsaP256PublicKey::DataView input, ::web_package::mojom::EcdsaP256PublicKeyPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::EcdsaP256SHA256Signature::DataView,
                                         ::web_package::mojom::EcdsaP256SHA256SignaturePtr> {
  static bool IsNull(const ::web_package::mojom::EcdsaP256SHA256SignaturePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::EcdsaP256SHA256SignaturePtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::EcdsaP256SHA256Signature::bytes)& bytes(
      const ::web_package::mojom::EcdsaP256SHA256SignaturePtr& input) {
    return input->bytes;
  }

  static bool Read(::web_package::mojom::EcdsaP256SHA256Signature::DataView input, ::web_package::mojom::EcdsaP256SHA256SignaturePtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::SignatureInfoEcdsaP256SHA256::DataView,
                                         ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr> {
  static bool IsNull(const ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr* output) { output->reset(); }

  static const decltype(::web_package::mojom::SignatureInfoEcdsaP256SHA256::public_key)& public_key(
      const ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr& input) {
    return input->public_key;
  }

  static const decltype(::web_package::mojom::SignatureInfoEcdsaP256SHA256::signature)& signature(
      const ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr& input) {
    return input->signature;
  }

  static bool Read(::web_package::mojom::SignatureInfoEcdsaP256SHA256::DataView input, ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr* output);
};


template <>
struct  StructTraits<::web_package::mojom::SignatureInfoUnknown::DataView,
                                         ::web_package::mojom::SignatureInfoUnknownPtr> {
  static bool IsNull(const ::web_package::mojom::SignatureInfoUnknownPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SignatureInfoUnknownPtr* output) { output->reset(); }

  static bool Read(::web_package::mojom::SignatureInfoUnknown::DataView input, ::web_package::mojom::SignatureInfoUnknownPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::DataView,
                                         ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr> {
  static bool IsNull(const ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::attributes_cbor)& attributes_cbor(
      const ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr& input) {
    return input->attributes_cbor;
  }

  static const decltype(::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::signature_info)& signature_info(
      const ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr& input) {
    return input->signature_info;
  }

  static bool Read(::web_package::mojom::BundleIntegrityBlockSignatureStackEntry::DataView input, ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleMetadata::DataView,
                                         ::web_package::mojom::BundleMetadataPtr> {
  static bool IsNull(const ::web_package::mojom::BundleMetadataPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleMetadataPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleMetadata::version) version(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->version;
  }

  static const decltype(::web_package::mojom::BundleMetadata::primary_url)& primary_url(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->primary_url;
  }

  static const decltype(::web_package::mojom::BundleMetadata::requests)& requests(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->requests;
  }

  static bool Read(::web_package::mojom::BundleMetadata::DataView input, ::web_package::mojom::BundleMetadataPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponseLocation::DataView,
                                         ::web_package::mojom::BundleResponseLocationPtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponseLocationPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponseLocationPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponseLocation::offset) offset(
      const ::web_package::mojom::BundleResponseLocationPtr& input) {
    return input->offset;
  }

  static decltype(::web_package::mojom::BundleResponseLocation::length) length(
      const ::web_package::mojom::BundleResponseLocationPtr& input) {
    return input->length;
  }

  static bool Read(::web_package::mojom::BundleResponseLocation::DataView input, ::web_package::mojom::BundleResponseLocationPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponse::DataView,
                                         ::web_package::mojom::BundleResponsePtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponsePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponsePtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponse::response_code) response_code(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->response_code;
  }

  static const decltype(::web_package::mojom::BundleResponse::response_headers)& response_headers(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->response_headers;
  }

  static decltype(::web_package::mojom::BundleResponse::payload_offset) payload_offset(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->payload_offset;
  }

  static decltype(::web_package::mojom::BundleResponse::payload_length) payload_length(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->payload_length;
  }

  static bool Read(::web_package::mojom::BundleResponse::DataView input, ::web_package::mojom::BundleResponsePtr* output);
};


template <>
struct  UnionTraits<::web_package::mojom::SignatureInfo::DataView,
                                        ::web_package::mojom::SignatureInfoPtr> {
  static bool IsNull(const ::web_package::mojom::SignatureInfoPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SignatureInfoPtr* output) { output->reset(); }

  static ::web_package::mojom::SignatureInfo::Tag GetTag(const ::web_package::mojom::SignatureInfoPtr& input) {
    return input->which();
  }

  static const ::web_package::mojom::SignatureInfoUnknownPtr& unknown(const ::web_package::mojom::SignatureInfoPtr& input) {
    return input->get_unknown();
  }

  static const ::web_package::mojom::SignatureInfoEd25519Ptr& ed25519(const ::web_package::mojom::SignatureInfoPtr& input) {
    return input->get_ed25519();
  }

  static const ::web_package::mojom::SignatureInfoEcdsaP256SHA256Ptr& ecdsa_p256_sha256(const ::web_package::mojom::SignatureInfoPtr& input) {
    return input->get_ecdsa_p256_sha256();
  }

  static bool Read(::web_package::mojom::SignatureInfo::DataView input, ::web_package::mojom::SignatureInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_