// components/web_package/mojom/web_bundle_parser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/web_package/mojom/web_bundle_parser.mojom-data-view.h"




namespace std {

template <>
struct hash<::web_package::mojom::BundleParseErrorType>
    : public mojo::internal::EnumHashImpl<::web_package::mojom::BundleParseErrorType> {};

template <>
struct hash<::web_package::mojom::BundleFormatVersion>
    : public mojo::internal::EnumHashImpl<::web_package::mojom::BundleFormatVersion> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleParseErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::web_package::mojom::BundleParseErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::web_package::mojom::BundleParseErrorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleFormatVersion, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::web_package::mojom::BundleFormatVersion, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::web_package::mojom::BundleFormatVersion>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleIntegrityBlockParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockParseErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in BundleIntegrityBlockParseError struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleIntegrityBlockParseError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleIntegrityBlockParseErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleMetadataParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataParseErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleMetadataParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in BundleMetadataParseError struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleMetadataParseError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleMetadataParseErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseParseErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponseParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in BundleResponseParseError struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponseParseError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseParseErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleIntegrityBlockAttributesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockAttributesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::web_bundle_id(input)) in_web_bundle_id = Traits::web_bundle_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_bundle_id)::BaseType> web_bundle_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_web_bundle_id,
      web_bundle_id_fragment);

    fragment->web_bundle_id.Set(
        web_bundle_id_fragment.is_null() ? nullptr : web_bundle_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->web_bundle_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null web_bundle_id in BundleIntegrityBlockAttributes struct");

    decltype(Traits::cbor(input)) in_cbor = Traits::cbor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cbor)::BaseType>
        cbor_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cbor_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_cbor,
      cbor_fragment,
      &cbor_validate_params);

    fragment->cbor.Set(
        cbor_fragment.is_null() ? nullptr : cbor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cbor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cbor in BundleIntegrityBlockAttributes struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleIntegrityBlockAttributes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleIntegrityBlockAttributesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleIntegrityBlockDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlock_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->size = Traits::size(input);

    decltype(Traits::signature_stack(input)) in_signature_stack = Traits::signature_stack(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature_stack)::BaseType>
        signature_stack_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_stack_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView>>(
      in_signature_stack,
      signature_stack_fragment,
      &signature_stack_validate_params);

    fragment->signature_stack.Set(
        signature_stack_fragment.is_null() ? nullptr : signature_stack_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature_stack.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature_stack in BundleIntegrityBlock struct");

    decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attributes)::BaseType> attributes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::web_package::mojom::BundleIntegrityBlockAttributesDataView>(
      in_attributes,
      attributes_fragment);

    fragment->attributes.Set(
        attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attributes in BundleIntegrityBlock struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleIntegrityBlock_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleIntegrityBlockDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::Ed25519PublicKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::Ed25519PublicKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::Ed25519PublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<32, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in Ed25519PublicKey struct");
  }

  static bool Deserialize(::web_package::mojom::internal::Ed25519PublicKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::Ed25519PublicKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::Ed25519SignatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::Ed25519SignatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::Ed25519Signature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<64, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in Ed25519Signature struct");
  }

  static bool Deserialize(::web_package::mojom::internal::Ed25519Signature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::Ed25519SignatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SignatureInfoEd25519DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoEd25519DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoEd25519_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key)::BaseType> public_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::web_package::mojom::Ed25519PublicKeyDataView>(
      in_public_key,
      public_key_fragment);

    fragment->public_key.Set(
        public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_key in SignatureInfoEd25519 struct");

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType> signature_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::web_package::mojom::Ed25519SignatureDataView>(
      in_signature,
      signature_fragment);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in SignatureInfoEd25519 struct");
  }

  static bool Deserialize(::web_package::mojom::internal::SignatureInfoEd25519_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SignatureInfoEd25519DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::EcdsaP256PublicKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::EcdsaP256PublicKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::EcdsaP256PublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<33, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in EcdsaP256PublicKey struct");
  }

  static bool Deserialize(::web_package::mojom::internal::EcdsaP256PublicKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::EcdsaP256PublicKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::EcdsaP256SHA256SignatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::EcdsaP256SHA256SignatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::EcdsaP256SHA256Signature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in EcdsaP256SHA256Signature struct");
  }

  static bool Deserialize(::web_package::mojom::internal::EcdsaP256SHA256Signature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::EcdsaP256SHA256SignatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoEcdsaP256SHA256_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key)::BaseType> public_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::web_package::mojom::EcdsaP256PublicKeyDataView>(
      in_public_key,
      public_key_fragment);

    fragment->public_key.Set(
        public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_key in SignatureInfoEcdsaP256SHA256 struct");

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType> signature_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::web_package::mojom::EcdsaP256SHA256SignatureDataView>(
      in_signature,
      signature_fragment);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in SignatureInfoEcdsaP256SHA256 struct");
  }

  static bool Deserialize(::web_package::mojom::internal::SignatureInfoEcdsaP256SHA256_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SignatureInfoUnknownDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoUnknownDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoUnknown_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::web_package::mojom::internal::SignatureInfoUnknown_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SignatureInfoUnknownDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockSignatureStackEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::attributes_cbor(input)) in_attributes_cbor = Traits::attributes_cbor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attributes_cbor)::BaseType>
        attributes_cbor_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attributes_cbor_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_attributes_cbor,
      attributes_cbor_fragment,
      &attributes_cbor_validate_params);

    fragment->attributes_cbor.Set(
        attributes_cbor_fragment.is_null() ? nullptr : attributes_cbor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attributes_cbor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attributes_cbor in BundleIntegrityBlockSignatureStackEntry struct");

    decltype(Traits::signature_info(input)) in_signature_info = Traits::signature_info(input);
    mojo::internal::MessageFragment<decltype(fragment->signature_info)>
        signature_info_fragment(fragment.message());
    signature_info_fragment.Claim(&fragment->signature_info);
    
    mojo::internal::Serialize<::web_package::mojom::SignatureInfoDataView>(
      in_signature_info,
      signature_info_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature_info in BundleIntegrityBlockSignatureStackEntry struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleIntegrityBlockSignatureStackEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::web_package::mojom::BundleFormatVersion>(
      Traits::version(input),
      &fragment->version);

    decltype(Traits::primary_url(input)) in_primary_url = Traits::primary_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_url)::BaseType> primary_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_primary_url,
      primary_url_fragment);

    fragment->primary_url.Set(
        primary_url_fragment.is_null() ? nullptr : primary_url_fragment.data());

    decltype(Traits::requests(input)) in_requests = Traits::requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requests)::BaseType>
        requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::BundleResponseLocationDataView>>(
      in_requests,
      requests_fragment,
      &requests_validate_params);

    fragment->requests.Set(
        requests_fragment.is_null() ? nullptr : requests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in BundleMetadata struct");
  }

  static bool Deserialize(::web_package::mojom::internal::BundleMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseLocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseLocationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponseLocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->offset = Traits::offset(input);

    fragment->length = Traits::length(input);
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponseLocation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseLocationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::BundleResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->response_code = Traits::response_code(input);

    decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_headers)::BaseType>
        response_headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& response_headers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_response_headers,
      response_headers_fragment,
      &response_headers_validate_params);

    fragment->response_headers.Set(
        response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_headers in BundleResponse struct");

    fragment->payload_offset = Traits::payload_offset(input);

    fragment->payload_length = Traits::payload_length(input);
  }

  static bool Deserialize(::web_package::mojom::internal::BundleResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::BundleResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::web_package::mojom::SignatureInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::web_package::mojom::SignatureInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::web_package::mojom::internal::SignatureInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::web_package::mojom::SignatureInfoDataView::Tag::kUnknown: {
    decltype(Traits::unknown(input))
    in_unknown = Traits::unknown(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unknown)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoUnknownDataView>(
  in_unknown,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unknown in SignatureInfo union");
    fragment->data.f_unknown.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::web_package::mojom::SignatureInfoDataView::Tag::kEd25519: {
    decltype(Traits::ed25519(input))
    in_ed25519 = Traits::ed25519(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_ed25519)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoEd25519DataView>(
  in_ed25519,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null ed25519 in SignatureInfo union");
    fragment->data.f_ed25519.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::web_package::mojom::SignatureInfoDataView::Tag::kEcdsaP256Sha256: {
    decltype(Traits::ecdsa_p256_sha256(input))
    in_ecdsa_p256_sha256 = Traits::ecdsa_p256_sha256(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_ecdsa_p256_sha256)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView>(
  in_ecdsa_p256_sha256,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null ecdsa_p256_sha256 in SignatureInfo union");
    fragment->data.f_ecdsa_p256_sha256.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::web_package::mojom::internal::SignatureInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::web_package::mojom::SignatureInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace web_package::mojom {

inline void BundleIntegrityBlockParseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BundleMetadataParseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BundleResponseParseErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BundleIntegrityBlockAttributesDataView::GetWebBundleIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->web_bundle_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BundleIntegrityBlockAttributesDataView::GetCborDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->cbor.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void BundleIntegrityBlockDataView::GetSignatureStackDataView(
    mojo::ArrayDataView<BundleIntegrityBlockSignatureStackEntryDataView>* output) {
  auto pointer = data_->signature_stack.Get();
  *output = mojo::ArrayDataView<BundleIntegrityBlockSignatureStackEntryDataView>(pointer, message_);
}
inline void BundleIntegrityBlockDataView::GetAttributesDataView(
    BundleIntegrityBlockAttributesDataView* output) {
  auto pointer = data_->attributes.Get();
  *output = BundleIntegrityBlockAttributesDataView(pointer, message_);
}


inline void Ed25519PublicKeyDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void Ed25519SignatureDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void SignatureInfoEd25519DataView::GetPublicKeyDataView(
    Ed25519PublicKeyDataView* output) {
  auto pointer = data_->public_key.Get();
  *output = Ed25519PublicKeyDataView(pointer, message_);
}
inline void SignatureInfoEd25519DataView::GetSignatureDataView(
    Ed25519SignatureDataView* output) {
  auto pointer = data_->signature.Get();
  *output = Ed25519SignatureDataView(pointer, message_);
}


inline void EcdsaP256PublicKeyDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void EcdsaP256SHA256SignatureDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void SignatureInfoEcdsaP256SHA256DataView::GetPublicKeyDataView(
    EcdsaP256PublicKeyDataView* output) {
  auto pointer = data_->public_key.Get();
  *output = EcdsaP256PublicKeyDataView(pointer, message_);
}
inline void SignatureInfoEcdsaP256SHA256DataView::GetSignatureDataView(
    EcdsaP256SHA256SignatureDataView* output) {
  auto pointer = data_->signature.Get();
  *output = EcdsaP256SHA256SignatureDataView(pointer, message_);
}




inline void BundleIntegrityBlockSignatureStackEntryDataView::GetAttributesCborDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->attributes_cbor.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void BundleIntegrityBlockSignatureStackEntryDataView::GetSignatureInfoDataView(
    SignatureInfoDataView* output) {
  auto pointer = &data_->signature_info;
  *output = SignatureInfoDataView(pointer, message_);
}


inline void BundleMetadataDataView::GetPrimaryUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->primary_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BundleMetadataDataView::GetRequestsDataView(
    mojo::MapDataView<::url::mojom::UrlDataView, BundleResponseLocationDataView>* output) {
  auto pointer = data_->requests.Get();
  *output = mojo::MapDataView<::url::mojom::UrlDataView, BundleResponseLocationDataView>(pointer, message_);
}




inline void BundleResponseDataView::GetResponseHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->response_headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void SignatureInfoDataView::GetUnknownDataView(
    SignatureInfoUnknownDataView* output) const {
  CHECK(is_unknown());
  *output = SignatureInfoUnknownDataView(data_->data.f_unknown.Get(), message_);
}
inline void SignatureInfoDataView::GetEd25519DataView(
    SignatureInfoEd25519DataView* output) const {
  CHECK(is_ed25519());
  *output = SignatureInfoEd25519DataView(data_->data.f_ed25519.Get(), message_);
}
inline void SignatureInfoDataView::GetEcdsaP256Sha256DataView(
    SignatureInfoEcdsaP256SHA256DataView* output) const {
  CHECK(is_ecdsa_p256_sha256());
  *output = SignatureInfoEcdsaP256SHA256DataView(data_->data.f_ecdsa_p256_sha256.Get(), message_);
}


}  // web_package::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::web_package::mojom::BundleParseErrorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::web_package::mojom::BundleParseErrorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::web_package::mojom::BundleFormatVersion> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::web_package::mojom::BundleFormatVersion value);
};

} // namespace perfetto

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_H_