// components/web_package/mojom/web_bundle_parser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace web_package::mojom {
class BundleIntegrityBlockParseErrorDataView;

class BundleMetadataParseErrorDataView;

class BundleResponseParseErrorDataView;

class BundleIntegrityBlockAttributesDataView;

class BundleIntegrityBlockDataView;

class Ed25519PublicKeyDataView;

class Ed25519SignatureDataView;

class SignatureInfoEd25519DataView;

class EcdsaP256PublicKeyDataView;

class EcdsaP256SHA256SignatureDataView;

class SignatureInfoEcdsaP256SHA256DataView;

class SignatureInfoUnknownDataView;

class BundleIntegrityBlockSignatureStackEntryDataView;

class BundleMetadataDataView;

class BundleResponseLocationDataView;

class BundleResponseDataView;

class SignatureInfoDataView;


}  // web_package::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::web_package::mojom::BundleIntegrityBlockParseErrorDataView> {
  using Data = ::web_package::mojom::internal::BundleIntegrityBlockParseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleMetadataParseErrorDataView> {
  using Data = ::web_package::mojom::internal::BundleMetadataParseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseParseErrorDataView> {
  using Data = ::web_package::mojom::internal::BundleResponseParseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleIntegrityBlockAttributesDataView> {
  using Data = ::web_package::mojom::internal::BundleIntegrityBlockAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleIntegrityBlockDataView> {
  using Data = ::web_package::mojom::internal::BundleIntegrityBlock_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::Ed25519PublicKeyDataView> {
  using Data = ::web_package::mojom::internal::Ed25519PublicKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::Ed25519SignatureDataView> {
  using Data = ::web_package::mojom::internal::Ed25519Signature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SignatureInfoEd25519DataView> {
  using Data = ::web_package::mojom::internal::SignatureInfoEd25519_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::EcdsaP256PublicKeyDataView> {
  using Data = ::web_package::mojom::internal::EcdsaP256PublicKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::EcdsaP256SHA256SignatureDataView> {
  using Data = ::web_package::mojom::internal::EcdsaP256SHA256Signature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView> {
  using Data = ::web_package::mojom::internal::SignatureInfoEcdsaP256SHA256_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SignatureInfoUnknownDataView> {
  using Data = ::web_package::mojom::internal::SignatureInfoUnknown_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView> {
  using Data = ::web_package::mojom::internal::BundleIntegrityBlockSignatureStackEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleMetadataDataView> {
  using Data = ::web_package::mojom::internal::BundleMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseLocationDataView> {
  using Data = ::web_package::mojom::internal::BundleResponseLocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::BundleResponseDataView> {
  using Data = ::web_package::mojom::internal::BundleResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::web_package::mojom::SignatureInfoDataView> {
  using Data = ::web_package::mojom::internal::SignatureInfo_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace web_package::mojom {


enum class BundleParseErrorType : int32_t {
  
  kParserInternalError = 0,
  
  kFormatError = 1,
  
  kVersionError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BundleParseErrorType value);
inline bool IsKnownEnumValue(BundleParseErrorType value) {
  return internal::BundleParseErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BundleFormatVersion : int32_t {
  
  kB1 = 0,
  
  kB2 = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, BundleFormatVersion value);
inline bool IsKnownEnumValue(BundleFormatVersion value) {
  return internal::BundleFormatVersion_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebBundleParserFactoryInterfaceBase {};

using WebBundleParserFactoryPtrDataView =
    mojo::InterfacePtrDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryRequestDataView =
    mojo::InterfaceRequestDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBundleParserFactoryInterfaceBase>;
using WebBundleParserFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBundleParserFactoryInterfaceBase>;
class WebBundleParserInterfaceBase {};

using WebBundleParserPtrDataView =
    mojo::InterfacePtrDataView<WebBundleParserInterfaceBase>;
using WebBundleParserRequestDataView =
    mojo::InterfaceRequestDataView<WebBundleParserInterfaceBase>;
using WebBundleParserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBundleParserInterfaceBase>;
using WebBundleParserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBundleParserInterfaceBase>;
class BundleDataSourceInterfaceBase {};

using BundleDataSourcePtrDataView =
    mojo::InterfacePtrDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceRequestDataView =
    mojo::InterfaceRequestDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BundleDataSourceInterfaceBase>;
using BundleDataSourceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BundleDataSourceInterfaceBase>;


class BundleIntegrityBlockParseErrorDataView {
 public:
  BundleIntegrityBlockParseErrorDataView() = default;

  BundleIntegrityBlockParseErrorDataView(
      internal::BundleIntegrityBlockParseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::web_package::mojom::BundleParseErrorType>(
        data_value, output);
  }
  BundleParseErrorType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::web_package::mojom::BundleParseErrorType>(data_->type));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundleIntegrityBlockParseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleMetadataParseErrorDataView {
 public:
  BundleMetadataParseErrorDataView() = default;

  BundleMetadataParseErrorDataView(
      internal::BundleMetadataParseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::web_package::mojom::BundleParseErrorType>(
        data_value, output);
  }
  BundleParseErrorType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::web_package::mojom::BundleParseErrorType>(data_->type));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundleMetadataParseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleResponseParseErrorDataView {
 public:
  BundleResponseParseErrorDataView() = default;

  BundleResponseParseErrorDataView(
      internal::BundleResponseParseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::web_package::mojom::BundleParseErrorType>(
        data_value, output);
  }
  BundleParseErrorType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::web_package::mojom::BundleParseErrorType>(data_->type));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundleResponseParseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleIntegrityBlockAttributesDataView {
 public:
  BundleIntegrityBlockAttributesDataView() = default;

  BundleIntegrityBlockAttributesDataView(
      internal::BundleIntegrityBlockAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebBundleIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleId(UserType* output) {
    
    auto* pointer = data_->web_bundle_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCborDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCbor(UserType* output) {
    
    auto* pointer = data_->cbor.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::BundleIntegrityBlockAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleIntegrityBlockDataView {
 public:
  BundleIntegrityBlockDataView() = default;

  BundleIntegrityBlockDataView(
      internal::BundleIntegrityBlock_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t size() const {
    return data_->size;
  }
  inline void GetSignatureStackDataView(
      mojo::ArrayDataView<BundleIntegrityBlockSignatureStackEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatureStack(UserType* output) {
    
    auto* pointer = data_->signature_stack.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetAttributesDataView(
      BundleIntegrityBlockAttributesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributes(UserType* output) {
    
    auto* pointer = data_->attributes.Get();
    return mojo::internal::Deserialize<::web_package::mojom::BundleIntegrityBlockAttributesDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundleIntegrityBlock_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Ed25519PublicKeyDataView {
 public:
  Ed25519PublicKeyDataView() = default;

  Ed25519PublicKeyDataView(
      internal::Ed25519PublicKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Ed25519PublicKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Ed25519SignatureDataView {
 public:
  Ed25519SignatureDataView() = default;

  Ed25519SignatureDataView(
      internal::Ed25519Signature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Ed25519Signature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignatureInfoEd25519DataView {
 public:
  SignatureInfoEd25519DataView() = default;

  SignatureInfoEd25519DataView(
      internal::SignatureInfoEd25519_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPublicKeyDataView(
      Ed25519PublicKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<::web_package::mojom::Ed25519PublicKeyDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      Ed25519SignatureDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<::web_package::mojom::Ed25519SignatureDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignatureInfoEd25519_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EcdsaP256PublicKeyDataView {
 public:
  EcdsaP256PublicKeyDataView() = default;

  EcdsaP256PublicKeyDataView(
      internal::EcdsaP256PublicKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::EcdsaP256PublicKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EcdsaP256SHA256SignatureDataView {
 public:
  EcdsaP256SHA256SignatureDataView() = default;

  EcdsaP256SHA256SignatureDataView(
      internal::EcdsaP256SHA256Signature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::EcdsaP256SHA256Signature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignatureInfoEcdsaP256SHA256DataView {
 public:
  SignatureInfoEcdsaP256SHA256DataView() = default;

  SignatureInfoEcdsaP256SHA256DataView(
      internal::SignatureInfoEcdsaP256SHA256_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPublicKeyDataView(
      EcdsaP256PublicKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<::web_package::mojom::EcdsaP256PublicKeyDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      EcdsaP256SHA256SignatureDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<::web_package::mojom::EcdsaP256SHA256SignatureDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignatureInfoEcdsaP256SHA256_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignatureInfoUnknownDataView {
 public:
  SignatureInfoUnknownDataView() = default;

  SignatureInfoUnknownDataView(
      internal::SignatureInfoUnknown_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SignatureInfoUnknown_Data* data_ = nullptr;
};


class BundleIntegrityBlockSignatureStackEntryDataView {
 public:
  BundleIntegrityBlockSignatureStackEntryDataView() = default;

  BundleIntegrityBlockSignatureStackEntryDataView(
      internal::BundleIntegrityBlockSignatureStackEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAttributesCborDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributesCbor(UserType* output) {
    
    auto* pointer = data_->attributes_cbor.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetSignatureInfoDataView(
      SignatureInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatureInfo(UserType* output) {
    
    auto* pointer = !data_->signature_info.is_null() ? &data_->signature_info : nullptr;
    return mojo::internal::Deserialize<::web_package::mojom::SignatureInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundleIntegrityBlockSignatureStackEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleMetadataDataView {
 public:
  BundleMetadataDataView() = default;

  BundleMetadataDataView(
      internal::BundleMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) const {
    auto data_value = data_->version;
    return mojo::internal::Deserialize<::web_package::mojom::BundleFormatVersion>(
        data_value, output);
  }
  BundleFormatVersion version() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::web_package::mojom::BundleFormatVersion>(data_->version));
  }
  inline void GetPrimaryUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `primary_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrimaryUrl` instead "
    "of `ReadPrimaryUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->primary_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRequestsDataView(
      mojo::MapDataView<::url::mojom::UrlDataView, BundleResponseLocationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequests(UserType* output) {
    
    auto* pointer = data_->requests.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::BundleResponseLocationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BundleMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundleResponseLocationDataView {
 public:
  BundleResponseLocationDataView() = default;

  BundleResponseLocationDataView(
      internal::BundleResponseLocation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
 private:
  internal::BundleResponseLocation_Data* data_ = nullptr;
};


class BundleResponseDataView {
 public:
  BundleResponseDataView() = default;

  BundleResponseDataView(
      internal::BundleResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t response_code() const {
    return data_->response_code;
  }
  inline void GetResponseHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  uint64_t payload_offset() const {
    return data_->payload_offset;
  }
  uint64_t payload_length() const {
    return data_->payload_length;
  }
 private:
  internal::BundleResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignatureInfoDataView {
 public:
  using Tag = internal::SignatureInfo_Data::SignatureInfo_Tag;

  SignatureInfoDataView() = default;

  SignatureInfoDataView(
      internal::SignatureInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_unknown() const { return data_->tag == Tag::kUnknown; }
  inline void GetUnknownDataView(
      SignatureInfoUnknownDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnknown(UserType* output) const {
    
    CHECK(is_unknown());
    return mojo::internal::Deserialize<::web_package::mojom::SignatureInfoUnknownDataView>(
        data_->data.f_unknown.Get(), output, message_);
  }
  bool is_ed25519() const { return data_->tag == Tag::kEd25519; }
  inline void GetEd25519DataView(
      SignatureInfoEd25519DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEd25519(UserType* output) const {
    
    CHECK(is_ed25519());
    return mojo::internal::Deserialize<::web_package::mojom::SignatureInfoEd25519DataView>(
        data_->data.f_ed25519.Get(), output, message_);
  }
  bool is_ecdsa_p256_sha256() const { return data_->tag == Tag::kEcdsaP256Sha256; }
  inline void GetEcdsaP256Sha256DataView(
      SignatureInfoEcdsaP256SHA256DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEcdsaP256Sha256(UserType* output) const {
    
    CHECK(is_ecdsa_p256_sha256());
    return mojo::internal::Deserialize<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView>(
        data_->data.f_ecdsa_p256_sha256.Get(), output, message_);
  }

 private:
  internal::SignatureInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // web_package::mojom

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_DATA_VIEW_H_