// components/wallet/content/common/mojom/image_extractor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WALLET_CONTENT_COMMON_MOJOM_IMAGE_EXTRACTOR_MOJOM_H_
#define COMPONENTS_WALLET_CONTENT_COMMON_MOJOM_IMAGE_EXTRACTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/wallet/content/common/mojom/image_extractor.mojom-features.h"  // IWYU pragma: export
#include "components/wallet/content/common/mojom/image_extractor.mojom-shared.h"  // IWYU pragma: export
#include "components/wallet/content/common/mojom/image_extractor.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace wallet::mojom {

class ImageExtractorProxy;

template <typename ImplRefTraits>
class ImageExtractorStub;

class ImageExtractorRequestValidator;
class ImageExtractorResponseValidator;


class ImageExtractor
    : public ImageExtractorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "wallet.mojom.ImageExtractor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImageExtractorInterfaceBase;
  using Proxy_ = ImageExtractorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImageExtractorStub<ImplRefTraits>;

  using RequestValidator_ = ImageExtractorRequestValidator;
  using ResponseValidator_ = ImageExtractorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtractImagesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExtractImages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImageExtractor() = default;

  using ExtractImagesCallback = base::OnceCallback<void(const std::vector<::SkBitmap>&)>;
  using ExtractImagesMojoCallback = base::OnceCallback<void(const std::vector<::SkBitmap>&)>;

  virtual void ExtractImages(ExtractImagesCallback callback) = 0;
};



class  ImageExtractorProxy
    : public ImageExtractor {
 public:
  using InterfaceType = ImageExtractor;

  explicit ImageExtractorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExtractImages(ExtractImagesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ImageExtractorStubDispatch {
 public:
  static bool Accept(ImageExtractor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImageExtractor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImageExtractor>>
class ImageExtractorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImageExtractorStub() = default;
  ~ImageExtractorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageExtractorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageExtractorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ImageExtractorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ImageExtractorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // wallet::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_WALLET_CONTENT_COMMON_MOJOM_IMAGE_EXTRACTOR_MOJOM_H_