// components/variations/variations.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_H_
#define COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/variations/variations.mojom-features.h"  // IWYU pragma: export
#include "components/variations/variations.mojom-shared.h"  // IWYU pragma: export
#include "components/variations/variations.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace variations::mojom {








class  VariationsHeaders {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VariationsHeaders, T>::value>;
  using DataView = VariationsHeadersDataView;
  using Data_ = internal::VariationsHeaders_Data;

  template <typename... Args>
  static VariationsHeadersPtr New(Args&&... args) {
    return VariationsHeadersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VariationsHeadersPtr From(const U& u) {
    return mojo::TypeConverter<VariationsHeadersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VariationsHeaders>::Convert(*this);
  }


  VariationsHeaders();

  explicit VariationsHeaders(
      const base::flat_map<GoogleWebVisibility, std::string>& headers_map);


  ~VariationsHeaders();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VariationsHeadersPtr>
  VariationsHeadersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariationsHeaders::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariationsHeaders::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VariationsHeaders::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VariationsHeaders_UnserializedMessageContext<
            UserType, VariationsHeaders::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VariationsHeaders::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VariationsHeaders::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VariationsHeaders_UnserializedMessageContext<
            UserType, VariationsHeaders::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VariationsHeaders::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<GoogleWebVisibility, std::string> headers_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VariationsHeaders::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VariationsHeadersPtr VariationsHeaders::Clone() const {
  return New(
      mojo::Clone(headers_map)
  );
}

template <typename T, VariationsHeaders::EnableIfSame<T>*>
bool VariationsHeaders::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers_map, other_struct.headers_map))
    return false;
  return true;
}

template <typename T, VariationsHeaders::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.headers_map < rhs.headers_map)
    return true;
  if (rhs.headers_map < lhs.headers_map)
    return false;
  return false;
}


}  // variations::mojom

namespace mojo {


template <>
struct  StructTraits<::variations::mojom::VariationsHeaders::DataView,
                                         ::variations::mojom::VariationsHeadersPtr> {
  static bool IsNull(const ::variations::mojom::VariationsHeadersPtr& input) { return !input; }
  static void SetToNull(::variations::mojom::VariationsHeadersPtr* output) { output->reset(); }

  static const decltype(::variations::mojom::VariationsHeaders::headers_map)& headers_map(
      const ::variations::mojom::VariationsHeadersPtr& input) {
    return input->headers_map;
  }

  static bool Read(::variations::mojom::VariationsHeaders::DataView input, ::variations::mojom::VariationsHeadersPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_H_