// components/user_data_importer/mojom/bookmark_html_parser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_SHARED_H_
#define COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::user_data_importer::mojom::ImportedBookmarkEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::user_data_importer::mojom::ImportedBookmarkEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::user_data_importer::mojom::internal::ImportedBookmarkEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_folder = Traits::is_folder(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ImportedBookmarkEntry struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType>
        path_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_path,
      path_fragment,
      &path_validate_params);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in ImportedBookmarkEntry struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ImportedBookmarkEntry struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in ImportedBookmarkEntry struct");

    decltype(Traits::last_visit_time(input)) in_last_visit_time = Traits::last_visit_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_visit_time)::BaseType> last_visit_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_visit_time,
      last_visit_time_fragment);

    fragment->last_visit_time.Set(
        last_visit_time_fragment.is_null() ? nullptr : last_visit_time_fragment.data());

    fragment->in_toolbar = Traits::in_toolbar(input);
  }

  static bool Deserialize(::user_data_importer::mojom::internal::ImportedBookmarkEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::user_data_importer::mojom::ImportedBookmarkEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::user_data_importer::mojom::SearchEngineInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::user_data_importer::mojom::SearchEngineInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::user_data_importer::mojom::internal::SearchEngineInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in SearchEngineInfo struct");

    decltype(Traits::keyword(input)) in_keyword = Traits::keyword(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyword)::BaseType> keyword_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_keyword,
      keyword_fragment);

    fragment->keyword.Set(
        keyword_fragment.is_null() ? nullptr : keyword_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->keyword.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keyword in SearchEngineInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SearchEngineInfo struct");
  }

  static bool Deserialize(::user_data_importer::mojom::internal::SearchEngineInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::user_data_importer::mojom::SearchEngineInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::user_data_importer::mojom::FaviconUsageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::user_data_importer::mojom::FaviconUsageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::user_data_importer::mojom::internal::FaviconUsageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_url in FaviconUsageData struct");

    decltype(Traits::png_data(input)) in_png_data = Traits::png_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->png_data)::BaseType>
        png_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& png_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_png_data,
      png_data_fragment,
      &png_data_validate_params);

    fragment->png_data.Set(
        png_data_fragment.is_null() ? nullptr : png_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->png_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null png_data in FaviconUsageData struct");

    decltype(Traits::urls(input)) in_urls = Traits::urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urls)::BaseType>
        urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_urls,
      urls_fragment,
      &urls_validate_params);

    fragment->urls.Set(
        urls_fragment.is_null() ? nullptr : urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null urls in FaviconUsageData struct");
  }

  static bool Deserialize(::user_data_importer::mojom::internal::FaviconUsageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::user_data_importer::mojom::FaviconUsageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::user_data_importer::mojom::ParsedBookmarksDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::user_data_importer::mojom::ParsedBookmarksDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::user_data_importer::mojom::internal::ParsedBookmarks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bookmarks(input)) in_bookmarks = Traits::bookmarks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bookmarks)::BaseType>
        bookmarks_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bookmarks_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::user_data_importer::mojom::ImportedBookmarkEntryDataView>>(
      in_bookmarks,
      bookmarks_fragment,
      &bookmarks_validate_params);

    fragment->bookmarks.Set(
        bookmarks_fragment.is_null() ? nullptr : bookmarks_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bookmarks.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bookmarks in ParsedBookmarks struct");

    decltype(Traits::reading_list(input)) in_reading_list = Traits::reading_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reading_list)::BaseType>
        reading_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& reading_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::user_data_importer::mojom::ImportedBookmarkEntryDataView>>(
      in_reading_list,
      reading_list_fragment,
      &reading_list_validate_params);

    fragment->reading_list.Set(
        reading_list_fragment.is_null() ? nullptr : reading_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reading_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reading_list in ParsedBookmarks struct");

    decltype(Traits::search_engines(input)) in_search_engines = Traits::search_engines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->search_engines)::BaseType>
        search_engines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& search_engines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::user_data_importer::mojom::SearchEngineInfoDataView>>(
      in_search_engines,
      search_engines_fragment,
      &search_engines_validate_params);

    fragment->search_engines.Set(
        search_engines_fragment.is_null() ? nullptr : search_engines_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->search_engines.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null search_engines in ParsedBookmarks struct");

    decltype(Traits::favicons(input)) in_favicons = Traits::favicons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicons)::BaseType>
        favicons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& favicons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::user_data_importer::mojom::FaviconUsageDataDataView>>(
      in_favicons,
      favicons_fragment,
      &favicons_validate_params);

    fragment->favicons.Set(
        favicons_fragment.is_null() ? nullptr : favicons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicons in ParsedBookmarks struct");
  }

  static bool Deserialize(::user_data_importer::mojom::internal::ParsedBookmarks_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::user_data_importer::mojom::ParsedBookmarksDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace user_data_importer::mojom {

inline void ImportedBookmarkEntryDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImportedBookmarkEntryDataView::GetPathDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->path.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void ImportedBookmarkEntryDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ImportedBookmarkEntryDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void ImportedBookmarkEntryDataView::GetLastVisitTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_visit_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void SearchEngineInfoDataView::GetDisplayNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->display_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SearchEngineInfoDataView::GetKeywordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->keyword.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SearchEngineInfoDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void FaviconUsageDataDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FaviconUsageDataDataView::GetPngDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->png_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void FaviconUsageDataDataView::GetUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void ParsedBookmarksDataView::GetBookmarksDataView(
    mojo::ArrayDataView<ImportedBookmarkEntryDataView>* output) {
  auto pointer = data_->bookmarks.Get();
  *output = mojo::ArrayDataView<ImportedBookmarkEntryDataView>(pointer, message_);
}
inline void ParsedBookmarksDataView::GetReadingListDataView(
    mojo::ArrayDataView<ImportedBookmarkEntryDataView>* output) {
  auto pointer = data_->reading_list.Get();
  *output = mojo::ArrayDataView<ImportedBookmarkEntryDataView>(pointer, message_);
}
inline void ParsedBookmarksDataView::GetSearchEnginesDataView(
    mojo::ArrayDataView<SearchEngineInfoDataView>* output) {
  auto pointer = data_->search_engines.Get();
  *output = mojo::ArrayDataView<SearchEngineInfoDataView>(pointer, message_);
}
inline void ParsedBookmarksDataView::GetFaviconsDataView(
    mojo::ArrayDataView<FaviconUsageDataDataView>* output) {
  auto pointer = data_->favicons.Get();
  *output = mojo::ArrayDataView<FaviconUsageDataDataView>(pointer, message_);
}



}  // user_data_importer::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_SHARED_H_