// components/user_data_importer/mojom/bookmark_html_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-params-data.h"
namespace user_data_importer {
namespace mojom {

namespace internal {


// static
bool ImportedBookmarkEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImportedBookmarkEntry_Data* object =
      static_cast<const ImportedBookmarkEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_visit_time, validation_context))
    return false;

  return true;
}

ImportedBookmarkEntry_Data::ImportedBookmarkEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchEngineInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchEngineInfo_Data* object =
      static_cast<const SearchEngineInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyword, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

SearchEngineInfo_Data::SearchEngineInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FaviconUsageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FaviconUsageData_Data* object =
      static_cast<const FaviconUsageData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->png_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& png_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->png_data, validation_context,
                                         &png_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

FaviconUsageData_Data::FaviconUsageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParsedBookmarks_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ParsedBookmarks_Data* object =
      static_cast<const ParsedBookmarks_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmarks, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bookmarks, validation_context,
                                         &bookmarks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reading_list, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reading_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reading_list, validation_context,
                                         &reading_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search_engines, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_engines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->search_engines, validation_context,
                                         &search_engines_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicons, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& favicons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->favicons, validation_context,
                                         &favicons_validate_params)) {
    return false;
  }

  return true;
}

ParsedBookmarks_Data::ParsedBookmarks_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkHtmlParser_Parse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkHtmlParser_Parse_Params_Data* object =
      static_cast<const BookmarkHtmlParser_Parse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_html, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_html_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_html, validation_context,
                                         &raw_html_validate_params)) {
    return false;
  }

  return true;
}

BookmarkHtmlParser_Parse_Params_Data::BookmarkHtmlParser_Parse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkHtmlParser_Parse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkHtmlParser_Parse_ResponseParams_Data* object =
      static_cast<const BookmarkHtmlParser_Parse_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

BookmarkHtmlParser_Parse_ResponseParams_Data::BookmarkHtmlParser_Parse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace user_data_importer