// components/unexportable_keys/mojom/unexportable_key_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SignatureAlgorithmSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SignatureAlgorithm = {
  
  RSA_PKCS1_SHA1: 0,
  RSA_PKCS1_SHA256: 1,
  ECDSA_SHA256: 2,
  RSA_PSS_SHA256: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ServiceErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ServiceError = {
  
  kCryptoApiFailed: 1,
  kKeyNotFound: 2,
  kKeyCollision: 3,
  kNoKeyProvider: 4,
  kAlgorithmNotSupported: 5,
  kKeyNotReady: 6,
  kVerifySignatureFailed: 7,
  kOperationNotSupported: 8,
  MIN_VALUE: 1,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundTaskPrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundTaskPriority = {
  
  kBestEffort: 0,
  kUserVisible: 1,
  kUserBlocking: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UnexportableKeyServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'unexportable_keys.mojom.UnexportableKeyService', scope);
  }
}

/** @interface */
export class UnexportableKeyServiceInterface {
  
  /**
   * @param { !Array<!SignatureAlgorithm> } acceptableAlgorithms
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_GenerateSigningKey_ResponseParam_Result,
   *  }>}
   */

  generateSigningKey(acceptableAlgorithms, priority) {}
  
  /**
   * @param { !Array<!number> } wrappedKey
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result,
   *  }>}
   */

  fromWrappedSigningKey(wrappedKey, priority) {}
  
  /**
   * @param { !UnexportableKeyId } keyId
   * @param { !Array<!number> } data
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_Sign_ResponseParam_Result,
   *  }>}
   */

  sign(keyId, data, priority) {}
  
  /**
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result,
   *  }>}
   */

  getAllSigningKeysForGarbageCollection(priority) {}
  
  /**
   * @param { !UnexportableKeyId } keyId
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        error: ?ServiceError,
   *  }>}
   */

  deleteKey(keyId, priority) {}
  
  /**
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_DeleteAllKeys_ResponseParam_Result,
   *  }>}
   */

  deleteAllKeys(priority) {}
}

/**
 * @implements { UnexportableKeyServiceInterface }
 */
export class UnexportableKeyServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UnexportableKeyServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UnexportableKeyServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UnexportableKeyServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!SignatureAlgorithm> } acceptableAlgorithms
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_GenerateSigningKey_ResponseParam_Result,
   *  }>}
   */

  generateSigningKey(
      acceptableAlgorithms,
      priority) {
    return this.proxy.sendMessage(
        0,
        UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        [
          acceptableAlgorithms,
          priority
        ],
        true);
  }

  
  /**
   * @param { !Array<!number> } wrappedKey
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result,
   *  }>}
   */

  fromWrappedSigningKey(
      wrappedKey,
      priority) {
    return this.proxy.sendMessage(
        1,
        UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        [
          wrappedKey,
          priority
        ],
        true);
  }

  
  /**
   * @param { !UnexportableKeyId } keyId
   * @param { !Array<!number> } data
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_Sign_ResponseParam_Result,
   *  }>}
   */

  sign(
      keyId,
      data,
      priority) {
    return this.proxy.sendMessage(
        2,
        UnexportableKeyService_Sign_ParamsSpec.$,
        UnexportableKeyService_Sign_ResponseParamsSpec.$,
        [
          keyId,
          data,
          priority
        ],
        true);
  }

  
  /**
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result,
   *  }>}
   */

  getAllSigningKeysForGarbageCollection(
      priority) {
    return this.proxy.sendMessage(
        3,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        [
          priority
        ],
        true);
  }

  
  /**
   * @param { !UnexportableKeyId } keyId
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        error: ?ServiceError,
   *  }>}
   */

  deleteKey(
      keyId,
      priority) {
    return this.proxy.sendMessage(
        4,
        UnexportableKeyService_DeleteKey_ParamsSpec.$,
        UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        [
          keyId,
          priority
        ],
        false);
  }

  
  /**
   * @param { !BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !UnexportableKeyService_DeleteAllKeys_ResponseParam_Result,
   *  }>}
   */

  deleteAllKeys(
      priority) {
    return this.proxy.sendMessage(
        5,
        UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        [
          priority
        ],
        true);
  }
}

/**
 * An object which receives request messages for the UnexportableKeyService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UnexportableKeyServiceReceiver {
  /**
   * @param {!UnexportableKeyServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UnexportableKeyServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UnexportableKeyServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UnexportableKeyServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        impl.generateSigningKey.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        1,
        UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        impl.fromWrappedSigningKey.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        UnexportableKeyService_Sign_ParamsSpec.$,
        UnexportableKeyService_Sign_ResponseParamsSpec.$,
        impl.sign.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        3,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        impl.getAllSigningKeysForGarbageCollection.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        UnexportableKeyService_DeleteKey_ParamsSpec.$,
        UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        impl.deleteKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        impl.deleteAllKeys.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UnexportableKeyService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "unexportable_keys.mojom.UnexportableKeyService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UnexportableKeyServiceRemote}
   */
  static getRemote() {
    let remote = new UnexportableKeyServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UnexportableKeyService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UnexportableKeyServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UnexportableKeyServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UnexportableKeyServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generateSigningKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        this.generateSigningKey.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fromWrappedSigningKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        this.fromWrappedSigningKey.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sign =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UnexportableKeyService_Sign_ParamsSpec.$,
        UnexportableKeyService_Sign_ResponseParamsSpec.$,
        this.sign.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllSigningKeysForGarbageCollection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        this.getAllSigningKeysForGarbageCollection.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UnexportableKeyService_DeleteKey_ParamsSpec.$,
        UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        this.deleteKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAllKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        this.deleteAllKeys.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NewKeyDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_GenerateSigningKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_FromWrappedSigningKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_Sign_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_Sign_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_DeleteKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_DeleteKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_DeleteAllKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UnexportableKeyService_Sign_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    UnexportableKeyIdSpec.$,
    'UnexportableKeyId',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UnexportableKeyId {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.keyId;
  }
}



mojo.internal.Struct(
    NewKeyDataSpec.$,
    'NewKeyData',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        UnexportableKeyIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subjectPublicKeyInfo', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wrappedKey', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'algorithm', 24,
        0,
        SignatureAlgorithmSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NewKeyData {
  constructor() {
    /** @type { !UnexportableKeyId } */
    this.keyId;
    /** @type { !Array<!number> } */
    this.subjectPublicKeyInfo;
    /** @type { !Array<!number> } */
    this.wrappedKey;
    /** @type { !SignatureAlgorithm } */
    this.algorithm;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
    'UnexportableKeyService_GenerateSigningKey_Params',
    [
      mojo.internal.StructField(
        'acceptableAlgorithms', 0,
        0,
        mojo.internal.Array(SignatureAlgorithmSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_GenerateSigningKey_Params {
  constructor() {
    /** @type { !Array<!SignatureAlgorithm> } */
    this.acceptableAlgorithms;
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
    'UnexportableKeyService_GenerateSigningKey_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_GenerateSigningKey_ResponseParams {
  constructor() {
    /** @type { !UnexportableKeyService_GenerateSigningKey_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
    'UnexportableKeyService_FromWrappedSigningKey_Params',
    [
      mojo.internal.StructField(
        'wrappedKey', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_FromWrappedSigningKey_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.wrappedKey;
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
    'UnexportableKeyService_FromWrappedSigningKey_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_FromWrappedSigningKey_ResponseParams {
  constructor() {
    /** @type { !UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_Sign_ParamsSpec.$,
    'UnexportableKeyService_Sign_Params',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        UnexportableKeyIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 16,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UnexportableKeyService_Sign_Params {
  constructor() {
    /** @type { !UnexportableKeyId } */
    this.keyId;
    /** @type { !Array<!number> } */
    this.data;
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_Sign_ResponseParamsSpec.$,
    'UnexportableKeyService_Sign_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UnexportableKeyService_Sign_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_Sign_ResponseParams {
  constructor() {
    /** @type { !UnexportableKeyService_Sign_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
    'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params {
  constructor() {
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
    'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams {
  constructor() {
    /** @type { !UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_DeleteKey_ParamsSpec.$,
    'UnexportableKeyService_DeleteKey_Params',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        UnexportableKeyIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_DeleteKey_Params {
  constructor() {
    /** @type { !UnexportableKeyId } */
    this.keyId;
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
    'UnexportableKeyService_DeleteKey_ResponseParams',
    [
      mojo.internal.StructField(
        'error_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_$value",
          originalFieldName: "error",
        }
      ),
      mojo.internal.StructField(
        'error_$value', 4,
        0,
        ServiceErrorSpec.$,
        1,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "error",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UnexportableKeyService_DeleteKey_ResponseParams {
  constructor() {
    /** @type { (ServiceError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
    'UnexportableKeyService_DeleteAllKeys_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        BackgroundTaskPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UnexportableKeyService_DeleteAllKeys_Params {
  constructor() {
    /** @type { !BackgroundTaskPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
    'UnexportableKeyService_DeleteAllKeys_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UnexportableKeyService_DeleteAllKeys_ResponseParams {
  constructor() {
    /** @type { !UnexportableKeyService_DeleteAllKeys_ResponseParam_Result } */
    this.result;
  }
}

mojo.internal.Union(
    UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec.$, 'UnexportableKeyService_GenerateSigningKey_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': NewKeyDataSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!NewKeyData|undefined),
 *   failure: (!ServiceError|undefined),
 * } }
 */
export const UnexportableKeyService_GenerateSigningKey_ResponseParam_Result = {};
mojo.internal.Union(
    UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec.$, 'UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': NewKeyDataSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!NewKeyData|undefined),
 *   failure: (!ServiceError|undefined),
 * } }
 */
export const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result = {};
mojo.internal.Union(
    UnexportableKeyService_Sign_ResponseParam_ResultSpec.$, 'UnexportableKeyService_Sign_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'failure': {
        'ordinal': 1,
        'type': ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!number>|undefined),
 *   failure: (!ServiceError|undefined),
 * } }
 */
export const UnexportableKeyService_Sign_ResponseParam_Result = {};
mojo.internal.Union(
    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec.$, 'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(UnexportableKeyIdSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!UnexportableKeyId>|undefined),
 *   failure: (!ServiceError|undefined),
 * } }
 */
export const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result = {};
mojo.internal.Union(
    UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec.$, 'UnexportableKeyService_DeleteAllKeys_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Uint64,
      },
      'failure': {
        'ordinal': 1,
        'type': ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!bigint|undefined),
 *   failure: (!ServiceError|undefined),
 * } }
 */
export const UnexportableKeyService_DeleteAllKeys_ResponseParam_Result = {};
