// components/unexportable_keys/mojom/unexportable_key_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/unexportable_keys/mojom/unexportable_key_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('unexportableKeys.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }


  var SignatureAlgorithm = {};
  SignatureAlgorithm.RSA_PKCS1_SHA1 = 0;
  SignatureAlgorithm.RSA_PKCS1_SHA256 = 1;
  SignatureAlgorithm.ECDSA_SHA256 = 2;
  SignatureAlgorithm.RSA_PSS_SHA256 = 3;
  SignatureAlgorithm.MIN_VALUE = 0;
  SignatureAlgorithm.MAX_VALUE = 3;

  SignatureAlgorithm.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SignatureAlgorithm.toKnownEnumValue = function(value) {
    return value;
  };

  SignatureAlgorithm.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ServiceError = {};
  ServiceError.kCryptoApiFailed = 1;
  ServiceError.kKeyNotFound = 2;
  ServiceError.kKeyCollision = 3;
  ServiceError.kNoKeyProvider = 4;
  ServiceError.kAlgorithmNotSupported = 5;
  ServiceError.kKeyNotReady = 6;
  ServiceError.kVerifySignatureFailed = 7;
  ServiceError.kOperationNotSupported = 8;
  ServiceError.MIN_VALUE = 1;
  ServiceError.MAX_VALUE = 8;

  ServiceError.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  ServiceError.toKnownEnumValue = function(value) {
    return value;
  };

  ServiceError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BackgroundTaskPriority = {};
  BackgroundTaskPriority.kBestEffort = 0;
  BackgroundTaskPriority.kUserVisible = 1;
  BackgroundTaskPriority.kUserBlocking = 2;
  BackgroundTaskPriority.MIN_VALUE = 0;
  BackgroundTaskPriority.MAX_VALUE = 2;

  BackgroundTaskPriority.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  BackgroundTaskPriority.toKnownEnumValue = function(value) {
    return value;
  };

  BackgroundTaskPriority.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function UnexportableKeyId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyId.prototype.initDefaults_ = function() {
    this.keyId = null;
  };
  UnexportableKeyId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyId.keyId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyId.encodedSize = codec.kStructHeaderSize + 8;

  UnexportableKeyId.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  UnexportableKeyId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.keyId);
  };
  function NewKeyData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NewKeyData.prototype.initDefaults_ = function() {
    this.keyId = null;
    this.subjectPublicKeyInfo = null;
    this.wrappedKey = null;
    this.algorithm = 0;
  };
  NewKeyData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NewKeyData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NewKeyData.keyId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UnexportableKeyId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NewKeyData.subjectPublicKeyInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NewKeyData.wrappedKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NewKeyData.algorithm
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, SignatureAlgorithm);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NewKeyData.encodedSize = codec.kStructHeaderSize + 32;

  NewKeyData.decode = function(decoder) {
    var packed;
    var val = new NewKeyData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyId =
        decoder.decodeStructPointer(UnexportableKeyId);
    val.subjectPublicKeyInfo =
        decoder.decodeArrayPointer(codec.Uint8);
    val.wrappedKey =
        decoder.decodeArrayPointer(codec.Uint8);
    val.algorithm =
        decoder.decodeStruct(new codec.Enum(SignatureAlgorithm));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NewKeyData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NewKeyData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UnexportableKeyId, val.keyId);
    encoder.encodeArrayPointer(codec.Uint8, val.subjectPublicKeyInfo);
    encoder.encodeArrayPointer(codec.Uint8, val.wrappedKey);
    encoder.encodeStruct(codec.Int32, val.algorithm);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_GenerateSigningKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_GenerateSigningKey_Params.prototype.initDefaults_ = function() {
    this.acceptableAlgorithms = null;
    this.priority = 0;
  };
  UnexportableKeyService_GenerateSigningKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_GenerateSigningKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_GenerateSigningKey_Params.acceptableAlgorithms
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(SignatureAlgorithm), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_GenerateSigningKey_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_GenerateSigningKey_Params.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_GenerateSigningKey_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_GenerateSigningKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.acceptableAlgorithms =
        decoder.decodeArrayPointer(new codec.Enum(SignatureAlgorithm));
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_GenerateSigningKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_GenerateSigningKey_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(SignatureAlgorithm), val.acceptableAlgorithms);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_GenerateSigningKey_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_GenerateSigningKey_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  UnexportableKeyService_GenerateSigningKey_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_GenerateSigningKey_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_GenerateSigningKey_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UnexportableKeyService_GenerateSigningKey_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_GenerateSigningKey_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_GenerateSigningKey_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_GenerateSigningKey_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(UnexportableKeyService_GenerateSigningKey_ResponseParam_Result);
    return val;
  };

  UnexportableKeyService_GenerateSigningKey_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_GenerateSigningKey_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UnexportableKeyService_GenerateSigningKey_ResponseParam_Result, val.result);
  };
  function UnexportableKeyService_FromWrappedSigningKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_FromWrappedSigningKey_Params.prototype.initDefaults_ = function() {
    this.wrappedKey = null;
    this.priority = 0;
  };
  UnexportableKeyService_FromWrappedSigningKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_FromWrappedSigningKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_FromWrappedSigningKey_Params.wrappedKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_FromWrappedSigningKey_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_FromWrappedSigningKey_Params.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_FromWrappedSigningKey_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_FromWrappedSigningKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.wrappedKey =
        decoder.decodeArrayPointer(codec.Uint8);
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_FromWrappedSigningKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_FromWrappedSigningKey_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.wrappedKey);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_FromWrappedSigningKey_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_FromWrappedSigningKey_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_FromWrappedSigningKey_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result);
    return val;
  };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_FromWrappedSigningKey_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result, val.result);
  };
  function UnexportableKeyService_Sign_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_Sign_Params.prototype.initDefaults_ = function() {
    this.keyId = null;
    this.data = null;
    this.priority = 0;
  };
  UnexportableKeyService_Sign_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_Sign_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_Sign_Params.keyId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UnexportableKeyId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_Sign_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_Sign_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_Sign_Params.encodedSize = codec.kStructHeaderSize + 24;

  UnexportableKeyService_Sign_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_Sign_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyId =
        decoder.decodeStructPointer(UnexportableKeyId);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_Sign_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_Sign_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UnexportableKeyId, val.keyId);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_Sign_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_Sign_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  UnexportableKeyService_Sign_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_Sign_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_Sign_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UnexportableKeyService_Sign_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_Sign_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_Sign_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_Sign_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(UnexportableKeyService_Sign_ResponseParam_Result);
    return val;
  };

  UnexportableKeyService_Sign_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_Sign_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UnexportableKeyService_Sign_ResponseParam_Result, val.result);
  };
  function UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.prototype.initDefaults_ = function() {
    this.priority = 0;
  };
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.encodedSize = codec.kStructHeaderSize + 8;

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result);
    return val;
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result, val.result);
  };
  function UnexportableKeyService_DeleteKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_DeleteKey_Params.prototype.initDefaults_ = function() {
    this.keyId = null;
    this.priority = 0;
  };
  UnexportableKeyService_DeleteKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_DeleteKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_DeleteKey_Params.keyId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UnexportableKeyId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_DeleteKey_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_DeleteKey_Params.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_DeleteKey_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_DeleteKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyId =
        decoder.decodeStructPointer(UnexportableKeyId);
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_DeleteKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_DeleteKey_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UnexportableKeyId, val.keyId);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_DeleteKey_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_DeleteKey_ResponseParams.prototype.initDefaults_ = function() {
    this.error_$flag = false;
    this.error_$value = 0;
  };
  UnexportableKeyService_DeleteKey_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_DeleteKey_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate UnexportableKeyService_DeleteKey_ResponseParams.error_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_DeleteKey_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UnexportableKeyService_DeleteKey_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_DeleteKey_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.error_$value =
        decoder.decodeStruct(new codec.Enum(ServiceError));
    return val;
  };

  UnexportableKeyService_DeleteKey_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_DeleteKey_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.error_$value);
  };
  function UnexportableKeyService_DeleteAllKeys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_DeleteAllKeys_Params.prototype.initDefaults_ = function() {
    this.priority = 0;
  };
  UnexportableKeyService_DeleteAllKeys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_DeleteAllKeys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_DeleteAllKeys_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundTaskPriority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_DeleteAllKeys_Params.encodedSize = codec.kStructHeaderSize + 8;

  UnexportableKeyService_DeleteAllKeys_Params.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_DeleteAllKeys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.priority =
        decoder.decodeStruct(new codec.Enum(BackgroundTaskPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UnexportableKeyService_DeleteAllKeys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_DeleteAllKeys_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UnexportableKeyService_DeleteAllKeys_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnexportableKeyService_DeleteAllKeys_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  UnexportableKeyService_DeleteAllKeys_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnexportableKeyService_DeleteAllKeys_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnexportableKeyService_DeleteAllKeys_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UnexportableKeyService_DeleteAllKeys_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnexportableKeyService_DeleteAllKeys_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UnexportableKeyService_DeleteAllKeys_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UnexportableKeyService_DeleteAllKeys_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(UnexportableKeyService_DeleteAllKeys_ResponseParam_Result);
    return val;
  };

  UnexportableKeyService_DeleteAllKeys_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnexportableKeyService_DeleteAllKeys_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UnexportableKeyService_DeleteAllKeys_ResponseParam_Result, val.result);
  };

  function UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UnexportableKeyService_GenerateSigningKey_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.success:
          encoder.encodeStructPointer(NewKeyData, val.success);
          break;
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UnexportableKeyService_GenerateSigningKey_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStructPointer(NewKeyData);
          break;
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(ServiceError));
          break;
      }
      decoder.align();

      return result;
    };


    UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.success:
          

    // validate UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.success
    err = messageValidator.validateStructPointer(data_offset, NewKeyData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.Tags.failure:
          

    // validate UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result.encodedSize = 16;

  function UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.success:
          encoder.encodeStructPointer(NewKeyData, val.success);
          break;
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStructPointer(NewKeyData);
          break;
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(ServiceError));
          break;
      }
      decoder.align();

      return result;
    };


    UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.success:
          

    // validate UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.success
    err = messageValidator.validateStructPointer(data_offset, NewKeyData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.Tags.failure:
          

    // validate UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result.encodedSize = 16;

  function UnexportableKeyService_Sign_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UnexportableKeyService_Sign_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  UnexportableKeyService_Sign_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UnexportableKeyService_Sign_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UnexportableKeyService_Sign_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UnexportableKeyService_Sign_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != UnexportableKeyService_Sign_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "UnexportableKeyService_Sign_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_Sign_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(UnexportableKeyService_Sign_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != UnexportableKeyService_Sign_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "UnexportableKeyService_Sign_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_Sign_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    UnexportableKeyService_Sign_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(codec.Uint8, val.success);
          break;
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    UnexportableKeyService_Sign_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UnexportableKeyService_Sign_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(codec.Uint8);
          break;
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(ServiceError));
          break;
      }
      decoder.align();

      return result;
    };


    UnexportableKeyService_Sign_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.success:
          

    // validate UnexportableKeyService_Sign_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case UnexportableKeyService_Sign_ResponseParam_Result.Tags.failure:
          

    // validate UnexportableKeyService_Sign_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UnexportableKeyService_Sign_ResponseParam_Result.encodedSize = 16;

  function UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(new codec.PointerTo(UnexportableKeyId), val.success);
          break;
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(new codec.PointerTo(UnexportableKeyId));
          break;
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(ServiceError));
          break;
      }
      decoder.align();

      return result;
    };


    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.success:
          

    // validate UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(UnexportableKeyId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.Tags.failure:
          

    // validate UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result.encodedSize = 16;

  function UnexportableKeyService_DeleteAllKeys_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UnexportableKeyService_DeleteAllKeys_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.success:
          encoder.encodeStruct(codec.Uint64, val.success);
          break;
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UnexportableKeyService_DeleteAllKeys_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStruct(codec.Uint64);
          break;
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(ServiceError));
          break;
      }
      decoder.align();

      return result;
    };


    UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.success:
          

          break;
        case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.Tags.failure:
          

    // validate UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, ServiceError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result.encodedSize = 16;
  var kUnexportableKeyService_GenerateSigningKey_Name = 0;
  var kUnexportableKeyService_FromWrappedSigningKey_Name = 1;
  var kUnexportableKeyService_Sign_Name = 2;
  var kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name = 3;
  var kUnexportableKeyService_DeleteKey_Name = 4;
  var kUnexportableKeyService_DeleteAllKeys_Name = 5;

  function UnexportableKeyServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UnexportableKeyService,
                                                   handleOrPtrInfo);
  }

  function UnexportableKeyServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UnexportableKeyService, associatedInterfacePtrInfo);
  }

  UnexportableKeyServiceAssociatedPtr.prototype =
      Object.create(UnexportableKeyServicePtr.prototype);
  UnexportableKeyServiceAssociatedPtr.prototype.constructor =
      UnexportableKeyServiceAssociatedPtr;

  function UnexportableKeyServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  UnexportableKeyServicePtr.prototype.generateSigningKey = function() {
    return UnexportableKeyServiceProxy.prototype.generateSigningKey
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.generateSigningKey = function(acceptableAlgorithms, priority) {
    var params_ = new UnexportableKeyService_GenerateSigningKey_Params();
    params_.acceptableAlgorithms = acceptableAlgorithms;
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_GenerateSigningKey_Name,
          codec.align(UnexportableKeyService_GenerateSigningKey_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_GenerateSigningKey_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_GenerateSigningKey_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UnexportableKeyServicePtr.prototype.fromWrappedSigningKey = function() {
    return UnexportableKeyServiceProxy.prototype.fromWrappedSigningKey
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.fromWrappedSigningKey = function(wrappedKey, priority) {
    var params_ = new UnexportableKeyService_FromWrappedSigningKey_Params();
    params_.wrappedKey = wrappedKey;
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_FromWrappedSigningKey_Name,
          codec.align(UnexportableKeyService_FromWrappedSigningKey_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_FromWrappedSigningKey_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_FromWrappedSigningKey_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UnexportableKeyServicePtr.prototype.sign = function() {
    return UnexportableKeyServiceProxy.prototype.sign
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.sign = function(keyId, data, priority) {
    var params_ = new UnexportableKeyService_Sign_Params();
    params_.keyId = keyId;
    params_.data = data;
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_Sign_Name,
          codec.align(UnexportableKeyService_Sign_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_Sign_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_Sign_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UnexportableKeyServicePtr.prototype.getAllSigningKeysForGarbageCollection = function() {
    return UnexportableKeyServiceProxy.prototype.getAllSigningKeysForGarbageCollection
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.getAllSigningKeysForGarbageCollection = function(priority) {
    var params_ = new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params();
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name,
          codec.align(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UnexportableKeyServicePtr.prototype.deleteKey = function() {
    return UnexportableKeyServiceProxy.prototype.deleteKey
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.deleteKey = function(keyId, priority) {
    var params_ = new UnexportableKeyService_DeleteKey_Params();
    params_.keyId = keyId;
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_DeleteKey_Name,
          codec.align(UnexportableKeyService_DeleteKey_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_DeleteKey_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_DeleteKey_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UnexportableKeyServicePtr.prototype.deleteAllKeys = function() {
    return UnexportableKeyServiceProxy.prototype.deleteAllKeys
        .apply(this.ptr.getProxy(), arguments);
  };

  UnexportableKeyServiceProxy.prototype.deleteAllKeys = function(priority) {
    var params_ = new UnexportableKeyService_DeleteAllKeys_Params();
    params_.priority = priority;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUnexportableKeyService_DeleteAllKeys_Name,
          codec.align(UnexportableKeyService_DeleteAllKeys_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UnexportableKeyService_DeleteAllKeys_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UnexportableKeyService_DeleteAllKeys_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function UnexportableKeyServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  UnexportableKeyServiceStub.prototype.generateSigningKey = function(acceptableAlgorithms, priority) {
    return this.delegate_ && this.delegate_.generateSigningKey && this.delegate_.generateSigningKey(acceptableAlgorithms, priority);
  }
  UnexportableKeyServiceStub.prototype.fromWrappedSigningKey = function(wrappedKey, priority) {
    return this.delegate_ && this.delegate_.fromWrappedSigningKey && this.delegate_.fromWrappedSigningKey(wrappedKey, priority);
  }
  UnexportableKeyServiceStub.prototype.sign = function(keyId, data, priority) {
    return this.delegate_ && this.delegate_.sign && this.delegate_.sign(keyId, data, priority);
  }
  UnexportableKeyServiceStub.prototype.getAllSigningKeysForGarbageCollection = function(priority) {
    return this.delegate_ && this.delegate_.getAllSigningKeysForGarbageCollection && this.delegate_.getAllSigningKeysForGarbageCollection(priority);
  }
  UnexportableKeyServiceStub.prototype.deleteKey = function(keyId, priority) {
    return this.delegate_ && this.delegate_.deleteKey && this.delegate_.deleteKey(keyId, priority);
  }
  UnexportableKeyServiceStub.prototype.deleteAllKeys = function(priority) {
    return this.delegate_ && this.delegate_.deleteAllKeys && this.delegate_.deleteAllKeys(priority);
  }

  UnexportableKeyServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  UnexportableKeyServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUnexportableKeyService_GenerateSigningKey_Name:
      var params = reader.decodeStruct(UnexportableKeyService_GenerateSigningKey_Params);
      this.generateSigningKey(params.acceptableAlgorithms, params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_GenerateSigningKey_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_GenerateSigningKey_Name,
            codec.align(UnexportableKeyService_GenerateSigningKey_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_GenerateSigningKey_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUnexportableKeyService_FromWrappedSigningKey_Name:
      var params = reader.decodeStruct(UnexportableKeyService_FromWrappedSigningKey_Params);
      this.fromWrappedSigningKey(params.wrappedKey, params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_FromWrappedSigningKey_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_FromWrappedSigningKey_Name,
            codec.align(UnexportableKeyService_FromWrappedSigningKey_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_FromWrappedSigningKey_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUnexportableKeyService_Sign_Name:
      var params = reader.decodeStruct(UnexportableKeyService_Sign_Params);
      this.sign(params.keyId, params.data, params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_Sign_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_Sign_Name,
            codec.align(UnexportableKeyService_Sign_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_Sign_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name:
      var params = reader.decodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params);
      this.getAllSigningKeysForGarbageCollection(params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name,
            codec.align(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUnexportableKeyService_DeleteKey_Name:
      var params = reader.decodeStruct(UnexportableKeyService_DeleteKey_Params);
      this.deleteKey(params.keyId, params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_DeleteKey_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_DeleteKey_Name,
            codec.align(UnexportableKeyService_DeleteKey_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_DeleteKey_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUnexportableKeyService_DeleteAllKeys_Name:
      var params = reader.decodeStruct(UnexportableKeyService_DeleteAllKeys_Params);
      this.deleteAllKeys(params.priority).then(function(response) {
        var responseParams =
            new UnexportableKeyService_DeleteAllKeys_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kUnexportableKeyService_DeleteAllKeys_Name,
            codec.align(UnexportableKeyService_DeleteAllKeys_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UnexportableKeyService_DeleteAllKeys_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateUnexportableKeyServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUnexportableKeyService_GenerateSigningKey_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_GenerateSigningKey_Params;
      break;
      case kUnexportableKeyService_FromWrappedSigningKey_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_FromWrappedSigningKey_Params;
      break;
      case kUnexportableKeyService_Sign_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_Sign_Params;
      break;
      case kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params;
      break;
      case kUnexportableKeyService_DeleteKey_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_DeleteKey_Params;
      break;
      case kUnexportableKeyService_DeleteAllKeys_Name:
        if (message.expectsResponse())
          paramsClass = UnexportableKeyService_DeleteAllKeys_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUnexportableKeyServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kUnexportableKeyService_GenerateSigningKey_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_GenerateSigningKey_ResponseParams;
        break;
      case kUnexportableKeyService_FromWrappedSigningKey_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_FromWrappedSigningKey_ResponseParams;
        break;
      case kUnexportableKeyService_Sign_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_Sign_ResponseParams;
        break;
      case kUnexportableKeyService_GetAllSigningKeysForGarbageCollection_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams;
        break;
      case kUnexportableKeyService_DeleteKey_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_DeleteKey_ResponseParams;
        break;
      case kUnexportableKeyService_DeleteAllKeys_Name:
        if (message.isResponse())
          paramsClass = UnexportableKeyService_DeleteAllKeys_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var UnexportableKeyService = {
    name: 'unexportable_keys.mojom.UnexportableKeyService',
    kVersion: 0,
    ptrClass: UnexportableKeyServicePtr,
    proxyClass: UnexportableKeyServiceProxy,
    stubClass: UnexportableKeyServiceStub,
    validateRequest: validateUnexportableKeyServiceRequest,
    validateResponse: validateUnexportableKeyServiceResponse,
  };
  UnexportableKeyServiceStub.prototype.validator = validateUnexportableKeyServiceRequest;
  UnexportableKeyServiceProxy.prototype.validator = validateUnexportableKeyServiceResponse;
  exports.SignatureAlgorithm = SignatureAlgorithm;
  exports.ServiceError = ServiceError;
  exports.BackgroundTaskPriority = BackgroundTaskPriority;
  exports.UnexportableKeyId = UnexportableKeyId;
  exports.NewKeyData = NewKeyData;
  exports.UnexportableKeyService_GenerateSigningKey_ResponseParam_Result = UnexportableKeyService_GenerateSigningKey_ResponseParam_Result;
  exports.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result = UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result;
  exports.UnexportableKeyService_Sign_ResponseParam_Result = UnexportableKeyService_Sign_ResponseParam_Result;
  exports.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result;
  exports.UnexportableKeyService_DeleteAllKeys_ResponseParam_Result = UnexportableKeyService_DeleteAllKeys_ResponseParam_Result;
  exports.UnexportableKeyService = UnexportableKeyService;
  exports.UnexportableKeyServicePtr = UnexportableKeyServicePtr;
  exports.UnexportableKeyServiceAssociatedPtr = UnexportableKeyServiceAssociatedPtr;
})();