// components/unexportable_keys/mojom/unexportable_key_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::unexportable_keys::mojom::SignatureAlgorithm>
    : public mojo::internal::EnumHashImpl<::unexportable_keys::mojom::SignatureAlgorithm> {};

template <>
struct hash<::unexportable_keys::mojom::ServiceError>
    : public mojo::internal::EnumHashImpl<::unexportable_keys::mojom::ServiceError> {};

template <>
struct hash<::unexportable_keys::mojom::BackgroundTaskPriority>
    : public mojo::internal::EnumHashImpl<::unexportable_keys::mojom::BackgroundTaskPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::SignatureAlgorithm, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::unexportable_keys::mojom::SignatureAlgorithm, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::SignatureAlgorithm>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::ServiceError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::unexportable_keys::mojom::ServiceError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::BackgroundTaskPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::unexportable_keys::mojom::BackgroundTaskPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::BackgroundTaskPriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unexportable_keys::mojom::UnexportableKeyIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType> key_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_key_id,
      key_id_fragment);

    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_id in UnexportableKeyId struct");
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::NewKeyDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unexportable_keys::mojom::NewKeyDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unexportable_keys::mojom::internal::NewKeyData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType> key_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyIdDataView>(
      in_key_id,
      key_id_fragment);

    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_id in NewKeyData struct");

    decltype(Traits::subject_public_key_info(input)) in_subject_public_key_info = Traits::subject_public_key_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subject_public_key_info)::BaseType>
        subject_public_key_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subject_public_key_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_subject_public_key_info,
      subject_public_key_info_fragment,
      &subject_public_key_info_validate_params);

    fragment->subject_public_key_info.Set(
        subject_public_key_info_fragment.is_null() ? nullptr : subject_public_key_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subject_public_key_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subject_public_key_info in NewKeyData struct");

    decltype(Traits::wrapped_key(input)) in_wrapped_key = Traits::wrapped_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wrapped_key)::BaseType>
        wrapped_key_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& wrapped_key_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_wrapped_key,
      wrapped_key_fragment,
      &wrapped_key_validate_params);

    fragment->wrapped_key.Set(
        wrapped_key_fragment.is_null() ? nullptr : wrapped_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->wrapped_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null wrapped_key in NewKeyData struct");

    
    mojo::internal::Serialize<::unexportable_keys::mojom::SignatureAlgorithm>(
      Traits::algorithm(input),
      &fragment->algorithm);
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::NewKeyData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::NewKeyDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::unexportable_keys::mojom::NewKeyDataDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in UnexportableKeyService_GenerateSigningKey_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::unexportable_keys::mojom::NewKeyDataDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyService_Sign_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_success,
  value_fragment,
  &success_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in UnexportableKeyService_Sign_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyService_Sign_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::unexportable_keys::mojom::UnexportableKeyIdDataView>>(
  in_success,
  value_fragment,
  &success_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    fragment->data.f_success = in_success;
    break;
  }
  case ::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace unexportable_keys::mojom {

inline void UnexportableKeyIdDataView::GetKeyIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->key_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void NewKeyDataDataView::GetKeyIdDataView(
    UnexportableKeyIdDataView* output) {
  auto pointer = data_->key_id.Get();
  *output = UnexportableKeyIdDataView(pointer, message_);
}
inline void NewKeyDataDataView::GetSubjectPublicKeyInfoDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->subject_public_key_info.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void NewKeyDataDataView::GetWrappedKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->wrapped_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView::GetSuccessDataView(
    NewKeyDataDataView* output) const {
  CHECK(is_success());
  *output = NewKeyDataDataView(data_->data.f_success.Get(), message_);
}

inline void UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView::GetSuccessDataView(
    NewKeyDataDataView* output) const {
  CHECK(is_success());
  *output = NewKeyDataDataView(data_->data.f_success.Get(), message_);
}

inline void UnexportableKeyService_Sign_ResponseParam_ResultDataView::GetSuccessDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_success());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_success.Get(), message_);
}

inline void UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView::GetSuccessDataView(
    mojo::ArrayDataView<UnexportableKeyIdDataView>* output) const {
  CHECK(is_success());
  *output = mojo::ArrayDataView<UnexportableKeyIdDataView>(data_->data.f_success.Get(), message_);
}



}  // unexportable_keys::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::unexportable_keys::mojom::SignatureAlgorithm> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::unexportable_keys::mojom::SignatureAlgorithm value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::unexportable_keys::mojom::ServiceError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::unexportable_keys::mojom::ServiceError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::unexportable_keys::mojom::BackgroundTaskPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::unexportable_keys::mojom::BackgroundTaskPriority value);
};

} // namespace perfetto

#endif  // COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_SHARED_H_