// components/unexportable_keys/mojom/unexportable_key_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-params-data.h"
namespace unexportable_keys {
namespace mojom {

NOINLINE static const char* SignatureAlgorithmToStringHelper(SignatureAlgorithm value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SignatureAlgorithm::RSA_PKCS1_SHA1:
      return "RSA_PKCS1_SHA1";
    case SignatureAlgorithm::RSA_PKCS1_SHA256:
      return "RSA_PKCS1_SHA256";
    case SignatureAlgorithm::ECDSA_SHA256:
      return "ECDSA_SHA256";
    case SignatureAlgorithm::RSA_PSS_SHA256:
      return "RSA_PSS_SHA256";
    default:
      return nullptr;
  }
}

std::string SignatureAlgorithmToString(SignatureAlgorithm value) {
  const char *str = SignatureAlgorithmToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SignatureAlgorithm value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SignatureAlgorithm value) {
  return os << SignatureAlgorithmToString(value);
}

NOINLINE static const char* ServiceErrorToStringHelper(ServiceError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ServiceError::kCryptoApiFailed:
      return "kCryptoApiFailed";
    case ServiceError::kKeyNotFound:
      return "kKeyNotFound";
    case ServiceError::kKeyCollision:
      return "kKeyCollision";
    case ServiceError::kNoKeyProvider:
      return "kNoKeyProvider";
    case ServiceError::kAlgorithmNotSupported:
      return "kAlgorithmNotSupported";
    case ServiceError::kKeyNotReady:
      return "kKeyNotReady";
    case ServiceError::kVerifySignatureFailed:
      return "kVerifySignatureFailed";
    case ServiceError::kOperationNotSupported:
      return "kOperationNotSupported";
    default:
      return nullptr;
  }
}

std::string ServiceErrorToString(ServiceError value) {
  const char *str = ServiceErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ServiceError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ServiceError value) {
  return os << ServiceErrorToString(value);
}

NOINLINE static const char* BackgroundTaskPriorityToStringHelper(BackgroundTaskPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BackgroundTaskPriority::kBestEffort:
      return "kBestEffort";
    case BackgroundTaskPriority::kUserVisible:
      return "kUserVisible";
    case BackgroundTaskPriority::kUserBlocking:
      return "kUserBlocking";
    default:
      return nullptr;
  }
}

std::string BackgroundTaskPriorityToString(BackgroundTaskPriority value) {
  const char *str = BackgroundTaskPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BackgroundTaskPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BackgroundTaskPriority value) {
  return os << BackgroundTaskPriorityToString(value);
}

namespace internal {
// static
bool UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data* object = static_cast<const UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Tag::kFailure: {


      if (!::unexportable_keys::mojom::internal::ServiceError_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UnexportableKeyService_GenerateSigningKey_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data* object = static_cast<const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Tag::kFailure: {


      if (!::unexportable_keys::mojom::internal::ServiceError_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool UnexportableKeyService_Sign_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UnexportableKeyService_Sign_ResponseParam_Result_Data* object = static_cast<const UnexportableKeyService_Sign_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UnexportableKeyService_Sign_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_success, validation_context,
                                             &success_validate_params)) {
        return false;
      }
      return true;
    }
    case UnexportableKeyService_Sign_ResponseParam_Result_Tag::kFailure: {


      if (!::unexportable_keys::mojom::internal::ServiceError_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UnexportableKeyService_Sign_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data* object = static_cast<const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_success, validation_context,
                                             &success_validate_params)) {
        return false;
      }
      return true;
    }
    case UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Tag::kFailure: {


      if (!::unexportable_keys::mojom::internal::ServiceError_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data* object = static_cast<const UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Tag::kSuccess: {

      return true;
    }
    case UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Tag::kFailure: {


      if (!::unexportable_keys::mojom::internal::ServiceError_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UnexportableKeyService_DeleteAllKeys_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool UnexportableKeyId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyId_Data* object =
      static_cast<const UnexportableKeyId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_id, validation_context))
    return false;

  return true;
}

UnexportableKeyId_Data::UnexportableKeyId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NewKeyData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NewKeyData_Data* object =
      static_cast<const NewKeyData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subject_public_key_info, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subject_public_key_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subject_public_key_info, validation_context,
                                         &subject_public_key_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->wrapped_key, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& wrapped_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->wrapped_key, validation_context,
                                         &wrapped_key_validate_params)) {
    return false;
  }


  if (!::unexportable_keys::mojom::internal::SignatureAlgorithm_Data
        ::Validate(object->algorithm, validation_context))
    return false;

  return true;
}

NewKeyData_Data::NewKeyData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_GenerateSigningKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_GenerateSigningKey_Params_Data* object =
      static_cast<const UnexportableKeyService_GenerateSigningKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->acceptable_algorithms, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& acceptable_algorithms_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::unexportable_keys::mojom::internal::SignatureAlgorithm_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->acceptable_algorithms, validation_context,
                                         &acceptable_algorithms_validate_params)) {
    return false;
  }


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_GenerateSigningKey_Params_Data::UnexportableKeyService_GenerateSigningKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_GenerateSigningKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_GenerateSigningKey_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_GenerateSigningKey_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UnexportableKeyService_GenerateSigningKey_ResponseParams_Data::UnexportableKeyService_GenerateSigningKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_FromWrappedSigningKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_FromWrappedSigningKey_Params_Data* object =
      static_cast<const UnexportableKeyService_FromWrappedSigningKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->wrapped_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& wrapped_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->wrapped_key, validation_context,
                                         &wrapped_key_validate_params)) {
    return false;
  }


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_FromWrappedSigningKey_Params_Data::UnexportableKeyService_FromWrappedSigningKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data::UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_Sign_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_Sign_Params_Data* object =
      static_cast<const UnexportableKeyService_Sign_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_Sign_Params_Data::UnexportableKeyService_Sign_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_Sign_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_Sign_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_Sign_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UnexportableKeyService_Sign_ResponseParams_Data::UnexportableKeyService_Sign_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data* object =
      static_cast<const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data*>(data);


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_DeleteKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_DeleteKey_Params_Data* object =
      static_cast<const UnexportableKeyService_DeleteKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_id, validation_context))
    return false;


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_DeleteKey_Params_Data::UnexportableKeyService_DeleteKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_DeleteKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_DeleteKey_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_DeleteKey_ResponseParams_Data*>(data);


  if (!::unexportable_keys::mojom::internal::ServiceError_Data
        ::Validate(object->error_$value, validation_context))
    return false;

  return true;
}

UnexportableKeyService_DeleteKey_ResponseParams_Data::UnexportableKeyService_DeleteKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_DeleteAllKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_DeleteAllKeys_Params_Data* object =
      static_cast<const UnexportableKeyService_DeleteAllKeys_Params_Data*>(data);


  if (!::unexportable_keys::mojom::internal::BackgroundTaskPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

UnexportableKeyService_DeleteAllKeys_Params_Data::UnexportableKeyService_DeleteAllKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnexportableKeyService_DeleteAllKeys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnexportableKeyService_DeleteAllKeys_ResponseParams_Data* object =
      static_cast<const UnexportableKeyService_DeleteAllKeys_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UnexportableKeyService_DeleteAllKeys_ResponseParams_Data::UnexportableKeyService_DeleteAllKeys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace unexportable_keys

namespace perfetto {

// static
void TraceFormatTraits<::unexportable_keys::mojom::SignatureAlgorithm>::WriteIntoTrace(
   perfetto::TracedValue context, ::unexportable_keys::mojom::SignatureAlgorithm value) {
  return std::move(context).WriteString(::unexportable_keys::mojom::SignatureAlgorithmToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::unexportable_keys::mojom::ServiceError>::WriteIntoTrace(
   perfetto::TracedValue context, ::unexportable_keys::mojom::ServiceError value) {
  return std::move(context).WriteString(::unexportable_keys::mojom::ServiceErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::unexportable_keys::mojom::BackgroundTaskPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::unexportable_keys::mojom::BackgroundTaskPriority value) {
  return std::move(context).WriteString(::unexportable_keys::mojom::BackgroundTaskPriorityToString(value));
}

} // namespace perfetto