// components/unexportable_keys/mojom/unexportable_key_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('unexportableKeys.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.SignatureAlgorithmSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
unexportableKeys.mojom.SignatureAlgorithm = {
  
  RSA_PKCS1_SHA1: 0,
  RSA_PKCS1_SHA256: 1,
  ECDSA_SHA256: 2,
  RSA_PSS_SHA256: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.ServiceErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
unexportableKeys.mojom.ServiceError = {
  
  kCryptoApiFailed: 1,
  kKeyNotFound: 2,
  kKeyCollision: 3,
  kNoKeyProvider: 4,
  kAlgorithmNotSupported: 5,
  kKeyNotReady: 6,
  kVerifySignatureFailed: 7,
  kOperationNotSupported: 8,
  MIN_VALUE: 1,
  MAX_VALUE: 8,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.BackgroundTaskPrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
unexportableKeys.mojom.BackgroundTaskPriority = {
  
  kBestEffort: 0,
  kUserVisible: 1,
  kUserBlocking: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        unexportableKeys.mojom.UnexportableKeyService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { unexportableKeys.mojom.UnexportableKeyServiceInterface }
 */
unexportableKeys.mojom.UnexportableKeyServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!unexportableKeys.mojom.UnexportableKeyServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          unexportableKeys.mojom.UnexportableKeyServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!unexportableKeys.mojom.UnexportableKeyServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!unexportableKeys.mojom.SignatureAlgorithm> } acceptableAlgorithms
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_Result,
   *  }>}
   */

  generateSigningKey(
      acceptableAlgorithms,
      priority) {
    return this.proxy.sendMessage(
        0,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        [
          acceptableAlgorithms,
          priority
        ],
        true);
  }

  
  /**
   * @param { !Array<!number> } wrappedKey
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result,
   *  }>}
   */

  fromWrappedSigningKey(
      wrappedKey,
      priority) {
    return this.proxy.sendMessage(
        1,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        [
          wrappedKey,
          priority
        ],
        true);
  }

  
  /**
   * @param { !unexportableKeys.mojom.UnexportableKeyId } keyId
   * @param { !Array<!number> } data
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_Result,
   *  }>}
   */

  sign(
      keyId,
      data,
      priority) {
    return this.proxy.sendMessage(
        2,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParamsSpec.$,
        [
          keyId,
          data,
          priority
        ],
        true);
  }

  
  /**
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result,
   *  }>}
   */

  getAllSigningKeysForGarbageCollection(
      priority) {
    return this.proxy.sendMessage(
        3,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        [
          priority
        ],
        true);
  }

  
  /**
   * @param { !unexportableKeys.mojom.UnexportableKeyId } keyId
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        error: ?unexportableKeys.mojom.ServiceError,
   *  }>}
   */

  deleteKey(
      keyId,
      priority) {
    return this.proxy.sendMessage(
        4,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        [
          keyId,
          priority
        ],
        false);
  }

  
  /**
   * @param { !unexportableKeys.mojom.BackgroundTaskPriority } priority
   * @return {!Promise<{
        result: !unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_Result,
   *  }>}
   */

  deleteAllKeys(
      priority) {
    return this.proxy.sendMessage(
        5,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        [
          priority
        ],
        true);
  }
};

/**
 * An object which receives request messages for the UnexportableKeyService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
unexportableKeys.mojom.UnexportableKeyServiceReceiver = class {
  /**
   * @param {!unexportableKeys.mojom.UnexportableKeyServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!unexportableKeys.mojom.UnexportableKeyServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        unexportableKeys.mojom.UnexportableKeyServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!unexportableKeys.mojom.UnexportableKeyServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        impl.generateSigningKey.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        1,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        impl.fromWrappedSigningKey.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParamsSpec.$,
        impl.sign.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        3,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        impl.getAllSigningKeysForGarbageCollection.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        impl.deleteKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        impl.deleteAllKeys.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
unexportableKeys.mojom.UnexportableKeyService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "unexportable_keys.mojom.UnexportableKeyService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!unexportableKeys.mojom.UnexportableKeyServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new unexportableKeys.mojom.UnexportableKeyServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UnexportableKeyService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
unexportableKeys.mojom.UnexportableKeyServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      unexportableKeys.mojom.UnexportableKeyServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!unexportableKeys.mojom.UnexportableKeyServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generateSigningKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
        this.generateSigningKey.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fromWrappedSigningKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
        this.fromWrappedSigningKey.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sign =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParamsSpec.$,
        this.sign.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllSigningKeysForGarbageCollection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
        this.getAllSigningKeysForGarbageCollection.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
        this.deleteKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAllKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
        this.deleteAllKeys.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.NewKeyDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_Sign_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyIdSpec.$,
    'UnexportableKeyId',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyId = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.keyId;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.NewKeyDataSpec.$,
    'NewKeyData',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subjectPublicKeyInfo', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wrappedKey', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'algorithm', 24,
        0,
        unexportableKeys.mojom.SignatureAlgorithmSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
unexportableKeys.mojom.NewKeyData = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyId } */
    this.keyId;
    /** @export { !Array<!number> } */
    this.subjectPublicKeyInfo;
    /** @export { !Array<!number> } */
    this.wrappedKey;
    /** @export { !unexportableKeys.mojom.SignatureAlgorithm } */
    this.algorithm;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ParamsSpec.$,
    'UnexportableKeyService_GenerateSigningKey_Params',
    [
      mojo.internal.StructField(
        'acceptableAlgorithms', 0,
        0,
        mojo.internal.Array(unexportableKeys.mojom.SignatureAlgorithmSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_Params = class {
  constructor() {
    /** @export { !Array<!unexportableKeys.mojom.SignatureAlgorithm> } */
    this.acceptableAlgorithms;
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParamsSpec.$,
    'UnexportableKeyService_GenerateSigningKey_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParams = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ParamsSpec.$,
    'UnexportableKeyService_FromWrappedSigningKey_Params',
    [
      mojo.internal.StructField(
        'wrappedKey', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.wrappedKey;
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParamsSpec.$,
    'UnexportableKeyService_FromWrappedSigningKey_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParams = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_Sign_ParamsSpec.$,
    'UnexportableKeyService_Sign_Params',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 16,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_Sign_Params = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyId } */
    this.keyId;
    /** @export { !Array<!number> } */
    this.data;
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParamsSpec.$,
    'UnexportableKeyService_Sign_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParams = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsSpec.$,
    'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsSpec.$,
    'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ParamsSpec.$,
    'UnexportableKeyService_DeleteKey_Params',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 8,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_DeleteKey_Params = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyId } */
    this.keyId;
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParamsSpec.$,
    'UnexportableKeyService_DeleteKey_ResponseParams',
    [
      mojo.internal.StructField(
        'error_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "error_$value",
          originalFieldName: "error",
        }
      ),
      mojo.internal.StructField(
        'error_$value', 4,
        0,
        unexportableKeys.mojom.ServiceErrorSpec.$,
        1,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "error",
        }
      ),
    ],
    [[0, 16],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_DeleteKey_ResponseParams = class {
  constructor() {
    /** @export { (unexportableKeys.mojom.ServiceError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ParamsSpec.$,
    'UnexportableKeyService_DeleteAllKeys_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        unexportableKeys.mojom.BackgroundTaskPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_Params = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.BackgroundTaskPriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParamsSpec.$,
    'UnexportableKeyService_DeleteAllKeys_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParams = class {
  constructor() {
    /** @export { !unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Union(
    unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultSpec.$, 'UnexportableKeyService_GenerateSigningKey_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': unexportableKeys.mojom.NewKeyDataSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': unexportableKeys.mojom.ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!unexportableKeys.mojom.NewKeyData|undefined),
 *   failure: (!unexportableKeys.mojom.ServiceError|undefined),
 * } }
 */
unexportableKeys.mojom.UnexportableKeyService_GenerateSigningKey_ResponseParam_Result;


mojo.internal.Union(
    unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultSpec.$, 'UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': unexportableKeys.mojom.NewKeyDataSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': unexportableKeys.mojom.ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!unexportableKeys.mojom.NewKeyData|undefined),
 *   failure: (!unexportableKeys.mojom.ServiceError|undefined),
 * } }
 */
unexportableKeys.mojom.UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result;


mojo.internal.Union(
    unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_ResultSpec.$, 'UnexportableKeyService_Sign_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'failure': {
        'ordinal': 1,
        'type': unexportableKeys.mojom.ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!number>|undefined),
 *   failure: (!unexportableKeys.mojom.ServiceError|undefined),
 * } }
 */
unexportableKeys.mojom.UnexportableKeyService_Sign_ResponseParam_Result;


mojo.internal.Union(
    unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultSpec.$, 'UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(unexportableKeys.mojom.UnexportableKeyIdSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': unexportableKeys.mojom.ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!unexportableKeys.mojom.UnexportableKeyId>|undefined),
 *   failure: (!unexportableKeys.mojom.ServiceError|undefined),
 * } }
 */
unexportableKeys.mojom.UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result;


mojo.internal.Union(
    unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultSpec.$, 'UnexportableKeyService_DeleteAllKeys_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Uint64,
      },
      'failure': {
        'ordinal': 1,
        'type': unexportableKeys.mojom.ServiceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!bigint|undefined),
 *   failure: (!unexportableKeys.mojom.ServiceError|undefined),
 * } }
 */
unexportableKeys.mojom.UnexportableKeyService_DeleteAllKeys_ResponseParam_Result;
