// components/unexportable_keys/mojom/unexportable_key_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace unexportable_keys::mojom {
class UnexportableKeyIdDataView;

class NewKeyDataDataView;

class UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView;
class UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView;
class UnexportableKeyService_Sign_ResponseParam_ResultDataView;
class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView;
class UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView;


}  // unexportable_keys::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyIdDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::NewKeyDataDataView> {
  using Data = ::unexportable_keys::mojom::internal::NewKeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyService_Sign_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView> {
  using Data = ::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace unexportable_keys::mojom {


enum class SignatureAlgorithm : int32_t {
  
  RSA_PKCS1_SHA1 = 0,
  
  RSA_PKCS1_SHA256 = 1,
  
  ECDSA_SHA256 = 2,
  
  RSA_PSS_SHA256 = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SignatureAlgorithm value);
inline bool IsKnownEnumValue(SignatureAlgorithm value) {
  return internal::SignatureAlgorithm_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ServiceError : int32_t {
  
  kCryptoApiFailed = 1,
  
  kKeyNotFound = 2,
  
  kKeyCollision = 3,
  
  kNoKeyProvider = 4,
  
  kAlgorithmNotSupported = 5,
  
  kKeyNotReady = 6,
  
  kVerifySignatureFailed = 7,
  
  kOperationNotSupported = 8,
  kMinValue = 1,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, ServiceError value);
inline bool IsKnownEnumValue(ServiceError value) {
  return internal::ServiceError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundTaskPriority : int32_t {
  
  kBestEffort = 0,
  
  kUserVisible = 1,
  
  kUserBlocking = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BackgroundTaskPriority value);
inline bool IsKnownEnumValue(BackgroundTaskPriority value) {
  return internal::BackgroundTaskPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UnexportableKeyServiceInterfaceBase {};

using UnexportableKeyServicePtrDataView =
    mojo::InterfacePtrDataView<UnexportableKeyServiceInterfaceBase>;
using UnexportableKeyServiceRequestDataView =
    mojo::InterfaceRequestDataView<UnexportableKeyServiceInterfaceBase>;
using UnexportableKeyServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnexportableKeyServiceInterfaceBase>;
using UnexportableKeyServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnexportableKeyServiceInterfaceBase>;


class UnexportableKeyIdDataView {
 public:
  UnexportableKeyIdDataView() = default;

  UnexportableKeyIdDataView(
      internal::UnexportableKeyId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnexportableKeyId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NewKeyDataDataView {
 public:
  NewKeyDataDataView() = default;

  NewKeyDataDataView(
      internal::NewKeyData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyIdDataView(
      UnexportableKeyIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<::unexportable_keys::mojom::UnexportableKeyIdDataView>(
        pointer, output, message_);
  }
  inline void GetSubjectPublicKeyInfoDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubjectPublicKeyInfo(UserType* output) {
    
    auto* pointer = data_->subject_public_key_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetWrappedKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWrappedKey(UserType* output) {
    
    auto* pointer = data_->wrapped_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlgorithm(UserType* output) const {
    auto data_value = data_->algorithm;
    return mojo::internal::Deserialize<::unexportable_keys::mojom::SignatureAlgorithm>(
        data_value, output);
  }
  SignatureAlgorithm algorithm() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::unexportable_keys::mojom::SignatureAlgorithm>(data_->algorithm));
  }
 private:
  internal::NewKeyData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView {
 public:
  using Tag = internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Tag;

  UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView() = default;

  UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView(
      internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      NewKeyDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::NewKeyDataDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::ServiceError>(
        data_->data.f_failure, output);
  }
  ServiceError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(data_->data.f_failure));
  }

 private:
  internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView {
 public:
  using Tag = internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Tag;

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView() = default;

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView(
      internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      NewKeyDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::NewKeyDataDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::ServiceError>(
        data_->data.f_failure, output);
  }
  ServiceError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(data_->data.f_failure));
  }

 private:
  internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UnexportableKeyService_Sign_ResponseParam_ResultDataView {
 public:
  using Tag = internal::UnexportableKeyService_Sign_ResponseParam_Result_Data::UnexportableKeyService_Sign_ResponseParam_Result_Tag;

  UnexportableKeyService_Sign_ResponseParam_ResultDataView() = default;

  UnexportableKeyService_Sign_ResponseParam_ResultDataView(
      internal::UnexportableKeyService_Sign_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::ServiceError>(
        data_->data.f_failure, output);
  }
  ServiceError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(data_->data.f_failure));
  }

 private:
  internal::UnexportableKeyService_Sign_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView {
 public:
  using Tag = internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Tag;

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView() = default;

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView(
      internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<UnexportableKeyIdDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::unexportable_keys::mojom::UnexportableKeyIdDataView>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::ServiceError>(
        data_->data.f_failure, output);
  }
  ServiceError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(data_->data.f_failure));
  }

 private:
  internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView {
 public:
  using Tag = internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Tag;

  UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView() = default;

  UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView(
      internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  uint64_t success() const {
    CHECK(is_success());
    return data_->data.f_success;
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::unexportable_keys::mojom::ServiceError>(
        data_->data.f_failure, output);
  }
  ServiceError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::unexportable_keys::mojom::ServiceError>(data_->data.f_failure));
  }

 private:
  internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data* data_ = nullptr;
};



}  // unexportable_keys::mojom

#endif  // COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_DATA_VIEW_H_