// components/unexportable_keys/mojom/unexportable_key_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_BLINK_H_
#define COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-features.h"  // IWYU pragma: export
#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-shared.h"  // IWYU pragma: export
#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace unexportable_keys::mojom::blink {

class UnexportableKeyServiceProxy;

template <typename ImplRefTraits>
class UnexportableKeyServiceStub;

class UnexportableKeyServiceRequestValidator;
class UnexportableKeyServiceResponseValidator;


class UnexportableKeyService
    : public UnexportableKeyServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "unexportable_keys.mojom.UnexportableKeyService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UnexportableKeyServiceInterfaceBase;
  using Proxy_ = UnexportableKeyServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = UnexportableKeyServiceStub<ImplRefTraits>;

  using RequestValidator_ = UnexportableKeyServiceRequestValidator;
  using ResponseValidator_ = UnexportableKeyServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateSigningKeyMinVersion = 0,
    kFromWrappedSigningKeyMinVersion = 0,
    kSignMinVersion = 0,
    kGetAllSigningKeysForGarbageCollectionMinVersion = 0,
    kDeleteKeyMinVersion = 0,
    kDeleteAllKeysMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GenerateSigningKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FromWrappedSigningKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Sign_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllSigningKeysForGarbageCollection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UnexportableKeyService() = default;

  using GenerateSigningKeyCallback = base::OnceCallback<void(base::expected<
  NewKeyDataPtr,
  ServiceError>)>;
  using GenerateSigningKeyResult = base::expected<
  NewKeyDataPtr,
  ServiceError>;
  using GenerateSigningKeyMojoCallback = base::OnceCallback<void(UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr)>;

  virtual void GenerateSigningKey(const ::blink::Vector<SignatureAlgorithm>& acceptable_algorithms, BackgroundTaskPriority priority, GenerateSigningKeyCallback callback) = 0;

  using FromWrappedSigningKeyCallback = base::OnceCallback<void(base::expected<
  NewKeyDataPtr,
  ServiceError>)>;
  using FromWrappedSigningKeyResult = base::expected<
  NewKeyDataPtr,
  ServiceError>;
  using FromWrappedSigningKeyMojoCallback = base::OnceCallback<void(UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr)>;

  virtual void FromWrappedSigningKey(const ::blink::Vector<uint8_t>& wrapped_key, BackgroundTaskPriority priority, FromWrappedSigningKeyCallback callback) = 0;

  using SignCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<uint8_t>,
  ServiceError>)>;
  using SignResult = base::expected<
  ::blink::Vector<uint8_t>,
  ServiceError>;
  using SignMojoCallback = base::OnceCallback<void(UnexportableKeyService_Sign_ResponseParam_ResultPtr)>;

  virtual void Sign(UnexportableKeyIdPtr key_id, const ::blink::Vector<uint8_t>& data, BackgroundTaskPriority priority, SignCallback callback) = 0;

  using GetAllSigningKeysForGarbageCollectionCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<UnexportableKeyIdPtr>,
  ServiceError>)>;
  using GetAllSigningKeysForGarbageCollectionResult = base::expected<
  ::blink::Vector<UnexportableKeyIdPtr>,
  ServiceError>;
  using GetAllSigningKeysForGarbageCollectionMojoCallback = base::OnceCallback<void(UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr)>;

  virtual void GetAllSigningKeysForGarbageCollection(BackgroundTaskPriority priority, GetAllSigningKeysForGarbageCollectionCallback callback) = 0;

  using DeleteKeyCallback = base::OnceCallback<void(std::optional<ServiceError>)>;
  using DeleteKeyMojoCallback = base::OnceCallback<void(std::optional<ServiceError>)>;

  virtual void DeleteKey(UnexportableKeyIdPtr key_id, BackgroundTaskPriority priority, DeleteKeyCallback callback) = 0;

  using DeleteAllKeysCallback = base::OnceCallback<void(base::expected<
  uint64_t,
  ServiceError>)>;
  using DeleteAllKeysResult = base::expected<
  uint64_t,
  ServiceError>;
  using DeleteAllKeysMojoCallback = base::OnceCallback<void(UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr)>;

  virtual void DeleteAllKeys(BackgroundTaskPriority priority, DeleteAllKeysCallback callback) = 0;
};



class  UnexportableKeyServiceProxy
    : public UnexportableKeyService {
 public:
  using InterfaceType = UnexportableKeyService;

  explicit UnexportableKeyServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GenerateSigningKey(const ::blink::Vector<SignatureAlgorithm>& acceptable_algorithms, BackgroundTaskPriority priority, GenerateSigningKeyCallback callback) final;
  
  void FromWrappedSigningKey(const ::blink::Vector<uint8_t>& wrapped_key, BackgroundTaskPriority priority, FromWrappedSigningKeyCallback callback) final;
  
  void Sign(UnexportableKeyIdPtr key_id, const ::blink::Vector<uint8_t>& data, BackgroundTaskPriority priority, SignCallback callback) final;
  
  void GetAllSigningKeysForGarbageCollection(BackgroundTaskPriority priority, GetAllSigningKeysForGarbageCollectionCallback callback) final;
  
  void DeleteKey(UnexportableKeyIdPtr key_id, BackgroundTaskPriority priority, DeleteKeyCallback callback) final;
  
  void DeleteAllKeys(BackgroundTaskPriority priority, DeleteAllKeysCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UnexportableKeyServiceStubDispatch {
 public:
  static bool Accept(UnexportableKeyService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UnexportableKeyService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UnexportableKeyService>>
class UnexportableKeyServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UnexportableKeyServiceStub() = default;
  ~UnexportableKeyServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnexportableKeyServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnexportableKeyServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UnexportableKeyServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UnexportableKeyServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result {
 public:
  using DataView = UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView;
  using Data_ = internal::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Data;
  using Tag = Data_::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result_Tag;

  template <typename... Args>
  static UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr NewSuccess(
      NewKeyDataPtr value);
  // Construct an instance holding |failure|.
  static UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr NewFailure(
      ServiceError value);

  template <typename U>
  static UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyService_GenerateSigningKey_ResponseParam_Result>::Convert(*this);
  }
  ~UnexportableKeyService_GenerateSigningKey_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(const UnexportableKeyService_GenerateSigningKey_ResponseParam_Result& other) = delete;
  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result& operator=(const UnexportableKeyService_GenerateSigningKey_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr>
  UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_GenerateSigningKey_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_GenerateSigningKey_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const NewKeyDataPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  NewKeyDataPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(NewKeyDataPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ServiceError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(ServiceError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        NewKeyDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ServiceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    NewKeyDataPtr success;
    ServiceError failure;
  };

  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      NewKeyDataPtr value);
  UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ServiceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result {
 public:
  using DataView = UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView;
  using Data_ = internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Data;
  using Tag = Data_::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result_Tag;

  template <typename... Args>
  static UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr NewSuccess(
      NewKeyDataPtr value);
  // Construct an instance holding |failure|.
  static UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr NewFailure(
      ServiceError value);

  template <typename U>
  static UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result>::Convert(*this);
  }
  ~UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result& other) = delete;
  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result& operator=(const UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr>
  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const NewKeyDataPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  NewKeyDataPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(NewKeyDataPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ServiceError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(ServiceError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        NewKeyDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ServiceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    NewKeyDataPtr success;
    ServiceError failure;
  };

  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      NewKeyDataPtr value);
  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ServiceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UnexportableKeyService_Sign_ResponseParam_Result {
 public:
  using DataView = UnexportableKeyService_Sign_ResponseParam_ResultDataView;
  using Data_ = internal::UnexportableKeyService_Sign_ResponseParam_Result_Data;
  using Tag = Data_::UnexportableKeyService_Sign_ResponseParam_Result_Tag;

  template <typename... Args>
  static UnexportableKeyService_Sign_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UnexportableKeyService_Sign_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<uint8_t> value);
  // Construct an instance holding |failure|.
  static UnexportableKeyService_Sign_ResponseParam_ResultPtr NewFailure(
      ServiceError value);

  template <typename U>
  static UnexportableKeyService_Sign_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyService_Sign_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyService_Sign_ResponseParam_Result>::Convert(*this);
  }
  ~UnexportableKeyService_Sign_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UnexportableKeyService_Sign_ResponseParam_Result(const UnexportableKeyService_Sign_ResponseParam_Result& other) = delete;
  UnexportableKeyService_Sign_ResponseParam_Result& operator=(const UnexportableKeyService_Sign_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UnexportableKeyService_Sign_ResponseParam_ResultPtr>
  UnexportableKeyService_Sign_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_Sign_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_Sign_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<uint8_t>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<uint8_t>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<uint8_t> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ServiceError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(ServiceError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyService_Sign_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UnexportableKeyService_Sign_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ServiceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<uint8_t> success;
    ServiceError failure;
  };

  UnexportableKeyService_Sign_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<uint8_t> value);
  UnexportableKeyService_Sign_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ServiceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result {
 public:
  using DataView = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView;
  using Data_ = internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Data;
  using Tag = Data_::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result_Tag;

  template <typename... Args>
  static UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<UnexportableKeyIdPtr> value);
  // Construct an instance holding |failure|.
  static UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr NewFailure(
      ServiceError value);

  template <typename U>
  static UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result>::Convert(*this);
  }
  ~UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result& other) = delete;
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result& operator=(const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr>
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<UnexportableKeyIdPtr>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<UnexportableKeyIdPtr>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<UnexportableKeyIdPtr> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ServiceError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(ServiceError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<UnexportableKeyIdPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ServiceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<UnexportableKeyIdPtr> success;
    ServiceError failure;
  };

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<UnexportableKeyIdPtr> value);
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ServiceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result {
 public:
  using DataView = UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView;
  using Data_ = internal::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Data;
  using Tag = Data_::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result_Tag;

  template <typename... Args>
  static UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr NewSuccess(
      uint64_t value);
  // Construct an instance holding |failure|.
  static UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr NewFailure(
      ServiceError value);

  template <typename U>
  static UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyService_DeleteAllKeys_ResponseParam_Result>::Convert(*this);
  }
  ~UnexportableKeyService_DeleteAllKeys_ResponseParam_Result();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr>
  UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_DeleteAllKeys_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UnexportableKeyService_DeleteAllKeys_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  uint64_t get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(uint64_t success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ServiceError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(ServiceError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        uint64_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ServiceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint64_t success;
    ServiceError failure;
  };

  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      uint64_t value);
  UnexportableKeyService_DeleteAllKeys_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ServiceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  UnexportableKeyId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnexportableKeyId, T>::value>;
  using DataView = UnexportableKeyIdDataView;
  using Data_ = internal::UnexportableKeyId_Data;

  template <typename... Args>
  static UnexportableKeyIdPtr New(Args&&... args) {
    return UnexportableKeyIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnexportableKeyIdPtr From(const U& u) {
    return mojo::TypeConverter<UnexportableKeyIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnexportableKeyId>::Convert(*this);
  }


  UnexportableKeyId();

  explicit UnexportableKeyId(
      const ::base::UnguessableToken& key_id);


  ~UnexportableKeyId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnexportableKeyIdPtr>
  UnexportableKeyIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnexportableKeyId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnexportableKeyId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnexportableKeyId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnexportableKeyId_UnserializedMessageContext<
            UserType, UnexportableKeyId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnexportableKeyId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnexportableKeyId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnexportableKeyId_UnserializedMessageContext<
            UserType, UnexportableKeyId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnexportableKeyId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken key_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnexportableKeyId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NewKeyData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NewKeyData, T>::value>;
  using DataView = NewKeyDataDataView;
  using Data_ = internal::NewKeyData_Data;

  template <typename... Args>
  static NewKeyDataPtr New(Args&&... args) {
    return NewKeyDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NewKeyDataPtr From(const U& u) {
    return mojo::TypeConverter<NewKeyDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NewKeyData>::Convert(*this);
  }


  NewKeyData();

  NewKeyData(
      UnexportableKeyIdPtr key_id,
      ::blink::Vector<uint8_t> subject_public_key_info,
      ::blink::Vector<uint8_t> wrapped_key,
      SignatureAlgorithm algorithm);

NewKeyData(const NewKeyData&) = delete;
NewKeyData& operator=(const NewKeyData&) = delete;

  ~NewKeyData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NewKeyDataPtr>
  NewKeyDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NewKeyData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NewKeyData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NewKeyData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NewKeyData_UnserializedMessageContext<
            UserType, NewKeyData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NewKeyData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NewKeyData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NewKeyData_UnserializedMessageContext<
            UserType, NewKeyData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NewKeyData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UnexportableKeyIdPtr key_id;
  
  ::blink::Vector<uint8_t> subject_public_key_info;
  
  ::blink::Vector<uint8_t> wrapped_key;
  
  SignatureAlgorithm algorithm;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NewKeyData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UnexportableKeyService_GenerateSigningKey_ResponseParam_Result>::value>::type*>
bool UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result>::value>::type*>
bool UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
UnexportableKeyService_Sign_ResponseParam_ResultPtr UnexportableKeyService_Sign_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UnexportableKeyService_Sign_ResponseParam_Result>::value>::type*>
bool UnexportableKeyService_Sign_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result>::value>::type*>
bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UnexportableKeyService_DeleteAllKeys_ResponseParam_Result>::value>::type*>
bool UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
UnexportableKeyIdPtr UnexportableKeyId::Clone() const {
  return New(
      mojo::Clone(key_id)
  );
}

template <typename T, UnexportableKeyId::EnableIfSame<T>*>
bool UnexportableKeyId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  return true;
}

template <typename T, UnexportableKeyId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_id < rhs.key_id)
    return true;
  if (rhs.key_id < lhs.key_id)
    return false;
  return false;
}
template <typename StructPtrType>
NewKeyDataPtr NewKeyData::Clone() const {
  return New(
      mojo::Clone(key_id),
      mojo::Clone(subject_public_key_info),
      mojo::Clone(wrapped_key),
      mojo::Clone(algorithm)
  );
}

template <typename T, NewKeyData::EnableIfSame<T>*>
bool NewKeyData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->subject_public_key_info, other_struct.subject_public_key_info))
    return false;
  if (!mojo::Equals(this->wrapped_key, other_struct.wrapped_key))
    return false;
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  return true;
}

template <typename T, NewKeyData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_id < rhs.key_id)
    return true;
  if (rhs.key_id < lhs.key_id)
    return false;
  if (lhs.subject_public_key_info < rhs.subject_public_key_info)
    return true;
  if (rhs.subject_public_key_info < lhs.subject_public_key_info)
    return false;
  if (lhs.wrapped_key < rhs.wrapped_key)
    return true;
  if (rhs.wrapped_key < lhs.wrapped_key)
    return false;
  if (lhs.algorithm < rhs.algorithm)
    return true;
  if (rhs.algorithm < lhs.algorithm)
    return false;
  return false;
}


}  // unexportable_keys::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::unexportable_keys::mojom::blink::UnexportableKeyId::DataView,
                                         ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyIdPtr* output) { output->reset(); }

  static const decltype(::unexportable_keys::mojom::blink::UnexportableKeyId::key_id)& key_id(
      const ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr& input) {
    return input->key_id;
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyId::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr* output);
};


template <>
struct  StructTraits<::unexportable_keys::mojom::blink::NewKeyData::DataView,
                                         ::unexportable_keys::mojom::blink::NewKeyDataPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::NewKeyDataPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::NewKeyDataPtr* output) { output->reset(); }

  static const decltype(::unexportable_keys::mojom::blink::NewKeyData::key_id)& key_id(
      const ::unexportable_keys::mojom::blink::NewKeyDataPtr& input) {
    return input->key_id;
  }

  static const decltype(::unexportable_keys::mojom::blink::NewKeyData::subject_public_key_info)& subject_public_key_info(
      const ::unexportable_keys::mojom::blink::NewKeyDataPtr& input) {
    return input->subject_public_key_info;
  }

  static const decltype(::unexportable_keys::mojom::blink::NewKeyData::wrapped_key)& wrapped_key(
      const ::unexportable_keys::mojom::blink::NewKeyDataPtr& input) {
    return input->wrapped_key;
  }

  static decltype(::unexportable_keys::mojom::blink::NewKeyData::algorithm) algorithm(
      const ::unexportable_keys::mojom::blink::NewKeyDataPtr& input) {
    return input->algorithm;
  }

  static bool Read(::unexportable_keys::mojom::blink::NewKeyData::DataView input, ::unexportable_keys::mojom::blink::NewKeyDataPtr* output);
};


template <>
struct  UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView,
                                        ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Tag GetTag(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::unexportable_keys::mojom::blink::NewKeyDataPtr& success(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::unexportable_keys::mojom::blink::ServiceError failure(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView,
                                        ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Tag GetTag(const ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::unexportable_keys::mojom::blink::NewKeyDataPtr& success(const ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::unexportable_keys::mojom::blink::ServiceError failure(const ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::DataView,
                                        ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::Tag GetTag(const ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::blink::Vector<uint8_t>& success(const ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::unexportable_keys::mojom::blink::ServiceError failure(const ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView,
                                        ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Tag GetTag(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::blink::Vector<::unexportable_keys::mojom::blink::UnexportableKeyIdPtr>& success(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::unexportable_keys::mojom::blink::ServiceError failure(const ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView,
                                        ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr> {
  static bool IsNull(const ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Tag GetTag(const ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  uint64_t success(const ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::unexportable_keys::mojom::blink::ServiceError failure(const ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView input, ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_UNEXPORTABLE_KEYS_MOJOM_UNEXPORTABLE_KEY_SERVICE_MOJOM_BLINK_H_