// components/unexportable_keys/mojom/unexportable_key_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-params-data.h"
#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-shared-message-ids.h"

#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-blink-import-headers.h"
#include "components/unexportable_keys/mojom/unexportable_key_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace unexportable_keys::mojom::blink {
UnexportableKeyId::UnexportableKeyId()
    : key_id() {}

UnexportableKeyId::UnexportableKeyId(
    const ::base::UnguessableToken& key_id_in)
    : key_id(std::move(key_id_in)) {}

UnexportableKeyId::~UnexportableKeyId() = default;

void UnexportableKeyId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UnexportableKeyId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NewKeyData::NewKeyData()
    : key_id(),
      subject_public_key_info(),
      wrapped_key(),
      algorithm() {}

NewKeyData::NewKeyData(
    UnexportableKeyIdPtr key_id_in,
    ::blink::Vector<uint8_t> subject_public_key_info_in,
    ::blink::Vector<uint8_t> wrapped_key_in,
    SignatureAlgorithm algorithm_in)
    : key_id(std::move(key_id_in)),
      subject_public_key_info(std::move(subject_public_key_info_in)),
      wrapped_key(std::move(wrapped_key_in)),
      algorithm(std::move(algorithm_in)) {}

NewKeyData::~NewKeyData() = default;

void NewKeyData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UnexportableKeyIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject_public_key_info"), this->subject_public_key_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wrapped_key"), this->wrapped_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SignatureAlgorithm>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NewKeyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr
UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::NewSuccess(
    NewKeyDataPtr value) {
  return UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr
UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::NewFailure(
    ServiceError value) {
  return UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    NewKeyDataPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::~UnexportableKeyService_GenerateSigningKey_ResponseParam_Result() {
  DestroyActive();
}

void UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::set_success(NewKeyDataPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) NewKeyDataPtr(
        std::move(success));
  }
}

void UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::set_failure(ServiceError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    NewKeyDataPtr value)
    : success(std::move(value)) {}

UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : failure(std::move(value)) {}

void UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr
UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::NewSuccess(
    NewKeyDataPtr value) {
  return UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr
UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::NewFailure(
    ServiceError value) {
  return UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    NewKeyDataPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::~UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result() {
  DestroyActive();
}

void UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::set_success(NewKeyDataPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) NewKeyDataPtr(
        std::move(success));
  }
}

void UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::set_failure(ServiceError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    NewKeyDataPtr value)
    : success(std::move(value)) {}

UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : failure(std::move(value)) {}

void UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UnexportableKeyService_Sign_ResponseParam_ResultPtr
UnexportableKeyService_Sign_ResponseParam_Result::NewSuccess(
    ::blink::Vector<uint8_t> value) {
  return UnexportableKeyService_Sign_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

UnexportableKeyService_Sign_ResponseParam_ResultPtr
UnexportableKeyService_Sign_ResponseParam_Result::NewFailure(
    ServiceError value) {
  return UnexportableKeyService_Sign_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

UnexportableKeyService_Sign_ResponseParam_Result::UnexportableKeyService_Sign_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<uint8_t> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

UnexportableKeyService_Sign_ResponseParam_Result::UnexportableKeyService_Sign_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
UnexportableKeyService_Sign_ResponseParam_Result::~UnexportableKeyService_Sign_ResponseParam_Result() {
  DestroyActive();
}

void UnexportableKeyService_Sign_ResponseParam_Result::set_success(::blink::Vector<uint8_t> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::Vector<uint8_t>(
        std::move(success));
  }
}

void UnexportableKeyService_Sign_ResponseParam_Result::set_failure(ServiceError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


UnexportableKeyService_Sign_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<uint8_t> value)
    : success(std::move(value)) {}

UnexportableKeyService_Sign_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : failure(std::move(value)) {}

void UnexportableKeyService_Sign_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool UnexportableKeyService_Sign_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr
UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::NewSuccess(
    ::blink::Vector<UnexportableKeyIdPtr> value) {
  return UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr
UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::NewFailure(
    ServiceError value) {
  return UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<UnexportableKeyIdPtr> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::~UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result() {
  DestroyActive();
}

void UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::set_success(::blink::Vector<UnexportableKeyIdPtr> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::Vector<UnexportableKeyIdPtr>(
        std::move(success));
  }
}

void UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::set_failure(ServiceError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<UnexportableKeyIdPtr> value)
    : success(std::move(value)) {}

UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : failure(std::move(value)) {}

void UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr
UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::NewSuccess(
    uint64_t value) {
  return UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr
UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::NewFailure(
    ServiceError value) {
  return UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    uint64_t value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::~UnexportableKeyService_DeleteAllKeys_ResponseParam_Result() {
  DestroyActive();
}

void UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::set_success(uint64_t success) {
  if (tag_ != Tag::kSuccess) {
    DestroyActive();
    tag_ = Tag::kSuccess;
  }
  data_.success = success;
}

void UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::set_failure(ServiceError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    uint64_t value)
    : success(std::move(value)) {}

UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ServiceError value)
    : failure(std::move(value)) {}

void UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}
size_t UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSuccess:
      return mojo::internal::WTFHash(seed, data_.success);
    case Tag::kFailure:
      return mojo::internal::WTFHash(seed, data_.failure);
    default:
      NOTREACHED();
  }
}

bool UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

UnexportableKeyService::IPCStableHashFunction UnexportableKeyService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UnexportableKeyService>(message.name())) {
    case messages::UnexportableKeyService::kGenerateSigningKey: {
      return &UnexportableKeyService::GenerateSigningKey_Sym::IPCStableHash;
    }
    case messages::UnexportableKeyService::kFromWrappedSigningKey: {
      return &UnexportableKeyService::FromWrappedSigningKey_Sym::IPCStableHash;
    }
    case messages::UnexportableKeyService::kSign: {
      return &UnexportableKeyService::Sign_Sym::IPCStableHash;
    }
    case messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection: {
      return &UnexportableKeyService::GetAllSigningKeysForGarbageCollection_Sym::IPCStableHash;
    }
    case messages::UnexportableKeyService::kDeleteKey: {
      return &UnexportableKeyService::DeleteKey_Sym::IPCStableHash;
    }
    case messages::UnexportableKeyService::kDeleteAllKeys: {
      return &UnexportableKeyService::DeleteAllKeys_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UnexportableKeyService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UnexportableKeyService>(message.name())) {
      case messages::UnexportableKeyService::kGenerateSigningKey:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::GenerateSigningKey";
      case messages::UnexportableKeyService::kFromWrappedSigningKey:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::FromWrappedSigningKey";
      case messages::UnexportableKeyService::kSign:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::Sign";
      case messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::GetAllSigningKeysForGarbageCollection";
      case messages::UnexportableKeyService::kDeleteKey:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::DeleteKey";
      case messages::UnexportableKeyService::kDeleteAllKeys:
            return "Receive unexportable_keys::mojom::UnexportableKeyService::DeleteAllKeys";
    }
  } else {
    switch (static_cast<messages::UnexportableKeyService>(message.name())) {
      case messages::UnexportableKeyService::kGenerateSigningKey:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::GenerateSigningKey";
      case messages::UnexportableKeyService::kFromWrappedSigningKey:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::FromWrappedSigningKey";
      case messages::UnexportableKeyService::kSign:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::Sign";
      case messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::GetAllSigningKeysForGarbageCollection";
      case messages::UnexportableKeyService::kDeleteKey:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::DeleteKey";
      case messages::UnexportableKeyService::kDeleteAllKeys:
            return "Receive reply unexportable_keys::mojom::UnexportableKeyService::DeleteAllKeys";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UnexportableKeyService::GenerateSigningKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x679e0e05;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::GenerateSigningKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UnexportableKeyService::FromWrappedSigningKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc4f9fc2;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::FromWrappedSigningKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UnexportableKeyService::Sign_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7604e768;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::Sign
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UnexportableKeyService::GetAllSigningKeysForGarbageCollection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67759a51;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::GetAllSigningKeysForGarbageCollection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UnexportableKeyService::DeleteKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcad5cbb3;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::DeleteKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UnexportableKeyService::DeleteAllKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f43b866;  // IPCStableHash for unexportable_keys::mojom::UnexportableKeyService::DeleteAllKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UnexportableKeyService_GenerateSigningKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_GenerateSigningKey_ForwardToCallback(
      UnexportableKeyService::GenerateSigningKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_GenerateSigningKey_ForwardToCallback(const UnexportableKeyService_GenerateSigningKey_ForwardToCallback&) = delete;
  UnexportableKeyService_GenerateSigningKey_ForwardToCallback& operator=(const UnexportableKeyService_GenerateSigningKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::GenerateSigningKeyCallback callback_;
};

class UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback(
      UnexportableKeyService::FromWrappedSigningKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback(const UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback&) = delete;
  UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback& operator=(const UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::FromWrappedSigningKeyCallback callback_;
};

class UnexportableKeyService_Sign_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_Sign_ForwardToCallback(
      UnexportableKeyService::SignCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_Sign_ForwardToCallback(const UnexportableKeyService_Sign_ForwardToCallback&) = delete;
  UnexportableKeyService_Sign_ForwardToCallback& operator=(const UnexportableKeyService_Sign_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::SignCallback callback_;
};

class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback(
      UnexportableKeyService::GetAllSigningKeysForGarbageCollectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback(const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback&) = delete;
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback& operator=(const UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::GetAllSigningKeysForGarbageCollectionCallback callback_;
};

class UnexportableKeyService_DeleteKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_DeleteKey_ForwardToCallback(
      UnexportableKeyService::DeleteKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_DeleteKey_ForwardToCallback(const UnexportableKeyService_DeleteKey_ForwardToCallback&) = delete;
  UnexportableKeyService_DeleteKey_ForwardToCallback& operator=(const UnexportableKeyService_DeleteKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::DeleteKeyCallback callback_;
};

class UnexportableKeyService_DeleteAllKeys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnexportableKeyService_DeleteAllKeys_ForwardToCallback(
      UnexportableKeyService::DeleteAllKeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  UnexportableKeyService_DeleteAllKeys_ForwardToCallback(const UnexportableKeyService_DeleteAllKeys_ForwardToCallback&) = delete;
  UnexportableKeyService_DeleteAllKeys_ForwardToCallback& operator=(const UnexportableKeyService_DeleteAllKeys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UnexportableKeyService::DeleteAllKeysCallback callback_;
};

UnexportableKeyServiceProxy::UnexportableKeyServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UnexportableKeyServiceProxy::GenerateSigningKey(
    const ::blink::Vector<SignatureAlgorithm>& in_acceptable_algorithms, BackgroundTaskPriority in_priority, GenerateSigningKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::GenerateSigningKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("acceptable_algorithms"), in_acceptable_algorithms,
                        "<value of type const ::blink::Vector<SignatureAlgorithm>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kGenerateSigningKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_GenerateSigningKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->acceptable_algorithms)::BaseType>
      acceptable_algorithms_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& acceptable_algorithms_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::unexportable_keys::mojom::internal::SignatureAlgorithm_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::unexportable_keys::mojom::SignatureAlgorithm>>(
    in_acceptable_algorithms,
    acceptable_algorithms_fragment,
    &acceptable_algorithms_validate_params);

  params->acceptable_algorithms.Set(
      acceptable_algorithms_fragment.is_null() ? nullptr : acceptable_algorithms_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->acceptable_algorithms.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null acceptable_algorithms in UnexportableKeyService.GenerateSigningKey request");

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("GenerateSigningKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_GenerateSigningKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnexportableKeyServiceProxy::FromWrappedSigningKey(
    const ::blink::Vector<uint8_t>& in_wrapped_key, BackgroundTaskPriority in_priority, FromWrappedSigningKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::FromWrappedSigningKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wrapped_key"), in_wrapped_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kFromWrappedSigningKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_FromWrappedSigningKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->wrapped_key)::BaseType>
      wrapped_key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& wrapped_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_wrapped_key,
    wrapped_key_fragment,
    &wrapped_key_validate_params);

  params->wrapped_key.Set(
      wrapped_key_fragment.is_null() ? nullptr : wrapped_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->wrapped_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null wrapped_key in UnexportableKeyService.FromWrappedSigningKey request");

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("FromWrappedSigningKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnexportableKeyServiceProxy::Sign(
    UnexportableKeyIdPtr in_key_id, const ::blink::Vector<uint8_t>& in_data, BackgroundTaskPriority in_priority, SignCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::Sign", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_id"), in_key_id,
                        "<value of type UnexportableKeyIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kSign), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_Sign_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_id)::BaseType> key_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyIdDataView>(
    in_key_id,
    key_id_fragment);

  params->key_id.Set(
      key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_id in UnexportableKeyService.Sign request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in UnexportableKeyService.Sign request");

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("Sign");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_Sign_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnexportableKeyServiceProxy::GetAllSigningKeysForGarbageCollection(
    BackgroundTaskPriority in_priority, GetAllSigningKeysForGarbageCollectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::GetAllSigningKeysForGarbageCollection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("GetAllSigningKeysForGarbageCollection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnexportableKeyServiceProxy::DeleteKey(
    UnexportableKeyIdPtr in_key_id, BackgroundTaskPriority in_priority, DeleteKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::DeleteKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_id"), in_key_id,
                        "<value of type UnexportableKeyIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kDeleteKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_id)::BaseType> key_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyIdDataView>(
    in_key_id,
    key_id_fragment);

  params->key_id.Set(
      key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_id in UnexportableKeyService.DeleteKey request");

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("DeleteKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_DeleteKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UnexportableKeyServiceProxy::DeleteAllKeys(
    BackgroundTaskPriority in_priority, DeleteAllKeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send unexportable_keys::mojom::UnexportableKeyService::DeleteAllKeys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BackgroundTaskPriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kDeleteAllKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteAllKeys_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::unexportable_keys::mojom::BackgroundTaskPriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("DeleteAllKeys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnexportableKeyService_DeleteAllKeys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class UnexportableKeyService_GenerateSigningKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::GenerateSigningKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_GenerateSigningKey_ProxyToResponder> proxy(
        new UnexportableKeyService_GenerateSigningKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&UnexportableKeyService_GenerateSigningKey_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr Transform(base::expected<
  NewKeyDataPtr,
  ServiceError> in) {
    return in.has_value() ? ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~UnexportableKeyService_GenerateSigningKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_GenerateSigningKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::GenerateSigningKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr in_result);
};

bool UnexportableKeyService_GenerateSigningKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_GenerateSigningKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_GenerateSigningKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.0
  bool success = true;
  UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr p_result{};
  UnexportableKeyService_GenerateSigningKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void UnexportableKeyService_GenerateSigningKey_ProxyToResponder::Run(
    UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::GenerateSigningKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kGenerateSigningKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_GenerateSigningKey_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("GenerateSigningKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::FromWrappedSigningKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder> proxy(
        new UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr Transform(base::expected<
  NewKeyDataPtr,
  ServiceError> in) {
    return in.has_value() ? ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::FromWrappedSigningKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr in_result);
};

bool UnexportableKeyService_FromWrappedSigningKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.1
  bool success = true;
  UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr p_result{};
  UnexportableKeyService_FromWrappedSigningKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder::Run(
    UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::FromWrappedSigningKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kFromWrappedSigningKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("FromWrappedSigningKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UnexportableKeyService_Sign_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::SignCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_Sign_ProxyToResponder> proxy(
        new UnexportableKeyService_Sign_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&UnexportableKeyService_Sign_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static UnexportableKeyService_Sign_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::Vector<uint8_t>,
  ServiceError> in) {
    return in.has_value() ? ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~UnexportableKeyService_Sign_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_Sign_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::SignCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnexportableKeyService_Sign_ResponseParam_ResultPtr in_result);
};

bool UnexportableKeyService_Sign_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_Sign_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_Sign_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.2
  bool success = true;
  UnexportableKeyService_Sign_ResponseParam_ResultPtr p_result{};
  UnexportableKeyService_Sign_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void UnexportableKeyService_Sign_ProxyToResponder::Run(
    UnexportableKeyService_Sign_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::Sign", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UnexportableKeyService_Sign_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kSign), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_Sign_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyService_Sign_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("Sign");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::GetAllSigningKeysForGarbageCollectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder> proxy(
        new UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::Vector<UnexportableKeyIdPtr>,
  ServiceError> in) {
    return in.has_value() ? ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::GetAllSigningKeysForGarbageCollectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr in_result);
};

bool UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.3
  bool success = true;
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr p_result{};
  UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder::Run(
    UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::GetAllSigningKeysForGarbageCollection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("GetAllSigningKeysForGarbageCollection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UnexportableKeyService_DeleteKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::DeleteKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_DeleteKey_ProxyToResponder> proxy(
        new UnexportableKeyService_DeleteKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UnexportableKeyService_DeleteKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UnexportableKeyService_DeleteKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_DeleteKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::DeleteKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<ServiceError> in_error);
};

bool UnexportableKeyService_DeleteKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_DeleteKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_DeleteKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.4
  bool success = true;
  std::optional<ServiceError> p_error{};
  UnexportableKeyService_DeleteKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error)) {
    success = false;
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void UnexportableKeyService_DeleteKey_ProxyToResponder::Run(
    std::optional<ServiceError> in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::DeleteKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type std::optional<ServiceError>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kDeleteKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteKey_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->error_$flag = in_error.has_value();
  if (in_error.has_value()) {
    
    mojo::internal::Serialize<::unexportable_keys::mojom::ServiceError>(
      in_error.value(),
      &params->error_$value);
  } else {
    params->error_$value =
        static_cast<int32_t>(::unexportable_keys::mojom::ServiceError::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("DeleteKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UnexportableKeyService_DeleteAllKeys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UnexportableKeyService::DeleteAllKeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UnexportableKeyService_DeleteAllKeys_ProxyToResponder> proxy(
        new UnexportableKeyService_DeleteAllKeys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&UnexportableKeyService_DeleteAllKeys_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr Transform(base::expected<
  uint64_t,
  ServiceError> in) {
    return in.has_value() ? ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~UnexportableKeyService_DeleteAllKeys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UnexportableKeyService_DeleteAllKeys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UnexportableKeyService::DeleteAllKeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr in_result);
};

bool UnexportableKeyService_DeleteAllKeys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UnexportableKeyService_DeleteAllKeys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnexportableKeyService_DeleteAllKeys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UnexportableKeyService.5
  bool success = true;
  UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr p_result{};
  UnexportableKeyService_DeleteAllKeys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnexportableKeyService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void UnexportableKeyService_DeleteAllKeys_ProxyToResponder::Run(
    UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply unexportable_keys::mojom::UnexportableKeyService::DeleteAllKeys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UnexportableKeyService::kDeleteAllKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::unexportable_keys::mojom::internal::UnexportableKeyService_DeleteAllKeys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::unexportable_keys::mojom::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnexportableKeyService::Name_);
  message.set_method_name("DeleteAllKeys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UnexportableKeyServiceStubDispatch::Accept(
    UnexportableKeyService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UnexportableKeyService>(message->header()->name)) {
    case messages::UnexportableKeyService::kGenerateSigningKey: {
      break;
    }
    case messages::UnexportableKeyService::kFromWrappedSigningKey: {
      break;
    }
    case messages::UnexportableKeyService::kSign: {
      break;
    }
    case messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection: {
      break;
    }
    case messages::UnexportableKeyService::kDeleteKey: {
      break;
    }
    case messages::UnexportableKeyService::kDeleteAllKeys: {
      break;
    }
  }
  return false;
}

// static
bool UnexportableKeyServiceStubDispatch::AcceptWithResponder(
    UnexportableKeyService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UnexportableKeyService>(message->header()->name)) {
    case messages::UnexportableKeyService::kGenerateSigningKey: {
      internal::UnexportableKeyService_GenerateSigningKey_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_GenerateSigningKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.0
      bool success = true;
      ::blink::Vector<SignatureAlgorithm> p_acceptable_algorithms{};
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_GenerateSigningKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAcceptableAlgorithms(&p_acceptable_algorithms))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 0, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_GenerateSigningKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateSigningKey(        
        std::move(p_acceptable_algorithms), 
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::UnexportableKeyService::kFromWrappedSigningKey: {
      internal::UnexportableKeyService_FromWrappedSigningKey_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_FromWrappedSigningKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.1
      bool success = true;
      ::blink::Vector<uint8_t> p_wrapped_key{};
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_FromWrappedSigningKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWrappedKey(&p_wrapped_key))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 1, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_FromWrappedSigningKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FromWrappedSigningKey(        
        std::move(p_wrapped_key), 
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::UnexportableKeyService::kSign: {
      internal::UnexportableKeyService_Sign_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_Sign_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.2
      bool success = true;
      UnexportableKeyIdPtr p_key_id{};
      ::blink::Vector<uint8_t> p_data{};
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_Sign_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyId(&p_key_id))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 2, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_Sign_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Sign(        
        std::move(p_key_id), 
        std::move(p_data), 
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::UnexportableKeyService::kGetAllSigningKeysForGarbageCollection: {
      internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.3
      bool success = true;
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 3, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllSigningKeysForGarbageCollection(        
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::UnexportableKeyService::kDeleteKey: {
      internal::UnexportableKeyService_DeleteKey_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_DeleteKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.4
      bool success = true;
      UnexportableKeyIdPtr p_key_id{};
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_DeleteKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyId(&p_key_id))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 4, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_DeleteKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteKey(        
        std::move(p_key_id), 
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::UnexportableKeyService::kDeleteAllKeys: {
      internal::UnexportableKeyService_DeleteAllKeys_Params_Data* params =
          reinterpret_cast<
              internal::UnexportableKeyService_DeleteAllKeys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UnexportableKeyService.5
      bool success = true;
      BackgroundTaskPriority p_priority{};
      UnexportableKeyService_DeleteAllKeys_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnexportableKeyService::Name_, 5, false);
        return false;
      }
      auto callback =
          UnexportableKeyService_DeleteAllKeys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAllKeys(        
        std::move(p_priority), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUnexportableKeyServiceValidationInfo[] = {
    { &internal::UnexportableKeyService_GenerateSigningKey_Params_Data::Validate,
     &internal::UnexportableKeyService_GenerateSigningKey_ResponseParams_Data::Validate},
    { &internal::UnexportableKeyService_FromWrappedSigningKey_Params_Data::Validate,
     &internal::UnexportableKeyService_FromWrappedSigningKey_ResponseParams_Data::Validate},
    { &internal::UnexportableKeyService_Sign_Params_Data::Validate,
     &internal::UnexportableKeyService_Sign_ResponseParams_Data::Validate},
    { &internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_Params_Data::Validate,
     &internal::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParams_Data::Validate},
    { &internal::UnexportableKeyService_DeleteKey_Params_Data::Validate,
     &internal::UnexportableKeyService_DeleteKey_ResponseParams_Data::Validate},
    { &internal::UnexportableKeyService_DeleteAllKeys_Params_Data::Validate,
     &internal::UnexportableKeyService_DeleteAllKeys_ResponseParams_Data::Validate},
};

bool UnexportableKeyServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::unexportable_keys::mojom::blink::UnexportableKeyService::Name_,
    kUnexportableKeyServiceValidationInfo);
}

bool UnexportableKeyServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::unexportable_keys::mojom::blink::UnexportableKeyService::Name_,
    kUnexportableKeyServiceValidationInfo);
}


}  // unexportable_keys::mojom::blink


namespace mojo {


// static
bool StructTraits<::unexportable_keys::mojom::blink::UnexportableKeyId::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyId::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr* output) {
  bool success = true;
  ::unexportable_keys::mojom::blink::UnexportableKeyIdPtr result(::unexportable_keys::mojom::blink::UnexportableKeyId::New());
  
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::unexportable_keys::mojom::blink::NewKeyData::DataView, ::unexportable_keys::mojom::blink::NewKeyDataPtr>::Read(
    ::unexportable_keys::mojom::blink::NewKeyData::DataView input,
    ::unexportable_keys::mojom::blink::NewKeyDataPtr* output) {
  bool success = true;
  ::unexportable_keys::mojom::blink::NewKeyDataPtr result(::unexportable_keys::mojom::blink::NewKeyData::New());
  
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadSubjectPublicKeyInfo(&result->subject_public_key_info))
        success = false;
      if (success && !input.ReadWrappedKey(&result->wrapped_key))
        success = false;
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_ResultPtr* output) {
  using UnionType = ::unexportable_keys::mojom::blink::UnexportableKeyService_GenerateSigningKey_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::unexportable_keys::mojom::blink::NewKeyDataPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::unexportable_keys::mojom::blink::ServiceError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_ResultPtr* output) {
  using UnionType = ::unexportable_keys::mojom::blink::UnexportableKeyService_FromWrappedSigningKey_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::unexportable_keys::mojom::blink::NewKeyDataPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::unexportable_keys::mojom::blink::ServiceError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_ResultPtr* output) {
  using UnionType = ::unexportable_keys::mojom::blink::UnexportableKeyService_Sign_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::Vector<uint8_t> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::unexportable_keys::mojom::blink::ServiceError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_ResultPtr* output) {
  using UnionType = ::unexportable_keys::mojom::blink::UnexportableKeyService_GetAllSigningKeysForGarbageCollection_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::Vector<::unexportable_keys::mojom::blink::UnexportableKeyIdPtr> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::unexportable_keys::mojom::blink::ServiceError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView, ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr>::Read(
    ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result::DataView input,
    ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_ResultPtr* output) {
  using UnionType = ::unexportable_keys::mojom::blink::UnexportableKeyService_DeleteAllKeys_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      *output = UnionType::NewSuccess(input.success());
      break;
    }
    case Tag::kFailure: {
      ::unexportable_keys::mojom::blink::ServiceError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace unexportable_keys::mojom::blink {


void UnexportableKeyServiceInterceptorForTesting::GenerateSigningKey(const ::blink::Vector<SignatureAlgorithm>& acceptable_algorithms, BackgroundTaskPriority priority, GenerateSigningKeyCallback callback) {
  GetForwardingInterface()->GenerateSigningKey(
    std::move(acceptable_algorithms)
    , 
    std::move(priority)
    , std::move(callback));
}
void UnexportableKeyServiceInterceptorForTesting::FromWrappedSigningKey(const ::blink::Vector<uint8_t>& wrapped_key, BackgroundTaskPriority priority, FromWrappedSigningKeyCallback callback) {
  GetForwardingInterface()->FromWrappedSigningKey(
    std::move(wrapped_key)
    , 
    std::move(priority)
    , std::move(callback));
}
void UnexportableKeyServiceInterceptorForTesting::Sign(UnexportableKeyIdPtr key_id, const ::blink::Vector<uint8_t>& data, BackgroundTaskPriority priority, SignCallback callback) {
  GetForwardingInterface()->Sign(
    std::move(key_id)
    , 
    std::move(data)
    , 
    std::move(priority)
    , std::move(callback));
}
void UnexportableKeyServiceInterceptorForTesting::GetAllSigningKeysForGarbageCollection(BackgroundTaskPriority priority, GetAllSigningKeysForGarbageCollectionCallback callback) {
  GetForwardingInterface()->GetAllSigningKeysForGarbageCollection(
    std::move(priority)
    , std::move(callback));
}
void UnexportableKeyServiceInterceptorForTesting::DeleteKey(UnexportableKeyIdPtr key_id, BackgroundTaskPriority priority, DeleteKeyCallback callback) {
  GetForwardingInterface()->DeleteKey(
    std::move(key_id)
    , 
    std::move(priority)
    , std::move(callback));
}
void UnexportableKeyServiceInterceptorForTesting::DeleteAllKeys(BackgroundTaskPriority priority, DeleteAllKeysCallback callback) {
  GetForwardingInterface()->DeleteAllKeys(
    std::move(priority)
    , std::move(callback));
}
UnexportableKeyServiceAsyncWaiter::UnexportableKeyServiceAsyncWaiter(
    UnexportableKeyService* proxy) : proxy_(proxy) {}

UnexportableKeyServiceAsyncWaiter::~UnexportableKeyServiceAsyncWaiter() = default;


void UnexportableKeyServiceAsyncWaiter::DeleteKey(
    UnexportableKeyIdPtr key_id, BackgroundTaskPriority priority, std::optional<ServiceError>* out_error) {
  base::RunLoop loop;
  proxy_->DeleteKey(
      std::move(key_id),
      std::move(priority),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<ServiceError>* out_error
,
             std::optional<ServiceError> error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::optional<ServiceError> UnexportableKeyServiceAsyncWaiter::DeleteKey(
    UnexportableKeyIdPtr key_id, BackgroundTaskPriority priority) {
  std::optional<ServiceError> async_wait_result;
  DeleteKey(std::move(key_id),std::move(priority),&async_wait_result);
  return async_wait_result;
}






}  // unexportable_keys::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif