// components/translate/content/common/translate.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_H_
#define COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/translate/content/common/translate.mojom-features.h"  // IWYU pragma: export
#include "components/translate/content/common/translate.mojom-shared.h"  // IWYU pragma: export
#include "components/translate/content/common/translate.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/translate/content/common/translate_mojom_traits.h"




namespace translate::mojom {

class TranslateAgentProxy;

template <typename ImplRefTraits>
class TranslateAgentStub;

class TranslateAgentRequestValidator;
class TranslateAgentResponseValidator;


class TranslateAgent
    : public TranslateAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "translate.mojom.TranslateAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TranslateAgentInterfaceBase;
  using Proxy_ = TranslateAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = TranslateAgentStub<ImplRefTraits>;

  using RequestValidator_ = TranslateAgentRequestValidator;
  using ResponseValidator_ = TranslateAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kTranslateFrameMinVersion = 0,
    kRevertTranslationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TranslateFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RevertTranslation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TranslateAgent() = default;

  using TranslateFrameCallback = base::OnceCallback<void(bool, const std::string&, const std::string&, ::translate::TranslateErrors)>;
  using TranslateFrameMojoCallback = base::OnceCallback<void(bool, const std::string&, const std::string&, ::translate::TranslateErrors)>;

  virtual void TranslateFrame(const std::string& translate_script, const std::string& source_lang, const std::string& target_lang, TranslateFrameCallback callback) = 0;

  virtual void RevertTranslation() = 0;
};

class ContentTranslateDriverProxy;

template <typename ImplRefTraits>
class ContentTranslateDriverStub;

class ContentTranslateDriverRequestValidator;


class ContentTranslateDriver
    : public ContentTranslateDriverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "translate.mojom.ContentTranslateDriver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentTranslateDriverInterfaceBase;
  using Proxy_ = ContentTranslateDriverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentTranslateDriverStub<ImplRefTraits>;

  using RequestValidator_ = ContentTranslateDriverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRegisterPageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContentTranslateDriver() = default;

  virtual void RegisterPage(::mojo::PendingRemote<TranslateAgent> translate_agent, const ::translate::LanguageDetectionDetails& details, bool translation_critiera_met) = 0;
};



class  TranslateAgentProxy
    : public TranslateAgent {
 public:
  using InterfaceType = TranslateAgent;

  explicit TranslateAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TranslateFrame(const std::string& translate_script, const std::string& source_lang, const std::string& target_lang, TranslateFrameCallback callback) final;
  
  void RevertTranslation() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ContentTranslateDriverProxy
    : public ContentTranslateDriver {
 public:
  using InterfaceType = ContentTranslateDriver;

  explicit ContentTranslateDriverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterPage(::mojo::PendingRemote<TranslateAgent> translate_agent, const ::translate::LanguageDetectionDetails& details, bool translation_critiera_met) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TranslateAgentStubDispatch {
 public:
  static bool Accept(TranslateAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TranslateAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TranslateAgent>>
class TranslateAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TranslateAgentStub() = default;
  ~TranslateAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslateAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslateAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentTranslateDriverStubDispatch {
 public:
  static bool Accept(ContentTranslateDriver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentTranslateDriver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentTranslateDriver>>
class ContentTranslateDriverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentTranslateDriverStub() = default;
  ~ContentTranslateDriverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentTranslateDriverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentTranslateDriverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TranslateAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentTranslateDriverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TranslateAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  LanguageDetectionDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LanguageDetectionDetails, T>::value>;
  using DataView = LanguageDetectionDetailsDataView;
  using Data_ = internal::LanguageDetectionDetails_Data;

  template <typename... Args>
  static LanguageDetectionDetailsPtr New(Args&&... args) {
    return LanguageDetectionDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LanguageDetectionDetailsPtr From(const U& u) {
    return mojo::TypeConverter<LanguageDetectionDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LanguageDetectionDetails>::Convert(*this);
  }


  LanguageDetectionDetails();

  LanguageDetectionDetails(
      const ::GURL& url,
      const std::string& adopted_language,
      bool has_notranslate,
      bool has_run_lang_detection,
      ::base::Time time,
      const std::string& content_language,
      const std::string& model_detected_language,
      bool is_model_reliable,
      const std::string& html_root_language,
      const ::std::u16string& contents,
      float model_reliability_score,
      const std::string& detection_model_version);


  ~LanguageDetectionDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LanguageDetectionDetailsPtr>
  LanguageDetectionDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageDetectionDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageDetectionDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LanguageDetectionDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LanguageDetectionDetails_UnserializedMessageContext<
            UserType, LanguageDetectionDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LanguageDetectionDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LanguageDetectionDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LanguageDetectionDetails_UnserializedMessageContext<
            UserType, LanguageDetectionDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LanguageDetectionDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string adopted_language;
  
  bool has_notranslate;
  
  bool has_run_lang_detection;
  
  ::base::Time time;
  
  std::string content_language;
  
  std::string model_detected_language;
  
  bool is_model_reliable;
  
  std::string html_root_language;
  
  ::std::u16string contents;
  
  float model_reliability_score;
  
  std::string detection_model_version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LanguageDetectionDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LanguageDetectionDetailsPtr LanguageDetectionDetails::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(adopted_language),
      mojo::Clone(has_notranslate),
      mojo::Clone(has_run_lang_detection),
      mojo::Clone(time),
      mojo::Clone(content_language),
      mojo::Clone(model_detected_language),
      mojo::Clone(is_model_reliable),
      mojo::Clone(html_root_language),
      mojo::Clone(contents),
      mojo::Clone(model_reliability_score),
      mojo::Clone(detection_model_version)
  );
}

template <typename T, LanguageDetectionDetails::EnableIfSame<T>*>
bool LanguageDetectionDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->adopted_language, other_struct.adopted_language))
    return false;
  if (!mojo::Equals(this->has_notranslate, other_struct.has_notranslate))
    return false;
  if (!mojo::Equals(this->has_run_lang_detection, other_struct.has_run_lang_detection))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->content_language, other_struct.content_language))
    return false;
  if (!mojo::Equals(this->model_detected_language, other_struct.model_detected_language))
    return false;
  if (!mojo::Equals(this->is_model_reliable, other_struct.is_model_reliable))
    return false;
  if (!mojo::Equals(this->html_root_language, other_struct.html_root_language))
    return false;
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  if (!mojo::Equals(this->model_reliability_score, other_struct.model_reliability_score))
    return false;
  if (!mojo::Equals(this->detection_model_version, other_struct.detection_model_version))
    return false;
  return true;
}

template <typename T, LanguageDetectionDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.adopted_language < rhs.adopted_language)
    return true;
  if (rhs.adopted_language < lhs.adopted_language)
    return false;
  if (lhs.has_notranslate < rhs.has_notranslate)
    return true;
  if (rhs.has_notranslate < lhs.has_notranslate)
    return false;
  if (lhs.has_run_lang_detection < rhs.has_run_lang_detection)
    return true;
  if (rhs.has_run_lang_detection < lhs.has_run_lang_detection)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.content_language < rhs.content_language)
    return true;
  if (rhs.content_language < lhs.content_language)
    return false;
  if (lhs.model_detected_language < rhs.model_detected_language)
    return true;
  if (rhs.model_detected_language < lhs.model_detected_language)
    return false;
  if (lhs.is_model_reliable < rhs.is_model_reliable)
    return true;
  if (rhs.is_model_reliable < lhs.is_model_reliable)
    return false;
  if (lhs.html_root_language < rhs.html_root_language)
    return true;
  if (rhs.html_root_language < lhs.html_root_language)
    return false;
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  if (lhs.model_reliability_score < rhs.model_reliability_score)
    return true;
  if (rhs.model_reliability_score < lhs.model_reliability_score)
    return false;
  if (lhs.detection_model_version < rhs.detection_model_version)
    return true;
  if (rhs.detection_model_version < lhs.detection_model_version)
    return false;
  return false;
}


}  // translate::mojom

namespace mojo {


template <>
struct  StructTraits<::translate::mojom::LanguageDetectionDetails::DataView,
                                         ::translate::mojom::LanguageDetectionDetailsPtr> {
  static bool IsNull(const ::translate::mojom::LanguageDetectionDetailsPtr& input) { return !input; }
  static void SetToNull(::translate::mojom::LanguageDetectionDetailsPtr* output) { output->reset(); }

  static const decltype(::translate::mojom::LanguageDetectionDetails::url)& url(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->url;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::adopted_language)& adopted_language(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->adopted_language;
  }

  static decltype(::translate::mojom::LanguageDetectionDetails::has_notranslate) has_notranslate(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->has_notranslate;
  }

  static decltype(::translate::mojom::LanguageDetectionDetails::has_run_lang_detection) has_run_lang_detection(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->has_run_lang_detection;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::time)& time(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->time;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::content_language)& content_language(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->content_language;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::model_detected_language)& model_detected_language(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->model_detected_language;
  }

  static decltype(::translate::mojom::LanguageDetectionDetails::is_model_reliable) is_model_reliable(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->is_model_reliable;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::html_root_language)& html_root_language(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->html_root_language;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::contents)& contents(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->contents;
  }

  static decltype(::translate::mojom::LanguageDetectionDetails::model_reliability_score) model_reliability_score(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->model_reliability_score;
  }

  static const decltype(::translate::mojom::LanguageDetectionDetails::detection_model_version)& detection_model_version(
      const ::translate::mojom::LanguageDetectionDetailsPtr& input) {
    return input->detection_model_version;
  }

  static bool Read(::translate::mojom::LanguageDetectionDetails::DataView input, ::translate::mojom::LanguageDetectionDetailsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_H_