// components/translate/content/common/translate.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SHARED_H_
#define COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/translate/content/common/translate.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/translate/content/common/translate.mojom-data-view.h"




namespace std {

template <>
struct hash<::translate::mojom::TranslateError>
    : public mojo::internal::EnumHashImpl<::translate::mojom::TranslateError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::translate::mojom::TranslateError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::translate::mojom::TranslateError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::translate::mojom::TranslateError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::translate::mojom::LanguageDetectionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::translate::mojom::LanguageDetectionDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::translate::mojom::internal::LanguageDetectionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LanguageDetectionDetails struct");

    decltype(Traits::adopted_language(input)) in_adopted_language = Traits::adopted_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->adopted_language)::BaseType> adopted_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_adopted_language,
      adopted_language_fragment);

    fragment->adopted_language.Set(
        adopted_language_fragment.is_null() ? nullptr : adopted_language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->adopted_language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null adopted_language in LanguageDetectionDetails struct");

    fragment->has_notranslate = Traits::has_notranslate(input);

    fragment->has_run_lang_detection = Traits::has_run_lang_detection(input);

    decltype(Traits::time(input)) in_time = Traits::time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time)::BaseType> time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_time,
      time_fragment);

    fragment->time.Set(
        time_fragment.is_null() ? nullptr : time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in LanguageDetectionDetails struct");

    decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_language)::BaseType> content_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_language,
      content_language_fragment);

    fragment->content_language.Set(
        content_language_fragment.is_null() ? nullptr : content_language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_language in LanguageDetectionDetails struct");

    decltype(Traits::model_detected_language(input)) in_model_detected_language = Traits::model_detected_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_detected_language)::BaseType> model_detected_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_detected_language,
      model_detected_language_fragment);

    fragment->model_detected_language.Set(
        model_detected_language_fragment.is_null() ? nullptr : model_detected_language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_detected_language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_detected_language in LanguageDetectionDetails struct");

    fragment->is_model_reliable = Traits::is_model_reliable(input);

    decltype(Traits::html_root_language(input)) in_html_root_language = Traits::html_root_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html_root_language)::BaseType> html_root_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_html_root_language,
      html_root_language_fragment);

    fragment->html_root_language.Set(
        html_root_language_fragment.is_null() ? nullptr : html_root_language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->html_root_language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null html_root_language in LanguageDetectionDetails struct");

    decltype(Traits::contents(input)) in_contents = Traits::contents(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contents)::BaseType> contents_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_contents,
      contents_fragment);

    fragment->contents.Set(
        contents_fragment.is_null() ? nullptr : contents_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contents.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents in LanguageDetectionDetails struct");

    fragment->model_reliability_score = Traits::model_reliability_score(input);

    decltype(Traits::detection_model_version(input)) in_detection_model_version = Traits::detection_model_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->detection_model_version)::BaseType> detection_model_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_detection_model_version,
      detection_model_version_fragment);

    fragment->detection_model_version.Set(
        detection_model_version_fragment.is_null() ? nullptr : detection_model_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->detection_model_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detection_model_version in LanguageDetectionDetails struct");
  }

  static bool Deserialize(::translate::mojom::internal::LanguageDetectionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::translate::mojom::LanguageDetectionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace translate::mojom {

inline void LanguageDetectionDetailsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetAdoptedLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->adopted_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetContentLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetModelDetectedLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_detected_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetHtmlRootLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->html_root_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetContentsDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->contents.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void LanguageDetectionDetailsDataView::GetDetectionModelVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->detection_model_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // translate::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::translate::mojom::TranslateError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::translate::mojom::TranslateError value);
};

} // namespace perfetto

#endif  // COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SHARED_H_