// components/translate/content/common/translate.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/translate/content/common/translate.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/translate/content/common/translate.mojom-params-data.h"
namespace translate {
namespace mojom {

NOINLINE static const char* TranslateErrorToStringHelper(TranslateError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TranslateError::NONE:
      return "NONE";
    case TranslateError::NETWORK:
      return "NETWORK";
    case TranslateError::INITIALIZATION_ERROR:
      return "INITIALIZATION_ERROR";
    case TranslateError::UNKNOWN_LANGUAGE:
      return "UNKNOWN_LANGUAGE";
    case TranslateError::UNSUPPORTED_LANGUAGE:
      return "UNSUPPORTED_LANGUAGE";
    case TranslateError::IDENTICAL_LANGUAGES:
      return "IDENTICAL_LANGUAGES";
    case TranslateError::TRANSLATION_ERROR:
      return "TRANSLATION_ERROR";
    case TranslateError::TRANSLATION_TIMEOUT:
      return "TRANSLATION_TIMEOUT";
    case TranslateError::UNEXPECTED_SCRIPT_ERROR:
      return "UNEXPECTED_SCRIPT_ERROR";
    case TranslateError::BAD_ORIGIN:
      return "BAD_ORIGIN";
    case TranslateError::SCRIPT_LOAD_ERROR:
      return "SCRIPT_LOAD_ERROR";
    case TranslateError::TRANSLATE_ERROR_MAX:
      return "TRANSLATE_ERROR_MAX";
    default:
      return nullptr;
  }
}

std::string TranslateErrorToString(TranslateError value) {
  const char *str = TranslateErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TranslateError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TranslateError value) {
  return os << TranslateErrorToString(value);
}

namespace internal {


// static
bool LanguageDetectionDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LanguageDetectionDetails_Data* object =
      static_cast<const LanguageDetectionDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->adopted_language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& adopted_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->adopted_language, validation_context,
                                         &adopted_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_language, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_detected_language, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_detected_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_detected_language, validation_context,
                                         &model_detected_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->html_root_language, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& html_root_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->html_root_language, validation_context,
                                         &html_root_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->contents, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->detection_model_version, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& detection_model_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->detection_model_version, validation_context,
                                         &detection_model_version_validate_params)) {
    return false;
  }

  return true;
}

LanguageDetectionDetails_Data::LanguageDetectionDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslateAgent_TranslateFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslateAgent_TranslateFrame_Params_Data* object =
      static_cast<const TranslateAgent_TranslateFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->translate_script, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& translate_script_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->translate_script, validation_context,
                                         &translate_script_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_lang, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_lang, validation_context,
                                         &source_lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_lang, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_lang, validation_context,
                                         &target_lang_validate_params)) {
    return false;
  }

  return true;
}

TranslateAgent_TranslateFrame_Params_Data::TranslateAgent_TranslateFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslateAgent_TranslateFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslateAgent_TranslateFrame_ResponseParams_Data* object =
      static_cast<const TranslateAgent_TranslateFrame_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_lang, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& original_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->original_lang, validation_context,
                                         &original_lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->translated_lang, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& translated_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->translated_lang, validation_context,
                                         &translated_lang_validate_params)) {
    return false;
  }


  if (!::translate::mojom::internal::TranslateError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

TranslateAgent_TranslateFrame_ResponseParams_Data::TranslateAgent_TranslateFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslateAgent_RevertTranslation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslateAgent_RevertTranslation_Params_Data* object =
      static_cast<const TranslateAgent_RevertTranslation_Params_Data*>(data);

  return true;
}

TranslateAgent_RevertTranslation_Params_Data::TranslateAgent_RevertTranslation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentTranslateDriver_RegisterPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentTranslateDriver_RegisterPage_Params_Data* object =
      static_cast<const ContentTranslateDriver_RegisterPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->translate_agent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->translate_agent,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

ContentTranslateDriver_RegisterPage_Params_Data::ContentTranslateDriver_RegisterPage_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace translate

namespace perfetto {

// static
void TraceFormatTraits<::translate::mojom::TranslateError>::WriteIntoTrace(
   perfetto::TracedValue context, ::translate::mojom::TranslateError value) {
  return std::move(context).WriteString(::translate::mojom::TranslateErrorToString(value));
}

} // namespace perfetto