// components/translate/content/common/translate.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SEND_VALIDATION_H_

#include "components/translate/content/common/translate.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/translate/content/common/translate.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::translate::mojom::TranslateError, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::translate::mojom::LanguageDetectionDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::translate::mojom::LanguageDetectionDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::translate::mojom::internal::LanguageDetectionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in LanguageDetectionDetails struct");

      decltype(Traits::adopted_language(input)) in_adopted_language = Traits::adopted_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->adopted_language)::BaseType> adopted_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_adopted_language,
        adopted_language_fragment);

      fragment->adopted_language.Set(
          adopted_language_fragment.is_null() ? nullptr : adopted_language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->adopted_language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null adopted_language in LanguageDetectionDetails struct");

      fragment->has_notranslate = Traits::has_notranslate(input);

      fragment->has_run_lang_detection = Traits::has_run_lang_detection(input);

      decltype(Traits::time(input)) in_time = Traits::time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time)::BaseType> time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_time,
        time_fragment);

      fragment->time.Set(
          time_fragment.is_null() ? nullptr : time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time in LanguageDetectionDetails struct");

      decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_language)::BaseType> content_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_language,
        content_language_fragment);

      fragment->content_language.Set(
          content_language_fragment.is_null() ? nullptr : content_language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_language in LanguageDetectionDetails struct");

      decltype(Traits::model_detected_language(input)) in_model_detected_language = Traits::model_detected_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->model_detected_language)::BaseType> model_detected_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_model_detected_language,
        model_detected_language_fragment);

      fragment->model_detected_language.Set(
          model_detected_language_fragment.is_null() ? nullptr : model_detected_language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->model_detected_language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null model_detected_language in LanguageDetectionDetails struct");

      fragment->is_model_reliable = Traits::is_model_reliable(input);

      decltype(Traits::html_root_language(input)) in_html_root_language = Traits::html_root_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->html_root_language)::BaseType> html_root_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_html_root_language,
        html_root_language_fragment);

      fragment->html_root_language.Set(
          html_root_language_fragment.is_null() ? nullptr : html_root_language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->html_root_language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null html_root_language in LanguageDetectionDetails struct");

      decltype(Traits::contents(input)) in_contents = Traits::contents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contents)::BaseType> contents_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_contents,
        contents_fragment);

      fragment->contents.Set(
          contents_fragment.is_null() ? nullptr : contents_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contents in LanguageDetectionDetails struct");

      fragment->model_reliability_score = Traits::model_reliability_score(input);

      decltype(Traits::detection_model_version(input)) in_detection_model_version = Traits::detection_model_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->detection_model_version)::BaseType> detection_model_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_detection_model_version,
        detection_model_version_fragment);

      fragment->detection_model_version.Set(
          detection_model_version_fragment.is_null() ? nullptr : detection_model_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->detection_model_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null detection_model_version in LanguageDetectionDetails struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_SEND_VALIDATION_H_