// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{addWebUiListener}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{html,render}from"chrome://resources/lit/v3_0/lit.rollup.js";let instance=null;class TrafficLogTag{container=null;protocolEvents=[];knownEventTimestamps=new Set;isScrolledToBottom_(){return window.innerHeight+window.scrollY>=document.body.offsetHeight}scrollToBottom_(){window.scrollTo(0,document.body.scrollHeight)}onReceivedProtocolEvent_(details){if(this.knownEventTimestamps.has(details.time)){return}this.knownEventTimestamps.add(details.time);this.protocolEvents.push(details);const shouldScrollDown=this.isScrolledToBottom_();assert(this.container);render(this.getTrafficLogHtml_(),this.container);if(shouldScrollDown){this.scrollToBottom_()}}onClick_(e){if(e.target.classList.contains("proto")){return}let trafficEventDiv=e.target;if(trafficEventDiv.nodeName!=="DIV"&&trafficEventDiv.parentNode){trafficEventDiv=trafficEventDiv.parentNode}trafficEventDiv.classList.toggle("traffic-event-entry-expanded-fullscreen")}getTrafficLogHtml_(){return html`
      ${this.protocolEvents.map((item=>html`
        <div class="traffic-event-entry-fullscreen" @click="${this.onClick_}">
          <span class="time">${new Date(item.time).toLocaleString()}</span>
          <span class="type">${item.type}</span>
          <pre class="details">${item.details}</pre>
          <pre class="proto">${JSON.stringify(item.proto,null,2)}</pre>
        </div>
      `))}
    `}onLoad(){this.container=getRequiredElement("traffic-event-fullscreen-container");addWebUiListener("onProtocolEvent",this.onReceivedProtocolEvent_.bind(this))}static getInstance(){return instance||(instance=new TrafficLogTag)}}document.addEventListener("DOMContentLoaded",(()=>{TrafficLogTag.getInstance().onLoad()}));