// components/subresource_filter/core/mojom/subresource_filter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-features.h"  // IWYU pragma: export
#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared.h"  // IWYU pragma: export
#include "components/subresource_filter/core/mojom/subresource_filter.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace subresource_filter::mojom {

class SubresourceFilterRulesetObserverProxy;

template <typename ImplRefTraits>
class SubresourceFilterRulesetObserverStub;

class SubresourceFilterRulesetObserverRequestValidator;


class SubresourceFilterRulesetObserver
    : public SubresourceFilterRulesetObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "subresource_filter.mojom.SubresourceFilterRulesetObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SubresourceFilterRulesetObserverInterfaceBase;
  using Proxy_ = SubresourceFilterRulesetObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SubresourceFilterRulesetObserverStub<ImplRefTraits>;

  using RequestValidator_ = SubresourceFilterRulesetObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetRulesetForProcessMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetRulesetForProcess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SubresourceFilterRulesetObserver() = default;

  virtual void SetRulesetForProcess(::base::File ruleset_file) = 0;
};



class  SubresourceFilterRulesetObserverProxy
    : public SubresourceFilterRulesetObserver {
 public:
  using InterfaceType = SubresourceFilterRulesetObserver;

  explicit SubresourceFilterRulesetObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetRulesetForProcess(::base::File ruleset_file) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SubresourceFilterRulesetObserverStubDispatch {
 public:
  static bool Accept(SubresourceFilterRulesetObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SubresourceFilterRulesetObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SubresourceFilterRulesetObserver>>
class SubresourceFilterRulesetObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SubresourceFilterRulesetObserverStub() = default;
  ~SubresourceFilterRulesetObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterRulesetObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterRulesetObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SubresourceFilterRulesetObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  ActivationState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ActivationState, T>::value>;
  using DataView = ActivationStateDataView;
  using Data_ = internal::ActivationState_Data;

  template <typename... Args>
  static ActivationStatePtr New(Args&&... args) {
    return ActivationStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActivationStatePtr From(const U& u) {
    return mojo::TypeConverter<ActivationStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ActivationState>::Convert(*this);
  }


  ActivationState();

  ActivationState(
      ActivationLevel activation_level,
      SubresourceFilterDisabledReason disabled_reason,
      bool filtering_disabled_for_document,
      bool generic_blocking_rules_disabled,
      bool measure_performance,
      bool enable_logging);


  ~ActivationState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActivationStatePtr>
  ActivationStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActivationState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActivationState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ActivationState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ActivationState_UnserializedMessageContext<
            UserType, ActivationState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ActivationState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ActivationState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ActivationState_UnserializedMessageContext<
            UserType, ActivationState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ActivationState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ActivationLevel activation_level;
  
  SubresourceFilterDisabledReason disabled_reason;
  
  bool filtering_disabled_for_document;
  
  bool generic_blocking_rules_disabled;
  
  bool measure_performance;
  
  bool enable_logging;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ActivationState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DocumentLoadStatistics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DocumentLoadStatistics, T>::value>;
  using DataView = DocumentLoadStatisticsDataView;
  using Data_ = internal::DocumentLoadStatistics_Data;

  template <typename... Args>
  static DocumentLoadStatisticsPtr New(Args&&... args) {
    return DocumentLoadStatisticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DocumentLoadStatisticsPtr From(const U& u) {
    return mojo::TypeConverter<DocumentLoadStatisticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DocumentLoadStatistics>::Convert(*this);
  }


  DocumentLoadStatistics();

  DocumentLoadStatistics(
      int32_t num_loads_total,
      int32_t num_loads_evaluated,
      int32_t num_loads_matching_rules,
      int32_t num_loads_disallowed,
      ::base::TimeDelta evaluation_total_wall_duration,
      ::base::TimeDelta evaluation_total_cpu_duration);


  ~DocumentLoadStatistics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DocumentLoadStatisticsPtr>
  DocumentLoadStatisticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentLoadStatistics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentLoadStatistics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DocumentLoadStatistics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DocumentLoadStatistics_UnserializedMessageContext<
            UserType, DocumentLoadStatistics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DocumentLoadStatistics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DocumentLoadStatistics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DocumentLoadStatistics_UnserializedMessageContext<
            UserType, DocumentLoadStatistics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DocumentLoadStatistics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t num_loads_total;
  
  int32_t num_loads_evaluated;
  
  int32_t num_loads_matching_rules;
  
  int32_t num_loads_disallowed;
  
  ::base::TimeDelta evaluation_total_wall_duration;
  
  ::base::TimeDelta evaluation_total_cpu_duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DocumentLoadStatistics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ActivationStatePtr ActivationState::Clone() const {
  return New(
      mojo::Clone(activation_level),
      mojo::Clone(disabled_reason),
      mojo::Clone(filtering_disabled_for_document),
      mojo::Clone(generic_blocking_rules_disabled),
      mojo::Clone(measure_performance),
      mojo::Clone(enable_logging)
  );
}

template <typename T, ActivationState::EnableIfSame<T>*>
bool ActivationState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->activation_level, other_struct.activation_level))
    return false;
  if (!mojo::Equals(this->disabled_reason, other_struct.disabled_reason))
    return false;
  if (!mojo::Equals(this->filtering_disabled_for_document, other_struct.filtering_disabled_for_document))
    return false;
  if (!mojo::Equals(this->generic_blocking_rules_disabled, other_struct.generic_blocking_rules_disabled))
    return false;
  if (!mojo::Equals(this->measure_performance, other_struct.measure_performance))
    return false;
  if (!mojo::Equals(this->enable_logging, other_struct.enable_logging))
    return false;
  return true;
}

template <typename T, ActivationState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.activation_level < rhs.activation_level)
    return true;
  if (rhs.activation_level < lhs.activation_level)
    return false;
  if (lhs.disabled_reason < rhs.disabled_reason)
    return true;
  if (rhs.disabled_reason < lhs.disabled_reason)
    return false;
  if (lhs.filtering_disabled_for_document < rhs.filtering_disabled_for_document)
    return true;
  if (rhs.filtering_disabled_for_document < lhs.filtering_disabled_for_document)
    return false;
  if (lhs.generic_blocking_rules_disabled < rhs.generic_blocking_rules_disabled)
    return true;
  if (rhs.generic_blocking_rules_disabled < lhs.generic_blocking_rules_disabled)
    return false;
  if (lhs.measure_performance < rhs.measure_performance)
    return true;
  if (rhs.measure_performance < lhs.measure_performance)
    return false;
  if (lhs.enable_logging < rhs.enable_logging)
    return true;
  if (rhs.enable_logging < lhs.enable_logging)
    return false;
  return false;
}
template <typename StructPtrType>
DocumentLoadStatisticsPtr DocumentLoadStatistics::Clone() const {
  return New(
      mojo::Clone(num_loads_total),
      mojo::Clone(num_loads_evaluated),
      mojo::Clone(num_loads_matching_rules),
      mojo::Clone(num_loads_disallowed),
      mojo::Clone(evaluation_total_wall_duration),
      mojo::Clone(evaluation_total_cpu_duration)
  );
}

template <typename T, DocumentLoadStatistics::EnableIfSame<T>*>
bool DocumentLoadStatistics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->num_loads_total, other_struct.num_loads_total))
    return false;
  if (!mojo::Equals(this->num_loads_evaluated, other_struct.num_loads_evaluated))
    return false;
  if (!mojo::Equals(this->num_loads_matching_rules, other_struct.num_loads_matching_rules))
    return false;
  if (!mojo::Equals(this->num_loads_disallowed, other_struct.num_loads_disallowed))
    return false;
  if (!mojo::Equals(this->evaluation_total_wall_duration, other_struct.evaluation_total_wall_duration))
    return false;
  if (!mojo::Equals(this->evaluation_total_cpu_duration, other_struct.evaluation_total_cpu_duration))
    return false;
  return true;
}

template <typename T, DocumentLoadStatistics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.num_loads_total < rhs.num_loads_total)
    return true;
  if (rhs.num_loads_total < lhs.num_loads_total)
    return false;
  if (lhs.num_loads_evaluated < rhs.num_loads_evaluated)
    return true;
  if (rhs.num_loads_evaluated < lhs.num_loads_evaluated)
    return false;
  if (lhs.num_loads_matching_rules < rhs.num_loads_matching_rules)
    return true;
  if (rhs.num_loads_matching_rules < lhs.num_loads_matching_rules)
    return false;
  if (lhs.num_loads_disallowed < rhs.num_loads_disallowed)
    return true;
  if (rhs.num_loads_disallowed < lhs.num_loads_disallowed)
    return false;
  if (lhs.evaluation_total_wall_duration < rhs.evaluation_total_wall_duration)
    return true;
  if (rhs.evaluation_total_wall_duration < lhs.evaluation_total_wall_duration)
    return false;
  if (lhs.evaluation_total_cpu_duration < rhs.evaluation_total_cpu_duration)
    return true;
  if (rhs.evaluation_total_cpu_duration < lhs.evaluation_total_cpu_duration)
    return false;
  return false;
}


}  // subresource_filter::mojom

namespace mojo {


template <>
struct  StructTraits<::subresource_filter::mojom::ActivationState::DataView,
                                         ::subresource_filter::mojom::ActivationStatePtr> {
  static bool IsNull(const ::subresource_filter::mojom::ActivationStatePtr& input) { return !input; }
  static void SetToNull(::subresource_filter::mojom::ActivationStatePtr* output) { output->reset(); }

  static decltype(::subresource_filter::mojom::ActivationState::activation_level) activation_level(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->activation_level;
  }

  static decltype(::subresource_filter::mojom::ActivationState::disabled_reason) disabled_reason(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->disabled_reason;
  }

  static decltype(::subresource_filter::mojom::ActivationState::filtering_disabled_for_document) filtering_disabled_for_document(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->filtering_disabled_for_document;
  }

  static decltype(::subresource_filter::mojom::ActivationState::generic_blocking_rules_disabled) generic_blocking_rules_disabled(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->generic_blocking_rules_disabled;
  }

  static decltype(::subresource_filter::mojom::ActivationState::measure_performance) measure_performance(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->measure_performance;
  }

  static decltype(::subresource_filter::mojom::ActivationState::enable_logging) enable_logging(
      const ::subresource_filter::mojom::ActivationStatePtr& input) {
    return input->enable_logging;
  }

  static bool Read(::subresource_filter::mojom::ActivationState::DataView input, ::subresource_filter::mojom::ActivationStatePtr* output);
};


template <>
struct  StructTraits<::subresource_filter::mojom::DocumentLoadStatistics::DataView,
                                         ::subresource_filter::mojom::DocumentLoadStatisticsPtr> {
  static bool IsNull(const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) { return !input; }
  static void SetToNull(::subresource_filter::mojom::DocumentLoadStatisticsPtr* output) { output->reset(); }

  static decltype(::subresource_filter::mojom::DocumentLoadStatistics::num_loads_total) num_loads_total(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->num_loads_total;
  }

  static decltype(::subresource_filter::mojom::DocumentLoadStatistics::num_loads_evaluated) num_loads_evaluated(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->num_loads_evaluated;
  }

  static decltype(::subresource_filter::mojom::DocumentLoadStatistics::num_loads_matching_rules) num_loads_matching_rules(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->num_loads_matching_rules;
  }

  static decltype(::subresource_filter::mojom::DocumentLoadStatistics::num_loads_disallowed) num_loads_disallowed(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->num_loads_disallowed;
  }

  static const decltype(::subresource_filter::mojom::DocumentLoadStatistics::evaluation_total_wall_duration)& evaluation_total_wall_duration(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->evaluation_total_wall_duration;
  }

  static const decltype(::subresource_filter::mojom::DocumentLoadStatistics::evaluation_total_cpu_duration)& evaluation_total_cpu_duration(
      const ::subresource_filter::mojom::DocumentLoadStatisticsPtr& input) {
    return input->evaluation_total_cpu_duration;
  }

  static bool Read(::subresource_filter::mojom::DocumentLoadStatistics::DataView input, ::subresource_filter::mojom::DocumentLoadStatisticsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_