// components/subresource_filter/core/mojom/subresource_filter.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace subresource_filter::mojom {
namespace internal {
class ActivationState_Data;
class DocumentLoadStatistics_Data;

struct ActivationLevel_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AdsViolation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SubresourceFilterDisabledReason_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  ActivationState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t activation_level;
  int32_t disabled_reason;
  uint8_t filtering_disabled_for_document : 1;
  uint8_t generic_blocking_rules_disabled : 1;
  uint8_t measure_performance : 1;
  uint8_t enable_logging : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ActivationState_Data>;

  ActivationState_Data();
  ~ActivationState_Data() = delete;
};
static_assert(sizeof(ActivationState_Data) == 24,
              "Bad sizeof(ActivationState_Data)");
// Used by ActivationState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ActivationState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ActivationState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ActivationState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ActivationState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ActivationState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DocumentLoadStatistics_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t num_loads_total;
  int32_t num_loads_evaluated;
  int32_t num_loads_matching_rules;
  int32_t num_loads_disallowed;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> evaluation_total_wall_duration;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> evaluation_total_cpu_duration;

 private:
  friend class mojo::internal::MessageFragment<DocumentLoadStatistics_Data>;

  DocumentLoadStatistics_Data();
  ~DocumentLoadStatistics_Data() = delete;
};
static_assert(sizeof(DocumentLoadStatistics_Data) == 40,
              "Bad sizeof(DocumentLoadStatistics_Data)");
// Used by DocumentLoadStatistics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DocumentLoadStatistics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DocumentLoadStatistics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DocumentLoadStatistics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DocumentLoadStatistics_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DocumentLoadStatistics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // subresource_filter::mojom

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_INTERNAL_H_