// components/subresource_filter/core/mojom/subresource_filter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace subresource_filter::mojom {
class ActivationStateDataView;

class DocumentLoadStatisticsDataView;



}  // subresource_filter::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::subresource_filter::mojom::ActivationStateDataView> {
  using Data = ::subresource_filter::mojom::internal::ActivationState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::subresource_filter::mojom::DocumentLoadStatisticsDataView> {
  using Data = ::subresource_filter::mojom::internal::DocumentLoadStatistics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace subresource_filter::mojom {


enum class ActivationLevel : int32_t {
  
  kDisabled = 0,
  
  kDryRun = 1,
  
  kEnabled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ActivationLevel value);
inline bool IsKnownEnumValue(ActivationLevel value) {
  return internal::ActivationLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AdsViolation : int32_t {
  
  kMobileAdDensityByHeightAbove30 = 0,
  
  kHeavyAdsInterventionAtHostLimit = 1,
  
  kLargeStickyAd = 2,
  
  kOverlayPopupAd = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AdsViolation value);
inline bool IsKnownEnumValue(AdsViolation value) {
  return internal::AdsViolation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubresourceFilterDisabledReason : int32_t {
  
  kUnknown = 0,
  
  kNoMatchingConfiguration = 1,
  
  kDisabledByConfiguration = 2,
  
  kUrlAllowlisted = 3,
  
  kWarningMode = 4,
  
  kNavigationError = 5,
  
  kFilterNeverCreated = 6,
  
  kRulesetUnavailableOrCorrupt = 7,
  
  kUrlNotHandledByNetworkStack = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, SubresourceFilterDisabledReason value);
inline bool IsKnownEnumValue(SubresourceFilterDisabledReason value) {
  return internal::SubresourceFilterDisabledReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SubresourceFilterRulesetObserverInterfaceBase {};

using SubresourceFilterRulesetObserverPtrDataView =
    mojo::InterfacePtrDataView<SubresourceFilterRulesetObserverInterfaceBase>;
using SubresourceFilterRulesetObserverRequestDataView =
    mojo::InterfaceRequestDataView<SubresourceFilterRulesetObserverInterfaceBase>;
using SubresourceFilterRulesetObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SubresourceFilterRulesetObserverInterfaceBase>;
using SubresourceFilterRulesetObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SubresourceFilterRulesetObserverInterfaceBase>;


class ActivationStateDataView {
 public:
  ActivationStateDataView() = default;

  ActivationStateDataView(
      internal::ActivationState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadActivationLevel(UserType* output) const {
    auto data_value = data_->activation_level;
    return mojo::internal::Deserialize<::subresource_filter::mojom::ActivationLevel>(
        data_value, output);
  }
  ActivationLevel activation_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::subresource_filter::mojom::ActivationLevel>(data_->activation_level));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisabledReason(UserType* output) const {
    auto data_value = data_->disabled_reason;
    return mojo::internal::Deserialize<::subresource_filter::mojom::SubresourceFilterDisabledReason>(
        data_value, output);
  }
  SubresourceFilterDisabledReason disabled_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::subresource_filter::mojom::SubresourceFilterDisabledReason>(data_->disabled_reason));
  }
  bool filtering_disabled_for_document() const {
    return data_->filtering_disabled_for_document;
  }
  bool generic_blocking_rules_disabled() const {
    return data_->generic_blocking_rules_disabled;
  }
  bool measure_performance() const {
    return data_->measure_performance;
  }
  bool enable_logging() const {
    return data_->enable_logging;
  }
 private:
  internal::ActivationState_Data* data_ = nullptr;
};


class DocumentLoadStatisticsDataView {
 public:
  DocumentLoadStatisticsDataView() = default;

  DocumentLoadStatisticsDataView(
      internal::DocumentLoadStatistics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t num_loads_total() const {
    return data_->num_loads_total;
  }
  int32_t num_loads_evaluated() const {
    return data_->num_loads_evaluated;
  }
  int32_t num_loads_matching_rules() const {
    return data_->num_loads_matching_rules;
  }
  int32_t num_loads_disallowed() const {
    return data_->num_loads_disallowed;
  }
  inline void GetEvaluationTotalWallDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvaluationTotalWallDuration(UserType* output) {
    
    auto* pointer = data_->evaluation_total_wall_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetEvaluationTotalCpuDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvaluationTotalCpuDuration(UserType* output) {
    
    auto* pointer = data_->evaluation_total_cpu_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::DocumentLoadStatistics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // subresource_filter::mojom

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_DATA_VIEW_H_