// components/spellcheck/common/spellcheck.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_TEST_UTILS_H_

#include "components/spellcheck/common/spellcheck.mojom.h"


namespace spellcheck::mojom {


class  SpellCheckerInterceptorForTesting : public SpellChecker {
  virtual SpellChecker* GetForwardingInterface() = 0;
  void Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) override;
  void CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) override;
};
class  SpellCheckerAsyncWaiter {
 public:
  explicit SpellCheckerAsyncWaiter(SpellChecker* proxy);

  SpellCheckerAsyncWaiter(const SpellCheckerAsyncWaiter&) = delete;
  SpellCheckerAsyncWaiter& operator=(const SpellCheckerAsyncWaiter&) = delete;

  ~SpellCheckerAsyncWaiter();

 private:
  SpellChecker* const proxy_;
};


class  SpellCheckInitializationHostInterceptorForTesting : public SpellCheckInitializationHost {
  virtual SpellCheckInitializationHost* GetForwardingInterface() = 0;
  void RequestDictionary() override;
};
class  SpellCheckInitializationHostAsyncWaiter {
 public:
  explicit SpellCheckInitializationHostAsyncWaiter(SpellCheckInitializationHost* proxy);

  SpellCheckInitializationHostAsyncWaiter(const SpellCheckInitializationHostAsyncWaiter&) = delete;
  SpellCheckInitializationHostAsyncWaiter& operator=(const SpellCheckInitializationHostAsyncWaiter&) = delete;

  ~SpellCheckInitializationHostAsyncWaiter();

 private:
  SpellCheckInitializationHost* const proxy_;
};


class  SpellCheckHostInterceptorForTesting : public SpellCheckHost {
  virtual SpellCheckHost* GetForwardingInterface() = 0;
  void NotifyChecked(const ::std::u16string& word, bool misspelled) override;
  void RequestTextCheck(const ::std::u16string& text, RequestTextCheckCallback callback) override;
  void CheckSpelling(const ::std::u16string& word, CheckSpellingCallback callback) override;
  void FillSuggestionList(const ::std::u16string& word, FillSuggestionListCallback callback) override;
};
class  SpellCheckHostAsyncWaiter {
 public:
  explicit SpellCheckHostAsyncWaiter(SpellCheckHost* proxy);

  SpellCheckHostAsyncWaiter(const SpellCheckHostAsyncWaiter&) = delete;
  SpellCheckHostAsyncWaiter& operator=(const SpellCheckHostAsyncWaiter&) = delete;

  ~SpellCheckHostAsyncWaiter();
  void RequestTextCheck(
      const ::std::u16string& text, std::vector<::SpellCheckResult>* out_results);
  std::vector<::SpellCheckResult> RequestTextCheck(const ::std::u16string& text);
  void CheckSpelling(
      const ::std::u16string& word, bool* out_correct);
  bool CheckSpelling(const ::std::u16string& word);
  void FillSuggestionList(
      const ::std::u16string& word, std::vector<::std::u16string>* out_suggestions);
  std::vector<::std::u16string> FillSuggestionList(const ::std::u16string& word);

 private:
  SpellCheckHost* const proxy_;
};




}  // spellcheck::mojom

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_TEST_UTILS_H_