// components/spellcheck/common/spellcheck.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/spellcheck/common/spellcheck.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"


namespace spellcheck::mojom {
class SpellCheckBDictLanguageDataView;

class SpellCheckResultDataView;



}  // spellcheck::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::spellcheck::mojom::SpellCheckBDictLanguageDataView> {
  using Data = ::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::spellcheck::mojom::SpellCheckResultDataView> {
  using Data = ::spellcheck::mojom::internal::SpellCheckResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace spellcheck::mojom {


enum class Decoration : int32_t {
  
  kSpelling = 0,
  
  kGrammar = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, Decoration value);
inline bool IsKnownEnumValue(Decoration value) {
  return internal::Decoration_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SpellCheckerInterfaceBase {};

using SpellCheckerPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckerInterfaceBase>;
using SpellCheckerRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckerInterfaceBase>;
using SpellCheckerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckerInterfaceBase>;
using SpellCheckerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckerInterfaceBase>;
class SpellCheckInitializationHostInterfaceBase {};

using SpellCheckInitializationHostPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckInitializationHostInterfaceBase>;
class SpellCheckHostInterfaceBase {};

using SpellCheckHostPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckHostInterfaceBase>;


class SpellCheckBDictLanguageDataView {
 public:
  SpellCheckBDictLanguageDataView() = default;

  SpellCheckBDictLanguageDataView(
      internal::SpellCheckBDictLanguage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpellCheckBDictLanguage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellCheckResultDataView {
 public:
  SpellCheckResultDataView() = default;

  SpellCheckResultDataView(
      internal::SpellCheckResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoration(UserType* output) const {
    auto data_value = data_->decoration;
    return mojo::internal::Deserialize<::spellcheck::mojom::Decoration>(
        data_value, output);
  }
  Decoration decoration() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::spellcheck::mojom::Decoration>(data_->decoration));
  }
  int32_t location() const {
    return data_->location;
  }
  int32_t length() const {
    return data_->length;
  }
  inline void GetReplacementsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacements(UserType* output) {
    
    auto* pointer = data_->replacements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  bool should_hide_suggestion_menu() const {
    return data_->should_hide_suggestion_menu;
  }
 private:
  internal::SpellCheckResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // spellcheck::mojom

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_DATA_VIEW_H_