// components/site_engagement/core/mojom/site_engagement_details.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/site_engagement/core/mojom/site_engagement_details.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/site_engagement/core/mojom/site_engagement_details.mojom-params-data.h"
#include "components/site_engagement/core/mojom/site_engagement_details.mojom-shared-message-ids.h"

#include "components/site_engagement/core/mojom/site_engagement_details.mojom-import-headers.h"
#include "components/site_engagement/core/mojom/site_engagement_details.mojom-test-utils.h"


namespace site_engagement::mojom {
SiteEngagementDetails::SiteEngagementDetails()
    : origin(),
      total_score(),
      base_score(),
      installed_bonus() {}

SiteEngagementDetails::SiteEngagementDetails(
    const ::GURL& origin_in,
    double total_score_in,
    double base_score_in,
    double installed_bonus_in)
    : origin(std::move(origin_in)),
      total_score(std::move(total_score_in)),
      base_score(std::move(base_score_in)),
      installed_bonus(std::move(installed_bonus_in)) {}

SiteEngagementDetails::~SiteEngagementDetails() = default;

void SiteEngagementDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_score"), this->total_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_score"), this->base_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_bonus"), this->installed_bonus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteEngagementDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SiteEngagementDetailsProvider::IPCStableHashFunction SiteEngagementDetailsProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SiteEngagementDetailsProvider>(message.name())) {
    case messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails: {
      return &SiteEngagementDetailsProvider::GetSiteEngagementDetails_Sym::IPCStableHash;
    }
    case messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl: {
      return &SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SiteEngagementDetailsProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SiteEngagementDetailsProvider>(message.name())) {
      case messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails:
            return "Receive site_engagement::mojom::SiteEngagementDetailsProvider::GetSiteEngagementDetails";
      case messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl:
            return "Receive site_engagement::mojom::SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl";
    }
  } else {
    switch (static_cast<messages::SiteEngagementDetailsProvider>(message.name())) {
      case messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails:
            return "Receive reply site_engagement::mojom::SiteEngagementDetailsProvider::GetSiteEngagementDetails";
      case messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl:
            return "Receive reply site_engagement::mojom::SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SiteEngagementDetailsProvider::GetSiteEngagementDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6529a923;  // IPCStableHash for site_engagement::mojom::SiteEngagementDetailsProvider::GetSiteEngagementDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cba59ca;  // IPCStableHash for site_engagement::mojom::SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback(
      SiteEngagementDetailsProvider::GetSiteEngagementDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback(const SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback&) = delete;
  SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback& operator=(const SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SiteEngagementDetailsProvider::GetSiteEngagementDetailsCallback callback_;
};

SiteEngagementDetailsProviderProxy::SiteEngagementDetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SiteEngagementDetailsProviderProxy::GetSiteEngagementDetails(
    GetSiteEngagementDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send site_engagement::mojom::SiteEngagementDetailsProvider::GetSiteEngagementDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::site_engagement::mojom::internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteEngagementDetailsProvider::Name_);
  message.set_method_name("GetSiteEngagementDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SiteEngagementDetailsProviderProxy::SetSiteEngagementBaseScoreForUrl(
    const ::GURL& in_url, double in_score) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send site_engagement::mojom::SiteEngagementDetailsProvider::SetSiteEngagementBaseScoreForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score"), in_score,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::site_engagement::mojom::internal::SiteEngagementDetailsProvider_SetSiteEngagementBaseScoreForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in SiteEngagementDetailsProvider.SetSiteEngagementBaseScoreForUrl request");

  params->score = in_score;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteEngagementDetailsProvider::Name_);
  message.set_method_name("SetSiteEngagementBaseScoreForUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SiteEngagementDetailsProvider::GetSiteEngagementDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder> proxy(
        new SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SiteEngagementDetailsProvider::GetSiteEngagementDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SiteEngagementDetailsPtr> in_info);
};

bool SiteEngagementDetailsProvider_GetSiteEngagementDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SiteEngagementDetailsProvider.0
  bool success = true;
  std::vector<SiteEngagementDetailsPtr> p_info{};
  SiteEngagementDetailsProvider_GetSiteEngagementDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SiteEngagementDetailsProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder::Run(
    std::vector<SiteEngagementDetailsPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply site_engagement::mojom::SiteEngagementDetailsProvider::GetSiteEngagementDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type std::vector<SiteEngagementDetailsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::site_engagement::mojom::internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::site_engagement::mojom::SiteEngagementDetailsDataView>>(
    in_info,
    info_fragment,
    &info_validate_params);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SiteEngagementDetailsProvider::Name_);
  message.set_method_name("GetSiteEngagementDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SiteEngagementDetailsProviderStubDispatch::Accept(
    SiteEngagementDetailsProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SiteEngagementDetailsProvider>(message->header()->name)) {
    case messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails: {
      break;
    }
    case messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl: {
      DCHECK(message->is_serialized());
      internal::SiteEngagementDetailsProvider_SetSiteEngagementBaseScoreForUrl_Params_Data* params =
          reinterpret_cast<internal::SiteEngagementDetailsProvider_SetSiteEngagementBaseScoreForUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SiteEngagementDetailsProvider.1
      bool success = true;
      ::GURL p_url{};
      double p_score{};
      SiteEngagementDetailsProvider_SetSiteEngagementBaseScoreForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_score = input_data_view.score();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SiteEngagementDetailsProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSiteEngagementBaseScoreForUrl(        
        std::move(p_url), 
        std::move(p_score));
      return true;
    }
  }
  return false;
}

// static
bool SiteEngagementDetailsProviderStubDispatch::AcceptWithResponder(
    SiteEngagementDetailsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SiteEngagementDetailsProvider>(message->header()->name)) {
    case messages::SiteEngagementDetailsProvider::kGetSiteEngagementDetails: {
      internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_Params_Data* params =
          reinterpret_cast<
              internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SiteEngagementDetailsProvider.0
      bool success = true;
      SiteEngagementDetailsProvider_GetSiteEngagementDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SiteEngagementDetailsProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          SiteEngagementDetailsProvider_GetSiteEngagementDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSiteEngagementDetails(std::move(callback));
      return true;
    }
    case messages::SiteEngagementDetailsProvider::kSetSiteEngagementBaseScoreForUrl: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSiteEngagementDetailsProviderValidationInfo[] = {
    { &internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_Params_Data::Validate,
     &internal::SiteEngagementDetailsProvider_GetSiteEngagementDetails_ResponseParams_Data::Validate},
    { &internal::SiteEngagementDetailsProvider_SetSiteEngagementBaseScoreForUrl_Params_Data::Validate,
     nullptr /* no response */},
};

bool SiteEngagementDetailsProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::site_engagement::mojom::SiteEngagementDetailsProvider::Name_,
    kSiteEngagementDetailsProviderValidationInfo);
}

bool SiteEngagementDetailsProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::site_engagement::mojom::SiteEngagementDetailsProvider::Name_,
    kSiteEngagementDetailsProviderValidationInfo);
}


}  // site_engagement::mojom


namespace mojo {


// static
bool StructTraits<::site_engagement::mojom::SiteEngagementDetails::DataView, ::site_engagement::mojom::SiteEngagementDetailsPtr>::Read(
    ::site_engagement::mojom::SiteEngagementDetails::DataView input,
    ::site_engagement::mojom::SiteEngagementDetailsPtr* output) {
  bool success = true;
  ::site_engagement::mojom::SiteEngagementDetailsPtr result(::site_engagement::mojom::SiteEngagementDetails::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->total_score = input.total_score();
      if (success)
        result->base_score = input.base_score();
      if (success)
        result->installed_bonus = input.installed_bonus();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace site_engagement::mojom {


void SiteEngagementDetailsProviderInterceptorForTesting::GetSiteEngagementDetails(GetSiteEngagementDetailsCallback callback) {
  GetForwardingInterface()->GetSiteEngagementDetails(std::move(callback));
}
void SiteEngagementDetailsProviderInterceptorForTesting::SetSiteEngagementBaseScoreForUrl(const ::GURL& url, double score) {
  GetForwardingInterface()->SetSiteEngagementBaseScoreForUrl(
    std::move(url)
    , 
    std::move(score)
    );
}
SiteEngagementDetailsProviderAsyncWaiter::SiteEngagementDetailsProviderAsyncWaiter(
    SiteEngagementDetailsProvider* proxy) : proxy_(proxy) {}

SiteEngagementDetailsProviderAsyncWaiter::~SiteEngagementDetailsProviderAsyncWaiter() = default;


void SiteEngagementDetailsProviderAsyncWaiter::GetSiteEngagementDetails(
    std::vector<SiteEngagementDetailsPtr>* out_info) {
  base::RunLoop loop;
  proxy_->GetSiteEngagementDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SiteEngagementDetailsPtr>* out_info
,
             std::vector<SiteEngagementDetailsPtr> info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

std::vector<SiteEngagementDetailsPtr> SiteEngagementDetailsProviderAsyncWaiter::GetSiteEngagementDetails(
    ) {
  std::vector<SiteEngagementDetailsPtr> async_wait_result;
  GetSiteEngagementDetails(&async_wait_result);
  return async_wait_result;
}






}  // site_engagement::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif